/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.interview.Interview;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.audit.Audit;
import com.sun.javatest.audit.AuditPane;
import com.sun.javatest.audit.BadChecksumPane;
import com.sun.javatest.audit.BadTestCaseTestsPane;
import com.sun.javatest.audit.BadTestDescriptionPane;
import com.sun.javatest.audit.BadTestsPane;
import com.sun.javatest.audit.OptionsDialog;
import com.sun.javatest.audit.SummaryPane;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.Map;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AuditTool
extends Tool {
    private static AuditTool theOne;
    private JMenuBar menuBar;
    private JTextField testSuiteField;
    private JTextField workDirField;
    private JTextField configFileField;
    private AuditPane[] panes;
    private JTabbedPane tabs;
    private OptionsDialog optionsDialog;
    private boolean autoShowOptions = true;
    private Listener listener = new Listener();
    private InterviewParameters interviewParams;
    private Thread worker;
    private Audit audit;
    private static final String OPTIONS = "options";
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$audit$AuditTool;

    static AuditTool access() {
        if (theOne == null) {
            theOne = new AuditTool();
        }
        return theOne;
    }

    private AuditTool() {
        super("audit", "audit.window.csh");
        this.setI18NTitle("tool.title");
        this.setShortTitle(this.uif.getI18NString("tool.shortTitle"));
        this.initGUI();
    }

    public void dispose() {
        super.dispose();
        if (this.optionsDialog != null) {
            this.optionsDialog.setVisible(false);
            this.optionsDialog.dispose();
        }
        theOne = null;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public TestSuite[] getLoadedTestSuites() {
        TestSuite[] testSuiteArray;
        TestSuite testSuite;
        TestSuite testSuite2 = testSuite = this.interviewParams == null ? null : this.interviewParams.getTestSuite();
        if (testSuite == null) {
            testSuiteArray = null;
        } else {
            TestSuite[] testSuiteArray2 = new TestSuite[1];
            testSuiteArray = testSuiteArray2;
            testSuiteArray2[0] = testSuite;
        }
        return testSuiteArray;
    }

    public WorkDirectory[] getLoadedWorkDirectories() {
        WorkDirectory[] workDirectoryArray;
        WorkDirectory workDirectory;
        WorkDirectory workDirectory2 = workDirectory = this.interviewParams == null ? null : this.interviewParams.getWorkDirectory();
        if (workDirectory == null) {
            workDirectoryArray = null;
        } else {
            WorkDirectory[] workDirectoryArray2 = new WorkDirectory[1];
            workDirectoryArray = workDirectoryArray2;
            workDirectoryArray2[0] = workDirectory;
        }
        return workDirectoryArray;
    }

    public void save(Map map) {
        File file;
        if (this.interviewParams == null) {
            return;
        }
        TestSuite testSuite = this.interviewParams.getTestSuite();
        map.put("testSuite", testSuite.getRoot().getPath());
        WorkDirectory workDirectory = this.interviewParams.getWorkDirectory();
        if (workDirectory != null) {
            map.put("workDir", workDirectory.getPath());
        }
        if ((file = this.interviewParams.getFile()) != null) {
            map.put("config", file.getPath());
        }
    }

    public static AuditTool restore(Map map) {
        AuditTool auditTool = AuditTool.access();
        auditTool.restore0(map);
        return auditTool;
    }

    private void restore0(Map map) {
        String string = (String)map.get("testSuite");
        String string2 = (String)map.get("workDir");
        String string3 = (String)map.get("config");
        try {
            this.interviewParams = InterviewParameters.open(string, string2, string3);
            this.updateGUI(null, this.interviewParams, this.uif.getI18NString("tool.restore.txt"));
            this.autoShowOptions = false;
        }
        catch (Interview.Fault fault) {
            this.uif.showError("tool.cantRestore", fault.getMessage());
        }
    }

    private void initGUI() {
        int n = this.uif.getDotsPerInch();
        this.setPreferredSize(new Dimension(6 * n, 4 * n));
        this.setLayout(new BorderLayout());
        this.addHierarchyListener(this.listener);
        this.menuBar = this.uif.createMenuBar("tool");
        String[] stringArray = new String[]{OPTIONS};
        JMenu jMenu = this.uif.createMenu("tool.audit", stringArray, this.listener);
        this.menuBar.add(jMenu);
        this.menuBar.add(this.uif.createHorizontalGlue("tool.pad"));
        JMenu jMenu2 = this.uif.createMenu("tool.help");
        jMenu2.add(this.uif.createHelpMenuItem("tool.help.window", "audit.window.csh"));
        this.menuBar.add(jMenu2);
        JPanel jPanel = this.uif.createPanel("head", false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.weightx = 0.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        this.testSuiteField = this.initField("tool.testSuite", jPanel, gridBagConstraints, gridBagConstraints2);
        this.workDirField = this.initField("tool.workDir", jPanel, gridBagConstraints, gridBagConstraints2);
        this.configFileField = this.initField("tool.configFile", jPanel, gridBagConstraints, gridBagConstraints2);
        this.add((Component)jPanel, "North");
        this.panes = new AuditPane[]{new SummaryPane(this.uif), new BadTestsPane(this.uif), new BadChecksumPane(this.uif), new BadTestDescriptionPane(this.uif), new BadTestCaseTestsPane(this.uif)};
        this.tabs = this.uif.createTabbedPane("tool.tabs", this.panes);
        this.tabs.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = AuditTool.this.tabs.getSelectedComponent();
                CSH.setHelpIDString(AuditTool.this.tabs, CSH.getHelpIDString(component));
            }
        });
        CSH.setHelpIDString(this.tabs, CSH.getHelpIDString(this.panes[0]));
        this.add((Component)this.tabs, "Center");
        this.updateGUI(null, null, this.uif.getI18NString("tool.initial.txt"));
    }

    private JTextField initField(String string, JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagConstraints gridBagConstraints2) {
        JLabel jLabel = this.uif.createLabel(string, true);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = this.uif.createOutputField(string, jLabel);
        jTextField.setBorder(null);
        jPanel.add((Component)jTextField, gridBagConstraints2);
        return jTextField;
    }

    private synchronized void showOptions() {
        if (this.worker != null) {
            this.uif.showError("tool.auditInProgress");
            return;
        }
        if (this.optionsDialog == null) {
            this.optionsDialog = new OptionsDialog((Component)this, this.listener, this.uif);
        }
        if (this.interviewParams != null) {
            this.optionsDialog.setParameters(this.interviewParams);
        }
        this.optionsDialog.setVisible(true);
    }

    private void setOptions() {
        String string = this.optionsDialog.getTestSuitePath();
        String string2 = this.optionsDialog.getWorkDirPath();
        String string3 = this.optionsDialog.getConfigFilePath();
        if (AuditTool.isEmpty(string) && AuditTool.isEmpty(string2) && AuditTool.isEmpty(string3)) {
            this.uif.showError("tool.noOptions");
            return;
        }
        try {
            this.interviewParams = InterviewParameters.open(string, string2, string3);
        }
        catch (Interview.Fault fault) {
            this.uif.showError("tool.badOptions", fault.getMessage());
            return;
        }
        this.optionsDialog.setVisible(false);
        this.startAudit();
    }

    private synchronized void startAudit() {
        if (this.worker != null) {
            this.uif.showError("tool.auditInProgress");
            return;
        }
        if (this.interviewParams.getWorkDirectory() == null) {
            this.uif.showError("tool.noWd");
            return;
        }
        this.worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Audit audit = AuditTool.this.audit;
                try {
                    audit = new Audit(AuditTool.this.interviewParams);
                }
                finally {
                    AuditTool auditTool = AuditTool.this;
                    synchronized (auditTool) {
                        AuditTool.this.worker = null;
                    }
                    AuditTool.this.updateGUI(audit, AuditTool.this.interviewParams, null);
                }
            }
        };
        this.worker.start();
        this.updateGUI(null, this.interviewParams, this.uif.getI18NString("tool.auditInProgress"));
    }

    private void updateGUI(final Audit audit, final InterviewParameters interviewParameters, final String string) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AuditTool.this.updateGUI(audit, interviewParameters, string);
                }
            });
            return;
        }
        this.audit = audit;
        TestSuite testSuite = interviewParameters == null ? null : interviewParameters.getTestSuite();
        String string2 = testSuite == null ? "" : testSuite.getPath();
        this.testSuiteField.setText(string2);
        WorkDirectory workDirectory = interviewParameters == null ? null : interviewParameters.getWorkDirectory();
        String string3 = workDirectory == null ? "" : workDirectory.getPath();
        this.workDirField.setText(string3);
        File file = interviewParameters == null ? null : interviewParameters.getFile();
        String string4 = file == null ? "" : file.getPath();
        this.configFileField.setText(string4);
        int n = 0;
        while (n < this.panes.length) {
            AuditPane auditPane = this.panes[n];
            if (audit != null) {
                auditPane.show(audit);
            } else if (string != null) {
                auditPane.show(string);
            }
            ++n;
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$audit$AuditTool == null ? (class$com$sun$javatest$audit$AuditTool = AuditTool.class$("com.sun.javatest.audit.AuditTool")) : class$com$sun$javatest$audit$AuditTool);
    }

    private class Listener
    implements ActionListener,
    HierarchyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(AuditTool.OPTIONS)) {
                AuditTool.this.showOptions();
            } else if (string.equals("OK")) {
                AuditTool.this.setOptions();
            }
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (AuditTool.this.isShowing() && AuditTool.this.autoShowOptions) {
                EventQueue.invokeLater(new Runnable(this){
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = listener;
                    }

                    public void run() {
                        AuditTool.access$600(Listener.access$900(this.this$1));
                    }
                });
                AuditTool.this.autoShowOptions = false;
            }
        }

        static /* synthetic */ AuditTool access$900(Listener listener) {
            return listener.AuditTool.this;
        }
    }
}

