/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestFinderQueue;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class Audit {
    private int testCount;
    private int[] checksumCounts = new int[3];
    private int[] envCounts = new int[2];
    private int[] statusCounts = new int[5];
    private boolean badDates = false;
    private TestDescription[] badTests;
    private TestResult[] badTestCaseTests;
    private TestResult[] badTestDescriptions;
    private TestResult[] badChecksumTests;
    private Date earliestStart;
    private Date latestStart;
    private DateFormat[] dateFormats;
    private Hashtable envTable = new Hashtable();
    private PrintStream out;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$audit$Audit == null ? (class$com$sun$javatest$audit$Audit = Audit.class$("com.sun.javatest.audit.Audit")) : class$com$sun$javatest$audit$Audit);
    static /* synthetic */ Class class$com$sun$javatest$audit$Audit;

    public Audit(Parameters parameters) {
        this(Audit.getTestFinderQueue(parameters), parameters.getExcludeList(), parameters.getWorkDirectory());
    }

    private static TestFinderQueue getTestFinderQueue(Parameters parameters) {
        TestSuite testSuite = parameters.getTestSuite();
        TestFinder testFinder = testSuite.getTestFinder();
        TestFinderQueue testFinderQueue = new TestFinderQueue();
        testFinderQueue.setTestFinder(testFinder);
        String[] stringArray = parameters.getTests();
        testFinderQueue.setTests(stringArray);
        TestFilter[] testFilterArray = parameters.getFilters();
        testFinderQueue.setFilters(testFilterArray);
        return testFinderQueue;
    }

    public Audit(TestFinderQueue testFinderQueue, ExcludeList excludeList, WorkDirectory workDirectory) {
        Object object;
        Object object2;
        Object object3;
        TestDescription testDescription;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        Vector<TestDescription> vector4 = new Vector<TestDescription>();
        while ((testDescription = testFinderQueue.next()) != null) {
            try {
                Object object4;
                Object object5;
                object3 = new TestResult(workDirectory, TestResult.getWorkRelativePath(testDescription));
                ++this.testCount;
                int n = ((TestResult)object3).getStatus().getType();
                this.statusCounts[n] = this.statusCounts[n] + 1;
                byte by = ((TestResult)object3).getChecksumState();
                this.checksumCounts[by] = this.checksumCounts[by] + 1;
                if (((TestResult)object3).getChecksumState() == 1) {
                    vector.addElement(object3);
                }
                if (!Audit.equal(testDescription, ((TestResult)object3).getDescription())) {
                    vector2.addElement(object3);
                }
                if (!this.checkTestCases((TestResult)object3, excludeList)) {
                    vector3.addElement(object3);
                }
                object2 = ((TestResult)object3).getEnvironment();
                object = object2.entrySet().iterator();
                while (object.hasNext()) {
                    object5 = (Map.Entry)object.next();
                    object4 = (String)object5.getKey();
                    String string = (String)object5.getValue();
                    Vector<String> vector5 = (Vector<String>)this.envTable.get(object4);
                    if (vector5 == null) {
                        vector5 = new Vector<String>();
                        this.envTable.put(object4, vector5);
                    }
                    if (vector5.contains(string)) continue;
                    vector5.addElement(string);
                }
                object5 = ((TestResult)object3).getProperty("start");
                if (object5 == null) {
                    this.badDates = true;
                    continue;
                }
                object4 = this.parseDate((String)object5);
                if (object4 == null) {
                    this.badDates = true;
                    continue;
                }
                if (this.earliestStart == null || ((Date)object4).before(this.earliestStart)) {
                    this.earliestStart = object4;
                }
                if (this.latestStart != null && !((Date)object4).after(this.latestStart)) continue;
                this.latestStart = object4;
            }
            catch (TestResult.Fault fault) {
                vector4.addElement(testDescription);
            }
        }
        object3 = this.envTable.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object = (Vector)this.envTable.get(object2);
            int n = ((Vector)object).size() == 1 ? 0 : 1;
            this.envCounts[n] = this.envCounts[n] + 1;
        }
        if (vector.size() > 0) {
            this.badChecksumTests = new TestResult[vector.size()];
            vector.copyInto(this.badChecksumTests);
        }
        if (vector2.size() > 0) {
            this.badTestDescriptions = new TestResult[vector2.size()];
            vector2.copyInto(this.badTestDescriptions);
        }
        if (vector3.size() > 0) {
            this.badTestCaseTests = new TestResult[vector3.size()];
            vector3.copyInto(this.badTestCaseTests);
        }
        if (vector4.size() > 0) {
            this.badTests = new TestDescription[vector4.size()];
            vector4.copyInto(this.badTests);
        }
    }

    public TestResult[] getBadChecksumTests() {
        return this.badChecksumTests;
    }

    public TestResult[] getBadTestDescriptions() {
        return this.badTestDescriptions;
    }

    public TestDescription[] getBadTests() {
        return this.badTests;
    }

    public TestResult[] getBadTestCaseTests() {
        return this.badTestCaseTests;
    }

    public int[] getChecksumCounts() {
        return this.checksumCounts;
    }

    public int[] getEnvCounts() {
        return this.envCounts;
    }

    public Hashtable getEnvTable() {
        return this.envTable;
    }

    public int[] getStatusCounts() {
        return this.statusCounts;
    }

    public Date getEarliestStartTime() {
        return this.earliestStart;
    }

    public Date getLatestStartTime() {
        return this.latestStart;
    }

    public boolean hasBadStartTimes() {
        return this.badDates;
    }

    public boolean isOK() {
        return this.isStatusCountsOK() && this.isChecksumCountsOK() && this.isDateStampsOK() && this.isAllTestsOK() && this.isAllTestCasesOK() && this.isAllTestDescriptionsOK();
    }

    public boolean isAllTestsOK() {
        return this.badTests == null;
    }

    public boolean isAllTestCasesOK() {
        return this.badTestCaseTests == null;
    }

    public boolean isAllTestDescriptionsOK() {
        return this.badTestDescriptions == null;
    }

    public boolean isChecksumCountsOK() {
        return this.checksumCounts[1] == 0;
    }

    public boolean isDateStampsOK() {
        return this.earliestStart != null && this.latestStart != null && !this.badDates;
    }

    public boolean isStatusCountsOK() {
        if (this.testCount == 0) {
            return false;
        }
        int n = 0;
        while (n < this.statusCounts.length) {
            if (n != 0 && this.statusCounts[n] != 0) {
                return false;
            }
            ++n;
        }
        return this.statusCounts[0] == this.testCount;
    }

    public synchronized void report(PrintStream printStream, boolean bl, boolean bl2) {
        this.out = printStream;
        this.showResultCounts();
        this.showChecksumCounts();
        this.showDateStampInfo();
        this.showEnvCounts();
        this.showBadChecksums();
        this.showBadTestDescriptions();
        this.showBadTestCaseTests();
        this.showBadTests();
        if (bl || bl2) {
            this.showEnvValues(bl);
        }
    }

    private void showBadChecksums() {
        if (this.badChecksumTests != null) {
            this.out.println("The following " + this.badChecksumTests.length + " tests had bad checksums.");
            int n = 0;
            while (n < this.badChecksumTests.length) {
                TestResult testResult = this.badChecksumTests[n];
                this.out.println(testResult.getWorkRelativePath());
                ++n;
            }
        }
    }

    private void showBadTestDescriptions() {
        if (this.badTestDescriptions != null) {
            this.out.println("The following " + this.badTestDescriptions.length + " tests had bad test descriptions.");
            int n = 0;
            while (n < this.badTestDescriptions.length) {
                TestResult testResult = this.badTestDescriptions[n];
                this.out.println(testResult.getWorkRelativePath());
                ++n;
            }
        }
    }

    private void showBadTestCaseTests() {
        if (this.badTestCaseTests != null) {
            this.out.println(i18n.getString("adt.tooManyTestCases", new Integer(this.badTestCaseTests.length)));
            int n = 0;
            while (n < this.badTestCaseTests.length) {
                TestResult testResult = this.badTestCaseTests[n];
                this.out.println(testResult.getWorkRelativePath());
                ++n;
            }
        }
    }

    private void showBadTests() {
        if (this.badTests != null) {
            this.out.println(i18n.getString("adt.badTests", new Integer(this.badTests.length)));
            int n = 0;
            while (n < this.badTests.length) {
                TestDescription testDescription = this.badTests[n];
                this.out.println(TestResult.getWorkRelativePath(testDescription));
                ++n;
            }
        }
    }

    private void showDateStampInfo() {
        if (this.earliestStart == null || this.latestStart == null) {
            this.out.println(i18n.getString("adt.noDateStamps"));
        } else {
            Integer n = new Integer(this.badDates ? 1 : 0);
            this.out.println(i18n.getString("adt.earliestResult", new Object[]{this.earliestStart, n}));
            this.out.println(i18n.getString("adt.latestResult", new Object[]{this.latestStart, n}));
            if (this.badDates) {
                this.out.println(i18n.getString("adt.badDateStamps"));
            }
        }
    }

    private void showEnvCounts() {
        int n = this.envCounts[0];
        int n2 = this.envCounts[1];
        if (n + n2 > 0) {
            if (n2 == 0) {
                this.out.println(i18n.getString("adt.env.allOK"));
            } else {
                this.out.println(i18n.getString("adt.env.count", new Object[]{new Integer(n), new Integer(n > 0 && n2 > 0 ? 1 : 0), new Integer(n2)}));
            }
        }
    }

    private void showEnvValues(boolean bl) {
        Object object;
        this.out.println();
        this.out.print(i18n.getString("adt.envList.title"));
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Enumeration enumeration = this.envTable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            treeSet.add(object);
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            Vector vector = (Vector)this.envTable.get(string);
            if (vector.size() == 1) {
                if (!bl) continue;
                this.out.println(i18n.getString("adt.envKeyValue", new Object[]{string, vector.elementAt(0)}));
                continue;
            }
            this.out.println(i18n.getString("adt.envKey", string));
            int n = 0;
            while (n < vector.size()) {
                this.out.println(i18n.getString("adt.envValue", vector.elementAt(n)));
                ++n;
            }
        }
    }

    private void showChecksumCounts() {
        if (this.testCount > 0) {
            int n = this.checksumCounts[2];
            int n2 = this.checksumCounts[1];
            int n3 = this.checksumCounts[0];
            if (n2 == 0 && n3 == 0) {
                this.out.println(i18n.getString("adt.cs.allOK"));
            } else {
                this.out.println(i18n.getString("adt.cs.count", new Object[]{new Integer(n), new Integer(n > 0 && n2 + n3 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 > 0 ? 1 : 0), new Integer(n3)}));
            }
        }
    }

    private void showResultCounts() {
        if (this.testCount == 0) {
            this.out.println(i18n.getString("adt.status.noTests"));
        } else {
            int n = this.statusCounts[0];
            int n2 = this.statusCounts[1];
            int n3 = this.statusCounts[2];
            int n4 = this.statusCounts[3];
            if (n == this.testCount) {
                this.out.println(i18n.getString("adt.status.allOK"));
            } else {
                this.out.println(i18n.getString("adt.status.count", new Object[]{new Integer(n), new Integer(n > 0 && n2 + n3 + n4 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 + n4 > 0 ? 1 : 0), new Integer(n3), new Integer(n3 > 0 && n4 > 0 ? 1 : 0), new Integer(n4)}));
            }
        }
    }

    private boolean showCount(String string, boolean bl, int n) {
        if (n == 0) {
            return bl;
        }
        this.out.print(i18n.getString(string, new Object[]{new Integer(bl ? 1 : 0), new Integer(n)}));
        return true;
    }

    private boolean checkTestCases(TestResult testResult, ExcludeList excludeList) throws TestResult.Fault {
        String string = testResult.getProperty("excludedTestCases");
        if (string == null) {
            return true;
        }
        String[] stringArray = StringArray.split(string);
        if (excludeList.excludesAllOf(testResult.getDescription())) {
            return true;
        }
        String[] stringArray2 = excludeList.getTestCases(testResult.getDescription());
        if (stringArray2 == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (!stringArray[n].equals(stringArray2[n2])) {
                        ++n2;
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean equal(TestDescription testDescription, TestDescription testDescription2) {
        if (testDescription == null || testDescription2 == null) {
            return testDescription == testDescription2;
        }
        Iterator iterator = testDescription.getParameterKeys();
        Iterator iterator2 = testDescription2.getParameterKeys();
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string;
            String string2;
            String string3 = (String)iterator.next();
            if (!string3.equals(string2 = (String)iterator2.next())) {
                return false;
            }
            String string4 = testDescription.getParameter(string3);
            if (string4.equals(string = testDescription.getParameter(string2)) || string3.equals("keywords") && Audit.keywordMatch(string4, string)) continue;
            return false;
        }
        return true;
    }

    private static final boolean keywordMatch(String string, String string2) {
        Object[] objectArray = StringArray.split(string);
        Arrays.sort(objectArray);
        Object[] objectArray2 = StringArray.split(string2);
        Arrays.sort(objectArray2);
        return objectArray.equals(objectArray2);
    }

    private Date parseDate(String string) {
        if (this.dateFormats == null) {
            this.initDateFormats();
        }
        int n = 0;
        while (n < this.dateFormats.length) {
            try {
                Date date = this.dateFormats[n].parse(string);
                if (n > 0) {
                    DateFormat dateFormat = this.dateFormats[n];
                    System.arraycopy(this.dateFormats, 0, this.dateFormats, 1, n);
                    this.dateFormats[0] = dateFormat;
                }
                return date;
            }
            catch (ParseException parseException) {
                ++n;
            }
        }
        return null;
    }

    private void initDateFormats() {
        Vector<DateFormat> vector = new Vector<DateFormat>();
        vector.addElement(DateFormat.getDateTimeInstance());
        vector.addElement(DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH));
        vector.addElement(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz"));
        vector.addElement(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz", Locale.ENGLISH));
        vector.addElement(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
        vector.addElement(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH));
        String string = System.getProperty("javatest.date.format");
        if (string != null) {
            vector.addElement(new SimpleDateFormat(string));
        }
        this.dateFormats = new DateFormat[vector.size()];
        vector.copyInto(this.dateFormats);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

