/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.util.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;

public class SocketConnection
implements Connection {
    private final Socket socket;
    private final InputStream socketInput;
    private final OutputStream socketOutput;
    private String name;
    private boolean closed;
    private Thread waitThread;
    private static Timer timer = new Timer();
    private static Hashtable addressCache = new Hashtable();

    public SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
    }

    public SocketConnection(String string, int n) throws IOException {
        this.socket = new Socket(string, n);
        this.socketInput = this.socket.getInputStream();
        this.socketOutput = this.socket.getOutputStream();
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append(SocketConnection.getHostName(this.socket.getInetAddress()));
            stringBuffer.append(",port=");
            stringBuffer.append(this.socket.getPort());
            stringBuffer.append(",localport=");
            stringBuffer.append(this.socket.getLocalPort());
            this.name = stringBuffer.toString();
        }
        return this.name;
    }

    public InputStream getInputStream() {
        return this.socketInput;
    }

    public OutputStream getOutputStream() {
        return this.socketOutput;
    }

    public synchronized void close() throws IOException {
        this.socket.close();
        this.socketInput.close();
        this.socketOutput.close();
        this.closed = true;
        if (this.waitThread != null) {
            this.waitThread.interrupt();
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilClosed(int n) throws InterruptedException {
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            this.waitThread = Thread.currentThread();
        }
        Timer.Timeable timeable = new Timer.Timeable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timeout() {
                SocketConnection socketConnection = SocketConnection.this;
                synchronized (socketConnection) {
                    if (SocketConnection.this.waitThread != null) {
                        SocketConnection.this.waitThread.interrupt();
                    }
                    try {
                        SocketConnection.this.socketInput.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        SocketConnection.this.socketOutput.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        Timer.Entry entry = timer.requestDelayedCallback(timeable, n);
        try {
            try {
                int n2;
                while ((n2 = this.socketInput.read()) != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            timer.cancel(entry);
            SocketConnection socketConnection2 = this;
            synchronized (socketConnection2) {
                this.waitThread = null;
            }
        }
    }

    private static String getHostName(InetAddress inetAddress) {
        String string = (String)addressCache.get(inetAddress);
        if (string == null) {
            string = inetAddress.getHostName();
            addressCache.put(inetAddress, string);
        }
        return string;
    }
}

