/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialPortConnection
implements Connection {
    private String name;
    private SerialPort port;
    private InputStream portInputStream;
    private OutputStream portOutputStream;
    private boolean closed;
    private static final int baudRate = Integer.getInteger("javatest.serialPort.baudRate", 38400);

    public SerialPortConnection(String string, String string2, int n) throws IOException, NoSuchPortException, PortInUseException, InterruptedException {
        this(SerialPortConnection.open(CommPortIdentifier.getPortIdentifier((String)string), string2, n));
    }

    public SerialPortConnection(CommPortIdentifier commPortIdentifier, String string, int n) throws IOException, PortInUseException, InterruptedException {
        this(SerialPortConnection.open(commPortIdentifier, string, n));
    }

    private SerialPortConnection(SerialPort serialPort) throws IOException, InterruptedException {
        this.port = serialPort;
        this.portInputStream = serialPort.getInputStream();
        this.portOutputStream = serialPort.getOutputStream();
        try {
            serialPort.setSerialPortParams(baudRate, 8, 1, 0);
            serialPort.setFlowControlMode(3);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new IOException(unsupportedCommOperationException.toString());
        }
        int n = this.portInputStream.available();
        if (n > 0) {
            this.portInputStream.skip(n);
        }
        serialPort.setDTR(true);
        try {
            serialPort.addEventListener(new SerialPortEventListener(){

                public void serialEvent(SerialPortEvent serialPortEvent) {
                    int n = serialPortEvent.getEventType();
                    switch (serialPortEvent.getEventType()) {
                        case 4: 
                        case 6: {
                            SerialPortConnection.this.updateReadyStatus();
                        }
                    }
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        serialPort.notifyOnCarrierDetect(true);
        serialPort.notifyOnDSR(true);
        this.waitUntilReady();
    }

    public String getName() {
        return this.port.getName();
    }

    public InputStream getInputStream() {
        return this.portInputStream;
    }

    public OutputStream getOutputStream() {
        return new FilterOutputStream(this.portOutputStream){

            public void flush() throws IOException {
                if (!SerialPortConnection.this.closed) {
                    super.flush();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                this.port.setDTR(false);
                this.port.close();
                Object var2_1 = null;
                this.closed = true;
                this.notifyAll();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closed = true;
                this.notifyAll();
                throw throwable;
            }
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void waitUntilClosed(int n) throws InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = l + (long)n;
        while (l < l2 && !this.closed) {
            this.wait(l2 - l);
            l = System.currentTimeMillis();
        }
    }

    private static SerialPort open(CommPortIdentifier commPortIdentifier, String string, int n) throws IOException, PortInUseException {
        if (commPortIdentifier.getPortType() != 1) {
            throw new IllegalArgumentException("not a serial port: " + commPortIdentifier.getName());
        }
        return (SerialPort)commPortIdentifier.open(string, n);
    }

    private synchronized void updateReadyStatus() {
        if (this.port.isDSR() || this.port.isCD()) {
            this.notifyAll();
        } else {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        SerialPortConnection.this.close();
                    }
                    catch (IOException iOException) {}
                }
            };
            thread.start();
        }
    }

    private synchronized void waitUntilReady() throws InterruptedException {
        while (!this.port.isDSR() && !this.port.isCD()) {
            this.wait();
        }
    }

    private String parityToString(int n) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return "odd";
            }
            case 2: {
                return "even";
            }
            case 3: {
                return "mark";
            }
            case 4: {
                return "space";
            }
        }
        return "?" + n + "?";
    }

    private String flowControlToString(int n) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 3: {
                return "h/w";
            }
            case 12: {
                return "s/w";
            }
        }
        return "?" + n + "?";
    }
}

