/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.BadValue;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.ModeOptions;
import com.sun.javatest.agent.PassiveConnectionFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.TextField;
import java.io.IOException;

class PassiveModeOptions
extends ModeOptions {
    private Label portLabel;
    private TextField portField;

    PassiveModeOptions() {
        super("passive");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.portLabel = new Label("port:");
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.portLabel, gridBagConstraints);
        String string = Integer.toString(1908);
        this.portField = new TextField(string, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.portField, gridBagConstraints);
    }

    ConnectionFactory createConnectionFactory(int n) throws BadValue, ConnectionFactory.Fault {
        try {
            int n2 = ModeOptions.getInt("port", this.portField);
            if (n2 < 0) {
                throw new BadValue("port may not be negative");
            }
            if (n < 0) {
                throw new BadValue("concurrency may not be negative");
            }
            return new PassiveConnectionFactory(n2, n);
        }
        catch (IOException iOException) {
            throw new ConnectionFactory.Fault(iOException, true);
        }
    }

    void setPort(int n) {
        this.portField.setText(Integer.toString(n));
    }
}

