/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

class Icon
extends Component {
    protected Image image;
    private Dimension imageSize;

    public Icon(Image image) {
        this.image = image;
        this.waitForSize();
        this.imageSize = new Dimension(-1, -1);
        this.imageSize.width = image.getWidth(this);
        this.imageSize.height = image.getHeight(this);
    }

    public Icon(String string) {
        Toolkit toolkit = this.getToolkit();
        this.imageSize = new Dimension(-1, -1);
        this.image = toolkit.getImage(string);
        this.waitForSize();
        this.imageSize.width = this.image.getWidth(this);
        this.imageSize.height = this.image.getHeight(this);
        this.setName(string);
    }

    public Icon(URL uRL) {
        Toolkit toolkit = this.getToolkit();
        this.imageSize = new Dimension(-1, -1);
        this.image = toolkit.getImage(uRL);
        this.waitForSize();
        this.imageSize.width = this.image.getWidth(this);
        this.imageSize.height = this.image.getHeight(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.imageSize;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            Dimension dimension = this.getSize();
            graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, this);
        }
    }

    protected void waitForSize() {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected Dimension getImageSize() {
        return this.imageSize;
    }
}

