/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import java.awt.AWTEventMulticaster;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;

class Folder
extends Panel
implements ItemSelectable {
    private ItemListener itemListener;
    private Vector entries = new Vector();
    private int border;
    private int slant;
    private int tabSpace;
    private int hgap;
    private int vgap;
    private int tabpad;

    public Folder() {
        this(0, 0);
    }

    public Folder(int n, int n2) {
        this(n, n2, 10, 5, 5);
    }

    Folder(int n, int n2, int n3, int n4, int n5) {
        this.hgap = n;
        this.vgap = n2;
        this.border = n3;
        this.slant = n4;
        this.tabSpace = n5;
        this.tabpad = 10;
        this.setLayout(new CardLayout());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Folder.this.mousePressed(mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public Insets getInsets() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.border + this.hgap;
        int n2 = this.border + (fontMetrics == null ? 0 : fontMetrics.getHeight()) + this.tabpad + this.vgap;
        int n3 = this.border + this.vgap;
        return new Insets(n2, n, n3, n);
    }

    public Component add(String string, Component component) {
        this.entries.addElement(new Entry(component, string, null, true));
        return super.add(string, component);
    }

    public Component add(String string, Component component, Color color) {
        this.entries.addElement(new Entry(component, string, color, true));
        return super.add(string, component);
    }

    public Component add(String string, Component component, Color color, boolean bl) {
        this.entries.addElement(new Entry(component, string, color, bl));
        return super.add(string, component);
    }

    public void showTab(String string) {
        this.showTab(string, true);
    }

    public void hideTab(String string) {
        this.showTab(string, false);
    }

    public void showTab(String string, boolean bl) {
        int n = 0;
        while (n < this.entries.size()) {
            Entry entry = (Entry)this.entries.elementAt(n);
            if (entry.name.equals(string)) {
                if (entry.visibleTab != bl) {
                    entry.visibleTab = bl;
                    this.repaint();
                }
                return;
            }
            ++n;
        }
    }

    public String getNextVisibleTab() {
        int n = Math.max(0, this.getCurrentIndex());
        int n2 = n + 1;
        while (n2 < this.entries.size()) {
            Entry entry = (Entry)this.entries.elementAt(n2);
            if (entry.visibleTab) {
                return entry.name;
            }
            ++n2;
        }
        return null;
    }

    public String getPrevVisibleTab() {
        int n = this.getCurrentIndex();
        int n2 = n - 1;
        while (n2 >= 0) {
            Entry entry = (Entry)this.entries.elementAt(n2);
            if (entry.visibleTab) {
                return entry.name;
            }
            --n2;
        }
        return null;
    }

    public Component current() {
        int n = 0;
        while (n < this.entries.size()) {
            Entry entry = (Entry)this.entries.elementAt(n);
            if (entry.comp.isVisible()) {
                return entry.comp;
            }
            ++n;
        }
        return null;
    }

    public void show(Component component) {
        int n = 0;
        while (n < this.entries.size()) {
            Entry entry = (Entry)this.entries.elementAt(n);
            if (entry.comp == component) {
                this.show(entry);
                return;
            }
            ++n;
        }
    }

    public void show(String string) {
        int n = 0;
        while (n < this.entries.size()) {
            Entry entry = (Entry)this.entries.elementAt(n);
            if (entry.name.equals(string)) {
                this.show(entry);
                return;
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight() + this.tabpad;
        Entry entry = null;
        int n2 = 0;
        while (n2 < this.entries.size()) {
            Entry entry2 = (Entry)this.entries.elementAt(n2);
            if (entry2.comp.isVisible()) {
                entry = entry2;
                break;
            }
            ++n2;
        }
        graphics.setColor(entry.color != null ? entry.color : this.getBackground());
        graphics.fillRoundRect(this.hgap, n + this.vgap, dimension.width - 2 * this.hgap - 1, dimension.height - n - 2 * this.vgap - 1, this.border, this.border);
        graphics.setColor(this.getForeground());
        graphics.drawRoundRect(this.hgap, n + this.vgap, dimension.width - 2 * this.hgap - 1, dimension.height - n - 2 * this.vgap - 1, this.border, this.border);
        int n3 = this.border + this.hgap;
        int n4 = n + this.vgap;
        int n5 = 0;
        while (n5 < this.entries.size()) {
            Entry entry3 = (Entry)this.entries.elementAt(n5);
            int n6 = entry3.visibleTab || entry3.comp.isVisible() ? n : n / 3;
            int n7 = fontMetrics.stringWidth(entry3.name);
            Polygon polygon = new Polygon();
            polygon.addPoint(n3, n4);
            polygon.addPoint(n3 + this.slant, n4 - n6);
            polygon.addPoint(n3 + this.slant + n7, n4 - n6);
            polygon.addPoint(n3 + this.slant + n7 + this.slant, n4);
            if (entry3.color != null) {
                graphics.setColor(entry3.color);
                graphics.fillPolygon(polygon);
            }
            graphics.setColor(this.getForeground());
            graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
            graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
            graphics.drawLine(polygon.xpoints[2], polygon.ypoints[2], polygon.xpoints[3], polygon.ypoints[3]);
            if (entry3.visibleTab || entry3.comp.isVisible()) {
                graphics.drawString(entry3.name, n3 + this.slant, n4 - this.tabpad / 2 - fontMetrics.getDescent());
            }
            if (entry3.comp.isVisible()) {
                graphics.setColor(entry3.color != null ? entry3.color : this.getBackground());
                graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[3], polygon.ypoints[3]);
            }
            n3 = polygon.xpoints[3] + this.tabSpace;
            ++n5;
        }
        super.paint(graphics);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        Entry entry = this.getCurrentEntry();
        if (entry == null) {
            return null;
        }
        return new Object[]{entry.comp};
    }

    int getMinimumWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.border + 2 * this.hgap + this.tabSpace;
        int n2 = 0;
        while (n2 < this.entries.size()) {
            Entry entry = (Entry)this.entries.elementAt(n2);
            n += this.slant + (fontMetrics == null ? 0 : fontMetrics.stringWidth(entry.name)) + this.slant + this.tabSpace;
            ++n2;
        }
        return n;
    }

    private void show(Entry entry) {
        Entry entry2 = this.getCurrentEntry();
        Component component = entry2 == null ? null : entry2.comp;
        ((CardLayout)this.getLayout()).show(this, entry.name);
        this.repaint();
        if (this.itemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, component, 2);
            ItemEvent itemEvent2 = new ItemEvent(this, 701, entry.comp, 1);
            this.itemListener.itemStateChanged(itemEvent);
            this.itemListener.itemStateChanged(itemEvent2);
        }
    }

    private int getCurrentIndex() {
        int n = 0;
        while (n < this.entries.size()) {
            Entry entry = (Entry)this.entries.elementAt(n);
            if (entry.comp.isVisible()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Entry getCurrentEntry() {
        int n = this.getCurrentIndex();
        return n == -1 ? null : (Entry)this.entries.elementAt(n);
    }

    void mousePressed(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.vgap < n2 && n2 < this.border + fontMetrics.getHeight() + this.vgap) {
            int n3 = this.border + this.hgap;
            int n4 = 0;
            while (n4 < this.entries.size()) {
                Entry entry = (Entry)this.entries.elementAt(n4);
                int n5 = fontMetrics.stringWidth(entry.name);
                if (n < (n3 += this.slant + n5 + this.slant + this.tabSpace)) {
                    this.show(entry);
                    break;
                }
                ++n4;
            }
        }
    }

    private class Layout
    extends CardLayout {
        private Layout() {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = super.minimumLayoutSize(container);
            int n = Math.max(dimension.width, ((Folder)container).getMinimumWidth());
            return new Dimension(n, dimension.height);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = super.preferredLayoutSize(container);
            int n = Math.max(dimension.width, ((Folder)container).getMinimumWidth());
            return new Dimension(n, dimension.height);
        }
    }

    private class Entry {
        Component comp;
        String name;
        Color color;
        boolean visibleTab;

        Entry(Component component, String string, Color color, boolean bl) {
            this.comp = component;
            this.name = string;
            this.color = color;
            this.visibleTab = bl;
        }
    }
}

