/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Agent;
import java.io.IOException;
import java.io.Writer;

class AgentWriter
extends Writer {
    private byte type;
    private Agent.Task parent;
    private char[] buf = new char[1024];
    private int count = 0;

    AgentWriter(byte by, Agent.Task task) {
        this.type = by;
        this.parent = task;
    }

    public synchronized void write(int n) throws IOException {
        this.buf[this.count++] = (char)n;
        if (this.count == this.buf.length) {
            this.parent.sendChars(this.type, this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public synchronized void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 < this.buf.length - this.count) {
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count += n2;
        } else {
            this.flush();
            if (n2 < this.buf.length) {
                System.arraycopy(cArray, n, this.buf, this.count, n2);
                this.count += n2;
            } else {
                this.parent.sendChars(this.type, cArray, n, n2);
            }
        }
    }

    public synchronized void flush() throws IOException {
        if (this.count > 0) {
            switch (this.type) {
                case 76: {
                    this.type = (byte)108;
                    break;
                }
                case 82: {
                    this.type = (byte)114;
                }
            }
            this.parent.sendChars(this.type, this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void close() throws IOException {
        this.flush();
    }
}

