/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.Status;
import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.BadValue;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.Deck;
import com.sun.javatest.agent.Folder;
import com.sun.javatest.agent.Icon;
import com.sun.javatest.agent.Map;
import com.sun.javatest.agent.ModeOptions;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

class AgentPanel
extends ScrollPane {
    private MapReader mapReader;
    private Deck deck;
    private ErrorPanel errorPanel;
    private HelpPanel helpPanel;
    private Panel mainPanel;
    private Folder mainFolder;
    private ButtonPanel buttonPanel;
    private ParamPanel paramPanel;
    private StatsPanel statsPanel;
    private TaskPanel taskPanel;
    private HistoryList historyList;
    private AgentObserver agentObs;
    private Agent.Observer userObs;
    private Agent currAgent;
    private static final String[] statusCodes = new String[]{"PASS", "FAIL", "CHCK", "ERR ", "!RUN"};

    public AgentPanel(ModeOptions[] modeOptionsArray, MapReader mapReader) {
        this.mapReader = mapReader;
        this.initGUI(modeOptionsArray);
    }

    public synchronized void setMode(String string) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setMode(string);
    }

    public void setConcurrency(int n) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setConcurrency(n);
    }

    public void setMapFile(String string) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setMapFile(string);
    }

    public void setRetryDelay(int n) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setRetryDelay(n);
    }

    public void setHistoryLimit(int n) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.historyList.setMaxTasks(n);
    }

    public void addObserver(Agent.Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (this.userObs != null) {
            throw new IllegalStateException("just one observer can be registered");
        }
        this.userObs = observer;
    }

    public synchronized void start() {
        try {
            this.currAgent = this.paramPanel.createAgent();
            this.currAgent.addObserver(this.agentObs);
            if (this.userObs != null) {
                this.currAgent.addObserver(this.userObs);
            }
            Thread thread = new Thread((Runnable)this.currAgent, "AgentPanel worker thread");
            thread.start();
            this.paramPanel.setEnabled(false);
            this.buttonPanel.setStartEnabled(false);
            this.buttonPanel.setStopEnabled(true);
        }
        catch (BadValue badValue) {
            this.error(badValue.getMessages());
        }
        catch (SecurityException securityException) {
            String[] stringArray = new String[]{"Security Exception", securityException.getMessage()};
            this.error(stringArray);
        }
        catch (ConnectionFactory.Fault fault) {
            String[] stringArray = new String[]{"cannot create connection", fault.getMessage()};
            this.error(stringArray);
        }
        catch (IOException iOException) {
            String[] stringArray = new String[]{"problem reading map file", iOException.getMessage()};
            this.error(stringArray);
        }
    }

    public synchronized void stop() {
        this.buttonPanel.setStopEnabled(false);
        if (this.currAgent != null) {
            this.currAgent.interrupt();
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.deck.getPreferredSize();
        return new Dimension(insets.left + dimension.width + insets.right, insets.top + dimension.height + insets.bottom);
    }

    void showTask(TaskState taskState) {
        this.mainFolder.show(this.taskPanel);
        this.taskPanel.setTask(taskState);
    }

    private void initGUI(ModeOptions[] modeOptionsArray) {
        this.agentObs = new AgentObserver();
        this.deck = new Deck();
        this.initMainPanel(modeOptionsArray);
        this.deck.add(this.mainPanel);
        this.errorPanel = new ErrorPanel();
        this.deck.add(this.errorPanel);
        this.helpPanel = new HelpPanel();
        this.deck.add(this.helpPanel);
        this.add(this.deck);
    }

    Component initMainPanel(ModeOptions[] modeOptionsArray) {
        this.mainPanel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainFolder = new Folder();
        this.paramPanel = new ParamPanel(modeOptionsArray);
        this.mainFolder.add("parameters", this.paramPanel);
        this.statsPanel = new StatsPanel();
        this.mainFolder.add("statistics", this.statsPanel);
        this.historyList = new HistoryList();
        this.mainFolder.add("history", this.historyList);
        this.taskPanel = new TaskPanel();
        this.mainFolder.add("selected task", this.taskPanel);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        this.mainPanel.add((Component)this.mainFolder, gridBagConstraints);
        this.buttonPanel = new ButtonPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 20;
        this.mainPanel.add((Component)this.buttonPanel, gridBagConstraints);
        return this.mainPanel;
    }

    private void setIdle() {
        this.paramPanel.setEnabled(true);
        this.buttonPanel.setStartEnabled(true);
        this.buttonPanel.setStopEnabled(false);
        this.currAgent = null;
        this.notifyAll();
    }

    private void showHelp() {
        this.deck.show(this.helpPanel);
    }

    private void error(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
        this.errorPanel.show(stringArray);
        this.deck.show(this.errorPanel);
    }

    private void ackError() {
        this.deck.show(this.mainPanel);
    }

    private static int getInt(String string, TextField textField) throws BadValue {
        try {
            return Integer.parseInt(textField.getText(), 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadValue("bad value in `" + string + "' field");
        }
    }

    private class TaskPanel
    extends Panel {
        private TaskState task;
        private Label clientField;
        private Label tagField;
        private Label classField;
        private TextField argsField;
        private Label resultField;

        TaskPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 0;
            Label label = new Label("client:");
            this.add((Component)label, gridBagConstraints);
            this.clientField = new Label("");
            this.add((Component)this.clientField, gridBagConstraints2);
            Label label2 = new Label("request:");
            this.add((Component)label2, gridBagConstraints);
            this.tagField = new Label("");
            this.add((Component)this.tagField, gridBagConstraints2);
            Label label3 = new Label("class:");
            this.add((Component)label3, gridBagConstraints);
            this.classField = new Label("");
            this.add((Component)this.classField, gridBagConstraints2);
            Label label4 = new Label("args:");
            this.add((Component)label4, gridBagConstraints);
            this.argsField = new TextField("");
            this.argsField.setEditable(false);
            this.add((Component)this.argsField, gridBagConstraints2);
            Label label5 = new Label("result:");
            this.add((Component)label5, gridBagConstraints);
            this.resultField = new Label("");
            this.add((Component)this.resultField, gridBagConstraints2);
        }

        TaskState getTask() {
            return this.task;
        }

        void setTask(TaskState taskState) {
            this.task = taskState;
            this.update();
        }

        void update() {
            if (this.task == null) {
                this.clientField.setText("");
                this.tagField.setText("");
                this.classField.setText("");
                this.argsField.setText("");
                this.resultField.setText("");
            } else {
                this.clientField.setText(this.task.connection.getName());
                this.tagField.setText(this.task.tag);
                this.classField.setText(this.task.className);
                String string = "";
                if (this.task.args != null) {
                    int n = 0;
                    while (n < this.task.args.length) {
                        string = string + this.task.args[n] + " ";
                        ++n;
                    }
                }
                this.argsField.setText(string);
                if (this.task.status == null) {
                    this.resultField.setText("");
                } else {
                    this.resultField.setText(this.task.status.toString());
                }
            }
        }
    }

    private class StatsPanel
    extends Panel {
        private Vector tasks = new Vector();
        private int[] statusCounts = new int[4];
        private int exceptionsCount;
        private TextField activeField;
        private TextField[] statusFields = new TextField[4];
        private TextField exceptionsField;

        StatsPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            this.activeField = this.addField("currently active:", gridBagConstraints, gridBagConstraints2);
            this.statusFields[0] = this.addField("passed:", gridBagConstraints, gridBagConstraints2);
            this.statusFields[1] = this.addField("failed:", gridBagConstraints, gridBagConstraints2);
            this.statusFields[2] = this.addField("error:", gridBagConstraints, gridBagConstraints2);
            this.statusFields[3] = this.addField("not run:", gridBagConstraints, gridBagConstraints2);
            this.exceptionsField = this.addField("exceptions:", gridBagConstraints, gridBagConstraints2);
        }

        void reset() {
            this.tasks.setSize(0);
            int n = 0;
            while (n < this.statusCounts.length) {
                this.statusCounts[n] = 0;
                ++n;
            }
            this.exceptionsCount = 0;
            this.activeField.setText("0");
            int n2 = 0;
            while (n2 < this.statusCounts.length) {
                this.statusFields[n2].setText("0");
                ++n2;
            }
            this.exceptionsField.setText("0");
        }

        void startedTask(TaskState taskState) {
            this.tasks.addElement(taskState);
            this.activeField.setText(String.valueOf(this.tasks.size()));
        }

        void finishedTask(TaskState taskState, boolean bl) {
            int n = this.tasks.indexOf(taskState);
            if (n == -1) {
                return;
            }
            this.tasks.removeElementAt(n);
            this.activeField.setText(String.valueOf(this.tasks.size()));
            if (!bl) {
                this.exceptionsField.setText(String.valueOf(++this.exceptionsCount));
            }
            if (taskState.status != null) {
                int n2;
                int n3 = n2 = taskState.status.getType();
                int n4 = this.statusCounts[n3] + 1;
                this.statusCounts[n3] = n4;
                this.statusFields[n2].setText(String.valueOf(n4));
            }
        }

        private TextField addField(String string, GridBagConstraints gridBagConstraints, GridBagConstraints gridBagConstraints2) {
            this.add((Component)new Label(string), gridBagConstraints);
            TextField textField = new TextField("0", 10);
            textField.setEditable(false);
            this.add((Component)textField, gridBagConstraints2);
            return textField;
        }
    }

    private class ParamPanel
    extends Panel
    implements ItemListener {
        private Choice modeChoice;
        private Deck modeDeck;
        private TextField mapFileField;
        private Label concurrencyLabel;
        private TextField concurrencyField;
        private int retryDelay;

        ParamPanel(ModeOptions[] modeOptionsArray) {
            Component component;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            this.add((Component)new Label("mode:"), gridBagConstraints);
            this.modeChoice = new Choice();
            this.modeDeck = new Deck();
            int n = 0;
            while (n < modeOptionsArray.length) {
                component = modeOptionsArray[n];
                this.modeChoice.addItem(component.getModeName());
                this.modeDeck.add(component);
                ++n;
            }
            this.modeChoice.addItemListener(this);
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.gridwidth = 1;
            this.add((Component)this.modeChoice, gridBagConstraints2);
            gridBagConstraints2.insets.left = 20;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)this.modeDeck, gridBagConstraints2);
            gridBagConstraints2.insets.left = 0;
            this.add((Component)new Label("map:"), gridBagConstraints);
            this.mapFileField = new TextField();
            this.add((Component)this.mapFileField, gridBagConstraints2);
            component = new Label("concurrency:");
            this.add(component, gridBagConstraints);
            this.concurrencyField = new TextField("1", 3);
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.weightx = 0.0;
            this.add((Component)this.concurrencyField, gridBagConstraints2);
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)new Label(), gridBagConstraints2);
        }

        public void setEnabled(boolean bl) {
            this.modeChoice.setEnabled(bl);
            int n = 0;
            while (n < this.modeDeck.getComponentCount()) {
                ModeOptions modeOptions = (ModeOptions)this.modeDeck.getComponent(n);
                modeOptions.setEnabled(bl);
                ++n;
            }
            this.mapFileField.setEnabled(bl);
            this.concurrencyField.setEnabled(bl);
        }

        public void setMode(String string) {
            this.modeChoice.select(string);
            int n = 0;
            while (n < this.modeDeck.getComponentCount()) {
                ModeOptions modeOptions = (ModeOptions)this.modeDeck.getComponent(n);
                if (string.equals(modeOptions.getModeName())) {
                    this.modeDeck.show(modeOptions);
                    return;
                }
                ++n;
            }
        }

        public void setConcurrency(int n) {
            this.concurrencyField.setText(Integer.toString(n));
        }

        public void setMapFile(String string) {
            this.mapFileField.setText(string);
        }

        public void setRetryDelay(int n) {
            this.retryDelay = n;
        }

        public Agent createAgent() throws BadValue, ConnectionFactory.Fault, IOException {
            Map map = AgentPanel.this.mapReader.read(this.mapFileField.getText());
            int n = AgentPanel.getInt("concurrency", this.concurrencyField);
            if (n < 0) {
                throw new BadValue("bad value for `concurrency field': " + n);
            }
            ModeOptions modeOptions = (ModeOptions)this.modeDeck.getCurrentCard();
            ConnectionFactory connectionFactory = modeOptions.createConnectionFactory(n);
            Agent agent = new Agent(connectionFactory, n);
            if (this.retryDelay > 0) {
                agent.setRetryDelay(this.retryDelay);
            }
            agent.setMap(map);
            return agent;
        }

        private Deck createModeDeck(Choice choice) {
            return AgentPanel.this.deck;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.modeChoice) {
                String string = ((Choice)itemSelectable).getSelectedItem();
                int n = 0;
                while (n < this.modeDeck.getComponentCount()) {
                    ModeOptions modeOptions = (ModeOptions)this.modeDeck.getComponent(n);
                    if (string.equals(modeOptions.getModeName())) {
                        this.modeDeck.show(modeOptions);
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    private class HistoryList
    extends List
    implements ItemListener {
        private int maxTasks = 10;
        private Vector tasks = new Vector();

        HistoryList() {
            super(5, false);
            super.addItemListener(this);
        }

        public synchronized void addTask(TaskState taskState) {
            if (this.tasks.size() >= this.maxTasks) {
                int n = 0;
                while (n < this.tasks.size()) {
                    String string = this.getItem(n);
                    if (!string.startsWith("CONN") && !string.startsWith("EXEC")) {
                        this.tasks.removeElementAt(n);
                        super.remove(n);
                    }
                    ++n;
                }
            }
            this.tasks.addElement(taskState);
            super.add("CONN " + taskState.connection.getName());
        }

        public synchronized TaskState getTask(Connection connection) {
            int n = 0;
            while (n < this.tasks.size()) {
                TaskState taskState = (TaskState)this.tasks.elementAt(n);
                if (taskState.connection == connection) {
                    return taskState;
                }
                ++n;
            }
            throw new Error("AgentPanel.HistoryList.getTask: can't find socket");
        }

        public synchronized TaskState getSelectedTask() {
            return (TaskState)this.tasks.elementAt(super.getSelectedIndex());
        }

        public synchronized void removeAll() {
            this.tasks.setSize(0);
            if (this.getItemCount() > 0) {
                super.removeAll();
            }
        }

        public synchronized void removeTask(TaskState taskState) {
            int n = this.tasks.indexOf(taskState);
            this.tasks.removeElementAt(n);
            super.remove(n);
        }

        public synchronized void setMaxTasks(int n) {
            this.maxTasks = n;
        }

        public synchronized void update(TaskState taskState, String string, String string2) {
            super.replaceItem(this.getKey(string, string2), this.tasks.indexOf(taskState));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        AgentPanel.this.showTask(this.getSelectedTask());
                        break;
                    }
                    case 702: {
                        AgentPanel.this.showTask(null);
                    }
                }
            }
        }

        private String getKey(String string, String string2) {
            return string + " " + string2;
        }
    }

    private class HelpPanel
    extends Panel
    implements ActionListener {
        HelpPanel() {
            Icon icon;
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            Panel panel = new Panel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(20, 20, 20, 20);
            Icon icon2 = this.createIcon("jticon.gif");
            if (icon2 != null) {
                gridBagConstraints.anchor = 11;
                panel.add((Component)icon2, gridBagConstraints);
            }
            if ((icon = this.createIcon("100percent.gif")) != null) {
                gridBagConstraints.anchor = 15;
                panel.add((Component)icon, gridBagConstraints);
            }
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            this.add((Component)panel, gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridwidth = 0;
            Panel panel2 = new Panel(new GridBagLayout());
            Label label = new Label("JavaTest Agent");
            label.setFont(new Font("SansSerif", 1, 32));
            panel2.add((Component)label, gridBagConstraints3);
            Label label2 = new Label(ProductInfo.getVersion());
            label2.setFont(new Font("SansSerif", 1, 24));
            panel2.add((Component)label2, gridBagConstraints3);
            Label label3 = new Label("Copyright (c) 2003 Sun Microsystems, Inc. All rights reserved.");
            panel2.add((Component)label3, gridBagConstraints3);
            Label label4 = new Label("Use is subject to license terms.");
            panel2.add((Component)label4, gridBagConstraints3);
            String string = "  For full information on using the\n  JavaTest Agent, please refer to the\n     JavaTest User's Guide\n  and to the documentation for the\n  test suite you are using.\n";
            TextArea textArea = new TextArea(string, 5, 35, 3);
            textArea.setEditable(false);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            panel2.add((Component)textArea, gridBagConstraints3);
            Button button = new Button("OK");
            button.addActionListener(this);
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.insets.bottom = 10;
            panel2.add((Component)button, gridBagConstraints3);
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)panel2, gridBagConstraints2);
        }

        private Icon createIcon(String string) {
            try {
                URL uRL = this.getClass().getResource(string);
                if (uRL == null) {
                    return null;
                }
                Icon icon = new Icon(uRL);
                return icon;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            catch (Error error) {
                return null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgentPanel.this.ackError();
        }
    }

    private class ErrorPanel
    extends Panel
    implements ActionListener {
        private ErrorPanel() {
        }

        public synchronized void show(String[] stringArray) {
            Component component;
            this.removeAll();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(30, 30, 0, 30);
            int n = 0;
            while (n < stringArray.length) {
                component = new Label(stringArray[n]);
                this.add(component, gridBagConstraints);
                gridBagConstraints.insets.top = 0;
                ++n;
            }
            gridBagConstraints.insets.top = 30;
            gridBagConstraints.insets.bottom = 30;
            component = new Button("OK");
            ((Button)component).addActionListener(this);
            this.add(component, gridBagConstraints);
            this.validate();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgentPanel.this.ackError();
        }
    }

    private class ButtonPanel
    extends Panel
    implements ActionListener {
        private Button startButton;
        private Button stopButton;
        private Button helpButton;

        ButtonPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            this.startButton = new Button("Start");
            this.startButton.addActionListener(this);
            this.add((Component)this.startButton, gridBagConstraints);
            this.stopButton = new Button("Stop");
            this.stopButton.addActionListener(this);
            this.stopButton.setEnabled(false);
            this.add((Component)this.stopButton, gridBagConstraints);
            this.helpButton = new Button("Help");
            this.helpButton.addActionListener(this);
            this.add((Component)this.helpButton, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.startButton) {
                AgentPanel.this.start();
            } else if (object == this.stopButton) {
                AgentPanel.this.stop();
            } else if (object == this.helpButton) {
                AgentPanel.this.showHelp();
            }
        }

        void setStartEnabled(boolean bl) {
            this.startButton.setEnabled(bl);
        }

        void setStopEnabled(boolean bl) {
            this.stopButton.setEnabled(bl);
        }
    }

    private class AgentObserver
    implements Agent.Observer {
        private AgentObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void started(Agent agent) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                AgentPanel.this.historyList.removeAll();
                AgentPanel.this.taskPanel.setTask(null);
                AgentPanel.this.statsPanel.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void errorOpeningConnection(Agent agent, Exception exception) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                String[] stringArray = new String[]{"error opening connection", exception.getMessage()};
                AgentPanel.this.error(stringArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(Agent agent) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                AgentPanel.this.setIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void openedConnection(Agent agent, Connection connection) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState taskState = new TaskState(connection);
                AgentPanel.this.historyList.addTask(taskState);
                if (AgentPanel.this.taskPanel.getTask() == null) {
                    AgentPanel.this.taskPanel.setTask(taskState);
                }
                AgentPanel.this.statsPanel.startedTask(taskState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execTest(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState taskState = AgentPanel.this.historyList.getTask(connection);
                taskState.mode = 0;
                taskState.tag = string;
                taskState.className = string2;
                taskState.args = stringArray;
                AgentPanel.this.historyList.update(taskState, "EXEC", string);
                if (taskState == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execCommand(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState taskState = AgentPanel.this.historyList.getTask(connection);
                taskState.mode = 1;
                taskState.tag = string;
                taskState.className = string2;
                taskState.args = stringArray;
                AgentPanel.this.historyList.update(taskState, "EXEC", string);
                if (taskState == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execMain(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState taskState = AgentPanel.this.historyList.getTask(connection);
                taskState.mode = 2;
                taskState.tag = string;
                taskState.className = string2;
                taskState.args = stringArray;
                AgentPanel.this.historyList.update(taskState, "EXEC", string);
                if (taskState == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void result(Agent agent, Connection connection, Status status) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState taskState = AgentPanel.this.historyList.getTask(connection);
                taskState.status = status;
                if (taskState == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exception(Agent agent, Connection connection, Throwable throwable) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState taskState = AgentPanel.this.historyList.getTask(connection);
                if (taskState.tag == null) {
                    AgentPanel.this.historyList.removeTask(taskState);
                } else {
                    AgentPanel.this.historyList.update(taskState, "*IO*", taskState.tag);
                }
                AgentPanel.this.statsPanel.finishedTask(taskState, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(Agent agent, Connection connection) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (agent != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState taskState = AgentPanel.this.historyList.getTask(connection);
                AgentPanel.this.historyList.update(taskState, statusCodes[taskState.status.getType()], taskState.tag);
                AgentPanel.this.statsPanel.finishedTask(taskState, true);
            }
        }
    }

    private static class TaskState {
        Connection connection;
        int mode;
        String tag;
        String className;
        String[] args;
        Status status;
        static final int TEST = 0;
        static final int COMMAND = 1;
        static final int MAIN = 2;

        TaskState(Connection connection) {
            this.connection = connection;
        }
    }

    public static interface MapReader {
        public Map read(String var1) throws IOException;
    }
}

