/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.AgentMonitorTool;
import com.sun.javatest.tool.CommandLineHelp;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Main;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;

public class AgentMonitorManager
extends ToolManager {
    private static final AgentMonitorManager theOne = new AgentMonitorManager();
    private boolean agentPoolFlag;
    private int agentPoolPort = -1;
    private int agentPoolTimeout = -1;
    private boolean monitorAgentFlag;
    private static final String AGENTMONITOR_PANEL = "agentMonitor";

    public static AgentMonitorManager access() {
        return theOne;
    }

    private AgentMonitorManager() {
    }

    public CommandLineHelp getCommandLineHelp() {
        String[] stringArray = new String[]{"agentPoolPort", "agentPoolTimeout", "startAgentPool", "monitorAgent"};
        return this.createCommandLineHelp("mgr.help", stringArray, null);
    }

    public Action[] getTaskMenuActions() {
        ToolAction toolAction = new ToolAction(this.i18n, "mgr.monitorTask"){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentMonitorManager.this.startTool();
            }
        };
        return new Action[]{toolAction};
    }

    public int decodeArg(String[] stringArray, int n, boolean bl) throws Main.BadArgs {
        if (stringArray[n].equalsIgnoreCase("-agentPoolPort") && n < stringArray.length - 1) {
            try {
                this.agentPoolPort = Integer.parseInt(stringArray[++n]);
                return 2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new Main.BadArgs(this.i18n, "mgr.badNumber.err", new Object[]{stringArray[n - 1], stringArray[n]});
            }
        }
        if (stringArray[n].equalsIgnoreCase("-agentPoolTimeout") && n < stringArray.length - 1) {
            try {
                this.agentPoolTimeout = Integer.parseInt(stringArray[++n]);
                return 2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new Main.BadArgs(this.i18n, "mgr.badNumber.err", new Object[]{stringArray[n - 1], stringArray[n]});
            }
        }
        if (stringArray[n].equalsIgnoreCase("-monitorAgent")) {
            this.monitorAgentFlag = true;
            return 1;
        }
        if (stringArray[n].equalsIgnoreCase("-startAgentPool")) {
            this.agentPoolFlag = true;
            return 1;
        }
        return 0;
    }

    public void validateArgs() throws Main.BadArgs {
    }

    public int getAcceptableModes() {
        return this.monitorAgentFlag ? 2 : 3;
    }

    public void setup(int n) throws ToolManager.Fault {
        if (this.agentPoolPort != -1 || this.agentPoolTimeout != -1 || this.agentPoolFlag) {
            AgentManager agentManager = AgentManager.access();
            ActiveAgentPool activeAgentPool = agentManager.getActiveAgentPool();
            if (this.agentPoolPort != -1) {
                activeAgentPool.setPort(this.agentPoolPort);
            }
            if (this.agentPoolTimeout != -1) {
                activeAgentPool.setTimeout(this.agentPoolTimeout * 1000);
            }
            try {
                if (this.agentPoolFlag) {
                    activeAgentPool.setListening(true);
                }
            }
            catch (IOException iOException) {
                throw new ToolManager.Fault(this.i18n, "mgr.listenOn.err", iOException);
            }
        }
        if (this.monitorAgentFlag) {
            this.startTool();
        }
    }

    public boolean run() {
        return true;
    }

    public void cleanup() {
        this.agentPoolPort = -1;
        this.agentPoolTimeout = -1;
        this.agentPoolFlag = false;
        this.monitorAgentFlag = false;
    }

    public void startTool() {
        AgentMonitorTool agentMonitorTool;
        Desktop desktop = Desktop.access();
        if (!desktop.containsTool(agentMonitorTool = AgentMonitorTool.access())) {
            desktop.addTool(agentMonitorTool);
        }
        desktop.setSelectedTool(agentMonitorTool);
    }
}

