/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.SocketConnection;
import com.sun.javatest.util.DynamicArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AgentManager {
    private static final AgentManager theManager = new AgentManager();
    private Observer[] observers = new Observer[0];
    private ActiveAgentPool pool = new ActiveAgentPool();
    private static final int PASSIVE_AGENT_RETRY_LIMIT = 12;

    public static AgentManager access() {
        return theManager;
    }

    private AgentManager() {
    }

    public synchronized void addObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.append(this.observers, observer);
    }

    public synchronized void removeObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
    }

    private synchronized void notifyStarted(Connection connection, String string, String string2, String string3, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < this.observers.length) {
            this.observers[n].started(connection, string, string2, string3, stringArray, bl);
            ++n;
        }
    }

    private synchronized void notifyFinished(Connection connection, Status status) {
        int n = 0;
        while (n < this.observers.length) {
            this.observers[n].finished(connection, status);
            ++n;
        }
    }

    public ActiveAgentPool getActiveAgentPool() {
        return this.pool;
    }

    public Task connect(Connection connection) throws IOException {
        return new Task(connection);
    }

    public Task connectToActiveAgent() throws ActiveAgentPool.NoAgentException, InterruptedException, IOException {
        return this.connect(this.pool.nextAgent());
    }

    public Task connectToPassiveAgent(String string) throws IOException {
        return this.connectToPassiveAgent(string, 1908);
    }

    public Task connectToPassiveAgent(String string, int n) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                return this.connect(new SocketConnection(string, n));
            }
            catch (ConnectException connectException) {
                if (n2 == 12) {
                    throw connectException;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    public class Task {
        private Connection connection;
        private DataInputStream in;
        private DataOutputStream out;
        private File[] classPath;
        private Hashtable zips = new Hashtable();

        Task(Connection connection) throws IOException {
            this.connection = connection;
            this.in = new DataInputStream(new BufferedInputStream(connection.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(connection.getOutputStream()));
        }

        public Connection getConnection() {
            return this.connection;
        }

        public File[] getClassPath() {
            return this.classPath;
        }

        public void setClassPath(String string) {
            this.classPath = this.split(string);
        }

        public void setClassPath(File[] fileArray) {
            if (fileArray == null) {
                throw new NullPointerException();
            }
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] == null) {
                    throw new IllegalArgumentException();
                }
                ++n;
            }
            this.classPath = fileArray;
        }

        public Status executeTest(String string, String string2, String[] stringArray, boolean bl, PrintWriter printWriter, PrintWriter printWriter2) {
            return this.run(string, "executeTest", string2, stringArray, bl, printWriter, printWriter2);
        }

        public Status executeCommand(String string, String string2, String[] stringArray, boolean bl, PrintWriter printWriter, PrintWriter printWriter2) {
            return this.run(string, "executeCommand", string2, stringArray, bl, printWriter, printWriter2);
        }

        public Status executeMain(String string, String string2, String[] stringArray, boolean bl, PrintWriter printWriter, PrintWriter printWriter2) {
            return this.run(string, "executeMain", string2, stringArray, bl, printWriter, printWriter2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Status run(String string, String string2, String string3, String[] stringArray, boolean bl, PrintWriter printWriter, PrintWriter printWriter2) {
            AgentManager.this.notifyStarted(this.connection, string, string2, string3, stringArray, bl);
            Status status = null;
            try {
                try {
                    this.out.writeShort(103);
                    this.out.writeUTF(string);
                    this.out.writeUTF(string2);
                    this.out.writeUTF(string3);
                    this.out.writeShort(stringArray.length);
                    int n = 0;
                    while (true) {
                        if (n >= stringArray.length) {
                            this.out.writeBoolean(bl);
                        }
                        this.out.writeUTF(stringArray[n]);
                        ++n;
                    }
                    this.out.writeBoolean(this.classPath != null);
                    this.out.writeByte(0);
                    this.out.flush();
                    status = this.readResults(printWriter, printWriter2);
                }
                catch (IOException iOException) {
                    try {
                        if (this.out != null) {
                            this.out.close();
                        }
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    status = iOException instanceof InterruptedIOException ? Status.error("Communication with agent interrupted! (timed out?)") : Status.error("Problem communicating with agent: " + iOException);
                    Object var12_12 = null;
                    AgentManager.this.notifyFinished(this.connection, status);
                    return status;
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                AgentManager.this.notifyFinished(this.connection, status);
                throw throwable;
            }
            AgentManager.this.notifyFinished(this.connection, status);
            return status;
        }

        private Status readResults(PrintWriter printWriter, PrintWriter printWriter2) throws IOException {
            Object object;
            Object object2;
            byte[] byArray = new byte[1024];
            Status status = null;
            while (status == null) {
                int n = this.in.read();
                block0 : switch (n) {
                    case -1: {
                        status = Status.error("premature EOF from agent");
                        break;
                    }
                    case 67: {
                        object2 = this.in.readUTF();
                        object = this.locateClass((String)object2);
                        if (object == null) {
                            this.out.writeInt(0);
                        } else {
                            this.out.writeInt(((byte[])object).length);
                            this.out.write((byte[])object, 0, ((byte[])object).length);
                        }
                        this.out.flush();
                        break;
                    }
                    case 68: {
                        String string = this.in.readUTF();
                        byte[] byArray2 = this.locateData(string);
                        if (byArray2 == null) {
                            this.out.writeInt(0);
                        } else {
                            this.out.writeInt(byArray2.length);
                            this.out.write(byArray2, 0, byArray2.length);
                        }
                        this.out.flush();
                        break;
                    }
                    case 83: {
                        int n2 = this.in.read();
                        String string = this.in.readUTF();
                        switch (n2) {
                            case 0: {
                                status = Status.passed(string);
                                break block0;
                            }
                            case 1: {
                                status = Status.failed(string);
                                break block0;
                            }
                            case 2: {
                                status = Status.error(string);
                                break block0;
                            }
                        }
                        status = Status.failed("Bad status from test: type=" + n2 + " reason=" + string);
                        break;
                    }
                    case 76: {
                        printWriter.write(this.in.readUTF());
                        break;
                    }
                    case 108: {
                        printWriter.write(this.in.readUTF());
                        printWriter.flush();
                        break;
                    }
                    case 82: {
                        printWriter2.write(this.in.readUTF());
                        break;
                    }
                    case 114: {
                        printWriter2.write(this.in.readUTF());
                        printWriter2.flush();
                    }
                }
            }
            this.out.close();
            this.in.close();
            this.connection.close();
            printWriter.flush();
            printWriter2.flush();
            Enumeration enumeration = this.zips.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (File)enumeration.nextElement();
                object = (ZipFile)this.zips.get(object2);
                this.zips.remove(object2);
                ((ZipFile)object).close();
            }
            return status;
        }

        private byte[] locateClass(String string) {
            if (this.classPath != null) {
                String string2 = string.replace('.', '/') + ".class";
                int n = 0;
                while (n < this.classPath.length) {
                    byte[] byArray = this.classPath[n].isDirectory() ? this.readFromDir(string2, this.classPath[n]) : this.readFromJar(string2, this.classPath[n]);
                    if (byArray != null) {
                        return byArray;
                    }
                    ++n;
                }
            }
            return null;
        }

        private byte[] locateData(String string) {
            if (this.classPath != null) {
                int n = 0;
                while (n < this.classPath.length) {
                    byte[] byArray = this.classPath[n].isDirectory() ? this.readFromDir(string, this.classPath[n]) : this.readFromJar(string, this.classPath[n]);
                    if (byArray != null) {
                        return byArray;
                    }
                    ++n;
                }
            }
            return null;
        }

        private byte[] readFromDir(String string, File file) {
            try {
                File file2 = new File(file, string);
                return this.read(new FileInputStream(file2), (int)file2.length());
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private byte[] readFromJar(String string, File file) {
            try {
                ZipEntry zipEntry;
                ZipFile zipFile = (ZipFile)this.zips.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zips.put(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string)) == null) {
                    return null;
                }
                return this.read(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
            }
            catch (IOException iOException) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] read(InputStream inputStream, int n) throws IOException {
            byte[] byArray;
            try {
                int n2;
                byte[] byArray2 = new byte[n];
                for (int i = 0; i < byArray2.length; i += n2) {
                    n2 = inputStream.read(byArray2, i, byArray2.length - i);
                    if (n2 > 0) {
                        continue;
                    }
                    throw new EOFException("unexpected end of file");
                }
                byArray = byArray2;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return byArray;
        }

        private File[] split(String string) {
            char c = File.pathSeparatorChar;
            Vector vector = new Vector();
            int n = 0;
            int n2 = string.indexOf(c);
            while (n2 != -1) {
                this.add(string.substring(n, n2), vector);
                n = n2 + 1;
                n2 = string.indexOf(c, n);
            }
            if (n != string.length()) {
                this.add(string.substring(n), vector);
            }
            Object[] objectArray = new File[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        private void add(String string, Vector vector) {
            if (string.length() != 0) {
                vector.addElement(new File(string));
            }
        }
    }

    public static interface Observer {
        public void started(Connection var1, String var2, String var3, String var4, String[] var5, boolean var6);

        public void finished(Connection var1, Status var2);
    }
}

