/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.agent.AgentWriter;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.Deprecated;
import com.sun.javatest.agent.Map;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.Timer;
import com.sun.javatest.util.WriterStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;

public class Agent
implements Runnable {
    private boolean closing;
    private Thread mainThread;
    private int maxThreads;
    private Vector threads = new Vector();
    private Vector tasks = new Vector();
    private Notifier notifier = new Notifier();
    private Object currSystemStreamOwner = null;
    private PrintStream saveOut;
    private PrintStream saveErr;
    public static boolean tracing = false;
    static PrintStream traceOut = System.out;
    public static final int DEFAULT_RETRY_DELAY = 5;
    private int retryDelay = 5;
    private ConnectionFactory connectionFactory;
    private Map map;
    private Timer timer;
    private static int threadInitNumber;
    static final short protocolVersion = 103;
    public static final int defaultActivePort = 1907;
    public static final int defaultPassivePort = 1908;
    static final byte CLASS = 67;
    static final byte DATA = 68;
    static final byte LOG = 76;
    static final byte LOG_FLUSH = 108;
    static final byte REF = 82;
    static final byte REF_FLUSH = 114;
    static final byte STATUS = 83;
    static final String productName = "JavaTest Agent";
    static final String productVersion = "JTA_3.1.4";
    static final String productCopyright = "Copyright \ufffd 2003 Sun Microsystems, Inc";
    private static Constructor classLoaderConstructor;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentClassLoader;
    static /* synthetic */ Class class$com$sun$javatest$agent$Agent$Task;

    public Agent(ConnectionFactory connectionFactory, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("bad concurrency: " + n);
        }
        this.connectionFactory = connectionFactory;
        this.maxThreads = n;
    }

    public void setRetryDelay(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid delay");
        }
        this.retryDelay = n;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public synchronized void setMap(Map map) {
        this.map = map;
        if (tracing) {
            if (map == null) {
                traceOut.println("set map null");
            } else {
                traceOut.println("set map:");
                Enumeration enumeration = map.enumerate();
                while (enumeration.hasMoreElements()) {
                    String[] stringArray = (String[])enumeration.nextElement();
                    traceOut.println("map-from: " + stringArray[0]);
                    traceOut.println("map-to:   " + stringArray[1]);
                }
                traceOut.println("end of map");
            }
        }
    }

    public void addObserver(Observer observer) {
        this.notifier.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.notifier.removeObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        if (this.mainThread != null) {
            throw new IllegalStateException("Agent already running");
        }
        this.mainThread = Thread.currentThread();
        this.timer = new Timer();
        this.closing = false;
        try {
            if (Agent.tracing) {
                Agent.traceOut.println("AGENT STARTED, maxThreads=" + this.maxThreads);
            }
            this.notifier.started();
            if (this.maxThreads <= 0) {
                return;
            }
            ** GOTO lbl40
        }
        catch (InterruptedException var1_2) {
            try {
                this.close();
                return;
            }
            catch (InterruptedException var2_4) {
                // empty catch block
                return;
            }
        }
        finally {
            this.timer.finished();
            this.notifier.finished();
            if (Agent.tracing) {
                Agent.traceOut.println("AGENT EXITING");
            }
            this.mainThread = null;
        }
        {
            var1_1 = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread thread = Thread.currentThread();
                    if (tracing) {
                        traceOut.println("THREAD " + thread.getName() + " STARTED " + this.getClass().getName());
                    }
                    try {
                        Agent.this.handleRequestsUntilClosed();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        Agent agent = Agent.this;
                        synchronized (agent) {
                            Agent.this.threads.removeElement(thread);
                            Agent.this.notifyAll();
                        }
                        if (tracing) {
                            traceOut.println("THREAD " + thread.getName() + " EXITING");
                        }
                    }
                }
            });
            var1_1.setName("Agent" + Agent.nextThreadNum());
            var2_3 = Thread.currentThread().getPriority();
            var3_5 = (var2_3 + 1) / 2;
            var1_1.setPriority(var3_5);
            var1_1.start();
            this.threads.addElement(var1_1);
            do {
                if (this.threads.size() < this.maxThreads && !this.closing) continue block8;
                this.wait();
lbl40:
                // 2 sources

            } while (!this.closing);
        }
        this.timer.finished();
        this.notifier.finished();
        if (Agent.tracing) {
            Agent.traceOut.println("AGENT EXITING");
        }
        this.mainThread = null;
    }

    public synchronized void interrupt() {
        if (this.mainThread != null) {
            this.mainThread.interrupt();
        }
    }

    public synchronized void close() throws InterruptedException {
        Object object;
        this.closing = true;
        try {
            if (tracing) {
                traceOut.println("CLOSING CONNECTION FACTORY");
            }
            this.connectionFactory.close();
        }
        catch (ConnectionFactory.Fault fault) {
            // empty catch block
        }
        int n = 0;
        while (n < this.tasks.size()) {
            Task task = (Task)this.tasks.elementAt(n);
            if (tracing) {
                object = task.connection;
                traceOut.println("CLOSING TASK " + (object == null ? "[unknown]" : object.getName()));
            }
            task.close();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.threads.size()) {
            object = (Thread)this.threads.elementAt(n2);
            if (tracing) {
                traceOut.println("INTERRUPTING THREAD " + ((Thread)object).getName());
            }
            ((Thread)object).interrupt();
            ++n2;
        }
        this.notifyAll();
        if (tracing) {
            traceOut.println("WAITING FOR TASKS TO EXIT");
        }
        while (this.tasks.size() > 0) {
            this.wait();
        }
        if (tracing) {
            traceOut.println("CLOSED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestsUntilClosed() throws InterruptedException {
        while (!this.closing) {
            try {
                Agent agent;
                Object var6_6;
                Task task;
                Connection connection = this.connectionFactory.nextConnection();
                Agent agent2 = this;
                synchronized (agent2) {
                    if (this.closing) {
                        Agent.closeIgnoreExceptions(connection);
                        return;
                    }
                    task = new Task(connection);
                    this.tasks.addElement(task);
                }
                try {
                    task.handleRequest();
                    var6_6 = null;
                    agent = this;
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    agent = this;
                    synchronized (agent) {
                        this.tasks.removeElement(task);
                    }
                    throw throwable;
                }
                synchronized (agent) {
                    this.tasks.removeElement(task);
                }
            }
            catch (ConnectionFactory.Fault fault) {
                this.notifier.errorOpeningConnection(fault.getException());
                if (tracing) {
                    traceOut.println("THREAD " + Thread.currentThread().getName() + " " + fault);
                }
                if (fault.isFatal()) {
                    this.close();
                    return;
                }
                int n = 1000 * Agent.min(5, this.getRetryDelay());
                Thread.currentThread();
                Thread.sleep(n);
            }
        }
    }

    private static void closeIgnoreExceptions(Connection connection) {
        try {
            connection.close();
        }
        catch (IOException iOException) {}
    }

    private static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void setSystemStreams(Object var1_1, PrintStream var2_2, PrintStream var3_3) throws InterruptedException, SecurityException {
        if (var1_1 != null) ** GOTO lbl4
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            this.wait();
lbl4:
            // 2 sources

            ** while (this.currSystemStreamOwner != null)
        }
lbl5:
        // 1 sources

        this.currSystemStreamOwner = var1_1;
        this.saveOut = System.out;
        this.saveErr = System.err;
        System.setOut(var2_2);
        System.setErr(var3_3);
    }

    private synchronized void resetSystemStreams(Object object) throws SecurityException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object != this.currSystemStreamOwner) {
            throw new IllegalStateException("expected: " + object + " found: " + this.currSystemStreamOwner);
        }
        this.currSystemStreamOwner = null;
        System.setOut(this.saveOut);
        System.setErr(this.saveErr);
        this.notifyAll();
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Task {
        private Connection connection;
        private DataInputStream in;
        private DataOutputStream out;
        private String tag;
        private String request;
        private ClassLoader agentClassLoader;

        Task(Connection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest() throws ConnectionFactory.Fault {
            block22: {
                try {
                    block21: {
                        try {
                            Status status;
                            Agent.this.notifier.openedConnection(this.connection);
                            if (tracing) {
                                traceOut.println("REQUEST FROM " + this.connection.getName());
                            }
                            this.in = new DataInputStream(this.connection.getInputStream());
                            short s = this.in.readShort();
                            if (s != 103) {
                                throw new IOException("protocol mismatch; expected 103 received " + s);
                            }
                            this.tag = this.in.readUTF();
                            if (tracing) {
                                traceOut.println("TAG IS `" + this.tag + "'");
                            }
                            this.request = this.in.readUTF();
                            if (tracing) {
                                traceOut.println("REQUEST IS `" + this.request + "'");
                            }
                            this.out = new DataOutputStream(new BufferedOutputStream(this.connection.getOutputStream()));
                            if (this.request.equals("executeTest") || this.request.equals("executeCommand") || this.request.equals("executeMain")) {
                                status = this.execute();
                            } else {
                                if (tracing) {
                                    traceOut.println("Unrecognized request for agent: `" + this.request + "'");
                                }
                                status = Status.error("Unrecognized request for agent: `" + this.request + "'");
                            }
                            if (tracing) {
                                traceOut.println("RETURN " + status);
                            }
                            Agent.this.notifier.result(this.connection, status);
                            if (tracing) {
                                traceOut.println("SEND STATUS");
                            }
                            this.sendStatus(status);
                            if (tracing) {
                                traceOut.println("FLUSH");
                            }
                            this.out.flush();
                            if (tracing) {
                                traceOut.println("AWAIT CLOSE");
                            }
                            this.connection.waitUntilClosed(5000);
                            if (this.connection.isClosed()) {
                                Agent.this.notifier.completed(this.connection);
                                break block21;
                            }
                            Agent.this.notifier.exception(this.connection, new IOException("timeout awaiting close from AgentManager"));
                        }
                        catch (InterruptedException interruptedException) {
                            if (tracing) {
                                traceOut.println("Interrupted");
                            }
                            Agent.this.notifier.exception(this.connection, interruptedException);
                            Object var5_6 = null;
                            this.close();
                            break block22;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            if (tracing) {
                                traceOut.println("Interrupted (IO)");
                            }
                            Agent.this.notifier.exception(this.connection, interruptedIOException);
                            Object var5_7 = null;
                            this.close();
                            break block22;
                        }
                        catch (IOException iOException) {
                            if (tracing) {
                                traceOut.println("EXCEPTION IS `" + iOException + "'");
                                iOException.printStackTrace(traceOut);
                            }
                            Agent.this.notifier.exception(this.connection, iOException);
                            Object var5_8 = null;
                            this.close();
                        }
                    }
                    Object var5_5 = null;
                    this.close();
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.close();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Status execute() throws IOException {
            Object object;
            byte by;
            String string = this.in.readUTF();
            if (tracing) {
                traceOut.println("CLASSNAME: " + string);
            }
            short s = this.in.readShort();
            if (tracing) {
                traceOut.println("nArgs: " + s);
            }
            String[] stringArray = new String[s];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.in.readUTF();
                if (tracing) {
                    traceOut.println("arg[" + n + "]: " + stringArray[n]);
                }
                ++n;
            }
            boolean bl = this.in.readBoolean();
            if (tracing) {
                traceOut.println("mapArgs: " + bl);
            }
            boolean bl2 = this.in.readBoolean();
            if (tracing) {
                traceOut.println("remoteClasses: " + bl2);
            }
            if ((by = this.in.readByte()) != 0) {
                throw new IOException("data format error");
            }
            if (Agent.this.map != null && bl) {
                Agent.this.map.map(stringArray);
            }
            PrintWriter printWriter = new PrintWriter(new AgentWriter(76, this));
            PrintWriter printWriter2 = new PrintWriter(new AgentWriter(82, this));
            try {
                Class<?> clazz;
                object = null;
                if (bl2) {
                    object = this.getAgentClassLoader();
                    clazz = ((ClassLoader)object).loadClass(string);
                } else {
                    clazz = Class.forName(string);
                }
                if (this.request.equals("executeTest")) {
                    Status status = this.executeTest(clazz, stringArray, printWriter, printWriter2);
                    return status;
                }
                if (this.request.equals("executeCommand")) {
                    Status status = this.executeCommand(clazz, stringArray, printWriter, printWriter2, (ClassLoader)object);
                    return status;
                }
                if (this.request.equals("executeMain")) {
                    Status status = this.executeMain(clazz, stringArray, printWriter, printWriter2);
                    return status;
                }
                Status status = Status.error("Unrecognized request for agent: `" + this.request + "'");
                return status;
            }
            catch (ClassCastException classCastException) {
                if (tracing) {
                    classCastException.printStackTrace(traceOut);
                }
                object = Status.error("Can't execute class `" + string + "': required interface not found");
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Status status = Status.error("Can't find class `" + string + "'");
                return status;
            }
            catch (IllegalAccessException illegalAccessException) {
                Status status = Status.error("Illegal access to class `" + string + "'");
                return status;
            }
            catch (InstantiationException instantiationException) {
                Status status = Status.error("Can't instantiate class`" + string + "'");
                return status;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
                Status status = Status.error("Unexpected exception: " + exception);
                return status;
            }
            catch (Error error) {
                error.printStackTrace(printWriter);
                Status status = Status.error("Unexpected error: " + error);
                return status;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(printWriter);
                Status status = Status.error("Unexpected throwable: " + throwable);
                return status;
            }
            finally {
                if (tracing) {
                    traceOut.println("CLOSE TESTREF");
                }
                printWriter2.close();
                if (tracing) {
                    traceOut.println("CLOSE TESTLOG");
                }
                printWriter.close();
            }
        }

        private Status executeTest(Class clazz, String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            Agent.this.notifier.execTest(this.connection, this.tag, clazz.getName(), stringArray);
            Test test = (Test)clazz.newInstance();
            return test.run(stringArray, printWriter, printWriter2);
        }

        private Status executeCommand(Class clazz, String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2, ClassLoader classLoader) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            Agent.this.notifier.execCommand(this.connection, this.tag, clazz.getName(), stringArray);
            Command command = (Command)clazz.newInstance();
            command.setClassLoader(classLoader);
            return command.run(stringArray, printWriter, printWriter2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Status executeMain(Class clazz, String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) throws IOException, ClassNotFoundException, IllegalAccessException {
            Status status;
            Agent.this.notifier.execMain(this.connection, this.tag, clazz.getName(), stringArray);
            PrintStream printStream = Deprecated.createPrintStream(new WriterStream(printWriter2));
            PrintStream printStream2 = Deprecated.createPrintStream(new WriterStream(printWriter));
            try {
                try {
                    Agent.this.setSystemStreams(this, printStream, printStream2);
                    Method method = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Agent.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    method.invoke(null, new Object[]{stringArray});
                    status = Status.passed("OK");
                    Object var12_12 = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Status status2 = Status.error("Can't find `public static void main(String[] args)' for `" + clazz.getName() + "'");
                    Object var12_13 = null;
                    Agent.this.resetSystemStreams(this);
                    printStream.flush();
                    printStream2.flush();
                    return status2;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    throwable.printStackTrace(printStream2);
                    Status status3 = Status.failed(throwable.toString());
                    Object var12_14 = null;
                    Agent.this.resetSystemStreams(this);
                    printStream.flush();
                    printStream2.flush();
                    return status3;
                }
                catch (InterruptedException interruptedException) {
                    Status status4 = Status.failed("interrupted while waiting for access to system streams");
                    Object var12_15 = null;
                    Agent.this.resetSystemStreams(this);
                    printStream.flush();
                    printStream2.flush();
                    return status4;
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                Agent.this.resetSystemStreams(this);
                printStream.flush();
                printStream2.flush();
                throw throwable;
            }
            Agent.this.resetSystemStreams(this);
            printStream.flush();
            printStream2.flush();
            return status;
        }

        synchronized void close() {
            if (this.connection != null) {
                Agent.closeIgnoreExceptions(this.connection);
                this.connection = null;
            }
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException iOException) {}
        }

        synchronized void sendChars(byte by, char[] cArray, int n, int n2) throws IOException {
            this.out.write(by);
            this.out.writeUTF(new String(cArray, n, n2));
            switch (by) {
                case 108: 
                case 114: {
                    this.out.flush();
                }
            }
        }

        private synchronized void sendStatus(Status status) throws IOException {
            this.out.write(83);
            this.out.write((byte)status.getType());
            this.out.writeUTF(status.getReason());
        }

        synchronized byte[] getClassData(String string) throws ClassNotFoundException {
            if (tracing) {
                traceOut.println("REMOTE LOAD " + string);
            }
            try {
                this.out.write(67);
                this.out.writeUTF(string);
                this.out.flush();
                int n = this.in.readInt();
                if (n == 0) {
                    throw new ClassNotFoundException(string);
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                while (n2 < byArray.length) {
                    int n3 = this.in.read(byArray, n2, byArray.length - n2);
                    if (n3 == -1) {
                        throw new ClassNotFoundException(string + ": EOF while reading class data");
                    }
                    n2 += n3;
                }
                return byArray;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string + ": " + iOException);
            }
        }

        synchronized byte[] getResourceData(String string) throws MissingResourceException, IOException {
            if (tracing) {
                traceOut.println("REMOTE LOAD " + string);
            }
            this.out.write(68);
            this.out.writeUTF(string);
            this.out.flush();
            int n = this.in.readInt();
            if (n == 0) {
                throw new MissingResourceException(string, null, string);
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = this.in.read(byArray, n2, byArray.length - n2);
                if (n3 == -1) {
                    throw new IOException(string + ": EOF while reading resource data");
                }
                n2 += n3;
            }
            return byArray;
        }

        private ClassLoader getAgentClassLoader() throws InstantiationException, IllegalAccessException {
            if (this.agentClassLoader == null) {
                Object object;
                Class[] classArray;
                if (classLoaderConstructor == null) {
                    try {
                        classArray = this.getClass().getName();
                        String string = classArray.substring(0, classArray.lastIndexOf(46));
                        object = Class.forName(string + ".AgentClassLoader2");
                    }
                    catch (Throwable throwable) {
                        Object object2;
                        if (class$com$sun$javatest$agent$AgentClassLoader == null) {
                            class$com$sun$javatest$agent$AgentClassLoader = Agent.class$("com.sun.javatest.agent.AgentClassLoader");
                            object2 = class$com$sun$javatest$agent$AgentClassLoader;
                        } else {
                            object2 = class$com$sun$javatest$agent$AgentClassLoader;
                        }
                        object = object2;
                    }
                    try {
                        classArray = new Class[]{class$com$sun$javatest$agent$Agent$Task == null ? (class$com$sun$javatest$agent$Agent$Task = Agent.class$("com.sun.javatest.agent.Agent$Task")) : class$com$sun$javatest$agent$Agent$Task};
                        classLoaderConstructor = object.getDeclaredConstructor(classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                }
                try {
                    object = new Object[]{this};
                    return (ClassLoader)classLoaderConstructor.newInstance(object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    classArray = invocationTargetException.getTargetException();
                    if (classArray instanceof RuntimeException) {
                        throw (RuntimeException)classArray;
                    }
                    if (classArray instanceof Error) {
                        throw (Error)classArray;
                    }
                    throw new Error(invocationTargetException.toString());
                }
            }
            return this.agentClassLoader;
        }
    }

    private class Notifier {
        private Observer[] observers = new Observer[0];

        private Notifier() {
        }

        public synchronized void addObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.append(this.observers, observer);
        }

        public synchronized void removeObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
        }

        public synchronized void started() {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].started(Agent.this);
                ++n;
            }
        }

        public synchronized void finished() {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].finished(Agent.this);
                ++n;
            }
        }

        public synchronized void openedConnection(Connection connection) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].openedConnection(Agent.this, connection);
                ++n;
            }
        }

        public synchronized void errorOpeningConnection(Exception exception) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].errorOpeningConnection(Agent.this, exception);
                ++n;
            }
        }

        public synchronized void execTest(Connection connection, String string, String string2, String[] stringArray) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].execTest(Agent.this, connection, string, string2, stringArray);
                ++n;
            }
        }

        public synchronized void execCommand(Connection connection, String string, String string2, String[] stringArray) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].execCommand(Agent.this, connection, string, string2, stringArray);
                ++n;
            }
        }

        public synchronized void execMain(Connection connection, String string, String string2, String[] stringArray) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].execMain(Agent.this, connection, string, string2, stringArray);
                ++n;
            }
        }

        public synchronized void result(Connection connection, Status status) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].result(Agent.this, connection, status);
                ++n;
            }
        }

        public synchronized void exception(Connection connection, Exception exception) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].exception(Agent.this, connection, exception);
                ++n;
            }
        }

        public synchronized void completed(Connection connection) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].completed(Agent.this, connection);
                ++n;
            }
        }
    }

    public static interface Observer {
        public void started(Agent var1);

        public void errorOpeningConnection(Agent var1, Exception var2);

        public void finished(Agent var1);

        public void openedConnection(Agent var1, Connection var2);

        public void execTest(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void execCommand(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void execMain(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void result(Agent var1, Connection var2, Status var3);

        public void exception(Agent var1, Connection var2, Throwable var3);

        public void completed(Agent var1, Connection var2);
    }
}

