/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.util.DynamicArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class ActiveAgentPool {
    private Thread worker;
    private int counter;
    private Entries entries = new Entries();
    private ServerSocket serverSocket;
    private int timeout = 180000;
    private int port = 1907;
    private final int MAX_ERRORS = 10;
    private static int entryWatcherCount;
    private static boolean debug;

    public synchronized void listen(int n, int n2) throws IOException {
        this.setListening(false);
        this.setPort(n);
        this.setTimeout(n2);
        this.setListening(true);
    }

    public synchronized int getPort() {
        return this.port == 0 && this.serverSocket != null ? this.serverSocket.getLocalPort() : this.port;
    }

    public synchronized void setPort(int n) {
        this.port = n;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    public synchronized boolean isListening() {
        return this.serverSocket != null;
    }

    public synchronized void setListening(boolean bl) throws IOException {
        if (debug) {
            new Exception("ActiveAgentPool.setListening " + bl + ",port=" + this.port).printStackTrace(System.err);
        }
        if (bl) {
            if (this.serverSocket != null) {
                if (this.port == 0 || this.serverSocket.getLocalPort() == this.port) {
                    return;
                }
                this.closeNoExceptions(this.serverSocket);
            }
            this.serverSocket = new ServerSocket(this.port);
            Runnable runnable = new Runnable(){

                public void run() {
                    ActiveAgentPool.this.acceptRequests();
                }
            };
            Thread thread = new Thread(runnable, "ActiveAgentPool" + this.counter++);
            thread.start();
        } else {
            Entry entry;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
            while ((entry = this.entries.next()) != null) {
                this.closeNoExceptions(entry);
            }
        }
    }

    Entry nextAgent() throws NoAgentException, InterruptedException {
        if (!this.isListening()) {
            throw new NoAgentException("AgentPool not listening");
        }
        Entry entry = this.entries.next(this.timeout);
        if (entry != null) {
            return entry;
        }
        throw new NoAgentException("Timeout waiting for agent to become available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void acceptRequests() {
        ActiveAgentPool activeAgentPool = this;
        // MONITORENTER : activeAgentPool
        ServerSocket serverSocket = this.serverSocket;
        // MONITOREXIT : activeAgentPool
        try {
            int n = 0;
            while (true) {
                ActiveAgentPool activeAgentPool2;
                block20: {
                    Object object;
                    if (n >= 10) {
                        System.err.println("too many errors opening socket for remote socket pool");
                        System.err.println("server thread exiting");
                        object = this;
                        // MONITORENTER : object
                        if (this.serverSocket == serverSocket) {
                            this.serverSocket = null;
                        }
                        break;
                    }
                    object = serverSocket.accept();
                    activeAgentPool2 = this;
                    // MONITORENTER : activeAgentPool2
                    if (serverSocket == this.serverSocket) {
                        this.entries.add(new Entry((Socket)object));
                        break block20;
                    }
                    this.closeNoExceptions((Socket)object);
                    // MONITOREXIT : activeAgentPool2
                    Object var10_7 = null;
                    this.closeNoExceptions(serverSocket);
                    return;
                }
                try {
                    // MONITOREXIT : activeAgentPool2
                    if (n <= 0) continue;
                    --n;
                }
                catch (IOException iOException) {
                    activeAgentPool2 = this;
                    // MONITORENTER : activeAgentPool2
                    if (serverSocket != this.serverSocket) {
                        // MONITOREXIT : activeAgentPool2
                        Object var10_8 = null;
                        this.closeNoExceptions(serverSocket);
                        return;
                    }
                    // MONITOREXIT : activeAgentPool2
                    System.err.println("error opening socket for remote socket pool");
                    System.err.println(iOException.getMessage());
                    ++n;
                }
            }
            // MONITOREXIT : object
            Object var10_9 = null;
            this.closeNoExceptions(serverSocket);
            return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.closeNoExceptions(serverSocket);
            throw throwable;
        }
    }

    Enumeration elements() {
        return this.entries.elements();
    }

    public void addObserver(Observer observer) {
        this.entries.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.entries.deleteObserver(observer);
    }

    private void closeNoExceptions(Entry entry) {
        try {
            entry.close();
        }
        catch (IOException iOException) {}
    }

    private void closeNoExceptions(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    private void closeNoExceptions(ServerSocket serverSocket) {
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {}
    }

    static {
        debug = Boolean.getBoolean("debug.ActiveAgentPool");
    }

    class Entries {
        private Vector v = new Vector();
        private Observer[] observers = new Observer[0];

        Entries() {
        }

        synchronized boolean contains(Entry entry) {
            return this.v.contains(entry);
        }

        synchronized Enumeration elements() {
            return ((Vector)this.v.clone()).elements();
        }

        synchronized void add(Entry entry) {
            this.v.addElement(entry);
            this.notifyAddedToPool(entry);
            this.notifyAll();
            Runnable runnable = new Runnable(this, entry){
                private final /* synthetic */ Entry val$e;
                private final /* synthetic */ Entries this$1;
                {
                    this.this$1 = entries;
                    this.val$e = entry;
                }

                public void run() {
                    this.val$e.readAhead();
                }
            };
            Thread thread = new Thread(runnable, "ActiveAgentPool.EntryWatcher" + entryWatcherCount++);
            thread.start();
        }

        synchronized boolean remove(Entry entry) {
            if (this.v.contains(entry)) {
                this.v.removeElement(entry);
                this.notifyRemovedFromPool(entry);
                return true;
            }
            return false;
        }

        synchronized Entry next() {
            Entry entry = null;
            if (this.v.size() > 0) {
                entry = (Entry)this.v.elementAt(0);
                this.v.removeElementAt(0);
                this.notifyRemovedFromPool(entry);
            }
            return entry;
        }

        synchronized Entry next(int n) throws InterruptedException {
            long l = System.currentTimeMillis() + (long)n;
            long l2 = n;
            while (l2 > 0L) {
                Entry entry;
                if (this.v.size() == 0) {
                    this.wait(l2);
                }
                if ((entry = this.next()) != null) {
                    return entry;
                }
                l2 = l - System.currentTimeMillis();
            }
            return null;
        }

        synchronized void addObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.append(this.observers, observer);
        }

        synchronized void deleteObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
        }

        private synchronized void notifyAddedToPool(Entry entry) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].addedToPool(entry);
                ++n;
            }
        }

        private synchronized void notifyRemovedFromPool(Entry entry) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].removedFromPool(entry);
                ++n;
            }
        }
    }

    class Entry
    implements Connection {
        private final Socket socket;
        private InputStream socketInput;
        private OutputStream socketOutput;
        private String name;
        private boolean reading;
        private Object data;
        private boolean closed;

        Entry(Socket socket) throws IOException {
            this.socket = socket;
            this.socketInput = socket.getInputStream();
            this.socketOutput = socket.getOutputStream();
        }

        public String getName() {
            if (this.name == null) {
                StringBuffer stringBuffer = new StringBuffer(32);
                stringBuffer.append(this.socket.getInetAddress().getHostName());
                stringBuffer.append(",port=");
                stringBuffer.append(this.socket.getPort());
                stringBuffer.append(",localport=");
                stringBuffer.append(this.socket.getLocalPort());
                this.name = stringBuffer.toString();
            }
            return this.name;
        }

        public synchronized InputStream getInputStream() {
            if (!this.reading && this.data == null) {
                return this.socketInput;
            }
            return new InputStream(this){
                private final /* synthetic */ Entry this$1;
                {
                    this.this$1 = entry;
                }

                public int read() throws IOException {
                    byte[] byArray = new byte[1];
                    int n = this.read(byArray);
                    return n == -1 ? -1 : byArray[0];
                }

                public int read(byte[] byArray, int n, int n2) throws IOException {
                    block8: {
                        int n3;
                        block9: {
                            int n4;
                            if (n2 == 0) {
                                return 0;
                            }
                            try {
                                Entry.access$000(this.this$1);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (Entry.access$100(this.this$1) == null) {
                                return Entry.access$200(this.this$1).read(byArray, n, n2);
                            }
                            try {
                                if (!(Entry.access$100(this.this$1) instanceof Integer)) break block8;
                                n3 = (Integer)Entry.access$100(this.this$1);
                                if (n3 != -1) break block9;
                                n4 = -1;
                                Object var8_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var8_10 = null;
                                Entry.access$102(this.this$1, null);
                                throw throwable;
                            }
                            Entry.access$102(this.this$1, null);
                            return n4;
                        }
                        byArray[n] = (byte)n3;
                        int n5 = 1;
                        Object var8_9 = null;
                        Entry.access$102(this.this$1, null);
                        return n5;
                    }
                    IOException iOException = (IOException)Entry.access$100(this.this$1);
                    iOException.fillInStackTrace();
                    throw iOException;
                }

                public void close() throws IOException {
                    Entry.access$200(this.this$1).close();
                }
            };
        }

        public OutputStream getOutputStream() {
            return this.socketOutput;
        }

        public synchronized void close() throws IOException {
            this.socketInput.close();
            this.socketOutput.close();
            this.closed = true;
            this.notifyAll();
        }

        public synchronized boolean isClosed() {
            return this.closed;
        }

        public synchronized void waitUntilClosed(int n) throws InterruptedException {
            long l = System.currentTimeMillis();
            long l2 = l + (long)n;
            while (l < l2 && !this.closed) {
                this.wait(l2 - l);
                l = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readAhead() {
            Entry entry = this;
            synchronized (entry) {
                if (!ActiveAgentPool.this.entries.contains(this)) {
                    return;
                }
                this.reading = true;
            }
            try {
                this.data = new Integer(this.socketInput.read());
            }
            catch (IOException iOException) {
                this.data = iOException;
            }
            finally {
                Entry entry2 = this;
                synchronized (entry2) {
                    boolean bl = ActiveAgentPool.this.entries.remove(this);
                    if (bl) {
                        ActiveAgentPool.this.closeNoExceptions(this);
                    }
                    this.reading = false;
                    this.notifyAll();
                }
            }
        }

        private synchronized void waitWhileReading() throws InterruptedException {
            while (this.reading) {
                this.wait();
            }
        }

        static /* synthetic */ void access$000(Entry entry) throws InterruptedException {
            entry.waitWhileReading();
        }

        static /* synthetic */ Object access$100(Entry entry) {
            return entry.data;
        }

        static /* synthetic */ InputStream access$200(Entry entry) {
            return entry.socketInput;
        }

        static /* synthetic */ Object access$102(Entry entry, Object object) {
            entry.data = object;
            return entry.data;
        }
    }

    public static interface Observer {
        public void addedToPool(Connection var1);

        public void removedFromPool(Connection var1);
    }

    public static class NoAgentException
    extends Exception {
        public NoAgentException(String string) {
            super(string);
        }
    }
}

