/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Script;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.interview.LegacyParameters;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpSetException;

public class TestSuite {
    private static final String TESTSUITE_HTML = "testsuite.html";
    private static final String TESTSUITE_JTT = "testsuite.jtt";
    private File root;
    private Map tsInfo;
    private ClassLoader loader;
    private TestFinder finder;
    private Class scriptClass;
    private String[] scriptArgs;
    private HelpSet[] additionalDocs;
    private String[] keywords;
    private static HashMap dirMap = new HashMap(2);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TestSuite == null ? (class$com$sun$javatest$TestSuite = TestSuite.class$("com.sun.javatest.TestSuite")) : class$com$sun$javatest$TestSuite);
    static /* synthetic */ Class class$com$sun$javatest$TestSuite;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$com$sun$javatest$finder$HTMLTestFinder;
    static /* synthetic */ Class class$com$sun$javatest$TestFinder;
    static /* synthetic */ Class class$com$sun$javatest$Script;
    static /* synthetic */ Class class$com$sun$javatest$lib$KeywordScript;
    static /* synthetic */ Class class$com$sun$javatest$InterviewParameters;

    public static boolean isTestSuite(File file) {
        File file2;
        if (file.isDirectory()) {
            file2 = file;
        } else if (file.getName().equalsIgnoreCase(TESTSUITE_HTML)) {
            file2 = file.getParentFile();
        } else {
            return false;
        }
        File file3 = new File(file2, TESTSUITE_JTT);
        File file4 = file2.getParentFile();
        File file5 = file4 == null ? null : new File(file4, TESTSUITE_JTT);
        File file6 = new File(file2, TESTSUITE_HTML);
        return TestSuite.isReadableFile(file3) || TestSuite.isReadableFile(file6) && (file5 == null || !file5.exists());
    }

    public static TestSuite open(File file) throws FileNotFoundException, Fault, NotTestSuiteFault {
        File file2;
        File file3;
        File file4;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        try {
            file4 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "ts.cantCanonicalize", new Object[]{file.getPath(), iOException.toString()});
        }
        if (file4.isDirectory()) {
            file3 = file4;
        } else if (file4.getName().equalsIgnoreCase(TESTSUITE_HTML)) {
            file3 = file4.getParentFile();
        } else {
            throw new NotTestSuiteFault(i18n, "ts.notTestSuiteFile", file4);
        }
        File file5 = new File(file3, TESTSUITE_JTT);
        if (TestSuite.isReadableFile(file5)) {
            try {
                Properties properties = new Properties();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file5));
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return TestSuite.open(file4, properties);
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "ts.cantReadTestSuiteFile", iOException.toString());
            }
        }
        File file6 = new File(file3, TESTSUITE_HTML);
        File file7 = file3.getParentFile();
        File file8 = file2 = file7 == null ? null : new File(file7, TESTSUITE_JTT);
        if (TestSuite.isReadableFile(file6) && (file2 == null || !file2.exists())) {
            return TestSuite.open(file4, new HashMap());
        }
        throw new NotTestSuiteFault(i18n, "ts.notTestSuiteFile", file4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TestSuite open(File file, Map map) throws Fault {
        HashMap hashMap = dirMap;
        synchronized (hashMap) {
            TestSuite testSuite;
            WeakReference weakReference = (WeakReference)dirMap.get(file);
            if (weakReference != null && (testSuite = (TestSuite)weakReference.get()) != null) {
                return testSuite;
            }
            testSuite = TestSuite.open0(file, map);
            dirMap.put(file, new WeakReference<TestSuite>(testSuite));
            return testSuite;
        }
    }

    private static TestSuite open0(File stringArray, Map map) throws Fault {
        Class[] classArray;
        Object object;
        Object object2;
        String[] stringArray2;
        URLClassLoader uRLClassLoader;
        String[] stringArray3 = StringArray.split((String)map.get("classpath"));
        if (stringArray3.length == 0) {
            uRLClassLoader = null;
        } else {
            try {
                stringArray2 = stringArray.isDirectory() ? stringArray : stringArray.getParentFile();
                object2 = new URL[stringArray3.length];
                int n = 0;
                while (n < stringArray3.length) {
                    object = stringArray3[n];
                    if (object.toLowerCase().startsWith("http:")) {
                        object2[n] = new URL((String)object);
                    } else {
                        classArray = new File((String)object);
                        if (!classArray.isAbsolute()) {
                            classArray = new File((File)stringArray2, (String)object);
                        }
                        object2[n] = classArray.toURL();
                    }
                    ++n;
                }
                uRLClassLoader = new URLClassLoader((URL[])object2, (class$com$sun$javatest$TestSuite == null ? (class$com$sun$javatest$TestSuite = TestSuite.class$("com.sun.javatest.TestSuite")) : class$com$sun$javatest$TestSuite).getClassLoader());
            }
            catch (MalformedURLException malformedURLException) {
                throw new Fault(i18n, "ts.badClassPath", new Object[]{stringArray, malformedURLException.getMessage()});
            }
        }
        stringArray2 = StringArray.split((String)map.get("testsuite"));
        if (stringArray2.length == 0) {
            object2 = new TestSuite((File)stringArray, map, uRLClassLoader);
        } else {
            String string = stringArray2[0];
            try {
                object = TestSuite.loadClass(string, uRLClassLoader);
                classArray = new Class[]{class$java$io$File == null ? (class$java$io$File = TestSuite.class$("java.io.File")) : class$java$io$File, class$java$util$Map == null ? (class$java$util$Map = TestSuite.class$("java.util.Map")) : class$java$util$Map, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = TestSuite.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
                Object[] objectArray = new Object[]{stringArray, map, uRLClassLoader};
                object2 = (TestSuite)TestSuite.newInstance((Class)object, classArray, objectArray);
            }
            catch (ClassCastException classCastException) {
                throw new Fault(i18n, "ts.notASubtype", new Object[]{string, "testsuite", (class$com$sun$javatest$TestSuite == null ? (class$com$sun$javatest$TestSuite = TestSuite.class$("com.sun.javatest.TestSuite")) : class$com$sun$javatest$TestSuite).getName()});
            }
            object = new String[stringArray2.length - 1];
            System.arraycopy(stringArray2, 1, object, 0, ((String[])object).length);
            ((TestSuite)object2).init((String[])object);
        }
        ((TestSuite)object2).setTestFinder(((TestSuite)object2).createTestFinder());
        return object2;
    }

    protected TestSuite(File file, Map map, ClassLoader classLoader) throws Fault {
        this.root = file;
        this.tsInfo = map;
        this.loader = classLoader;
        String string = map == null ? null : (String)map.get("keywords");
        this.keywords = string == null ? null : StringArray.split(string);
    }

    protected TestSuite(File file) {
        this.root = file;
    }

    protected void init(String[] stringArray) throws Fault {
        if (stringArray.length > 0) {
            throw new Fault(i18n, "ts.badArgs", stringArray[0]);
        }
    }

    public String getPath() {
        return this.root.getPath();
    }

    public File getRoot() {
        return this.root;
    }

    public File getRootDir() {
        return this.root.isDirectory() ? this.root : new File(this.root.getParent());
    }

    public File getTestsDir() {
        String string = this.tsInfo == null ? null : this.tsInfo.get("tests");
        if (string == null || string.length() == 0) {
            File file = this.getRootDir();
            File file2 = new File(file, "tests");
            if (file2.isDirectory()) {
                return file2;
            }
            return file;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getRootDir(), string.replace('/', File.separatorChar));
    }

    public void starting(Harness harness) throws Fault {
    }

    public TestFilter createTestFilter(TestEnvironment testEnvironment) {
        return null;
    }

    public TestFinder getTestFinder() {
        return this.finder;
    }

    protected void setTestFinder(TestFinder testFinder) {
        if (testFinder == null) {
            throw new NullPointerException();
        }
        if (this.finder != null && this.finder != testFinder) {
            throw new IllegalStateException();
        }
        this.finder = testFinder;
    }

    protected TestFinder createTestFinder() throws Fault {
        String[] stringArray = StringArray.split((String)this.tsInfo.get("finder"));
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{(class$com$sun$javatest$finder$HTMLTestFinder == null ? (class$com$sun$javatest$finder$HTMLTestFinder = TestSuite.class$("com.sun.javatest.finder.HTMLTestFinder")) : class$com$sun$javatest$finder$HTMLTestFinder).getName()};
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        File file = this.getTestsDir();
        try {
            Class clazz = this.loadClass(string);
            TestFinder testFinder = (TestFinder)TestSuite.newInstance(clazz);
            testFinder.init(stringArray2, file, null, null, null);
            return testFinder;
        }
        catch (ClassCastException classCastException) {
            throw new Fault(i18n, "ts.notASubtype", new Object[]{string, "finder", (class$com$sun$javatest$TestFinder == null ? (class$com$sun$javatest$TestFinder = TestSuite.class$("com.sun.javatest.TestFinder")) : class$com$sun$javatest$TestFinder).getName()});
        }
        catch (TestFinder.Fault fault) {
            throw new Fault(i18n, "ts.errorInitFinder", new Object[]{string, fault.getMessage()});
        }
    }

    public Script createScript(TestDescription testDescription, String[] stringArray, TestEnvironment testEnvironment, WorkDirectory workDirectory, BackupPolicy backupPolicy) throws Fault {
        Object object;
        if (this.scriptClass == null) {
            object = TestSuite.envLookup(testEnvironment, "script");
            if (((String[])object).length == 0) {
                object = StringArray.split((String)this.tsInfo.get("script"));
            }
            if (((String[])object).length > 0) {
                this.scriptClass = this.loadClass((String)object[0]);
                if (!(class$com$sun$javatest$Script == null ? (class$com$sun$javatest$Script = TestSuite.class$("com.sun.javatest.Script")) : class$com$sun$javatest$Script).isAssignableFrom(this.scriptClass)) {
                    throw new Fault(i18n, "ts.notASubtype", new Object[]{object[0], "script", (class$com$sun$javatest$Script == null ? (class$com$sun$javatest$Script = TestSuite.class$("com.sun.javatest.Script")) : class$com$sun$javatest$Script).getName()});
                }
                this.scriptArgs = new String[((Object)object).length - 1];
                System.arraycopy(object, 1, this.scriptArgs, 0, this.scriptArgs.length);
            } else {
                boolean bl = false;
                Iterator iterator = testEnvironment.keys().iterator();
                while (iterator.hasNext() && !bl) {
                    String string = (String)iterator.next();
                    bl = string.startsWith("script.");
                }
                if (bl) {
                    this.scriptClass = class$com$sun$javatest$lib$KeywordScript == null ? (class$com$sun$javatest$lib$KeywordScript = TestSuite.class$("com.sun.javatest.lib.KeywordScript")) : class$com$sun$javatest$lib$KeywordScript;
                    this.scriptArgs = new String[0];
                } else {
                    throw new Fault(i18n, "ts.noScript");
                }
            }
        }
        object = (Script)TestSuite.newInstance(this.scriptClass);
        ((Script)object).initArgs(this.scriptArgs);
        ((Script)object).initTestDescription(testDescription);
        ((Script)object).initExcludedTestCases(stringArray);
        ((Script)object).initTestEnvironment(testEnvironment);
        ((Script)object).initWorkDir(workDirectory);
        ((Script)object).initBackupPolicy(backupPolicy);
        ((Script)object).initClassLoader(this.loader);
        return object;
    }

    public InterviewParameters createInterview() throws Fault {
        String[] stringArray = StringArray.split((String)this.tsInfo.get("interview"));
        if (stringArray == null || stringArray.length == 0) {
            try {
                return new LegacyParameters(this);
            }
            catch (Interview.Fault fault) {
                throw new Fault(i18n, "ts.errorInitDefaultInterview", fault.getMessage());
            }
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        try {
            Class clazz = this.loadClass(string);
            InterviewParameters interviewParameters = (InterviewParameters)TestSuite.newInstance(clazz);
            interviewParameters.init(stringArray2);
            interviewParameters.setTestSuite(this);
            return interviewParameters;
        }
        catch (ClassCastException classCastException) {
            throw new Fault(i18n, "ts.notASubtype", new Object[]{string, "interview", (class$com$sun$javatest$InterviewParameters == null ? (class$com$sun$javatest$InterviewParameters = TestSuite.class$("com.sun.javatest.InterviewParameters")) : class$com$sun$javatest$InterviewParameters).getName()});
        }
        catch (Interview.Fault fault) {
            throw new Fault(i18n, "ts.errorInitInterview", new Object[]{string, fault.getMessage()});
        }
    }

    public String getID() {
        return this.tsInfo == null ? null : (String)this.tsInfo.get("id");
    }

    public String getName() {
        return this.tsInfo == null ? null : (String)this.tsInfo.get("name");
    }

    public int getEstimatedTestCount() {
        try {
            String string;
            if (this.tsInfo != null && (string = (String)this.tsInfo.get("testCount")) != null) {
                return Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1;
    }

    public File getInitialExcludeList() {
        String string;
        String string2 = string = this.tsInfo == null ? null : (String)this.tsInfo.get("initial.jtx");
        if (string == null) {
            return null;
        }
        File file = new File(string.replace('/', File.separatorChar));
        if (!file.isAbsolute()) {
            file = new File(this.getRootDir(), file.getPath());
        }
        return file;
    }

    public URL getLatestExcludeList() {
        try {
            String string = this.tsInfo == null ? null : (String)this.tsInfo.get("latest.jtx");
            return string == null ? null : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public HelpSet[] getAdditionalDocs() throws Fault {
        if (this.additionalDocs == null) {
            String[] stringArray = this.getAdditionalDocNames();
            if (stringArray == null) {
                this.additionalDocs = new HelpSet[0];
            } else {
                HelpSet[] helpSetArray = new HelpSet[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    URL uRL = HelpSet.findHelpSet(this.loader, string);
                    if (uRL == null) {
                        throw new Fault(i18n, "ts.cantFindDoc", string);
                    }
                    try {
                        helpSetArray[n] = new HelpSet(this.loader, uRL);
                    }
                    catch (HelpSetException helpSetException) {
                        throw new Fault(i18n, "ts.cantOpenDoc", new Object[]{string, helpSetException});
                    }
                    ++n;
                }
                this.additionalDocs = helpSetArray;
            }
        }
        return this.additionalDocs;
    }

    protected String[] getAdditionalDocNames() {
        return this.tsInfo == null ? null : StringArray.split((String)this.tsInfo.get("additionalDocs"));
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public URL[] getFilesForTest(TestDescription testDescription) {
        Object[] objectArray;
        Vector<URL> vector = new Vector<URL>();
        try {
            vector.add(testDescription.getFile().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String[] stringArray = StringArray.split(testDescription.getParameter("source"));
        if (stringArray != null) {
            objectArray = testDescription.getDir();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                File file = new File((File)objectArray, string.replace('/', File.separatorChar));
                try {
                    URL uRL = file.toURL();
                    if (!vector.contains(uRL)) {
                        vector.add(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n;
            }
        }
        objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public URL getLogo() {
        try {
            String string = this.tsInfo == null ? null : (String)this.tsInfo.get("logo");
            return string == null ? null : new URL(this.getRootDir().toURL(), string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static String[] envLookup(TestEnvironment testEnvironment, String string) throws Fault {
        try {
            return testEnvironment.lookup(string);
        }
        catch (TestEnvironment.Fault fault) {
            throw new Fault(i18n, "ts.cantFindNameInEnv", new Object[]{string, fault.getMessage()});
        }
    }

    protected static Object newInstance(Class clazz) throws Fault {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new Fault(i18n, "ts.cantInstantiate", new Object[]{clazz.getName(), instantiationException});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault(i18n, "ts.illegalAccess", new Object[]{clazz.getName(), illegalAccessException});
        }
    }

    protected static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) throws Fault {
        try {
            return clazz.getConstructor(classArray).newInstance(objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault(i18n, "ts.illegalAccess", new Object[]{clazz.getName(), illegalAccessException});
        }
        catch (InstantiationException instantiationException) {
            throw new Fault(i18n, "ts.cantInstantiate", new Object[]{clazz.getName(), instantiationException});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Fault) {
                throw (Fault)throwable;
            }
            throw new Fault(i18n, "ts.cantInit", new Object[]{clazz.getName(), throwable});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Fault(i18n, "ts.cantFindConstructor", new Object[]{clazz.getName(), noSuchMethodException});
        }
    }

    public Class loadClass(String string) throws Fault {
        return TestSuite.loadClass(string, this.loader);
    }

    protected static Class loadClass(String string, ClassLoader classLoader) throws Fault {
        try {
            if (classLoader == null) {
                return Class.forName(string);
            }
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault(i18n, "ts.classNotFound", new Object[]{string, classNotFoundException});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault(i18n, "ts.badClassName", new Object[]{string});
        }
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    protected Map getTestSuiteInfo() {
        return this.tsInfo;
    }

    public String getTestSuiteInfo(String string) {
        return (String)this.tsInfo.get(string);
    }

    private static boolean isReadableFile(File file) {
        return file.exists() && file.isFile() && file.canRead();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NotTestSuiteFault
    extends Fault {
        public NotTestSuiteFault(I18NResourceBundle i18NResourceBundle, String string, File file) {
            super(i18NResourceBundle, string, file.getPath());
        }
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        public Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        public Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

