/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.Properties;
import com.sun.javatest.util.PropertyArray;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class TestResult {
    public static final int NO_CHECKSUM = 0;
    public static final int BAD_CHECKSUM = 1;
    public static final int GOOD_CHECKSUM = 2;
    public static final int NUM_CHECKSUM_STATES = 3;
    private File resultsFile;
    private Status execStatus;
    private String testURL;
    private byte checksumState;
    private TestDescription desc;
    private String[] props;
    private String[] env;
    private Section[] sections;
    private TestResultTable.TreeNode parent;
    private static Hashtable observersTable = new Hashtable(16);
    public static final String MESSAGE_OUTPUT_NAME = "messages";
    public static final String MSG_SECTION_NAME = "script_messages";
    public static final String DESCRIPTION = "description";
    public static final String END = "end";
    public static final String ENVIRONMENT = "environment";
    public static final String EXEC_STATUS = "execStatus";
    public static final String JAVATEST_OS = "javatestOS";
    public static final String SCRIPT = "script";
    public static final String SECTIONS = "sections";
    public static final String START = "start";
    public static final String TEST = "test";
    public static final String VERSION = "javatestVersion";
    public static final String WORK = "work";
    static final String EXTN = ".jtr";
    private static final Status filesSame = Status.passed("Output file and reference file matched");
    private static final Status filesDifferent = Status.failed("Output file and reference file were different");
    private static final Status fileError = Status.failed("Error occurred during comparison");
    private static final Status interrupted = Status.failed("interrupted");
    private static final Status inProgress = Status.notRun("Test running...");
    private static final Status incomplete = Status.notRun("Section not closed, may be incomplete");
    private static final Status tdMismatch = Status.notRun("Old test flushed, new test description located");
    private static final Status notRunStatus = Status.notRun("");
    private static final String[] emptyStringArray = new String[0];
    private static final Section[] emptySectionArray = new Section[0];
    private static final String defaultClassDir = "classes";
    private static final String JTR_V1_HEADER = "#Test Results";
    private static final String JTR_V1_SECTRESULT = "command result:";
    private static final String JTR_V1_TSTRESULT = "test result:";
    private static final String JTR_V2_HEADER = "#Test Results (version 2)";
    private static final String JTR_V2_SECTION = "#section:";
    private static final String JTR_V2_CHECKSUM = "#checksum:";
    private static final String JTR_V2_TESTDESC = "#-----testdescription-----";
    private static final String JTR_V2_RESPROPS = "#-----testresult-----";
    private static final String JTR_V2_ENVIRONMENT = "#-----environment-----";
    private static final String JTR_V2_SECTRESULT = "result: ";
    private static final String JTR_V2_TSTRESULT = "test result: ";
    private static final String JTR_V2_SECTSTREAM = "----------";
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final int DEFAULT_MAX_SHRINK_LIST_SIZE = 128;
    private static final int maxShrinkListSize = Integer.getInteger("javatest.numCachedResults", 128);
    private static LinkedList shrinkList = new LinkedList();
    private static final int DEFAULT_MAX_OUTPUT_SIZE = 100000;
    private static final int maxOutputSize = Integer.getInteger("javatest.maxOutputSize", 100000);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TestResult == null ? (class$com$sun$javatest$TestResult = TestResult.class$("com.sun.javatest.TestResult")) : class$com$sun$javatest$TestResult);
    private static boolean debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$TestResult == null ? (class$com$sun$javatest$TestResult = TestResult.class$("com.sun.javatest.TestResult")) : class$com$sun$javatest$TestResult).getName());
    static /* synthetic */ Class class$com$sun$javatest$TestResult;

    public TestResult(TestDescription testDescription) {
        this.desc = testDescription;
        this.execStatus = inProgress;
        this.testURL = this.desc.getRootRelativeURL();
        this.createSection(MSG_SECTION_NAME);
        this.props = emptyStringArray;
    }

    public TestResult(TestDescription testDescription, WorkDirectory workDirectory) throws Fault {
        this.desc = testDescription;
        this.testURL = this.desc.getRootRelativeURL();
        this.execStatus = inProgress;
        this.reloadFromWorkDir(workDirectory);
    }

    public TestResult(File file) throws ResultFileNotFoundFault, ReloadFault {
        this.resultsFile = file;
        this.reload();
        this.testURL = this.desc.getRootRelativeURL();
        this.execStatus = Status.parse(PropertyArray.get(this.props, EXEC_STATUS));
    }

    public TestResult(WorkDirectory workDirectory, String string) throws Fault {
        this.resultsFile = workDirectory.getFile(string);
        this.reload();
        this.testURL = this.desc.getRootRelativeURL();
        this.execStatus = Status.parse(PropertyArray.get(this.props, EXEC_STATUS));
    }

    public TestResult(TestDescription testDescription, Status status) {
        this.desc = testDescription;
        this.testURL = this.desc.getRootRelativeURL();
        this.resultsFile = null;
        this.execStatus = status;
        this.props = emptyStringArray;
    }

    public static TestResult notRun(TestDescription testDescription) {
        return new TestResult(testDescription, notRunStatus);
    }

    public synchronized Section createSection(String string) {
        if (!this.isMutable()) {
            throw new IllegalStateException("This TestResult is no longer mutable!");
        }
        Section section = new Section(this, string);
        this.sections = (Section[])DynamicArray.append(this.sections, section);
        this.notifyCreatedSection(section);
        section.createOutput(MESSAGE_OUTPUT_NAME);
        return section;
    }

    public synchronized void setEnvironment(TestEnvironment testEnvironment) {
        if (!this.isMutable()) {
            throw new IllegalStateException("This TestResult is no longer mutable!");
        }
        Iterator iterator = testEnvironment.elementsUsed().iterator();
        while (iterator.hasNext()) {
            TestEnvironment.Element element = (TestEnvironment.Element)iterator.next();
            this.env = PropertyArray.put(this.env, element.getKey(), element.getValue());
        }
    }

    public synchronized void setStatus(Status status) {
        if (!this.isMutable()) {
            throw new IllegalStateException("This TestResult is no longer mutable!");
        }
        if (status == null) {
            throw new IllegalArgumentException("TestResult status cannot be set to null!");
        }
        this.sections[0].setStatus(null);
        this.execStatus = status;
        if (this.execStatus == inProgress) {
            this.execStatus = interrupted;
        }
        int n = 0;
        while (n < this.sections.length) {
            if (this.sections[n].isMutable()) {
                this.sections[n].setStatus(incomplete);
            }
            ++n;
        }
        this.props = PropertyArray.put(this.props, SECTIONS, StringArray.join(this.getSectionTitles()));
        this.props = PropertyArray.put(this.props, EXEC_STATUS, this.execStatus.toString());
        if (this.parent != null) {
            // empty if block
        }
        this.notifyCompleted();
    }

    public synchronized void putProperty(String string, String string2) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot put property, the TestResult is no longer mutable!");
        }
        this.props = PropertyArray.put(this.props, string, string2);
        this.notifyUpdatedProperty(string, string2);
    }

    public void reloadFromWorkDir(WorkDirectory workDirectory) throws Fault {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot reload results, the TestResult is no longer mutable!");
        }
        try {
            this.resultsFile = workDirectory.getFile(this.getWorkRelativePath());
            this.props = null;
            this.sections = null;
            this.execStatus = null;
            this.reload(new FileReader(this.resultsFile));
            this.execStatus = Status.parse(PropertyArray.get(this.props, EXEC_STATUS));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.props = emptyStringArray;
            this.env = emptyStringArray;
            this.sections = emptySectionArray;
            this.execStatus = Status.notRun("no test result file found");
        }
        catch (IOException iOException) {
            this.props = emptyStringArray;
            this.env = emptyStringArray;
            this.sections = emptySectionArray;
            this.execStatus = Status.error("error opening result file: " + iOException);
            throw new Fault(i18n, "rslt.badFile", iOException.toString());
        }
        catch (Fault fault) {
            this.props = emptyStringArray;
            this.env = emptyStringArray;
            this.sections = emptySectionArray;
            this.execStatus = Status.error(fault.getMessage());
            throw fault;
        }
    }

    public byte getChecksumState() {
        return this.checksumState;
    }

    public PrintWriter getTestCommentWriter() {
        return this.sections[0].getMessageWriter();
    }

    public String getTestName() {
        return this.testURL;
    }

    public boolean isReloadable() {
        return this.resultsFile != null && this.resultsFile.canRead();
    }

    public boolean isShrunk() {
        return !this.isMutable() && (this.desc == null || this.props == null || this.env == null || this.sections == null && this.execStatus != inProgress);
    }

    public synchronized TestDescription getDescription() throws Fault {
        if (this.desc == null) {
            this.reload();
        }
        return this.desc;
    }

    public String getWorkRelativePath() {
        return TestResult.getWorkRelativePath(this.testURL);
    }

    public File getFile() {
        return this.resultsFile;
    }

    public static String getWorkRelativePath(TestDescription testDescription) {
        String string = testDescription.getRootRelativePath();
        String string2 = testDescription.getParameter("id");
        return TestResult.getWorkRelativePath(string, string2);
    }

    public static String getWorkRelativePath(String string) {
        int n = string.lastIndexOf("#");
        if (n == -1) {
            return TestResult.getWorkRelativePath(string, null);
        }
        return TestResult.getWorkRelativePath(string.substring(0, n), string.substring(n + 1));
    }

    public static String getWorkRelativePath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        block4: while (n >= 0) {
            switch (stringBuffer.charAt(n)) {
                case '.': {
                    stringBuffer.setLength(n);
                    break block4;
                }
                case '/': {
                    break block4;
                }
                default: {
                    --n;
                }
            }
        }
        if (string2 != null) {
            stringBuffer.append('_');
            stringBuffer.append(string2);
        }
        stringBuffer.append(EXTN);
        return stringBuffer.toString();
    }

    public synchronized Enumeration getPropertyNames() {
        return PropertyArray.enumerate(this.props);
    }

    public synchronized String getProperty(String string) throws Fault {
        if (this.props == null) {
            this.reload();
        }
        return PropertyArray.get(this.props, string);
    }

    public synchronized Map getEnvironment() throws Fault {
        if (this.env == null) {
            this.reload();
        }
        return PropertyArray.getProperties(this.env);
    }

    public TestResultTable.TreeNode getParent() {
        return this.parent;
    }

    void setParent(TestResultTable.TreeNode treeNode) {
        this.parent = treeNode;
    }

    public synchronized boolean isMutable() {
        return this.execStatus == inProgress;
    }

    public synchronized Status getStatus() {
        return this.execStatus;
    }

    public synchronized int getSectionCount() {
        if (this.sections != null) {
            return this.sections.length;
        }
        if (PropertyArray.get(this.props, SECTIONS) != null) {
            return StringArray.split(PropertyArray.get(this.props, SECTIONS)).length;
        }
        return 0;
    }

    public synchronized Section getSection(int n) throws ReloadFault {
        if (this.sections == null && this.execStatus != inProgress) {
            try {
                this.reload();
            }
            catch (ReloadFault reloadFault) {
                throw reloadFault;
            }
            catch (Fault fault) {
                throw new ReloadFault(i18n, "rslt.badFile", fault.getMessage());
            }
        }
        Section section = n >= this.sections.length ? null : this.sections[n];
        return section;
    }

    public synchronized String[] getSectionTitles() {
        String string;
        if (this.props == null) {
            try {
                this.reload();
            }
            catch (Fault fault) {
                return null;
            }
        }
        if ((string = PropertyArray.get(this.props, SECTIONS)) != null) {
            return StringArray.split(string);
        }
        if (this.sections != null) {
            int n = this.getSectionCount();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.sections[n2].getTitle();
                ++n2;
            }
            return stringArray;
        }
        return null;
    }

    public static boolean isResultFile(File file) {
        String string = file.getPath();
        return string.endsWith(EXTN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeResults(WorkDirectory workDirectory, BackupPolicy backupPolicy) throws IOException {
        block5: {
            if (this.isMutable()) {
                throw new IllegalStateException("This TestResult is still mutable - set the status!");
            }
            if (this.props == null) {
                this.props = emptyStringArray;
            }
            String string = TestResult.getWorkRelativePath(this.desc).replace('/', File.separatorChar);
            this.resultsFile = workDirectory.getFile(string);
            File file = this.resultsFile.getParentFile();
            file.mkdirs();
            File file2 = this.createTempFile(workDirectory, backupPolicy);
            try {
                this.writeResults(file2, backupPolicy);
                Object var7_6 = null;
                if (!file2.exists()) break block5;
                file2.delete();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (file2.exists()) {
                    file2.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    private File createTempFile(WorkDirectory workDirectory, BackupPolicy backupPolicy) throws IOException {
        int n = 0;
        while (n < 100) {
            File file = new File(this.resultsFile.getPath() + "." + n + ".tmp");
            if (file.createNewFile()) {
                return file;
            }
            ++n;
        }
        throw new IOException("could not create temp file for " + this.resultsFile + ": too many tries");
    }

    private void writeResults(File file, BackupPolicy backupPolicy) throws IOException {
        FileWriter fileWriter;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            this.execStatus = Status.error("Problem writing result file for test: " + this.getTestName());
            this.resultsFile = null;
            throw iOException;
        }
        try {
            Object object;
            this.props = PropertyArray.put(this.props, EXEC_STATUS, this.execStatus.toString());
            fileWriter.write(JTR_V2_HEADER);
            fileWriter.write(lineSeparator);
            fileWriter.write("#" + new Date().toString());
            fileWriter.write(lineSeparator);
            fileWriter.write(JTR_V2_CHECKSUM);
            fileWriter.write(Long.toHexString(this.computeChecksum()));
            fileWriter.write(lineSeparator);
            if (debug) {
                fileWriter.write("# debug: test desc checksum: ");
                fileWriter.write(Long.toHexString(TestResult.computeChecksum(this.desc)));
                fileWriter.write(lineSeparator);
                object = this.desc.getParameterKeys();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    fileWriter.write("# debug: test desc checksum key " + string + ": ");
                    fileWriter.write(Long.toHexString(TestResult.computeChecksum(string) * TestResult.computeChecksum(this.desc.getParameter(string))));
                    fileWriter.write(lineSeparator);
                }
                fileWriter.write("# debug: test env checksum: ");
                if (this.env == null) {
                    fileWriter.write("null");
                } else {
                    fileWriter.write(Long.toHexString(TestResult.computeChecksum(this.env)));
                }
                fileWriter.write(lineSeparator);
                fileWriter.write("# debug: test props checksum: ");
                fileWriter.write(Long.toHexString(TestResult.computeChecksum(this.props)));
                fileWriter.write(lineSeparator);
                fileWriter.write("# debug: test sections checksum: ");
                fileWriter.write(Long.toHexString(TestResult.computeChecksum(this.sections)));
                fileWriter.write(lineSeparator);
                int n = 0;
                while (n < this.sections.length) {
                    fileWriter.write("# debug: test section[" + n + "] checksum: ");
                    fileWriter.write(Long.toHexString(TestResult.computeChecksum(this.sections[n])));
                    fileWriter.write(lineSeparator);
                    String[] stringArray = this.sections[n].getOutputNames();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        fileWriter.write("# debug: test section[" + n + "] name=" + stringArray[n2] + " checksum: ");
                        fileWriter.write(Long.toHexString(TestResult.computeChecksum(stringArray[n2])));
                        fileWriter.write(lineSeparator);
                        fileWriter.write("# debug: test section[" + n + "] name=" + stringArray[n2] + " output checksum: ");
                        fileWriter.write(Long.toHexString(TestResult.computeChecksum(this.sections[n].getOutput(stringArray[n2]))));
                        fileWriter.write(lineSeparator);
                        ++n2;
                    }
                    ++n;
                }
            }
            fileWriter.write(JTR_V2_TESTDESC);
            fileWriter.write(lineSeparator);
            object = new Properties();
            this.desc.save((Map)object);
            PropertyArray.save(PropertyArray.getArray((Properties)object), fileWriter);
            fileWriter.write(lineSeparator);
            if (this.env != null) {
                fileWriter.write(JTR_V2_ENVIRONMENT);
                fileWriter.write(lineSeparator);
                PropertyArray.save(this.env, fileWriter);
                fileWriter.write(lineSeparator);
            }
            fileWriter.write(JTR_V2_RESPROPS);
            fileWriter.write(lineSeparator);
            PropertyArray.save(this.props, fileWriter);
            fileWriter.write(lineSeparator);
            if (this.sections == null) {
                throw new JavaTestError("Cannot write test result - it contains no sections.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.sections.length) {
                this.sections[n].save(fileWriter);
                ++n;
            }
            fileWriter.write(lineSeparator);
            fileWriter.write(JTR_V2_TSTRESULT);
            fileWriter.write(this.execStatus.toString());
            fileWriter.write(lineSeparator);
            fileWriter.close();
        }
        catch (IOException iOException) {
            this.execStatus = Status.error("Write to temp. JTR file failed (old JTR intact): " + file.getPath());
            this.resultsFile = null;
            throw iOException;
        }
        try {
            backupPolicy.backupAndRename(file, this.resultsFile);
            this.addToShrinkList();
        }
        catch (IOException iOException) {
            this.execStatus = Status.error("Problem writing result file: " + this.resultsFile.getPath());
            this.resultsFile = null;
            throw iOException;
        }
    }

    public synchronized void addObserver(Observer observer) {
        if (this.isMutable()) {
            Object[] objectArray = (Observer[])observersTable.get(this);
            if (objectArray == null) {
                objectArray = new Observer[]{};
            }
            objectArray = (Observer[])DynamicArray.append(objectArray, observer);
            observersTable.put(this, objectArray);
        }
    }

    public synchronized void removeObserver(Observer observer) {
        Object[] objectArray = (Observer[])observersTable.get(this);
        if (objectArray == null) {
            return;
        }
        if ((objectArray = (Observer[])DynamicArray.remove(objectArray, observer)) == null) {
            observersTable.remove(this);
        } else {
            observersTable.put(this, objectArray);
        }
    }

    TestResult(String string, WorkDirectory workDirectory, Status status) {
        if (string == null) {
            throw new JavaTestError(i18n, "rslt.badTestUrl");
        }
        if (workDirectory == null) {
            throw new JavaTestError(i18n, "rslt.badWorkdir");
        }
        if (status == null) {
            throw new JavaTestError(i18n, "rslt.badStatus");
        }
        this.testURL = string;
        this.resultsFile = workDirectory.getFile(this.getWorkRelativePath());
        this.execStatus = status;
    }

    void shareStatus(Hashtable[] hashtableArray) {
        this.execStatus = TestResult.shareStatus(hashtableArray, this.execStatus);
    }

    String[] getTags() {
        Object[] objectArray;
        if (this.sections == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(this.sections.length * 2);
        int n = 0;
        while (n < this.sections.length) {
            objectArray = this.sections[n].getOutputNames();
            int n2 = 0;
            while (n2 < objectArray.length) {
                vector.addElement(objectArray[n2]);
                ++n2;
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void setTestDescription(TestDescription testDescription) {
        if (testDescription == null) {
            return;
        }
        String string = testDescription.getRootRelativeURL();
        if (!this.testURL.equals(string)) {
            throw new IllegalStateException();
        }
        if (this.desc != null) {
            if (!this.desc.equals(testDescription)) {
                this.execStatus = tdMismatch;
                this.desc = testDescription;
                this.props = emptyStringArray;
                this.resultsFile = null;
                this.env = emptyStringArray;
                this.sections = emptySectionArray;
                if (this.isMutable()) {
                    this.createSection(MSG_SECTION_NAME);
                }
            }
        } else {
            this.desc = testDescription;
        }
    }

    private static Reader getLastRefOutput(TestResult testResult) {
        try {
            Section section = testResult.getSection(testResult.getSectionCount() - 1);
            return new StringReader(section.getOutput("ref"));
        }
        catch (ReloadFault reloadFault) {
            return null;
        }
    }

    private long computeChecksum() {
        long l = 0L;
        l = l * 37L + TestResult.computeChecksum(this.desc);
        String string = PropertyArray.get(this.props, VERSION);
        if (!(this.env == null || string != null && string.equals("JT_2.1.1a"))) {
            l = l * 37L + TestResult.computeChecksum(this.env);
        }
        l = l * 37L + TestResult.computeChecksum(this.props);
        l = l * 37L + TestResult.computeChecksum(this.sections);
        l = l * 37L + (long)this.execStatus.getType() + TestResult.computeChecksum(this.execStatus.getReason());
        return Math.abs(l);
    }

    private static long computeChecksum(TestDescription testDescription) {
        long l = 0L;
        Iterator iterator = testDescription.getParameterKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            l += TestResult.computeChecksum(string) * TestResult.computeChecksum(testDescription.getParameter(string));
        }
        return l;
    }

    private static long computeChecksum(Section[] sectionArray) {
        long l = sectionArray.length;
        int n = 0;
        while (n < sectionArray.length) {
            l = l * 37L + TestResult.computeChecksum(sectionArray[n]);
            ++n;
        }
        return l;
    }

    private static long computeChecksum(Section section) {
        long l = TestResult.computeChecksum(section.getTitle());
        String[] stringArray = section.getOutputNames();
        int n = 0;
        while (n < stringArray.length) {
            l = l * 37L + TestResult.computeChecksum(stringArray[n]);
            l = l * 37L + TestResult.computeChecksum(section.getOutput(stringArray[n]));
            ++n;
        }
        return l;
    }

    private static long computeChecksum(String[] stringArray) {
        long l = stringArray.length;
        int n = 0;
        while (n < stringArray.length) {
            l = l * 37L + TestResult.computeChecksum(stringArray[n]);
            ++n;
        }
        return l;
    }

    private static long computeChecksum(String string) {
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            l = l * 37L + (long)c;
            ++n;
        }
        return l;
    }

    private synchronized void reload() throws ResultFileNotFoundFault, ReloadFault {
        if (this.resultsFile == null) {
            throw new ReloadFault(i18n, "rslt.noResultFile");
        }
        if (this.isMutable()) {
            throw new IllegalStateException("Cannot do a reload of this object.");
        }
        try {
            this.reload(new FileReader(this.resultsFile));
            this.addToShrinkList();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResultFileNotFoundFault(i18n, "rslt.fileNotFound", this.resultsFile);
        }
        catch (IOException iOException) {
            throw new ReloadFault(i18n, "rslt.badFile", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(Reader reader) throws ReloadFault, IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            if (string == null) {
                throw new ReloadFault(i18n, "rslt.empty", this.resultsFile);
            }
            if (string.equals(JTR_V2_HEADER)) {
                this.reloadVersion2(bufferedReader);
            } else if (string.equals(JTR_V1_HEADER)) {
                this.reloadVersion1(bufferedReader);
            } else {
                throw new ReloadFault(i18n, "rslt.badHeader", this.resultsFile);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }

    private void reloadVersion1(BufferedReader bufferedReader) throws ReloadFault, IOException {
        Section[] sectionArray;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        while (string != null && string.length() != 0) {
            stringBuffer.append(string);
            stringBuffer.append(lineSeparator);
            string = bufferedReader.readLine();
        }
        Properties properties = new Properties();
        if (this.props == null || this.desc == null) {
            object = new StringReader(stringBuffer.toString());
            stringBuffer = null;
            string = null;
            properties = new Properties();
            properties.load((Reader)object);
        }
        if (this.props == null) {
            this.props = PropertyArray.getArray(properties);
        }
        properties = null;
        if (this.desc == null) {
            object = new File(PropertyArray.get(this.props, "testsuite"));
            if (!((File)object).isDirectory()) {
                object = new File(((File)object).getParent());
            }
            sectionArray = new File(PropertyArray.get(this.props, "file"));
            this.uniquifyStrings(this.props);
            this.desc = new TestDescription((File)object, (File)sectionArray, PropertyArray.getProperties(this.props));
        }
        stringBuffer = new StringBuffer();
        string = bufferedReader.readLine();
        while (string != null) {
            if (string.startsWith("command: ")) {
                object = this.processOldSection(string, bufferedReader);
                if (object != null) {
                    this.sections = (Section[])DynamicArray.append(this.sections, object);
                }
            } else {
                if (string.startsWith(JTR_V1_TSTRESULT)) {
                    if (string == null) break;
                    string = this.extractSlice(string, JTR_V1_TSTRESULT.length(), " ", null);
                    this.execStatus = Status.parse(string);
                    break;
                }
                stringBuffer.append(string);
                stringBuffer.append(lineSeparator);
            }
            string = bufferedReader.readLine();
        }
        object = new Section(this, MSG_SECTION_NAME);
        ((Section)object).reloadOutput(MESSAGE_OUTPUT_NAME, stringBuffer.toString());
        sectionArray = new Section[this.sections.length + 1];
        sectionArray[0] = object;
        System.arraycopy(this.sections, 0, sectionArray, 1, this.sections.length);
        this.sections = sectionArray;
    }

    private Section processOldSection(String string, BufferedReader bufferedReader) throws ReloadFault, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Section section = null;
        String string2 = string;
        while (string2 != null) {
            if (string2.startsWith(JTR_V2_SECTSTREAM)) {
                String string3 = null;
                String string4 = null;
                StringBuffer stringBuffer2 = new StringBuffer();
                int n = 0;
                int n2 = 0;
                try {
                    string3 = this.extractSlice(string2, 10, null, ":");
                    string4 = this.extractSlice(string2, 10, ":", "(");
                    n = Integer.parseInt(this.extractSlice(string2, 10, "(", "/"));
                    n2 = Integer.parseInt(this.extractSlice(string2, 10, "/", ")"));
                    int n3 = 0;
                    while (n3 < n) {
                        stringBuffer2.append(bufferedReader.readLine());
                        ++n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ReloadFault(i18n, "rslt.badFile", numberFormatException);
                }
                if (section == null) {
                    section = new Section(this, string4);
                }
                section.reloadOutput(string3, stringBuffer2.toString());
            } else {
                if (string2.startsWith(JTR_V1_SECTRESULT)) {
                    if (section == null) {
                        section = new Section(this, "");
                    }
                    if ((string2 = this.extractSlice(string2, JTR_V1_SECTRESULT.length(), " ", null)) == null) {
                        throw new ReloadFault(i18n, "rslt.noSectionResult");
                    }
                    section.reloadStatus(Status.parse(string2));
                    break;
                }
                stringBuffer.append(string2);
                stringBuffer.append(lineSeparator);
            }
            string2 = bufferedReader.readLine();
        }
        section.reloadOutput(MESSAGE_OUTPUT_NAME, stringBuffer.toString());
        return section;
    }

    private void reloadVersion2(BufferedReader bufferedReader) throws ReloadFault, IOException {
        block16: {
            String string;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals(JTR_V2_TESTDESC)) break;
                if (string.startsWith(JTR_V2_CHECKSUM)) {
                    string2 = string.substring(JTR_V2_CHECKSUM.length());
                    continue;
                }
                if (string.startsWith("#")) continue;
                throw new ReloadFault(i18n, "rslt.badLine", string);
            }
            String[] stringArray = PropertyArray.load(bufferedReader);
            if (this.desc == null) {
                this.uniquifyStrings(stringArray);
                this.desc = TestDescription.load(stringArray);
            }
            stringArray = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith(JTR_V2_RESPROPS)) break;
                if (string.startsWith(JTR_V2_ENVIRONMENT)) {
                    this.env = PropertyArray.load(bufferedReader);
                    this.uniquifyStrings(this.env);
                    continue;
                }
                if (string.startsWith("#")) continue;
                throw new ReloadFault(i18n, "rslt.badLine", string);
            }
            if (this.env == null) {
                this.env = new String[0];
            }
            if (string == null) {
                throw new ReloadFault(i18n, "rslt.badFormat");
            }
            String[] stringArray2 = PropertyArray.load(bufferedReader);
            if (this.props == null) {
                this.uniquifyStrings(stringArray2);
                this.props = stringArray2;
            }
            stringArray2 = null;
            int n = this.getSectionCount();
            this.sections = new Section[n];
            int n2 = 0;
            while (n2 < this.getSectionCount()) {
                this.sections[n2] = new Section(this, bufferedReader);
                ++n2;
            }
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith(JTR_V2_TSTRESULT)) continue;
                this.execStatus = Status.parse(string.substring(JTR_V2_TSTRESULT.length()));
                break;
            }
            if (this.execStatus == null) {
                this.execStatus = Status.error("NO STATUS RECORDED IN FILE");
            }
            if (string2 == null) {
                this.checksumState = 0;
            } else {
                try {
                    long l = Long.parseLong(string2, 16);
                    if (l == this.computeChecksum()) {
                        this.checksumState = (byte)2;
                        break block16;
                    }
                    this.checksumState = 1;
                }
                catch (RuntimeException runtimeException) {
                    this.checksumState = 1;
                }
            }
        }
    }

    void uniquifyStrings(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].intern();
            ++n;
        }
    }

    String extractSlice(String string, int n, String string2, String string3) {
        int n2 = string2 == null ? n : string.indexOf(string2, n) + string2.length();
        int n3 = string3 == null ? string.length() : string.indexOf(string3, n2);
        if (n3 == -1) {
            return null;
        }
        try {
            return string.substring(n2, n3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compare(Reader reader, Reader reader2) throws Fault {
        int n;
        try {
            try {}
            catch (Throwable throwable) {
                Object var6_9 = null;
                reader.close();
                reader2.close();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "rslt.badCompare", iOException);
        }
        do {
            int n2;
            if ((n = reader.read()) == (n2 = reader2.read())) continue;
            boolean bl = false;
            Object var6_7 = null;
            reader.close();
            reader2.close();
            return bl;
        } while (n != -1);
        boolean bl = true;
        Object var6_8 = null;
        reader.close();
        reader2.close();
        return bl;
    }

    private static Status shareStatus(Hashtable[] hashtableArray, Status status) {
        String string;
        int n = status.getType();
        Status status2 = (Status)hashtableArray[n].get(string = status.getReason());
        if (status2 == null) {
            hashtableArray[n].put(string, status);
            status2 = status;
        }
        return status2;
    }

    private synchronized void notifyCreatedSection(Section section) {
        Observer[] observerArray = (Observer[])observersTable.get(this);
        if (observerArray != null) {
            int n = 0;
            while (n < observerArray.length) {
                observerArray[n].createdSection(this, section);
                ++n;
            }
        }
    }

    private synchronized void notifyCompletedSection(Section section) {
        Observer[] observerArray = (Observer[])observersTable.get(this);
        if (observerArray != null) {
            int n = 0;
            while (n < observerArray.length) {
                observerArray[n].completedSection(this, section);
                ++n;
            }
        }
    }

    private synchronized void notifyCreatedOutput(Section section, String string) {
        Observer[] observerArray = (Observer[])observersTable.get(this);
        if (observerArray != null) {
            int n = 0;
            while (n < observerArray.length) {
                observerArray[n].createdOutput(this, section, string);
                ++n;
            }
        }
    }

    private synchronized void notifyCompletedOutput(Section section, String string) {
        Observer[] observerArray = (Observer[])observersTable.get(this);
        if (observerArray != null) {
            int n = 0;
            while (n < observerArray.length) {
                observerArray[n].completedOutput(this, section, string);
                ++n;
            }
        }
    }

    private synchronized void notifyUpdatedOutput(Section section, String string, int n, int n2, String string2) {
        Observer[] observerArray = (Observer[])observersTable.get(this);
        if (observerArray != null) {
            int n3 = 0;
            while (n3 < observerArray.length) {
                observerArray[n3].updatedOutput(this, section, string, n, n2, string2);
                ++n3;
            }
        }
    }

    private synchronized void notifyUpdatedOutput(Section section, String string, int n, int n2, char[] cArray, int n3, int n4) {
        Observer[] observerArray = (Observer[])observersTable.get(this);
        if (observerArray != null) {
            String string2 = new String(cArray, n3, n4);
            int n5 = 0;
            while (n5 < observerArray.length) {
                observerArray[n5].updatedOutput(this, section, string, n, n2, string2);
                ++n5;
            }
        }
    }

    private synchronized void notifyUpdatedProperty(String string, String string2) {
        Observer[] observerArray = (Observer[])observersTable.get(this);
        if (observerArray != null) {
            int n = 0;
            while (n < observerArray.length) {
                observerArray[n].updatedProperty(this, string, string2);
                ++n;
            }
        }
    }

    private synchronized void notifyCompleted() {
        Observer[] observerArray = (Observer[])observersTable.remove(this);
        if (observerArray != null) {
            int n = 0;
            while (n < observerArray.length) {
                observerArray[n].completed(this);
                ++n;
            }
            observersTable.remove(this);
        }
    }

    private synchronized int findSection(String string) {
        if (this.sections == null || this.sections.length == 0) {
            return -1;
        }
        int n = 0;
        while (n < this.sections.length) {
            if (this.sections[n].getTitle().equals(string)) break;
            ++n;
        }
        if (n == this.sections.length) {
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToShrinkList() {
        LinkedList linkedList = shrinkList;
        synchronized (linkedList) {
            Object object;
            WeakReference weakReference;
            Iterator iterator = shrinkList.iterator();
            while (iterator.hasNext()) {
                weakReference = (WeakReference)iterator.next();
                object = weakReference.get();
                if (object != null && object != this) continue;
                iterator.remove();
            }
            while (shrinkList.size() >= maxShrinkListSize) {
                weakReference = (WeakReference)shrinkList.removeFirst();
                object = (TestResult)weakReference.get();
                if (object == null) continue;
                super.shrink();
            }
            shrinkList.addLast(new WeakReference<TestResult>(this));
        }
    }

    private synchronized void shrink() {
        if (this.isMutable()) {
            throw new IllegalStateException("Can't shrink a mutable test result!");
        }
        this.sections = null;
    }

    static /* synthetic */ String[] access$102(TestResult testResult, String[] stringArray) {
        testResult.env = stringArray;
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static interface OutputBuffer {
        public String getName();

        public String getOutput();

        public PrintWriter getPrintWriter();
    }

    /*
     * Exception performing whole class analysis.
     */
    public class Section {
        private OutputBuffer[] buffers;
        private String title;
        private Status result;
        private final /* synthetic */ TestResult this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMutable() {
            TestResult testResult = this.this$0;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    return this.this$0.isMutable() && this.result == inProgress;
                }
            }
        }

        public Status getStatus() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStatus(Status status) {
            TestResult testResult = this.this$0;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    this.checkMutable();
                    int n = 0;
                    while (n < this.buffers.length) {
                        OutputBuffer outputBuffer = this.buffers[n];
                        if (outputBuffer instanceof WritableOutputBuffer) {
                            WritableOutputBuffer writableOutputBuffer = (WritableOutputBuffer)outputBuffer;
                            writableOutputBuffer.getPrintWriter().close();
                        }
                        ++n;
                    }
                    if (this.this$0.env == null) {
                        TestResult.access$102(this.this$0, emptyStringArray);
                    }
                    this.result = status;
                    if (this.this$0.env == null) {
                        TestResult.access$102(this.this$0, emptyStringArray);
                    }
                    this.this$0.notifyCompletedSection(this);
                }
            }
        }

        public String getTitle() {
            return this.title;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintWriter getMessageWriter() {
            TestResult testResult = this.this$0;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    this.checkMutable();
                    return this.buffers[0].getPrintWriter();
                }
            }
        }

        public synchronized int getOutputCount() {
            return this.buffers.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintWriter createOutput(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            TestResult testResult = this.this$0;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    this.checkMutable();
                    WritableOutputBuffer writableOutputBuffer = new WritableOutputBuffer(string);
                    this.buffers = (OutputBuffer[])DynamicArray.append(this.buffers, writableOutputBuffer);
                    this.this$0.notifyCreatedOutput(this, string);
                    return writableOutputBuffer.getPrintWriter();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getOutput(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            TestResult testResult = this.this$0;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    OutputBuffer outputBuffer = this.findOutputBuffer(string);
                    return outputBuffer == null ? null : outputBuffer.getOutput();
                }
            }
        }

        public synchronized String[] getOutputNames() {
            String[] stringArray = new String[this.buffers.length];
            int n = 0;
            while (n < this.buffers.length) {
                stringArray[n] = this.buffers[n].getName();
                if (stringArray[n] == null) {
                    throw new IllegalStateException("BUFFER IS BROKEN");
                }
                ++n;
            }
            return stringArray;
        }

        Section(TestResult testResult, String string) {
            this.this$0 = testResult;
            this.buffers = new OutputBuffer[0];
            if (string == null) {
                throw new NullPointerException();
            }
            if (string.indexOf(32) != -1) {
                throw new IllegalArgumentException("space invalid in section title");
            }
            this.title = string;
            this.result = inProgress;
        }

        /*
         * Unable to fully structure code
         */
        Section(TestResult var1_1, BufferedReader var2_2) throws IOException, ReloadFault {
            super();
            this.this$0 = var1_1;
            this.buffers = new OutputBuffer[0];
            var3_3 = var2_2.readLine();
            while (var3_3 != null) {
                if (var3_3.startsWith("#section:")) {
                    this.title = var1_1.extractSlice(var3_3, 0, ":", null);
                    var3_3 = null;
                    continue;
                }
                var3_3 = var2_2.readLine();
            }
            if (this.title.equals("script_messages")) {
                this.title = "script_messages";
            }
            if (this.title != null) ** GOTO lbl18
            throw new ReloadFault(TestResult.access$500(), "rslt.noSectionTitle");
lbl-1000:
            // 1 sources

            {
                var4_4 = new FixedOutputBuffer(var3_3, var2_2);
                this.buffers = (OutputBuffer[])DynamicArray.append(this.buffers, var4_4);
lbl18:
                // 2 sources

                ** while ((var3_3 = var2_2.readLine()).startsWith((String)"----------"))
            }
lbl19:
            // 1 sources

            if (this.title != "script_messages") {
                if (var3_3 != null) {
                    if (var3_3.startsWith("result: ")) {
                        this.result = Status.parse(var3_3.substring("result: ".length()));
                    } else {
                        throw new ReloadFault(TestResult.access$500(), "rslt.badLine", new Integer(var3_3));
                    }
                }
                if (this.result == null) {
                    throw new ReloadFault(TestResult.access$500(), "rslt.noSectionResult");
                }
            }
        }

        void save(Writer writer) throws IOException {
            writer.write(TestResult.JTR_V2_SECTION + this.getTitle());
            writer.write(lineSeparator);
            int n = 0;
            while (n < this.buffers.length) {
                boolean bl;
                int n2;
                String string = this.buffers[n].getOutput();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                boolean bl2 = false;
                int n6 = 0;
                while (n6 < string.length()) {
                    n2 = string.charAt(n6);
                    if (n2 < 32) {
                        if (n2 == 10) {
                            ++n3;
                        } else if (n2 != 9 && n2 != 13) {
                            ++n5;
                        }
                    } else if (n2 < 127) {
                        if (n2 == 92) {
                            ++n4;
                        }
                    } else {
                        ++n5;
                    }
                    ++n6;
                }
                boolean bl3 = bl = n4 > 0 || n5 > 0;
                if (string.length() != 0 && !string.endsWith("\n")) {
                    bl2 = true;
                    ++n3;
                }
                writer.write(TestResult.JTR_V2_SECTSTREAM);
                writer.write(this.buffers[n].getName());
                writer.write(":");
                writer.write(40);
                writer.write(String.valueOf(n3));
                writer.write(47);
                if (bl) {
                    writer.write(String.valueOf(string.length() + n4 + 5 * n5));
                } else {
                    writer.write(String.valueOf(string.length()));
                }
                writer.write(41);
                if (bl) {
                    writer.write(42);
                }
                writer.write(TestResult.JTR_V2_SECTSTREAM);
                writer.write(lineSeparator);
                if (bl) {
                    n2 = 0;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        if (' ' <= c && c < '\u007f' && c != '\\') {
                            writer.write(c);
                        } else {
                            switch (c) {
                                case '\t': 
                                case '\n': 
                                case '\r': {
                                    writer.write(c);
                                    break;
                                }
                                case '\\': {
                                    writer.write("\\\\");
                                    break;
                                }
                                default: {
                                    writer.write("\\u");
                                    writer.write(Character.forDigit(c >> 12 & 0xF, 16));
                                    writer.write(Character.forDigit(c >> 8 & 0xF, 16));
                                    writer.write(Character.forDigit(c >> 4 & 0xF, 16));
                                    writer.write(Character.forDigit(c >> 0 & 0xF, 16));
                                }
                            }
                        }
                        ++n2;
                    }
                } else {
                    writer.write(string);
                }
                if (bl2) {
                    writer.write(lineSeparator);
                }
                ++n;
            }
            if (this.getTitle() != TestResult.MSG_SECTION_NAME) {
                writer.write(TestResult.JTR_V2_SECTRESULT + this.result.toString());
                writer.write(lineSeparator);
            }
            writer.write(lineSeparator);
        }

        synchronized void reloadOutput(String string, String string2) {
            if (string.equals(TestResult.MESSAGE_OUTPUT_NAME)) {
                string = TestResult.MESSAGE_OUTPUT_NAME;
            }
            FixedOutputBuffer fixedOutputBuffer = new FixedOutputBuffer(string, string2);
            this.buffers = (OutputBuffer[])DynamicArray.append(this.buffers, fixedOutputBuffer);
        }

        synchronized void reloadStatus(Status status) {
            this.result = status;
        }

        private void checkMutable() {
            if (!this.isMutable()) {
                throw new IllegalStateException("This section of the test result is now immutable.");
            }
        }

        private synchronized void makeOutputImmutable(OutputBuffer outputBuffer, String string, String string2) {
            int n = 0;
            while (n < this.buffers.length) {
                if (this.buffers[n] == outputBuffer) {
                    this.buffers[n] = new FixedOutputBuffer(string, string2);
                    return;
                }
                ++n;
            }
        }

        private synchronized OutputBuffer findOutputBuffer(String string) {
            int n = this.buffers.length - 1;
            while (n >= 0) {
                if (string.equals(this.buffers[n].getName())) {
                    return this.buffers[n];
                }
                --n;
            }
            return null;
        }

        private class WritableOutputBuffer
        extends Writer
        implements OutputBuffer {
            private boolean overflowed;
            private int overflowStart;
            private final String name;
            private StringBuffer output;
            private final PrintWriter pw;

            WritableOutputBuffer(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                this.name = string;
                this.output = new StringBuffer();
                this.pw = new PrintWriter(this);
            }

            public String getName() {
                return this.name;
            }

            public String getOutput() {
                return new String(this.output);
            }

            public PrintWriter getPrintWriter() {
                return this.pw;
            }

            public void write(char[] cArray, int n, int n2) throws IOException {
                if (this.output == null) {
                    throw new IOException("stream has been closed");
                }
                int n3 = this.output.length();
                this.output.append(cArray, n, n2);
                Section.this.this$0.notifyUpdatedOutput(Section.this, this.name, n3, n3, cArray, n, n2);
                if (this.output.length() > maxOutputSize) {
                    int n4 = maxOutputSize * 2 / 3;
                    if (this.overflowed) {
                        String string = this.output.toString();
                        this.output = new StringBuffer(string.substring(0, this.overflowStart) + string.substring(n4));
                        Section.this.this$0.notifyUpdatedOutput(Section.this, this.name, this.overflowStart, n4, "");
                    } else {
                        String string = "\n\n...\nOutput overflow:\nJavaTest has limited the test output to the text to that\nat the beginning and the end, so that you can see how the\ntest began, and how it completed.\n\nIf you need to see more of the output from the test,\nset the system property javatest.maxOutputSize to a higher\nvalue. The current value is " + maxOutputSize + "\n...\n\n";
                        this.overflowStart = maxOutputSize / 3;
                        String string2 = this.output.toString();
                        this.output = new StringBuffer(string2.substring(0, this.overflowStart) + string + string2.substring(n4));
                        Section.this.this$0.notifyUpdatedOutput(Section.this, this.name, this.overflowStart, n4, string);
                        this.overflowStart += string.length();
                        this.overflowed = true;
                    }
                }
            }

            public void flush() {
            }

            public void close() {
                Section.this.makeOutputImmutable(this, this.name, new String(this.output));
                Section.this.this$0.notifyCompletedOutput(Section.this, this.name);
            }
        }

        private class FixedOutputBuffer
        implements OutputBuffer {
            private final String name;
            private final String output;

            FixedOutputBuffer(String string, String string2) {
                if (string == null || string2 == null) {
                    throw new NullPointerException();
                }
                this.name = string;
                this.output = string2;
            }

            public String getName() {
                return this.name;
            }

            public String getOutput() {
                return this.output;
            }

            public PrintWriter getPrintWriter() {
                throw new IllegalStateException("This section is immutable");
            }

            FixedOutputBuffer(String string, BufferedReader bufferedReader) throws ReloadFault {
                String string2 = Section.this.this$0.extractSlice(string, TestResult.JTR_V2_SECTSTREAM.length(), null, ":");
                if (string2 == null) {
                    throw new ReloadFault(i18n, "rslt.noOutputTitle");
                }
                if (string2.equals(TestResult.MESSAGE_OUTPUT_NAME)) {
                    string2 = TestResult.MESSAGE_OUTPUT_NAME;
                }
                try {
                    boolean bl;
                    int n;
                    int n2;
                    try {
                        int n3 = TestResult.JTR_V2_SECTSTREAM.length();
                        int n4 = Integer.parseInt(Section.this.this$0.extractSlice(string, n3, "(", "/"));
                        n2 = Integer.parseInt(Section.this.this$0.extractSlice(string, n3, "/", ")"));
                        n = string.indexOf(")", n3);
                        bl = n >= 0 && n < string.length() - 2 ? string.charAt(n + 1) == '*' : false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ReloadFault(i18n, "rslt.badHeaderVersion", numberFormatException);
                    }
                    StringBuffer stringBuffer = new StringBuffer(n2);
                    if (bl) {
                        n = 0;
                        while (n < n2) {
                            int n5 = bufferedReader.read();
                            if (n5 == -1) {
                                throw new ReloadFault(i18n, "rslt.badEOF");
                            }
                            if (n5 == 92) {
                                n5 = bufferedReader.read();
                                ++n;
                                if (n5 == 117) {
                                    n5 = Character.digit((char)bufferedReader.read(), 16) << 12;
                                    n5 += Character.digit((char)bufferedReader.read(), 16) << 8;
                                    n5 += Character.digit((char)bufferedReader.read(), 16) << 4;
                                    n5 += Character.digit((char)bufferedReader.read(), 16);
                                    n += 4;
                                }
                            }
                            stringBuffer.append((char)n5);
                            ++n;
                        }
                    } else {
                        char[] cArray = new char[Math.min(4096, n2)];
                        int n6 = 0;
                        while (n6 < n2) {
                            int n7 = bufferedReader.read(cArray, 0, Math.min(cArray.length, n2 - n6));
                            stringBuffer.append(cArray, 0, n7);
                            n6 += n7;
                        }
                    }
                    this.name = string2;
                    this.output = stringBuffer.toString();
                    if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                        int n8 = bufferedReader.read();
                        if (n8 == 13) {
                            n8 = bufferedReader.read();
                        }
                        if (n8 != 10) {
                            throw new ReloadFault(i18n, "rslt.badChars", this.name);
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new ReloadFault(i18n, "rslt.badFile", iOException);
                }
            }
        }
    }

    public static interface Observer {
        public void createdSection(TestResult var1, Section var2);

        public void completedSection(TestResult var1, Section var2);

        public void createdOutput(TestResult var1, Section var2, String var3);

        public void completedOutput(TestResult var1, Section var2, String var3);

        public void updatedOutput(TestResult var1, Section var2, String var3, int var4, int var5, String var6);

        public void updatedProperty(TestResult var1, String var2, String var3);

        public void completed(TestResult var1);
    }

    public static class ReloadFault
    extends Fault {
        ReloadFault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle, string);
        }

        ReloadFault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle, string, object);
        }

        ReloadFault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle, string, objectArray);
        }
    }

    public static class ResultFileNotFoundFault
    extends Fault {
        ResultFileNotFoundFault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle, string);
        }

        ResultFileNotFoundFault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle, string, object);
        }

        ResultFileNotFoundFault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle, string, objectArray);
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

