/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.Fifo;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class TestFinderQueue {
    public static final byte NO_READ_AHEAD = 0;
    public static final byte LOW_READ_AHEAD = 1;
    public static final byte MEDIUM_READ_AHEAD = 2;
    public static final byte FULL_READ_AHEAD = 3;
    private TestFinder testFinder;
    private Fifo tests;
    private TestFilter[] filters;
    private String selectedId;
    private File rootDir;
    private File currInitialFile;
    private int testsFoundCountBeforeCurrInitialFile;
    private boolean zeroTestsOK;
    private Vector filesToRead = new Vector(32, 8);
    private int fileInsertPosn;
    private Fifo testDescsFound = new Fifo();
    private int filesRemainingCount;
    private int filesDoneCount;
    private int testsDoneCount;
    private int testsFoundCount;
    private int errorCount;
    private Hashtable filesFound = new Hashtable();
    private byte readAheadMode;
    private Thread readAheadWorker;
    private static int workerIndex;
    private Notifier notifier = new Notifier();
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$TestFinder;

    public TestFinderQueue() {
    }

    public TestFinderQueue(TestFinder testFinder) {
        this.setTestFinder(testFinder);
    }

    public TestFinder getTestFinder() {
        return this.testFinder;
    }

    public void setTestFinder(TestFinder testFinder) {
        if (testFinder == null) {
            throw new NullPointerException();
        }
        if (this.testFinder != null && this.testFinder != testFinder) {
            throw new IllegalStateException();
        }
        this.testFinder = testFinder;
        this.testFinder.setErrorHandler(new TestFinder.ErrorHandler(){

            public void error(String string) {
                TestFinderQueue.this.errorCount++;
                TestFinderQueue.this.notifier.error(string);
            }
        });
    }

    public void setFilters(TestFilter[] testFilterArray) {
        this.filters = testFilterArray;
    }

    public synchronized void setTests(String[] stringArray) {
        int n;
        File[] fileArray;
        File file = this.testFinder.getRoot();
        if (stringArray == null) {
            fileArray = new File[]{file};
        } else {
            fileArray = new File[stringArray.length];
            n = 0;
            while (n < stringArray.length) {
                fileArray[n] = new File(stringArray[n]);
                ++n;
            }
        }
        this.rootDir = file.isDirectory() ? file : new File(file.getParent());
        this.tests = new Fifo();
        this.currInitialFile = null;
        n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                File file2 = fileArray[n2];
                String string = file2.getName();
                if (string.indexOf("#") != -1 != (n == 0)) {
                    String string2;
                    if (!file2.isAbsolute()) {
                        file2 = new File(this.rootDir, file2.getPath());
                    }
                    if ((string2 = file2.getPath()).endsWith(File.separator)) {
                        file2 = new File(string2.substring(0, string2.length() - 1));
                    }
                    this.tests.insert(file2);
                }
                ++n2;
            }
            ++n;
        }
        this.filesRemainingCount = this.filesToRead.size() + this.tests.size();
    }

    public void setZeroTestsOK(boolean bl) {
        this.zeroTestsOK = bl;
    }

    public void repeat(TestDescription[] testDescriptionArray) {
        if (this.tests == null) {
            this.tests = new Fifo();
        }
        int n = 0;
        while (n < testDescriptionArray.length) {
            TestDescription testDescription = testDescriptionArray[n];
            this.testDescsFound.insert(testDescription);
            ++this.testsFoundCount;
            this.notifier.found(testDescription);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestDescription next() {
        TestDescription testDescription;
        TestFinderQueue testFinderQueue = this;
        synchronized (testFinderQueue) {
            while (this.needReadAhead() && this.readNextFile()) {
            }
            while ((testDescription = (TestDescription)this.testDescsFound.remove()) == null) {
                boolean bl = this.readNextFile();
                if (bl) continue;
                return null;
            }
            ++this.testsDoneCount;
        }
        this.notifier.done(testDescription);
        return testDescription;
    }

    public File getRoot() {
        return this.rootDir;
    }

    public int getFilesFoundCount() {
        return this.filesFound.size();
    }

    public int getFilesDoneCount() {
        return this.filesDoneCount;
    }

    public int getFilesRemainingCount() {
        return this.filesRemainingCount;
    }

    public int getTestsFoundCount() {
        return this.testsFoundCount;
    }

    public int getTestsDoneCount() {
        return this.testsDoneCount;
    }

    public int getTestsRemainingCount() {
        return this.testDescsFound.size();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void addObserver(Observer observer) {
        this.notifier.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.notifier.removeObserver(observer);
    }

    public synchronized void setReadAheadMode(byte by) {
        switch (by) {
            case 0: 
            case 3: {
                this.readAheadMode = by;
                this.readAheadWorker = null;
                break;
            }
            case 1: 
            case 2: {
                this.readAheadMode = by;
                if (this.readAheadWorker != null) break;
                this.readAheadWorker = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (TestFinderQueue.this.readAheadWorker == this && TestFinderQueue.this.readNextFile()) {
                        }
                        TestFinderQueue testFinderQueue = TestFinderQueue.this;
                        synchronized (testFinderQueue) {
                            if (TestFinderQueue.this.readAheadWorker == this) {
                                TestFinderQueue.this.readAheadWorker = null;
                            }
                        }
                    }
                };
                this.readAheadWorker.setName("TestFinderQueue:Worker:" + workerIndex++);
                this.readAheadWorker.setPriority(1);
                this.readAheadWorker.start();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value for mode");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        TestFinderQueue testFinderQueue = this;
        synchronized (testFinderQueue) {
            this.filesToRead.setSize(0);
            this.tests.flush();
            this.testDescsFound.flush();
            this.filesRemainingCount = 0;
        }
        this.notifier.flushed();
    }

    private boolean needReadAhead() {
        switch (this.readAheadMode) {
            case 3: {
                return true;
            }
            case 2: {
                if (this.testsFoundCount < 100) {
                    return true;
                }
                double d = 1.0 - Math.exp(-2.0E-4 * (double)this.testsFoundCount);
                return (double)this.testsDoneCount > (double)this.testsFoundCount * d;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean readNextFile() {
        if (this.filesToRead.isEmpty()) {
            if (this.currInitialFile != null && this.testsFoundCountBeforeCurrInitialFile == this.testsFoundCount && !this.zeroTestsOK) {
                ++this.errorCount;
                this.notifier.error(TestFinderQueue.i18n.getString("finder.noTests", this.currInitialFile));
            }
            while (this.filesToRead.isEmpty() && !this.tests.isEmpty()) {
                this.currInitialFile = (File)this.tests.remove();
                this.foundFile(this.currInitialFile);
            }
            if (this.filesToRead.isEmpty()) {
                this.currInitialFile = null;
                return false;
            }
            this.testsFoundCountBeforeCurrInitialFile = this.testsFoundCount;
        }
        var1_1 = (File)this.filesToRead.lastElement();
        this.filesToRead.setSize(this.filesToRead.size() - 1);
        this.filesRemainingCount = this.filesToRead.size() + this.tests.size();
        var2_2 = var1_1.getPath();
        var3_3 = var2_2.indexOf(35);
        if (var3_3 != -1) {
            this.selectedId = var2_2.substring(var3_3 + 1);
            var1_1 = new File(var2_2.substring(0, var3_3));
        }
        this.fileInsertPosn = this.filesToRead.size();
        this.notifier.reading(var1_1);
        try {
            this.testFinder.read(var1_1);
        }
        finally {
            var4_4 = this.testFinder.getTests();
            var5_5 = 0;
            ** while (var5_5 < var4_4.length)
        }
lbl-1000:
        // 1 sources

        {
            this.foundTestDescription(var4_4[var5_5]);
            ++var5_5;
            continue;
        }
lbl32:
        // 1 sources

        var6_6 = this.testFinder.getFiles();
        var7_7 = 0;
        while (var7_7 < var6_6.length) {
            this.foundFile(var6_6[var7_7]);
            ++var7_7;
        }
        this.selectedId = null;
        ++this.filesDoneCount;
        this.notifier.done(var1_1);
        return true;
    }

    private void foundFile(File file) {
        File file2;
        if (this.selectedId == null && (file2 = this.filesFound.put(file.getPath(), file)) == null) {
            this.filesToRead.insertElementAt(file, this.fileInsertPosn);
            this.notifier.found(file);
        }
    }

    private void foundTestDescription(TestDescription testDescription) {
        if (this.selectedId == null || this.selectedId.equals(testDescription.getId())) {
            if (this.filters != null) {
                int n = 0;
                while (n < this.filters.length) {
                    TestFilter testFilter = this.filters[n];
                    try {
                        if (!testFilter.accepts(testDescription)) {
                            this.notifier.ignored(testDescription, testFilter);
                            return;
                        }
                    }
                    catch (TestFilter.Fault fault) {
                        ++this.errorCount;
                        this.notifier.error(testDescription, fault.getMessage());
                        return;
                    }
                    ++n;
                }
            }
            this.testDescsFound.insert(testDescription);
            ++this.testsFoundCount;
            this.notifier.found(testDescription);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TestFinder == null ? (class$com$sun$javatest$TestFinder = TestFinderQueue.class$("com.sun.javatest.TestFinder")) : class$com$sun$javatest$TestFinder);
    }

    private static class Notifier
    implements Observer {
        private Observer[] observers = new Observer[0];

        private Notifier() {
        }

        public synchronized void addObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.append(this.observers, observer);
        }

        public synchronized void removeObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
        }

        public synchronized void found(File file) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].found(file);
                ++n;
            }
        }

        public synchronized void reading(File file) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].reading(file);
                ++n;
            }
        }

        public synchronized void done(File file) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].done(file);
                ++n;
            }
        }

        public synchronized void found(TestDescription testDescription) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].found(testDescription);
                ++n;
            }
        }

        public synchronized void ignored(TestDescription testDescription, TestFilter testFilter) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].ignored(testDescription, testFilter);
                ++n;
            }
        }

        public synchronized void done(TestDescription testDescription) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].done(testDescription);
                ++n;
            }
        }

        public synchronized void flushed() {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].flushed();
                ++n;
            }
        }

        public synchronized void error(String string) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].error(string);
                ++n;
            }
        }

        public synchronized void error(TestDescription testDescription, String string) {
            int n = 0;
            while (n < this.observers.length) {
                this.observers[n].error(testDescription, string);
                ++n;
            }
        }
    }

    public static interface Observer {
        public void found(File var1);

        public void reading(File var1);

        public void done(File var1);

        public void found(TestDescription var1);

        public void ignored(TestDescription var1, TestFilter var2);

        public void done(TestDescription var1);

        public void flushed();

        public void error(String var1);

        public void error(TestDescription var1, String var2);
    }
}

