/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TestEnvContext {
    private Map[] propTables;
    private String[] propTableNames;
    private String[] envNames;
    private String[] envMenuNames;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TestEnvContext == null ? (class$com$sun$javatest$TestEnvContext = TestEnvContext.class$("com.sun.javatest.TestEnvContext")) : class$com$sun$javatest$TestEnvContext);
    private static boolean debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$TestEnvContext == null ? (class$com$sun$javatest$TestEnvContext = TestEnvContext.class$("com.sun.javatest.TestEnvContext")) : class$com$sun$javatest$TestEnvContext).getName());
    static /* synthetic */ Class class$com$sun$javatest$TestEnvContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestEnvContext(File[] fileArray) throws Fault {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    File file = fileArray[n];
                    this.add(vector2, vector, this.load(file), file.getPath());
                    ++n;
                }
            }
        }
        finally {
            this.propTables = new Map[vector2.size()];
            vector2.copyInto(this.propTables);
            this.propTableNames = new String[vector.size()];
            vector.copyInto(this.propTableNames);
            this.updateEnvTable();
        }
    }

    public TestEnvContext(Map[] mapArray, String[] stringArray) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < mapArray.length) {
            this.add(vector2, vector, mapArray[n], stringArray[n]);
            ++n;
        }
        this.propTables = new Map[vector2.size()];
        vector2.copyInto(this.propTables);
        this.propTableNames = new String[vector.size()];
        vector.copyInto(this.propTableNames);
        this.updateEnvTable();
    }

    public TestEnvContext(Map map, String string) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.add(vector2, vector, map, string);
        this.propTables = new Map[vector2.size()];
        vector2.copyInto(this.propTables);
        this.propTableNames = new String[vector.size()];
        vector.copyInto(this.propTableNames);
        this.updateEnvTable();
    }

    public TestEnvironment getEnv(String string) throws TestEnvironment.Fault {
        if (this.isValidEnv(string)) {
            return new TestEnvironment(string, this.propTables, this.propTableNames);
        }
        return null;
    }

    public boolean isValidEnv(String string) {
        if (string.length() == 0) {
            return true;
        }
        int n = 0;
        while (n < this.envNames.length) {
            if (this.envNames[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] getEnvNames() {
        return this.envNames;
    }

    public String[] getEnvMenuNames() {
        return this.envMenuNames;
    }

    private Map load(File file) throws Fault {
        if (file == null) {
            return null;
        }
        try {
            Properties properties = new Properties();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            properties.load(bufferedReader);
            ((Reader)bufferedReader).close();
            return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "tec.cantFindFile", file);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "tec.ioError", new Object[]{file, iOException});
        }
    }

    private void add(Vector vector, Vector vector2, Map map, String string) {
        if (map != null) {
            vector.addElement(map);
            vector2.addElement(string);
        }
    }

    private void updateEnvTable() {
        Object object;
        Object[] objectArray = this.propTables;
        Object[] objectArray2 = this.propTableNames;
        Object[] objectArray3 = TestEnvironment.defaultPropTables;
        Object[] objectArray4 = TestEnvironment.defaultPropTableNames;
        if (objectArray3 != null && objectArray3.length > 0) {
            objectArray = (Map[])DynamicArray.join(objectArray3, objectArray);
            objectArray2 = (String[])DynamicArray.join(objectArray4, objectArray2);
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (debug) {
            System.err.println(this.getClass().getName() + ": trace");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (debug) {
                System.err.println("Checking " + (String)objectArray2[n] + " for environments...");
            }
            object = objectArray[n];
            Iterator iterator = object.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = null;
                if (debug) {
                    System.err.println("Checking property " + string);
                }
                if (!string.startsWith("env.")) continue;
                if (string.endsWith(".inherits")) {
                    string2 = string.substring("env.".length(), string.length() - ".inherits".length());
                } else if (string.endsWith(".menu")) {
                    string2 = string.substring("env.".length(), string.length() - ".menu".length());
                    String string3 = (String)object.get(string);
                    if ("false".equals(string3)) {
                        this.sortedInsert(vector2, string2);
                    }
                } else if (string.endsWith(".description")) {
                    string2 = string.substring("env.".length(), string.length() - ".description".length());
                } else if (string.endsWith(".finder")) {
                    string2 = string.substring("env.".length(), string.length() - ".finder".length());
                } else if (string.endsWith(".script")) {
                    string2 = string.substring("env.".length(), string.length() - ".script".length());
                } else if (string.endsWith(".testsuite")) {
                    string2 = string.substring("env.".length(), string.length() - ".testsuite".length());
                } else {
                    int n2 = string.lastIndexOf(46);
                    int n3 = n2 - ".script.".length() + 1;
                    if (n3 <= 0 || !string.regionMatches(n3, ".script.", 0, ".script.".length())) continue;
                    string2 = string.substring("env.".length(), n3);
                }
                if (debug) {
                    System.err.println("found environment name: " + string2);
                }
                this.sortedInsert(vector, string2);
            }
            ++n;
        }
        this.envNames = new String[vector.size()];
        vector.copyInto(this.envNames);
        object = (Vector)vector.clone();
        int n4 = 0;
        while (n4 < vector2.size()) {
            ((Vector)object).removeElement(vector2.elementAt(n4));
            ++n4;
        }
        this.envMenuNames = new String[((Vector)object).size()];
        ((Vector)object).copyInto(this.envMenuNames);
    }

    private void sortedInsert(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            int n2 = string.compareTo((String)vector.elementAt(n));
            if (n2 > 0) {
                vector.insertElementAt(string, n);
                return;
            }
            if (n2 == 0) {
                return;
            }
            ++n;
        }
        vector.addElement(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

