/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.Hashtable;

class TRT_TreeNode
implements TestResultTable.TreeNode {
    private Object[] childs = null;
    private TRT_TreeNode parent;
    private TestResultTable table;
    private int counter = 0;
    private int[] childStats;
    private String name = null;
    private long lastScanDate;
    private static Hashtable observerTable = new Hashtable(16);
    private String[] filesToScan;
    protected static int debug = Debug.getInt(class$com$sun$javatest$TRT_TreeNode == null ? (class$com$sun$javatest$TRT_TreeNode = TRT_TreeNode.class$("com.sun.javatest.TRT_TreeNode")) : class$com$sun$javatest$TRT_TreeNode);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TRT_TreeNode == null ? (class$com$sun$javatest$TRT_TreeNode = TRT_TreeNode.class$("com.sun.javatest.TRT_TreeNode")) : class$com$sun$javatest$TRT_TreeNode);
    static /* synthetic */ Class class$com$sun$javatest$TRT_TreeNode;

    public synchronized void addObserver(TestResultTable.TreeNodeObserver treeNodeObserver) {
        Object[] objectArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (objectArray == null) {
            objectArray = new TestResultTable.TreeNodeObserver[]{};
        }
        objectArray = (TestResultTable.TreeNodeObserver[])DynamicArray.append(objectArray, treeNodeObserver);
        observerTable.put(this, objectArray);
    }

    public synchronized void removeObserver(TestResultTable.TreeNodeObserver treeNodeObserver) {
        Object[] objectArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (objectArray == null) {
            return;
        }
        if ((objectArray = (TestResultTable.TreeNodeObserver[])DynamicArray.remove(objectArray, treeNodeObserver)) == null) {
            observerTable.remove(this);
        } else {
            observerTable.put(this, objectArray);
        }
    }

    public int getSize() {
        this.scanSubtree(this);
        return this.counter;
    }

    public TestResultTable.TreeNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TestResultTable getEnclosingTable() {
        return this.table;
    }

    public boolean isUpToDate() {
        return this.lastScanDate != 0L;
    }

    public int getChildCount() {
        this.scanIfNeeded();
        if (this.childs == null) {
            return 0;
        }
        return this.childs.length;
    }

    public Object getChild(int n) {
        this.scanIfNeeded();
        if (this.childs == null || n >= this.childs.length) {
            return null;
        }
        return this.childs[n];
    }

    public TestResult[] getTestResults() {
        this.scanIfNeeded();
        TestResult[] testResultArray = null;
        if (this.childs != null && this.childs.length != 0) {
            int n = 0;
            while (n < this.childs.length) {
                if (this.childs[n] instanceof TestResult) {
                    testResultArray = (TestResult[])DynamicArray.append(testResultArray, this.childs[n]);
                }
                ++n;
            }
        }
        return testResultArray;
    }

    public TestResultTable.TreeNode[] getTreeNodes() {
        this.scanIfNeeded();
        if (this.childs == null) {
            return null;
        }
        TestResultTable.TreeNode[] treeNodeArray = null;
        int n = 0;
        while (n < this.childs.length) {
            if (this.childs[n] instanceof TestResultTable.TreeNode) {
                treeNodeArray = (TestResultTable.TreeNode[])DynamicArray.append(treeNodeArray, this.childs[n]);
            }
            ++n;
        }
        return treeNodeArray;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf(int n) {
        this.scanIfNeeded();
        if (n < 0 || n >= this.childs.length) {
            return false;
        }
        if (this.childs[n] instanceof TestResult) {
            return true;
        }
        if (this.childs[n] instanceof TRT_TreeNode) {
            return this.childs == null || this.childs.length == 0;
        }
        return false;
    }

    public int[] getChildStatus() {
        this.scanSubtree(this);
        if (this.childStats == null) {
            TRT_TreeNode.refreshChildStats(this);
        }
        return this.childStats;
    }

    public int getIndex(Object object) {
        this.scanIfNeeded();
        if (object == null) {
            return -2;
        }
        int n = 0;
        while (n < this.childs.length) {
            if (this.childs[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public TestResult matchTest(String string) {
        this.scanIfNeeded();
        if (debug > 1) {
            Debug.println("Matching Test URL: " + this.name + " in " + this);
        }
        TestResult testResult = null;
        if (this.childs == null || this.childs.length == 0) {
            return null;
        }
        int n = 0;
        while (n < this.childs.length) {
            if (this.childs[n] instanceof TestResult) {
                TestResult testResult2 = (TestResult)this.childs[n];
                try {
                    String string2 = testResult2.getDescription().getRootRelativeURL();
                }
                catch (TestResult.Fault fault) {
                    throw new JavaTestError(i18n, "trttn.noTd", fault);
                }
                if (debug > 1) {
                    Debug.println("   -> trying to match against " + this.name);
                }
                if (this.name.equals(string)) {
                    testResult = (TestResult)this.childs[n];
                    n = this.childs.length;
                } else {
                    testResult = null;
                }
            }
            ++n;
        }
        return testResult;
    }

    TRT_TreeNode(TestResultTable testResultTable, TestResultTable.TreeNode treeNode) {
        this.table = testResultTable;
        this.parent = (TRT_TreeNode)treeNode;
    }

    int getCurrentSize() {
        return this.counter;
    }

    void incChildStat(int n) {
        int n2 = n;
        this.childStats[n2] = this.childStats[n2] + 1;
    }

    void decChildStat(int n) {
        int n2 = n;
        this.childStats[n2] = this.childStats[n2] - 1;
    }

    void invalidateChildStats() {
        this.childStats = null;
        this.notifyCounterChange();
        TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)this.getParent();
        if (tRT_TreeNode != null) {
            tRT_TreeNode.invalidateChildStats();
        }
    }

    boolean isChildStatsValid() {
        return this.childStats == null;
    }

    static void bubbleUpChildStat(TRT_TreeNode tRT_TreeNode, int n) {
        int n2 = n;
        tRT_TreeNode.childStats[n2] = tRT_TreeNode.childStats[n2] + 1;
        TRT_TreeNode tRT_TreeNode2 = (TRT_TreeNode)tRT_TreeNode.getParent();
        if (tRT_TreeNode2 != null) {
            TRT_TreeNode.bubbleUpChildStat(tRT_TreeNode2, n);
        }
    }

    static void swapChildStat(TRT_TreeNode tRT_TreeNode, int n, int n2) {
        int n3 = n;
        tRT_TreeNode.childStats[n3] = tRT_TreeNode.childStats[n3] - 1;
        int n4 = n2;
        tRT_TreeNode.childStats[n4] = tRT_TreeNode.childStats[n4] + 1;
        TRT_TreeNode tRT_TreeNode2 = (TRT_TreeNode)tRT_TreeNode.getParent();
        if (tRT_TreeNode2 != null) {
            TRT_TreeNode.swapChildStat(tRT_TreeNode2, n, n2);
        }
    }

    void incNodeCounter() {
        ++this.counter;
    }

    TestResult getTestResult(String string) {
        int n = this.getTestIndex(string);
        if (n != -1) {
            try {
                return (TestResult)this.getChild(n);
            }
            catch (ClassCastException classCastException) {
                throw new JavaTestError(i18n, "trttn.badCast");
            }
        }
        return null;
    }

    TRT_TreeNode getTreeNode(String string) {
        int n = this.getNodeIndex(string);
        if (n != -1) {
            try {
                return (TRT_TreeNode)this.getChild(n);
            }
            catch (ClassCastException classCastException) {
                throw new JavaTestError(i18n, "trttn.badCast");
            }
        }
        return null;
    }

    int getTestIndex(String string) {
        if (string == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        int n = this.getResultIndex(TestResult.getWorkRelativePath(string));
        return n;
    }

    synchronized int getResultIndex(String string) {
        if (string == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        this.scanIfNeeded();
        int n = -1;
        if (this.childs != null && this.childs.length != 0) {
            int n2 = 0;
            while (n2 < this.childs.length) {
                TestResult testResult;
                if (this.childs[n2] instanceof TestResult && (testResult = (TestResult)this.childs[n2]).getWorkRelativePath().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    int getTestIndex(TestResult testResult) {
        if (testResult == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        int n = this.getResultIndex(testResult.getWorkRelativePath());
        return n;
    }

    synchronized int getNodeIndex(String string) {
        this.scanIfNeeded();
        int n = -1;
        if (string == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        if (this.childs == null || this.childs.length == 0) {
            n = -1;
        } else {
            int n2 = 0;
            while (n2 < this.childs.length) {
                TRT_TreeNode tRT_TreeNode;
                if (this.childs[n2] instanceof TRT_TreeNode && (tRT_TreeNode = (TRT_TreeNode)this.childs[n2]).getName().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    synchronized void scanIfNeeded() {
        if (this.childs != null || this.table.getTestFinder() == null) {
            return;
        }
        if (debug > 0) {
            Debug.println("starting scanIfNeeded() on node " + this.getName());
        }
        this.childs = new Object[0];
        if (this.isRoot() && this.filesToScan == null) {
            File file = this.table.getTestSuiteRoot();
            this.lastScanDate = this.table.getLastModifiedTime(file);
            this.processFile(file);
            if (this.filesToScan == null) {
                this.filesToScan = new String[0];
            }
        }
        if (this.filesToScan != null) {
            int n = 0;
            while (n < this.filesToScan.length) {
                if (this.filesToScan[n] == this.name) {
                    File file = new File(this.getTestSuiteRootPathPrefix() + File.separator + TestResultTable.getRootRelativePath(this));
                    this.lastScanDate = this.table.getLastModifiedTime(file);
                    this.processFile(file);
                } else {
                    this.processFile(new File(this.getTestSuiteRootPathPrefix() + File.separator + TestResultTable.getRootRelativePath(this), this.filesToScan[n]));
                }
                ++n;
            }
        } else if (debug > 0) {
            Debug.println("nothing to scan in " + this.getName());
        }
    }

    synchronized TestResult resetTest(int n, TestResult testResult) {
        if (this.childs[n] != testResult) {
            return null;
        }
        File file = testResult.getFile();
        if (file != null) {
            boolean bl = file.delete();
        }
        String string = testResult.getTestName();
        String string2 = null;
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(35);
        string2 = n3 > n2 ? string.substring(0, n3) : string;
        TestResult testResult2 = null;
        TestDescription testDescription = null;
        try {
            testDescription = testResult.getDescription();
        }
        catch (TestResult.Fault fault) {
            // empty catch block
        }
        TestDescription testDescription2 = this.updateTestDescription(string, testDescription);
        testResult2 = TestResult.notRun(testDescription2);
        if (testResult2 != null) {
            return this.replaceTest(testResult2, n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean refreshIfNeeded() {
        if (this.filesToScan != null) {
            File file = new File(this.getTestSuiteRootPathPrefix() + File.separator + TestResultTable.getRootRelativePath(this));
            TestFinder testFinder = this.table.getTestFinder();
            File[] fileArray = null;
            long l = this.table.getLastModifiedTime(file);
            TestFinder testFinder2 = testFinder;
            synchronized (testFinder2) {
                testFinder.read(file);
                File[] fileArray2 = testFinder.getFiles();
                fileArray = new File[fileArray2.length];
                System.arraycopy(fileArray2, 0, fileArray, 0, fileArray2.length);
            }
            int n = 0;
            while (n < fileArray.length) {
                if (this.table.isBranchFile(fileArray[n])) {
                    this.updateDirectory(fileArray[n]);
                } else if (this.table.getLastModifiedTime(fileArray[n]) > this.lastScanDate) {
                    this.updateFile(fileArray[n]);
                }
                ++n;
            }
            this.lastScanDate = l;
        } else if (debug > 0) {
            Debug.println("nothing to refresh in " + this.getName());
        }
        return true;
    }

    synchronized TestResult refreshIfNeeded(TestResult testResult) {
        TestResult testResult2 = null;
        try {
            TestDescription testDescription = testResult.getDescription();
            TestDescription testDescription2 = this.updateTestDescription(testResult.getTestName(), testDescription);
            if (testDescription == testDescription2) {
                testResult2 = testResult;
            } else {
                TestResult testResult3 = TestResult.notRun(testDescription2);
                if (testResult3 != null) {
                    this.addChild(testResult3);
                    testResult2 = testResult3;
                }
            }
        }
        catch (TestResult.Fault fault) {
            if (debug > 0) {
                fault.printStackTrace(Debug.getWriter());
            }
            testResult2 = testResult;
        }
        return testResult2;
    }

    synchronized boolean updateDirectory(File file) {
        boolean bl;
        block7: {
            TestResultTable.TreeNode[] treeNodeArray = this.getTreeNodes();
            String string = this.makeNodeRelative(file);
            bl = false;
            if (treeNodeArray != null) {
                int n = 0;
                while (n < treeNodeArray.length) {
                    if (treeNodeArray[n].getName().equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            } else {
                bl = false;
            }
            if (bl) break block7;
            try {
                TRT_TreeNode tRT_TreeNode = this.createDirNode(this, string);
                int n = this.getIndex(tRT_TreeNode);
                this.notifyInsBranch(tRT_TreeNode, n);
                TestResultTable.TreeNode[] treeNodeArray2 = TestResultTable.getObjectPath(tRT_TreeNode);
                TestResultTable.TreeNode[] treeNodeArray3 = new TRT_TreeNode[treeNodeArray2.length - 1];
                System.arraycopy(treeNodeArray2, 0, treeNodeArray3, 0, treeNodeArray2.length - 1);
                this.table.notifyNewBranch(treeNodeArray3, tRT_TreeNode, n);
                tRT_TreeNode.scanIfNeeded();
            }
            catch (Fault fault) {
                if (debug <= 0) break block7;
                fault.printStackTrace(Debug.getWriter());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean updateFile(File file) {
        TestFinder testFinder = this.table.getTestFinder();
        TestDescription[] testDescriptionArray = null;
        TestFinder testFinder2 = testFinder;
        synchronized (testFinder2) {
            testFinder.read(file);
            TestDescription[] testDescriptionArray2 = testFinder.getTests();
            testDescriptionArray = new TestDescription[testDescriptionArray2.length];
            System.arraycopy(testDescriptionArray2, 0, testDescriptionArray, 0, testDescriptionArray2.length);
        }
        int n = 0;
        while (n < testDescriptionArray.length) {
            TestResult testResult = this.getTestResult(testDescriptionArray[n].getRootRelativeURL());
            TestDescription testDescription = null;
            try {
                if (testResult != null) {
                    testDescription = testResult.getDescription();
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
            if (testResult == null || testDescription == null || !testDescriptionArray[n].equals(testDescription)) {
                TestResult testResult2 = TestResult.notRun(testDescriptionArray[n]);
                this.table.update(testResult2);
                TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(this);
                int n2 = this.getTestIndex(testResult2);
                if (testResult == null) {
                    this.table.notifyNewLeaf(treeNodeArray, testResult2, n2);
                } else {
                    this.table.notifyRemoveLeaf(treeNodeArray, testResult, n2);
                    this.table.notifyNewLeaf(treeNodeArray, testResult2, n2);
                }
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized TestDescription updateTestDescription(String string, TestDescription testDescription) {
        String string2 = string;
        if (string2 == null) {
            string2 = testDescription.getRootRelativeURL();
        }
        String string3 = null;
        int n = string2.lastIndexOf(47);
        int n2 = string2.lastIndexOf(35);
        TestDescription testDescription2 = null;
        string3 = n2 > n ? string2.substring(0, n2) : string2;
        File file = new File(this.getTestSuiteRootPathPrefix() + File.separator + string3);
        if (this.table.getLastModifiedTime(file) > this.lastScanDate || testDescription == null) {
            TestFinder testFinder;
            TestFinder testFinder2 = testFinder = this.table.getTestFinder();
            synchronized (testFinder2) {
                testFinder.read(file);
                TestDescription[] testDescriptionArray = testFinder.getTests();
                int n3 = 0;
                while (n3 < testDescriptionArray.length) {
                    if (testDescriptionArray[n3].getRootRelativeURL().equals(string2)) {
                        testDescription2 = testDescriptionArray[n3];
                        break;
                    }
                    ++n3;
                }
            }
        }
        if (testDescription2 == null) {
            return testDescription;
        }
        if (testDescription == null || !testDescription.equals(testDescription2)) {
            return testDescription2;
        }
        return testDescription;
    }

    private TestResult replaceTest(TestResult testResult, int n) {
        TestResult testResult2 = (TestResult)this.childs[n];
        this.childs[n] = testResult;
        this.notifyReplacedResult(testResult2, testResult, n);
        testResult.setParent(this);
        testResult2.setParent(null);
        return testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file) {
        Object object;
        TestFinder testFinder;
        if (debug > 0) {
            Debug.println("--- Entering processFile() ---");
            Debug.println("Full name is: " + TestResultTable.getRootRelativePath(this));
            Debug.println("Processing file: " + file.getPath());
        }
        TestDescription[] testDescriptionArray = null;
        File[] fileArray = null;
        TestFinder testFinder2 = testFinder = this.table.getTestFinder();
        synchronized (testFinder2) {
            testFinder.read(file);
            TestDescription[] testDescriptionArray2 = testFinder.getTests();
            object = testFinder.getFiles();
            if (testDescriptionArray2 != null && testDescriptionArray2.length != 0) {
                testDescriptionArray = new TestDescription[testDescriptionArray2.length];
                System.arraycopy(testDescriptionArray2, 0, testDescriptionArray, 0, testDescriptionArray2.length);
            } else {
                testDescriptionArray = new TestDescription[]{};
            }
            if (object != null && ((File[])object).length != 0) {
                fileArray = new File[((File[])object).length];
                System.arraycopy(object, 0, fileArray, 0, ((File[])object).length);
            } else {
                fileArray = new File[]{};
            }
            if (debug > 0) {
                Debug.println("Read " + testDescriptionArray.length + " tests, and " + fileArray.length + " files.");
            }
        }
        int n = 0;
        while (n < testDescriptionArray.length) {
            object = TestResult.notRun(testDescriptionArray[n]);
            this.addChild((TestResult)object);
            ++n;
        }
        this.insertFinderFiles(this, fileArray);
        if (debug > 0) {
            Debug.println("--- Exiting processFile() ---");
        }
    }

    private synchronized void insertFinderFiles(TRT_TreeNode tRT_TreeNode, File[] fileArray) {
        int n = 0;
        while (n < fileArray.length) {
            if (debug > 1) {
                Debug.println("**");
                Debug.println("original file is: " + fileArray[n].getPath());
            }
            String string = this.makeNodeRelative(fileArray[n]);
            if (debug > 1) {
                Debug.println("stripped file is: " + string);
            }
            if (string.charAt(string.length() - 1) == '/') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.indexOf(47) == -1) {
                if (this.getEnclosingTable().isBranchFile(fileArray[n])) {
                    if (debug > 1) {
                        Debug.println("   => directory, creating node");
                    }
                    try {
                        TRT_TreeNode tRT_TreeNode2 = this.createDirNode(tRT_TreeNode, string);
                    }
                    catch (Fault fault) {
                        throw new JavaTestError(i18n, "trttn.nameClash", fault);
                    }
                } else {
                    if (debug > 1) {
                        Debug.println("   => file, adding to scan list");
                    }
                    this.addToScanList(this, string, fileArray[n]);
                }
            } else {
                this.recursiveFinderInsert(this, fileArray[n], string);
            }
            if (debug > 1) {
                Debug.println("**");
            }
            ++n;
        }
    }

    private synchronized void recursiveFinderInsert(TRT_TreeNode tRT_TreeNode, File file, String string) {
        String string2;
        if (debug > 0) {
            Debug.println("Recursive insert: " + string + " into " + tRT_TreeNode.getName());
        }
        if (string == (string2 = TestResultTable.behead(string))) {
            if (this.getEnclosingTable().isBranchFile(file)) {
                if (debug > 0) {
                    Debug.println("    -> Creating empty node and leaving.");
                }
                TRT_TreeNode tRT_TreeNode2 = new TRT_TreeNode(this.table, tRT_TreeNode);
                tRT_TreeNode2.setName(string2);
                tRT_TreeNode.addChild(tRT_TreeNode2);
            } else {
                this.addToScanList(tRT_TreeNode, string, file);
            }
        } else {
            String string3 = TestResultTable.getDirName(string);
            try {
                TRT_TreeNode tRT_TreeNode3 = this.createDirNode(tRT_TreeNode, string3);
                this.recursiveFinderInsert(tRT_TreeNode3, file, string2);
            }
            catch (Fault fault) {
                throw new JavaTestError(i18n, "trttn.nameClash", fault);
            }
        }
    }

    private TRT_TreeNode createDirNode(TRT_TreeNode tRT_TreeNode, String string) throws Fault {
        int n;
        if (debug > 1) {
            Debug.println("   => Trying to create dir node for: " + string);
        }
        if ((n = tRT_TreeNode.getResultIndex(string)) != -1) {
            throw new Fault(i18n, "trttn.alreadyExists", string);
        }
        int n2 = tRT_TreeNode.getNodeIndex(string);
        TRT_TreeNode tRT_TreeNode2 = null;
        if (n2 == -1) {
            if (debug > 1) {
                Debug.println("   => Creating " + string);
                Debug.println("   => Node is : " + tRT_TreeNode);
            }
            tRT_TreeNode2 = new TRT_TreeNode(this.table, tRT_TreeNode);
            tRT_TreeNode2.setName(string);
            this.addToScanList(tRT_TreeNode2, tRT_TreeNode2.name, new File(string));
            tRT_TreeNode.addChild(tRT_TreeNode2);
        } else {
            if (debug > 1) {
                Debug.println("   => Node exists, delegating.");
                Debug.println("   => index " + n2 + " in node " + tRT_TreeNode.getName());
            }
            try {
                tRT_TreeNode2 = (TRT_TreeNode)tRT_TreeNode.getChild(n2);
                if (debug > 1) {
                    Debug.println("   => " + tRT_TreeNode2);
                }
            }
            catch (ClassCastException classCastException) {
                throw new JavaTestError(i18n, "trttn.unexpecCast", classCastException);
            }
        }
        return tRT_TreeNode2;
    }

    void scanSubtree(TRT_TreeNode tRT_TreeNode) {
        if (this.table.getTestFinder() == null) {
            return;
        }
        tRT_TreeNode.scanIfNeeded();
        TRT_TreeNode[] tRT_TreeNodeArray = (TRT_TreeNode[])tRT_TreeNode.getTreeNodes();
        if (tRT_TreeNodeArray != null && tRT_TreeNodeArray.length != 0) {
            int n = 0;
            while (n < tRT_TreeNodeArray.length) {
                this.scanSubtree(tRT_TreeNodeArray[n]);
                ++n;
            }
        }
    }

    private String makeNodeRelative(File file) {
        if (debug > 1) {
            Debug.println("relativising: " + file.getPath());
        }
        if (file.isAbsolute()) {
            int n = this.getTestSuitePathLen();
            if (debug > 1) {
                Debug.println("  -> URL is absolute (" + file.getPath().length() + " chars), stripping.");
                Debug.println("  -> Stripping " + n + " characters.");
            }
            String string = TestResultTable.getRootRelativePath(this);
            if (debug > 1) {
                Debug.println("  -> removing rrp: " + string);
            }
            String string2 = file.getPath().substring(n += string == null || string.length() == 0 ? 0 : string.length() + 1);
            if (debug > 1) {
                Debug.println("  -> final node path: " + string2);
            }
            return string2.replace(File.separatorChar, '/');
        }
        String string = TestResultTable.getRootRelativePath(this);
        String string3 = file.getPath().replace(File.separatorChar, '/');
        if (debug > 1) {
            Debug.println("  -> check for RRP against: " + string);
        }
        if (string != null && string.length() != 0 && string3.startsWith(string)) {
            if (debug > 1) {
                Debug.println("  -> URL is root relative, stripping");
            }
            int n = string == null ? 0 : string.length();
            String string4 = string3.substring(n + 1);
            return string4;
        }
        if (debug > 1) {
            Debug.println("  -> relative, continue");
        }
        return string3;
    }

    private void addToScanList(TRT_TreeNode tRT_TreeNode, String string, File file) {
        if (debug > 1) {
            Debug.println("   => Adding " + string + " to scan list and leaving.");
            Debug.println("   => Node is : " + tRT_TreeNode);
        }
        int n = 0;
        if (tRT_TreeNode.filesToScan != null) {
            n = 0;
            while (n < tRT_TreeNode.filesToScan.length) {
                if (tRT_TreeNode.filesToScan[n].equals(string)) break;
                ++n;
            }
        }
        if (tRT_TreeNode.filesToScan == null || n >= tRT_TreeNode.filesToScan.length) {
            tRT_TreeNode.filesToScan = (String[])DynamicArray.append(tRT_TreeNode.filesToScan, string);
        } else if (debug > 1) {
            Debug.println(i18n.getString("trttn.multRef", file.getPath()));
        }
    }

    synchronized TestResult addChild(TestResult testResult) {
        this.scanIfNeeded();
        if (testResult == null) {
            throw new JavaTestError(i18n, "trttn.nullNode");
        }
        if (debug > 1) {
            Debug.println("Adding test " + testResult.getTestName());
            Debug.println("   -> " + testResult.getStatus().toString());
            Debug.println("   -> node ref: " + this);
            Debug.println("   -> node name: " + this.getName());
        }
        int n = this.getTestIndex(testResult);
        TestResult testResult2 = null;
        if (n == -1) {
            if (debug > 1) {
                Debug.println("no old entry for " + testResult);
            }
            try {
                this.childs = DynamicArray.append(this.childs, testResult, Class.forName("java.lang.Object"));
                testResult.setParent(this);
                this.bubbleUpCounterInc();
                this.notifyInsResult(testResult, this.childs.length - 1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JavaTestError(i18n, "trttn.noObject", classNotFoundException);
            }
        } else if (this.shouldReplaceTest(n, testResult)) {
            testResult2 = (TestResult)this.childs[n];
            this.childs[n] = testResult;
            if (debug > 1) {
                Debug.println("   -> ** replacing existing TR with " + testResult);
                Debug.println("   -> " + testResult.getTestName());
                Debug.println("   -> " + testResult.getStatus().toString());
                Debug.println("   -> node: " + this);
            }
            testResult2.setParent(null);
            testResult.setParent(this);
            this.notifyReplacedResult(testResult2, testResult, n);
        } else {
            if (debug > 1) {
                Debug.println("   -> ** TRT selectively ignoring insert of " + testResult);
                Debug.println("   -> old status: " + ((TestResult)this.childs[n]).getStatus().toString());
                Debug.println("   -> curr. ref in TRT: " + this.childs[n]);
                Debug.println("   -> ignored new ref.: " + testResult);
            }
            return testResult;
        }
        this.invalidateChildStats();
        return testResult2;
    }

    synchronized void addChild(TRT_TreeNode tRT_TreeNode) {
        if (tRT_TreeNode == null) {
            throw new JavaTestError(i18n, "trttn.nullNode");
        }
        this.scanIfNeeded();
        try {
            this.childs = DynamicArray.append(this.childs, tRT_TreeNode, Class.forName("java.lang.Object"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JavaTestError(i18n, "trttn.noObject", classNotFoundException);
        }
    }

    void setName(String string) {
        this.name = string;
    }

    private boolean shouldReplaceTest(int n, TestResult testResult) {
        if (!(this.childs[n] instanceof TestResult) || testResult == null || n < 0 || n >= this.childs.length) {
            return false;
        }
        TestResult testResult2 = (TestResult)this.childs[n];
        if (!testResult2.getTestName().equals(testResult.getTestName())) {
            return false;
        }
        if (testResult2.getStatus().getType() != testResult.getStatus().getType()) {
            return true;
        }
        if (!testResult2.getStatus().getReason().equals(testResult.getStatus().getReason())) {
            return true;
        }
        boolean bl = testResult2.isShrunk();
        boolean bl2 = testResult.isShrunk();
        if (bl && !bl2) {
            return true;
        }
        return !bl && !bl2;
    }

    private static void refreshChildStats(TRT_TreeNode tRT_TreeNode) {
        if (tRT_TreeNode.childStats != null) {
            return;
        }
        tRT_TreeNode.childStats = new int[4];
        int n = 0;
        while (n < tRT_TreeNode.childs.length) {
            Object object;
            if (tRT_TreeNode.childs[n] instanceof TRT_TreeNode) {
                object = (TRT_TreeNode)tRT_TreeNode.childs[n];
                int[] nArray = ((TRT_TreeNode)object).getChildStatus();
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = n2;
                    tRT_TreeNode.childStats[n3] = tRT_TreeNode.childStats[n3] + nArray[n2];
                    ++n2;
                }
            } else {
                object = (TestResult)tRT_TreeNode.childs[n];
                int n4 = ((TestResult)object).getStatus().getType();
                tRT_TreeNode.childStats[n4] = tRT_TreeNode.childStats[n4] + 1;
            }
            ++n;
        }
    }

    void bubbleUpCounterInc() {
        ++this.counter;
        this.notifyCounterChange();
        TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)this.getParent();
        if (tRT_TreeNode != null) {
            tRT_TreeNode.bubbleUpCounterInc();
        }
    }

    private int getTestSuitePathLen() {
        if (this.table.getTestSuiteRoot().isFile()) {
            return this.table.getTestSuiteRoot().getParent().length() + 1;
        }
        return this.table.getTestSuiteRoot().getAbsolutePath().length() + 1;
    }

    private String getTestSuiteRootPathPrefix() {
        File file = this.table.getTestSuiteRoot();
        if (file.isFile()) {
            return file.getParent();
        }
        return file.getPath();
    }

    private void notifyInsBranch(TRT_TreeNode tRT_TreeNode, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            int n2 = 0;
            while (n2 < treeNodeObserverArray.length) {
                treeNodeObserverArray[n2].insertedBranch(this, tRT_TreeNode, n);
                ++n2;
            }
        }
    }

    private void notifyInsResult(TestResult testResult, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            int n2 = 0;
            while (n2 < treeNodeObserverArray.length) {
                treeNodeObserverArray[n2].insertedResult(this, testResult, n);
                ++n2;
            }
        }
    }

    private void notifyReplacedResult(TestResult testResult, TestResult testResult2, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            int n2 = 0;
            while (n2 < treeNodeObserverArray.length) {
                treeNodeObserverArray[n2].replacedResult(this, testResult, testResult2, n);
                ++n2;
            }
        }
    }

    private void notifyRemovedBranch(int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            int n2 = 0;
            while (n2 < treeNodeObserverArray.length) {
                treeNodeObserverArray[n2].removedBranch(this, n);
                ++n2;
            }
        }
    }

    private void notifyRemovedResult(TestResult testResult, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            int n2 = 0;
            while (n2 < treeNodeObserverArray.length) {
                treeNodeObserverArray[n2].removedResult(this, testResult, n);
                ++n2;
            }
        }
    }

    private void notifyCounterChange() {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            int n = 0;
            while (n < treeNodeObserverArray.length) {
                treeNodeObserverArray[n].countersInvalidated(this);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

