/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

class TRT_Iterator
implements TestResultTable.TreeIterator {
    private String[] initialTests;
    private Object outQueueLock = new Object();
    private LinkedList outQueue;
    private TestResultTable.TreeNode[] nodes;
    private int nodeIndex = -1;
    private TestFilter[] filters;
    private int[] resultStats;
    private int absoluteCount;
    private int rejectCount;
    private boolean recordRejects;
    private Hashtable filteredTRs;
    private TestResult currentResult;
    private Object rejLock;
    private FilterObserver fo;
    private Stack stack;
    private PseudoFrame currFrame = null;
    private TestResultTable.TreeNode location;
    private TestResultTable.TreeNode root;
    private boolean finished = false;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TRT_Iterator == null ? (class$com$sun$javatest$TRT_Iterator = TRT_Iterator.class$("com.sun.javatest.TRT_Iterator")) : class$com$sun$javatest$TRT_Iterator);
    protected boolean debug = Debug.getBoolean(class$com$sun$javatest$TRT_Iterator == null ? (class$com$sun$javatest$TRT_Iterator = TRT_Iterator.class$("com.sun.javatest.TRT_Iterator")) : class$com$sun$javatest$TRT_Iterator);
    static /* synthetic */ Class class$com$sun$javatest$TRT_Iterator;

    protected TRT_Iterator() {
        this.outQueue = new LinkedList();
        this.resultStats = new int[4];
    }

    TRT_Iterator(TestResultTable.TreeNode treeNode) {
        this();
        this.nodes = new TestResultTable.TreeNode[1];
        this.nodes[0] = treeNode;
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator without filters, one initial node.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode treeNode, TestFilter[] testFilterArray) {
        this();
        this.filters = testFilterArray;
        this.nodes = new TestResultTable.TreeNode[1];
        this.nodes[0] = treeNode;
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters and one initial node.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode[] treeNodeArray, TestFilter[] testFilterArray) {
        this();
        this.filters = testFilterArray;
        if (treeNodeArray != null) {
            this.nodes = new TestResultTable.TreeNode[treeNodeArray.length];
            System.arraycopy(treeNodeArray, 0, this.nodes, 0, treeNodeArray.length);
        }
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters and initial nodes.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode[] treeNodeArray, TestResult[] testResultArray, TestFilter[] testFilterArray) {
        this();
        this.filters = testFilterArray;
        if (testResultArray != null && testResultArray.length != 0) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < testResultArray.length) {
                try {
                    if (this.wouldAccept(testResultArray[n]) == -1) {
                        this.outQueue.addLast(testResultArray[n]);
                        vector.add(testResultArray[n].getDescription().getRootRelativeURL());
                    }
                }
                catch (TestResult.Fault fault) {
                    // empty catch block
                }
                ++n;
            }
            this.initialTests = new String[vector.size()];
            vector.copyInto(this.initialTests);
        }
        if (treeNodeArray != null) {
            this.nodes = new TestResultTable.TreeNode[treeNodeArray.length];
            System.arraycopy(treeNodeArray, 0, this.nodes, 0, treeNodeArray.length);
        }
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters, nodes and initial TR set.");
        }
    }

    public boolean hasMoreElements() {
        return !this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        TestResult testResult = null;
        if (this.hasMoreElements()) {
            Object object = this.outQueueLock;
            synchronized (object) {
                testResult = (TestResult)this.outQueue.removeFirst();
            }
            this.findNext();
            int n = testResult.getStatus().getType();
            this.resultStats[n] = this.resultStats[n] + 1;
            return testResult;
        }
        throw new NoSuchElementException(i18n.getString("trt.noElements"));
    }

    public boolean hasNext() {
        return this.hasMoreElements();
    }

    public Object next() {
        return this.nextElement();
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from TestResultTable thhrough interator.  Do not call this method.");
    }

    public int getProcessedCount() {
        return this.absoluteCount;
    }

    public int getRejectCount() {
        return this.rejectCount;
    }

    public void setRecordRejects(boolean bl) {
        this.recordRejects = bl;
        if (this.recordRejects) {
            if (this.filteredTRs == null) {
                this.filteredTRs = new Hashtable(10);
            }
            if (this.fo == null) {
                this.fo = new FilterObserver();
            }
        }
    }

    public int[] getResultStats() {
        int[] nArray = new int[this.resultStats.length];
        System.arraycopy(this.resultStats, 0, nArray, 0, this.resultStats.length);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getFilterStats() {
        if (this.filteredTRs == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        Object object = this.rejLock;
        synchronized (object) {
            Enumeration enumeration = this.filteredTRs.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Iterator iterator = ((Vector)this.filteredTRs.get(k)).iterator();
                while (iterator.hasNext()) {
                    hashtable.put(iterator.next(), k);
                }
            }
        }
        return hashtable;
    }

    public TestFilter[] getFilters() {
        if (this.filters == null || this.filters.length == 0) {
            return null;
        }
        TestFilter[] testFilterArray = new TestFilter[this.filters.length];
        System.arraycopy(this.filters, 0, testFilterArray, 0, this.filters.length);
        return testFilterArray;
    }

    public String[] getInitialURLs() {
        int n;
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        if (this.nodes != null) {
            n = 0;
            while (n < this.nodes.length) {
                vector.addElement(TestResultTable.getRootRelativePath(this.nodes[n]));
                ++n;
            }
        }
        if (this.initialTests != null) {
            n = 0;
            while (n < this.initialTests.length) {
                vector.add(this.initialTests[n]);
                ++n;
            }
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        if (this.hasNext()) {
            Object object = this.outQueueLock;
            synchronized (object) {
                return this.outQueue.getFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPending(TestResult testResult) {
        int n;
        block35: {
            String string;
            Object object;
            String string2;
            String string3;
            block36: {
                if (!this.hasMoreElements()) {
                    return false;
                }
                string2 = string3 = testResult.getTestName();
                Object object2 = this.outQueueLock;
                synchronized (object2) {
                    if (this.outQueue.size() > 0) {
                        n = 0;
                        while (n < this.outQueue.size()) {
                            TestResult testResult2 = (TestResult)this.outQueue.get(n);
                            if (testResult2.getTestName().equals(string3)) {
                                return true;
                            }
                            ++n;
                        }
                    }
                }
                n = 0;
                boolean bl = false;
                if (this.nodes == null) break block35;
                int n2 = this.nodeIndex;
                while (n2 < this.nodes.length) {
                    object = TestResultTable.getRootRelativePath(this.nodes[n2]);
                    if (string3.startsWith((String)object)) {
                        if (n2 > this.nodeIndex) {
                            n = 1;
                            bl = true;
                            break;
                        }
                        if (n2 < this.nodeIndex) {
                            n = 0;
                            bl = true;
                            break;
                        }
                        if (((String)object).length() != 0) {
                            string2 = string3.substring(((String)object).length() + 1);
                        }
                        int n3 = 0;
                        block13: while (n3 < this.stack.size()) {
                            String string4 = TestResultTable.getDirName(string2);
                            string2 = TestResultTable.behead(string2);
                            PseudoFrame pseudoFrame = (PseudoFrame)this.stack.elementAt(n3);
                            TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)pseudoFrame.getNode();
                            int n4 = tRT_TreeNode.getNodeIndex(string4);
                            int n5 = pseudoFrame.getCurrentIndex();
                            if (string3.indexOf("/") == -1) {
                                n4 = n5;
                            }
                            if (n4 == -1 || n4 < n5) {
                                n = 0;
                                bl = true;
                                break;
                            }
                            if (n4 == pseudoFrame.getCurrentIndex()) {
                                if (string2.indexOf(47) == -1) {
                                    if (n3 + 1 == this.stack.size()) {
                                        bl = false;
                                        break;
                                    }
                                    switch (TRT_Iterator.checkTestPosition(pseudoFrame, string3)) {
                                        case -1: 
                                        case 0: {
                                            n = 0;
                                            bl = true;
                                            break block13;
                                        }
                                        case 2: {
                                            n = 1;
                                            bl = true;
                                            break block13;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                            } else {
                                n = 1;
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                if (bl) break block35;
                object = (TRT_TreeNode)this.currFrame.getNode();
                string = TestResultTable.getDirName(string2);
                if ((string2 = TestResultTable.behead(string2)).indexOf("/") != -1) break block36;
                switch (TRT_Iterator.checkTestPosition(this.currFrame, string3)) {
                    case -1: 
                    case 0: {
                        n = 0;
                        break block35;
                    }
                    case 2: {
                        n = 1;
                        break block35;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (!string.equals(this.currFrame.getNode().getName())) {
                n = 0;
                string = TestResultTable.getDirName(string2);
                object = (TRT_TreeNode)this.currFrame.getNode();
                int n6 = ((TRT_TreeNode)object).getNodeIndex(string);
                int n7 = this.currFrame.getCurrentIndex();
                if (n6 == -1) {
                    n = 0;
                } else if (n6 < n7) {
                    n = 0;
                } else {
                    if (n6 == n7) {
                        throw new IllegalStateException("");
                    }
                    n = 1;
                }
            } else {
                int n8 = ((TRT_TreeNode)object).getTestIndex(string3);
                if (n8 == -1) {
                    n = 0;
                }
                n = n8 > this.currFrame.getCurrentIndex() ? 1 : 0;
            }
        }
        return n != 0;
    }

    private void init(TestResultTable.TreeNode[] treeNodeArray) {
        this.nodes = treeNodeArray != null && treeNodeArray.length == 0 ? null : treeNodeArray;
        boolean bl = this.nextNode();
        if (bl) {
            this.findNext();
        } else if (this.outQueue.size() == 0) {
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized void findNext() {
        var1_1 = false;
        if (!this.finished) ** GOTO lbl46
        return;
lbl-1000:
        // 1 sources

        {
            block15: {
                if (this.currFrame == null) {
                    var2_3 = this.outQueueLock;
                    synchronized (var2_3) {
                        if (this.outQueue.size() == 0) {
                            this.finished = true;
                        }
                    }
                    return;
                }
                var2_2 = this.currFrame.nextIndex();
                if (var2_2 == -1) {
                    this.nextFrame();
                    continue;
                }
                var3_4 = this.currFrame.getNode().getChild(var2_2);
                if (var3_4 == null) {
                    this.nextFrame();
                    continue;
                }
                if (var3_4 instanceof TestResultTable.TreeNode) {
                    var4_6 = (TestResultTable.TreeNode)var3_4;
                    this.push(this.currFrame);
                    this.currFrame = new PseudoFrame((TestResultTable.TreeNode)var4_6);
                    continue;
                }
                var4_6 = (TestResult)var3_4;
                try {
                    var5_7 = this.wouldAccept((TestResult)var4_6);
                    if (var5_7 >= 0) {
                    }
                    break block15;
                }
                catch (TestResult.Fault var5_8) {
                    if (!this.debug) continue;
                    var5_8.printStackTrace(Debug.getWriter());
                }
                continue;
            }
            var5_9 = this.outQueueLock;
            synchronized (var5_9) {
                this.outQueue.addLast(var4_6);
            }
            var1_1 = true;
lbl46:
            // 8 sources

            ** while (!var1_1)
        }
lbl47:
        // 1 sources

    }

    private boolean isTop(TestResultTable.TreeNode treeNode) {
        return treeNode.isRoot() || this.nodes[this.nodeIndex] == treeNode;
    }

    private boolean nextNode() {
        this.stack = new Stack();
        this.currFrame = null;
        if (this.nodes != null && ++this.nodeIndex < this.nodes.length) {
            TestResultTable.TreeNode treeNode = this.nodes[this.nodeIndex];
            this.currFrame = new PseudoFrame(treeNode);
            return true;
        }
        return false;
    }

    private void push(PseudoFrame pseudoFrame) {
        this.stack.push(pseudoFrame);
    }

    private PseudoFrame pop() {
        if (!this.stack.empty()) {
            return (PseudoFrame)this.stack.pop();
        }
        return null;
    }

    private void nextFrame() {
        this.currFrame = this.pop();
        if (this.currFrame == null) {
            this.nextNode();
        }
    }

    private int wouldAccept(TestResult testResult) throws TestResult.Fault {
        if (this.filters == null || this.filters.length == 0) {
            return -1;
        }
        if (this.debug) {
            Debug.println("Iterator checking filter for: " + testResult.getWorkRelativePath());
        }
        ++this.absoluteCount;
        this.currentResult = testResult;
        int n = 0;
        while (n < this.filters.length) {
            boolean bl;
            block7: {
                bl = true;
                try {
                    bl = this.fo == null ? this.filters[n].accepts(testResult.getDescription()) : this.filters[n].accepts(testResult.getDescription(), this.fo);
                }
                catch (TestFilter.Fault fault) {
                    bl = true;
                    if (!this.debug) break block7;
                    Debug.println("   -> exception while checking filter: " + fault.getMessage());
                }
            }
            if (!bl) {
                if (this.debug) {
                    Debug.println("   -> Rejected by: " + this.filters[n]);
                    Debug.println("   -> Test Status: " + testResult.getStatus().getType());
                }
                ++this.rejectCount;
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static int checkTestPosition(PseudoFrame pseudoFrame, String string) {
        TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)pseudoFrame.getNode();
        int n = tRT_TreeNode.getTestIndex(string);
        int n2 = pseudoFrame.getCurrentIndex();
        int n3 = 3;
        n3 = n == -1 ? -1 : (n < n2 ? 0 : (n == n2 ? 1 : (n > n2 ? 2 : 3)));
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FilterObserver
    implements TestFilter.Observer {
        private FilterObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rejected(TestDescription testDescription, TestFilter testFilter) {
            Object object = TRT_Iterator.this.rejLock;
            synchronized (object) {
                Vector<TestResult> vector = (Vector<TestResult>)TRT_Iterator.this.filteredTRs.get(testFilter);
                if (vector == null) {
                    vector = new Vector<TestResult>();
                    TRT_Iterator.this.filteredTRs.put(testFilter, vector);
                }
                try {
                    if (TRT_Iterator.this.currentResult.getDescription() != testDescription) {
                        throw new JavaTestError("TRT_Iterator observered TR.TD does not match filtered one.");
                    }
                }
                catch (TestResult.Fault fault) {
                    throw new JavaTestError("TRT_Iterator cannot determine TR source info.", fault);
                }
                vector.add(TRT_Iterator.this.currentResult);
            }
        }
    }

    private static class PseudoFrame {
        private int currIndex;
        private TestResultTable.TreeNode node;

        PseudoFrame(TestResultTable.TreeNode treeNode) {
            this.node = treeNode;
            this.currIndex = -1;
        }

        int nextIndex() {
            if (++this.currIndex < this.node.getChildCount()) {
                return this.currIndex;
            }
            return -1;
        }

        TestResultTable.TreeNode getNode() {
            return this.node;
        }

        int getCurrentIndex() {
            return this.currIndex;
        }
    }
}

