/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Command;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.ResourceTable;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import com.sun.javatest.util.Timer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Vector;

public abstract class Script {
    private static ResourceTable sourceTable = new ResourceTable();
    protected TestDescription td;
    protected String[] excludedTestCases;
    protected TestEnvironment env;
    protected String[] scriptArgs;
    protected WorkDirectory workDir;
    protected BackupPolicy backupPolicy = BackupPolicy.noBackups();
    protected ClassLoader loader;
    protected PrintWriter trOut;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$Script == null ? (class$com$sun$javatest$Script = Script.class$("com.sun.javatest.Script")) : class$com$sun$javatest$Script);
    protected static final Status error_badExecuteArgs = Status.error(i18n.getString("script.badExecuteArgs"));
    protected static final Status error_badTestClassDir = Status.error(i18n.getString("script.badTestClassDir"));
    protected static final Status error_compFailUnexp = Status.error(i18n.getString("script.compFailUnexp"));
    protected static final Status error_noActionSpecified = Status.error(i18n.getString("script.noAction"));
    protected static final Status error_noExecuteClass = Status.error(i18n.getString("script.noExecuteClass"));
    protected static final Status error_noExtnInSource = Status.error(i18n.getString("script.noExtnInSrc"));
    protected static final Status error_noRMIClasses = Status.error(i18n.getString("script.noRMIClasses"));
    protected static final Status error_noSource = Status.error(i18n.getString("script.noSource"));
    protected static final Status fail_compFailUnexp = Status.failed(i18n.getString("script.compFailUnexp"));
    protected static final Status fail_compSuccUnexp = Status.failed(i18n.getString("script.compSuccUnexp"));
    protected static final Status fail_execSuccUnexp = Status.failed(i18n.getString("script.execSuccUnexp"));
    protected static final Status pass_compFailExp = Status.passed(i18n.getString("script.compFailExp"));
    protected static final Status pass_compSuccExp = Status.passed(i18n.getString("script.compSuccExp"));
    protected static final Status pass_execFailExp = Status.passed(i18n.getString("script.execFailExp"));
    protected static final Status noSource = error_noSource;
    protected static final Status noExtnInSource = error_noExtnInSource;
    private static final String[] nullArgs = new String[0];
    private static final String DEFAULT_COMPILE_COMMAND = "compile";
    private static final String DEFAULT_EXECUTE_COMMAND = "execute";
    private static final String DEFAULT_RMIC_COMMAND = "rmic";
    private static final String defaultClassDir = "classes";
    private static String osInfo;
    protected static Timer alarmTimer;
    private TestResult testResult;
    private Alarm alarm;
    private boolean jtrIfPassed = System.getProperty("javatest.script.jtrIfPassed", "true").equals("true");
    private static boolean debugAlarm;
    static /* synthetic */ Class class$com$sun$javatest$Script;
    static /* synthetic */ Class class$com$sun$javatest$Command;

    public void initArgs(String[] stringArray) {
        this.scriptArgs = stringArray;
    }

    public void initTestDescription(TestDescription testDescription) {
        this.td = testDescription;
        this.testResult = new TestResult(testDescription);
        this.trOut = this.testResult.getTestCommentWriter();
    }

    public void initExcludedTestCases(String[] stringArray) {
        this.excludedTestCases = stringArray;
    }

    public void initTestEnvironment(TestEnvironment testEnvironment) {
        this.env = testEnvironment;
    }

    public void initWorkDir(WorkDirectory workDirectory) {
        this.workDir = workDirectory;
    }

    public void initBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public void initClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    protected void initDelegate(Script script, String[] stringArray) {
        script.scriptArgs = stringArray;
        script.td = this.td;
        script.env = this.env;
        script.workDir = this.workDir;
        script.backupPolicy = this.backupPolicy;
        script.loader = this.loader;
        script.testResult = this.testResult;
        script.trOut = this.trOut;
        script.jtrIfPassed = this.jtrIfPassed;
    }

    protected void initTestResult(TestResult testResult) {
        if (this.testResult != null) {
            throw new IllegalStateException();
        }
        this.testResult = testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        String string;
        if (this.workDir == null) {
            throw new NullPointerException(i18n.getString("script.noWorkDir"));
        }
        if (this.td == null) {
            throw new NullPointerException(i18n.getString("script.noTestDesc"));
        }
        if (this.testResult == null) {
            throw new NullPointerException(i18n.getString("script.noTestRslt"));
        }
        if (this.env == null) {
            throw new NullPointerException(i18n.getString("script.noTestEnv"));
        }
        Status status = null;
        File file = this.workDir.getFile(this.td.getRootRelativeDir().getPath());
        Class clazz = class$com$sun$javatest$Script == null ? (class$com$sun$javatest$Script = Script.class$("com.sun.javatest.Script")) : class$com$sun$javatest$Script;
        synchronized (clazz) {
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        String string2 = this.td.getFile().getPath().replace(File.separatorChar, '/');
        String string3 = string2.startsWith("/") ? "file://" : "file:///";
        String string4 = string3 + string2;
        String string5 = this.td.getId();
        if (string5 != null) {
            string4 = string4 + "#" + string5;
        }
        this.testResult.putProperty("description", string4);
        this.testResult.putProperty("start", new Date().toString());
        this.testResult.putProperty("javatestVersion", ProductInfo.getVersion());
        this.testResult.putProperty("work", file.getAbsolutePath());
        this.testResult.putProperty("environment", this.env.getName());
        if (osInfo == null) {
            string = System.getProperty("os.arch");
            object = System.getProperty("os.name");
            String string6 = System.getProperty("os.version");
            osInfo = (String)object + " " + string6 + " (" + string + ")";
        }
        this.testResult.putProperty("javatestOS", osInfo);
        if (this.excludedTestCases != null) {
            this.testResult.putProperty("excludedTestCases", StringArray.join(this.excludedTestCases));
        }
        object = (string = this.td.getParameter("classDir")) == null ? this.workDir.getFile(defaultClassDir) : new File(file, string);
        this.env.putUrlAndFile("testClassDir", (File)object, true);
        this.env.putUrlAndFile("testWorkDir", file, true);
        this.env.put("test", this.td.getFile().getPath());
        this.env.put("testDir", this.td.getFile().getParent());
        this.env.put("testURL", string4);
        this.env.put("testPath", this.td.getRootRelativeURL());
        int n = this.getTestTimeout();
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        try {
            this.testResult.putProperty("test", this.td.getRootRelativeURL());
            this.testResult.putProperty("script", this.getClass().getName() + " " + StringArray.join(this.scriptArgs));
            if (n > 0) {
                this.testResult.putProperty("timeoutSeconds", Integer.toString(n));
                this.setAlarm(n * 1000);
            }
            status = this.run(this.scriptArgs, this.td, this.env);
        }
        finally {
            if (n > 0) {
                this.setAlarm(0);
            }
            try {
                System.setOut(System.out);
                System.setErr(System.err);
            }
            catch (SecurityException securityException) {}
            if (Thread.interrupted()) {
                status = Status.error(i18n.getString("script.interrupted"));
            }
            this.testResult.putProperty("end", new Date().toString());
            if (status == null) {
                status = Status.error(i18n.getString("script.noStatus"));
            } else {
                switch (status.getType()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        status = Status.error(i18n.getString("script.badTestStatus", status));
                    }
                }
            }
        }
        this.testResult.setEnvironment(this.env);
        this.testResult.setStatus(status);
        try {
            if (status.getType() != 0 || this.jtrIfPassed) {
                this.testResult.writeResults(this.workDir, this.backupPolicy);
            }
        }
        catch (IOException iOException) {}
    }

    public abstract Status run(String[] var1, TestDescription var2, TestEnvironment var3);

    public TestDescription getTestDescription() {
        return this.td;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public boolean getJTRIfPassed() {
        return this.jtrIfPassed;
    }

    public void setJTRIfPassed(boolean bl) {
        this.jtrIfPassed = bl;
    }

    protected void setAlarm(int n) {
        if (this.alarm != null) {
            this.alarm.cancel();
            this.alarm = null;
        }
        if (n > 0) {
            this.alarm = new Alarm(n);
        }
    }

    protected void setAlarm(int n, Thread thread) {
        if (this.alarm != null) {
            this.alarm.cancel();
            this.alarm = null;
        }
        if (n > 0) {
            this.alarm = new Alarm(n, thread);
        }
    }

    protected int getTestTimeout() {
        float f;
        block5: {
            f = 1.0f;
            try {
                String[] stringArray = this.env.lookup("javatestTimeoutFactor");
                if (stringArray == null) break block5;
                if (stringArray.length == 1) {
                    f = Float.parseFloat(stringArray[0]);
                } else if (stringArray.length == 2) {
                    f = Float.parseFloat(stringArray[1]);
                }
            }
            catch (TestEnvironment.Fault fault) {}
        }
        return (int)(600.0f * f);
    }

    protected Status compileIndividually(String[] stringArray) {
        return this.compileIndividually(DEFAULT_COMPILE_COMMAND, stringArray);
    }

    protected Status compileIndividually(String string, String[] stringArray) {
        if (stringArray.length == 0) {
            return error_noSource;
        }
        int n = 0;
        while (n < stringArray.length) {
            Status status = this.compileOne(string, stringArray[n]);
            if (!status.isPassed()) {
                return status;
            }
            ++n;
        }
        return pass_compSuccExp;
    }

    protected Status compileIndividually(File[] fileArray) {
        return this.compileIndividually(DEFAULT_COMPILE_COMMAND, Script.filesToStrings(fileArray));
    }

    protected Status compileIndividually(String string, File[] fileArray) {
        return this.compileIndividually(string, Script.filesToStrings(fileArray));
    }

    protected Status compileOne(String string) {
        return this.compileOne(DEFAULT_COMPILE_COMMAND, string);
    }

    protected Status compileOne(String string, String string2) {
        return this.compileTogether(string, new String[]{string2});
    }

    protected Status compileOne(File file) {
        return this.compileOne(DEFAULT_COMPILE_COMMAND, file.getPath());
    }

    protected Status compileOne(String string, File file) {
        return this.compileOne(string, file.getPath());
    }

    protected Status compileTogether(String[] stringArray) {
        return this.compileTogether(DEFAULT_COMPILE_COMMAND, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status compileTogether(String string, String[] stringArray) {
        String string2;
        block11: {
            Object object;
            if (stringArray.length == 0) {
                return error_noSource;
            }
            try {
                object = this.env.lookup("testClassDir");
                if (object == null || ((String[])object).length != 1) {
                    return error_badTestClassDir;
                }
                File file = new File(object[0]);
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            catch (TestEnvironment.Fault fault) {
                return error_badTestClassDir;
            }
            object = stringArray[0];
            int n = ((String)object).lastIndexOf(46);
            if (n == -1) {
                return error_noExtnInSource;
            }
            string2 = ((String)object).substring(n);
            this.env.put("testSource", stringArray);
            boolean bl = sourceTable.acquire(stringArray, 600000);
            if (bl) break block11;
            Status status = Status.error(i18n.getString("script.srcLockTimeout"));
            Object var10_12 = null;
            sourceTable.release(stringArray);
            return status;
        }
        try {
            Status status = this.invokeCommand(string + string2);
            Object var10_13 = null;
            sourceTable.release(stringArray);
            return status;
        }
        catch (InterruptedException interruptedException) {
            try {
                Status status = Status.error(i18n.getString("script.srcLockInterrupted"));
                Object var10_14 = null;
                sourceTable.release(stringArray);
                return status;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                sourceTable.release(stringArray);
                throw throwable;
            }
        }
    }

    protected Status compileTogether(File[] fileArray) {
        return this.compileTogether(DEFAULT_COMPILE_COMMAND, Script.filesToStrings(fileArray));
    }

    protected Status compileTogether(String string, File[] fileArray) {
        return this.compileTogether(string, Script.filesToStrings(fileArray));
    }

    protected Status compileIfNecessary(String[] stringArray, String string) {
        return this.compileIfNecessary(DEFAULT_COMPILE_COMMAND, stringArray, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Status compileIfNecessary(String var1_1, String[] var2_2, String var3_3) {
        if (var2_2.length == 0) {
            return Script.error_noSource;
        }
        if (var3_3 == null) {
            var3_3 = "$testClassDir";
        }
        if (var3_3.startsWith("$")) {
            try {
                var4_4 = this.env.resolve(var3_3);
                if (var4_4 == null) return Script.error_badTestClassDir;
                if (var4_4.length != 1) {
                    return Script.error_badTestClassDir;
                }
                var3_3 = var4_4[0];
            }
            catch (TestEnvironment.Fault var4_5) {
                return Script.error_badTestClassDir;
            }
        }
        if (!(var4_4 = new File(var3_3)).exists()) {
            var4_4.mkdirs();
        }
        var5_6 = new Vector<Object[]>(0, var2_2.length);
        var6_7 = 0;
        while (true) {
            block25: {
                block24: {
                    block26: {
                        if (var6_7 >= var2_2.length) {
                            if (var5_6.size() <= 0) return Status.passed(Script.i18n.getString("script.allUpToDate"));
                            var7_8 = new String[var5_6.size()];
                            var5_6.copyInto(var7_8);
                            return this.compileTogether(var1_1, (String[])var7_8);
                        }
                        var9_10 = (var7_8 = var2_2[var6_7]).indexOf(46, (var8_9 = var7_8.lastIndexOf(File.separatorChar)) + 1);
                        var10_11 = var7_8.substring(var8_9 + 1, var9_10 == -1 ? var7_8.length() : var9_10);
                        var12_13 = null;
                        try {
                            try {
                                var12_13 = new BufferedReader(new FileReader((String)var7_8));
                                var13_14 = new StreamTokenizer(var12_13);
                                var13_14.ordinaryChar(47);
                                var13_14.slashStarComments(true);
                                var13_14.slashSlashComments(true);
                                var13_14.wordChars(46, 46);
                                var14_16 = var13_14.nextToken();
                                if (var14_16 == -3 && var13_14.sval.equals("package")) {
                                    var14_16 = var13_14.nextToken();
                                    if (var14_16 == -3) {
                                        var11_12 = var13_14.sval.replace('.', File.separatorChar) + File.separatorChar;
                                        break block24;
                                    }
                                    this.trOut.println(Script.i18n.getString("script.badPackage"));
                                    var5_6.addElement(var7_8);
                                    var16_18 = null;
                                    if (var12_13 == null) break block25;
                                    break block26;
                                }
                                var11_12 = "";
                                break block24;
                            }
                            catch (IOException var13_15) {
                                this.trOut.println(Script.i18n.getString("script.badDateStamp", new Object[]{var7_8, var13_15}));
                                var5_6.addElement(var7_8);
                                var16_18 = null;
                                if (var12_13 != null) {
                                    try {
                                        var12_13.close();
                                    }
                                    catch (IOException var17_19) {}
                                }
                                break block25;
                            }
                        }
                        catch (Throwable var15_20) {
                            var16_18 = null;
                            if (var12_13 == null) throw var15_20;
                            ** try [egrp 3[TRYBLOCK] [8 : 398->406)] { 
lbl67:
                            // 1 sources

                            var12_13.close();
                            throw var15_20;
lbl69:
                            // 1 sources

                            catch (IOException var17_19) {
                                // empty catch block
                            }
                            throw var15_20;
                        }
                    }
                    try {}
                    catch (IOException var17_19) {}
                    var12_13.close();
                    break block25;
                }
                var16_18 = null;
                if (var12_13 != null) {
                    try {}
                    catch (IOException var17_19) {}
                    var12_13.close();
                }
                var13_14 = new File((String)var7_8);
                var14_17 = new File(var3_3, var11_12 + var10_11 + ".class");
                if (var14_17.exists() && var14_17.lastModified() > var13_14.lastModified()) {
                    this.trOut.println(Script.i18n.getString("script.upToDate", (Object)var7_8));
                } else {
                    var5_6.addElement(var7_8);
                }
            }
            ++var6_7;
        }
    }

    protected Status compileIfNecessary(File[] fileArray, String string) {
        return this.compileIfNecessary(DEFAULT_COMPILE_COMMAND, Script.filesToStrings(fileArray), string);
    }

    protected Status compileIfNecessary(String string, File[] fileArray, String string2) {
        return this.compileIfNecessary(string, Script.filesToStrings(fileArray), string2);
    }

    protected Status execute(String string, String string2) {
        return this.execute(DEFAULT_EXECUTE_COMMAND, string, string2);
    }

    protected Status execute(String string, String string2, String string3) {
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = string3 == null ? nullArgs : this.env.resolve(string3);
            if (this.excludedTestCases != null) {
                stringArray = this.exclude(stringArray, this.excludedTestCases);
            }
            return this.execute(string, string2, stringArray);
        }
        catch (TestEnvironment.Fault fault) {
            this.trOut.println(i18n.getString("script.testEnvFault", new Object[]{string3, fault.toString()}));
            return error_badExecuteArgs;
        }
    }

    protected Status execute(String string, String[] stringArray) {
        return this.execute(DEFAULT_EXECUTE_COMMAND, string, stringArray);
    }

    protected Status execute(String string, String string2, String[] stringArray) {
        if (string2 == null || string2.length() == 0) {
            return error_noExecuteClass;
        }
        this.env.put("testExecuteClass", string2);
        this.env.put("testExecuteArgs", stringArray);
        return this.invokeCommand(string);
    }

    protected Status rmiCompile(String[] stringArray) {
        return this.rmiCompile(DEFAULT_RMIC_COMMAND, stringArray);
    }

    protected Status rmiCompile(String string, String[] stringArray) {
        try {
            String[] stringArray2 = this.env.lookup("testClassDir");
            if (stringArray2 == null || stringArray2.length != 1) {
                return error_badTestClassDir;
            }
            File file = new File(stringArray2[0]);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (TestEnvironment.Fault fault) {
            return error_badTestClassDir;
        }
        if (stringArray == null || stringArray.length == 0) {
            return error_noRMIClasses;
        }
        this.env.put("testRmicClasses", stringArray);
        this.env.put("testRmicClass", stringArray);
        return this.invokeCommand(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status invokeCommand(String string) {
        Status status = null;
        try {
            String[] stringArray = this.env.lookup("command." + string);
            if (stringArray.length == 0) {
                return Status.error(i18n.getString("script.noCommand", new Object[]{this.env.getName(), string}));
            }
            String string2 = stringArray[0];
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            TestResult.Section section = this.testResult.createSection(string);
            section.getMessageWriter().println(i18n.getString("script.command", new Object[]{string2, StringArray.join(stringArray2)}));
            PrintWriter printWriter = null;
            PrintWriter printWriter2 = null;
            try {
                printWriter = section.createOutput("ref");
                printWriter2 = section.createOutput("log");
                status = this.invokeClass(string2, stringArray2, printWriter2, printWriter);
                printWriter2.close();
                printWriter.close();
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (printWriter2 != null) {
                    printWriter2.close();
                }
            }
            section.setStatus(status);
            return status;
        }
        catch (TestEnvironment.Fault fault) {
            return Status.error(i18n.getString("script.badCommand", new Object[]{this.env.getName(), string}));
        }
    }

    private Status invokeClass(String string, String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        Command command;
        try {
            Class<?> clazz = this.loader == null ? Class.forName(string) : this.loader.loadClass(string);
            command = (Command)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            return Status.error(i18n.getString("script.cantRunClass", new Object[]{string, (class$com$sun$javatest$Command == null ? (class$com$sun$javatest$Command = Script.class$("com.sun.javatest.Command")) : class$com$sun$javatest$Command).getName()}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Status.error(i18n.getString("script.cantFindClass", new Object[]{string, this.env.getName()}));
        }
        catch (IllegalAccessException illegalAccessException) {
            return Status.error(i18n.getString("script.cantAccessClass", new Object[]{string, this.env.getName()}));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Status.error(i18n.getString("script.badClassName", new Object[]{string, this.env.getName()}));
        }
        catch (InstantiationException instantiationException) {
            return Status.error(i18n.getString("script.cantCreateClass", new Object[]{string, this.env.getName()}));
        }
        catch (ThreadDeath threadDeath) {
            throw (ThreadDeath)threadDeath.fillInStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            return Status.error(i18n.getString("script.unexpLoadExc", new Object[]{string, exception}));
        }
        catch (Error error) {
            error.printStackTrace(printWriter);
            return Status.error(i18n.getString("script.unexpLoadErr", new Object[]{string, error}));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printWriter);
            return Status.error(i18n.getString("script.unexpLoadThr", new Object[]{string, throwable}));
        }
        try {
            command.setClassLoader(this.loader);
            return command.run(stringArray, printWriter, printWriter2);
        }
        catch (ThreadDeath threadDeath) {
            throw (ThreadDeath)threadDeath.fillInStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            return Status.failed(i18n.getString("script.unexpExecExc", new Object[]{string, exception}));
        }
        catch (Error error) {
            error.printStackTrace(printWriter);
            return Status.failed(i18n.getString("script.unexpExecErr", new Object[]{string, error}));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printWriter);
            return Status.error(i18n.getString("script.unexpExecThr", new Object[]{string, throwable}));
        }
    }

    protected String[] exclude(String[] stringArray, String[] stringArray2) {
        if (stringArray2 == null) {
            return stringArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray2.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray2[n]);
            ++n;
        }
        String[] stringArray3 = new String[stringArray.length + 2];
        stringArray3[0] = "-exclude";
        stringArray3[1] = stringBuffer.toString();
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        this.testResult.putProperty("exclude", stringArray3[1]);
        return stringArray3;
    }

    protected static String[] filesToStrings(File[] fileArray) {
        String[] stringArray = new String[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            stringArray[n] = fileArray[n].getPath();
            ++n;
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        alarmTimer = new Timer();
        debugAlarm = Boolean.getBoolean("debug.com.sun.javatest.Script.Alarm");
    }

    private class Alarm
    implements Timer.Timeable {
        private int delay;
        private Thread threadToInterrupt;
        private int count;
        private Timer.Entry entry;

        Alarm(int n) {
            this(n, Thread.currentThread());
        }

        Alarm(int n, Thread thread) {
            if (thread == null) {
                throw new NullPointerException();
            }
            this.delay = n;
            this.threadToInterrupt = thread;
            this.entry = alarmTimer.requestDelayedCallback(this, n);
            if (debugAlarm) {
                System.err.println(i18n.getString("script.alarm.started", this));
            }
        }

        synchronized void cancel() {
            if (debugAlarm) {
                System.err.println(i18n.getString("script.alarm.cancelled", this));
            }
            alarmTimer.cancel(this.entry);
        }

        public synchronized void timeout() {
            if (this.count == 0) {
                Script.this.trOut.println(i18n.getString("script.timeout", new Float((float)this.delay / 1000.0f)));
            } else if (this.count % 100 == 0) {
                Script.this.trOut.println(i18n.getString("script.notResponding", new Integer(this.count)));
                if (this.count % 1000 == 0) {
                    System.err.println(i18n.getString("script.timedOut", new Object[]{Script.this.td.getRootRelativeURL(), new Integer(this.count)}));
                }
            }
            if (debugAlarm) {
                System.err.println(i18n.getString("script.alarm.interrupt", new Object[]{this, this.threadToInterrupt}));
            }
            this.threadToInterrupt.interrupt();
            ++this.count;
            this.entry = alarmTimer.requestDelayedCallback(this, 100L);
        }
    }
}

