/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class InterviewParameters
extends Interview
implements Parameters {
    private ExcludeListFilter cachedExcludeListFilter;
    private KeywordsFilter cachedKeywordsFilter;
    private StatusFilter cachedStatusFilter;
    private TestFilter cachedRelevantTestFilter;
    private TestSuite cachedRelevantTestFilterTestSuite;
    private TestEnvironment cachedRelevantTestFilterEnv;
    private TestFilter[] cachedTestFilters;
    private WorkDirectory workDir;
    private BackupPolicy backupPolicy;
    private File currFile;
    private long currFileLastModified;
    private boolean currFileLoaded;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$InterviewParameters == null ? (class$com$sun$javatest$InterviewParameters = InterviewParameters.class$("com.sun.javatest.InterviewParameters")) : class$com$sun$javatest$InterviewParameters);
    static /* synthetic */ Class class$com$sun$javatest$InterviewParameters;

    protected InterviewParameters(String string) {
        super(string);
    }

    public abstract void setWorkDirectory(WorkDirectory var1);

    public void init(String[] stringArray) throws Interview.Fault {
        if (stringArray != null && stringArray.length > 0) {
            throw new Interview.Fault(i18n, "ip.unknownArgs");
        }
    }

    protected Question getPrologSuccessorQuestion() {
        return this.getEnvFirstQuestion();
    }

    public TestEnvironment getEnv() {
        Parameters.EnvParameters envParameters = this.getEnvParameters();
        if (envParameters == null) {
            throw new NullPointerException();
        }
        return envParameters.getEnv();
    }

    protected abstract Question getEnvFirstQuestion();

    protected Question getEnvSuccessorQuestion() {
        return this.getTestsFirstQuestion();
    }

    public String[] getTests() {
        Parameters.TestsParameters testsParameters = this.getTestsParameters();
        return testsParameters == null ? null : testsParameters.getTests();
    }

    protected abstract Question getTestsFirstQuestion();

    protected Question getTestsSuccessorQuestion() {
        return this.getExcludeListFirstQuestion();
    }

    public ExcludeList getExcludeList() {
        Parameters.ExcludeListParameters excludeListParameters = this.getExcludeListParameters();
        return excludeListParameters == null ? new ExcludeList() : excludeListParameters.getExcludeList();
    }

    protected abstract Question getExcludeListFirstQuestion();

    protected Question getExcludeTableFirstQuestion() {
        return this.getExcludeListFirstQuestion();
    }

    protected Question getExcludeListSuccessorQuestion() {
        return this.getKeywordsFirstQuestion();
    }

    protected Question getExcludeTableSuccessorQuestion() {
        return this.getExcludeListSuccessorQuestion();
    }

    public Keywords getKeywords() {
        Parameters.KeywordsParameters keywordsParameters = this.getKeywordsParameters();
        return keywordsParameters == null ? null : keywordsParameters.getKeywords();
    }

    protected abstract Question getKeywordsFirstQuestion();

    protected Question getKeywordsSuccessorQuestion() {
        return this.getPriorStatusFirstQuestion();
    }

    public boolean[] getPriorStatusValues() {
        Parameters.PriorStatusParameters priorStatusParameters = this.getPriorStatusParameters();
        return priorStatusParameters == null ? null : priorStatusParameters.getPriorStatusValues();
    }

    protected abstract Question getPriorStatusFirstQuestion();

    protected Question getPriorStatusSuccessorQuestion() {
        return this.getConcurrencyFirstQuestion();
    }

    public int getConcurrency() {
        Parameters.ConcurrencyParameters concurrencyParameters = this.getConcurrencyParameters();
        return concurrencyParameters == null ? 1 : concurrencyParameters.getConcurrency();
    }

    protected abstract Question getConcurrencyFirstQuestion();

    protected Question getConcurrencySuccessorQuestion() {
        return this.getTimeoutFactorFirstQuestion();
    }

    public float getTimeoutFactor() {
        Parameters.TimeoutFactorParameters timeoutFactorParameters = this.getTimeoutFactorParameters();
        return timeoutFactorParameters == null ? 1.0f : timeoutFactorParameters.getTimeoutFactor();
    }

    protected abstract Question getTimeoutFactorFirstQuestion();

    protected Question getTimeoutFactorSuccessorQuestion() {
        return this.getEpilogFirstQuestion();
    }

    protected abstract Question getEpilogFirstQuestion();

    public boolean isValid() {
        return this.isFinishable();
    }

    public String getErrorMessage() {
        Question[] questionArray = this.getPath();
        Question question = questionArray[questionArray.length - 1];
        if (question instanceof FinalQuestion) {
            return null;
        }
        if (question instanceof ErrorQuestion) {
            return question.getText();
        }
        return i18n.getString("ip.noAnswer", new Object[]{question.getSummary(), question.getText(), question.getKey()});
    }

    public TestFilter getExcludeTableFilter() {
        return this.getExcludeListFilter();
    }

    public TestFilter getExcludeListFilter() {
        ExcludeList excludeList = this.getExcludeList();
        if (excludeList == null) {
            this.cachedExcludeListFilter = null;
        } else if (this.cachedExcludeListFilter == null || this.cachedExcludeListFilter.getExcludeList() != excludeList) {
            this.cachedExcludeListFilter = new ExcludeListFilter(excludeList);
        }
        return this.cachedExcludeListFilter;
    }

    public TestFilter getKeywordsFilter() {
        Keywords keywords = this.getKeywords();
        if (keywords == null) {
            this.cachedKeywordsFilter = null;
        } else if (this.cachedKeywordsFilter == null || this.cachedKeywordsFilter.getKeywords() != keywords) {
            this.cachedKeywordsFilter = new KeywordsFilter(keywords);
        }
        return this.cachedKeywordsFilter;
    }

    public TestFilter getPriorStatusFilter() {
        WorkDirectory workDirectory = this.getWorkDirectory();
        TestResultTable testResultTable = workDirectory == null ? null : workDirectory.getTestResultTable();
        boolean[] blArray = this.getPriorStatusValues();
        if (testResultTable == null || blArray == null) {
            this.cachedStatusFilter = null;
        } else if (this.cachedStatusFilter == null || this.cachedStatusFilter.getTestResultTable() != testResultTable || !InterviewParameters.equal(this.cachedStatusFilter.getStatusValues(), blArray)) {
            this.cachedStatusFilter = new StatusFilter(blArray, testResultTable);
        }
        return this.cachedStatusFilter;
    }

    public TestFilter getRelevantTestFilter() {
        TestSuite testSuite = this.getTestSuite();
        TestEnvironment testEnvironment = this.getEnv();
        if (testSuite == null || testEnvironment == null) {
            this.cachedRelevantTestFilter = null;
        } else if (this.cachedRelevantTestFilter == null || testSuite != this.cachedRelevantTestFilterTestSuite || testEnvironment != this.cachedRelevantTestFilterEnv) {
            this.cachedRelevantTestFilter = testSuite.createTestFilter(testEnvironment);
        }
        return this.cachedRelevantTestFilter;
    }

    public synchronized TestFilter[] getFilters() {
        TestFilter testFilter;
        TestFilter testFilter2;
        TestFilter testFilter3;
        Vector<TestFilter> vector = new Vector<TestFilter>();
        TestFilter testFilter4 = this.getExcludeListFilter();
        if (testFilter4 != null) {
            vector.addElement(testFilter4);
        }
        if ((testFilter3 = this.getKeywordsFilter()) != null) {
            vector.addElement(testFilter3);
        }
        if ((testFilter2 = this.getPriorStatusFilter()) != null) {
            vector.addElement(testFilter2);
        }
        if ((testFilter = this.getRelevantTestFilter()) != null) {
            vector.addElement(testFilter);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (InterviewParameters.equal(vector, this.cachedTestFilters)) {
            return this.cachedTestFilters;
        }
        Object[] objectArray = new TestFilter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static boolean equal(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null || blArray2 == null) {
            return blArray == blArray2;
        }
        if (blArray.length != blArray2.length) {
            return false;
        }
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n] != blArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean equal(Vector vector, TestFilter[] testFilterArray) {
        if (testFilterArray == null || vector.size() != testFilterArray.length) {
            return false;
        }
        int n = 0;
        while (n < vector.size()) {
            if (!vector.elementAt(n).equals(testFilterArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public File getFile() {
        return this.currFile;
    }

    public void setFile(File file) {
        this.currFile = file;
        this.currFileLoaded = false;
        this.currFileLastModified = 0L;
    }

    public static boolean isInterviewFile(File file) {
        return file.getName().endsWith(".jti");
    }

    public static InterviewParameters open(File file) throws IOException, Interview.Fault {
        return InterviewParameters.open(file, null, null);
    }

    public static InterviewParameters open(File file, TestSuite testSuite) throws IOException, Interview.Fault {
        return InterviewParameters.open(file, testSuite, null);
    }

    public static InterviewParameters open(File file, WorkDirectory workDirectory) throws IOException, Interview.Fault {
        return InterviewParameters.open(file, workDirectory.getTestSuite(), workDirectory);
    }

    private static InterviewParameters open(File file, TestSuite testSuite, WorkDirectory workDirectory) throws IOException, Interview.Fault {
        Object object;
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            try {
                properties.load(bufferedInputStream);
            }
            catch (RuntimeException runtimeException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.errorReadingFile", new Object[]{file, runtimeException});
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        if (testSuite == null) {
            object = (String)properties.get("TESTSUITE");
            if (object == null) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.noTestSuiteInFile", file);
            }
            try {
                testSuite = TestSuite.open(new File((String)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindTestSuiteInFile", new Object[]{object, file});
            }
            catch (TestSuite.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuiteInFile", new Object[]{object, file, fault.getMessage()});
            }
        }
        if (workDirectory == null) {
            object = (String)properties.get("WORKDIR");
            if (object == null) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.noWorkDirInFile", file);
            }
            try {
                workDirectory = WorkDirectory.open(new File((String)object), testSuite);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindWorkDirInFile", new Object[]{object, file});
            }
            catch (WorkDirectory.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDirInFile", new Object[]{object, file, fault.getMessage()});
            }
        }
        try {
            object = testSuite.createInterview();
        }
        catch (TestSuite.Fault fault) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantCreateInterviewForTestSuite", new Object[]{testSuite.getPath(), fault.getMessage()});
        }
        ((InterviewParameters)object).setWorkDirectory(workDirectory);
        try {
            ((InterviewParameters)object).load((Map)properties, file);
        }
        catch (Interview.Fault fault) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantLoadInterview", new Object[]{file, fault.getMessage()});
        }
        return object;
    }

    public void clear() {
        super.clear();
        this.setEdited(false);
        this.currFile = null;
    }

    public static InterviewParameters open(String string, String string2, String string3) throws Interview.Fault {
        Object object;
        TestSuite testSuite;
        Object object2;
        if (string != null && string.length() > 0) {
            try {
                object2 = new File(string);
                testSuite = TestSuite.open((File)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindTestSuite", string);
            }
            catch (IOException iOException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuite", new Object[]{string, iOException});
            }
            catch (TestSuite.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuite", new Object[]{string, fault.getMessage()});
            }
        } else {
            testSuite = null;
        }
        if (string2 != null && string2.length() > 0) {
            try {
                object = new File(string2);
                if (testSuite != null) {
                    object2 = WorkDirectory.open((File)object, testSuite);
                }
                object2 = WorkDirectory.open((File)object);
                testSuite = ((WorkDirectory)object2).getTestSuite();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindWorkDir", string2);
            }
            catch (IOException iOException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDir", new Object[]{string2, iOException});
            }
            catch (WorkDirectory.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDir", new Object[]{string2, fault.getMessage()});
            }
        } else {
            object2 = null;
        }
        if (string3 != null && string3.length() > 0) {
            try {
                File file = new File(string3);
                if (object2 == null) {
                    if (testSuite == null) {
                        object = InterviewParameters.open(file);
                        testSuite = object.getTestSuite();
                    } else {
                        object = InterviewParameters.open(file, testSuite);
                    }
                    object2 = object.getWorkDirectory();
                }
                object = InterviewParameters.open(file, (WorkDirectory)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindConfigFile", string3);
            }
            catch (IOException iOException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenConfigFile", new Object[]{string3, iOException});
            }
        } else if (testSuite != null) {
            try {
                object = testSuite.createInterview();
            }
            catch (TestSuite.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantCreateInterviewForTestSuite", new Object[]{string, fault});
            }
            if (object2 != null) {
                ((InterviewParameters)object).setWorkDirectory((WorkDirectory)object2);
            }
        } else {
            object = null;
        }
        return object;
    }

    public void load() throws IOException, Interview.Fault {
        File file = this.getFile();
        if (file != null && file.exists()) {
            this.load(file);
        } else {
            this.clear();
            this.setEdited(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws FileNotFoundException, IOException, Interview.Fault {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            this.load((Map)properties, file);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
    }

    public void load(Map map, File file) throws Interview.Fault {
        this.load(map);
        this.setEdited(false);
        this.currFile = file;
        this.currFileLastModified = file.lastModified();
        this.currFileLoaded = true;
    }

    public void load(Parameters parameters) {
        this.loadTestsParameters(parameters.getTestsParameters());
        this.loadExcludeListParameters(parameters.getExcludeListParameters());
        this.loadKeywordsParameters(parameters.getKeywordsParameters());
        this.loadPriorStatusParameters(parameters.getPriorStatusParameters());
        this.loadEnvParameters(parameters.getEnvParameters());
        this.loadConcurrencyParameters(parameters.getConcurrencyParameters());
        this.loadTimeoutFactorParameters(parameters.getTimeoutFactorParameters());
    }

    private void loadTestsParameters(Parameters.TestsParameters testsParameters) {
        Parameters.TestsParameters testsParameters2 = this.getTestsParameters();
        if (!(testsParameters2 instanceof Parameters.MutableTestsParameters)) {
            return;
        }
        Parameters.MutableTestsParameters mutableTestsParameters = (Parameters.MutableTestsParameters)testsParameters2;
        if (testsParameters instanceof Parameters.MutableTestsParameters) {
            Parameters.MutableTestsParameters mutableTestsParameters2 = (Parameters.MutableTestsParameters)testsParameters;
            mutableTestsParameters.setTestsMode(mutableTestsParameters2.getTestsMode());
            mutableTestsParameters.setSpecifiedTests(mutableTestsParameters2.getSpecifiedTests());
        } else {
            String[] stringArray = testsParameters.getTests();
            if (stringArray == null) {
                mutableTestsParameters.setTestsMode(1);
                mutableTestsParameters.setSpecifiedTests(null);
            } else {
                mutableTestsParameters.setTestsMode(2);
                mutableTestsParameters.setSpecifiedTests(stringArray);
            }
        }
    }

    private void loadExcludeListParameters(Parameters.ExcludeListParameters excludeListParameters) {
        Parameters.ExcludeListParameters excludeListParameters2 = this.getExcludeListParameters();
        if (!(excludeListParameters2 instanceof Parameters.MutableExcludeListParameters)) {
            return;
        }
        Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)excludeListParameters2;
        if (excludeListParameters instanceof Parameters.MutableExcludeListParameters) {
            Parameters.MutableExcludeListParameters mutableExcludeListParameters2 = (Parameters.MutableExcludeListParameters)excludeListParameters;
            mutableExcludeListParameters.setExcludeMode(mutableExcludeListParameters2.getExcludeMode());
            mutableExcludeListParameters.setCustomExcludeFiles(mutableExcludeListParameters2.getCustomExcludeFiles());
            mutableExcludeListParameters.setLatestExcludeAutoCheckEnabled(mutableExcludeListParameters2.isLatestExcludeAutoCheckEnabled());
            mutableExcludeListParameters.setLatestExcludeAutoCheckMode(mutableExcludeListParameters2.getLatestExcludeAutoCheckMode());
            mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(mutableExcludeListParameters2.getLatestExcludeAutoCheckInterval());
        } else {
            mutableExcludeListParameters.setExcludeMode(4);
            mutableExcludeListParameters.setCustomExcludeFiles(null);
            mutableExcludeListParameters.setLatestExcludeAutoCheckEnabled(false);
            mutableExcludeListParameters.setLatestExcludeAutoCheckMode(1);
            mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(0);
        }
    }

    private void loadKeywordsParameters(Parameters.KeywordsParameters keywordsParameters) {
        Parameters.KeywordsParameters keywordsParameters2 = this.getKeywordsParameters();
        if (!(keywordsParameters2 instanceof Parameters.MutableKeywordsParameters)) {
            return;
        }
        Parameters.MutableKeywordsParameters mutableKeywordsParameters = (Parameters.MutableKeywordsParameters)keywordsParameters2;
        if (keywordsParameters instanceof Parameters.MutableKeywordsParameters) {
            Parameters.MutableKeywordsParameters mutableKeywordsParameters2 = (Parameters.MutableKeywordsParameters)keywordsParameters;
            mutableKeywordsParameters.setKeywordsMode(mutableKeywordsParameters2.getKeywordsMode());
            mutableKeywordsParameters.setMatchKeywords(mutableKeywordsParameters2.getMatchKeywordsMode(), mutableKeywordsParameters2.getMatchKeywordsValue());
        } else {
            Keywords keywords = keywordsParameters.getKeywords();
            if (keywords == null) {
                mutableKeywordsParameters.setKeywordsMode(1);
                mutableKeywordsParameters.setMatchKeywords(3, "");
            } else {
                mutableKeywordsParameters.setKeywordsMode(2);
                mutableKeywordsParameters.setMatchKeywords(3, keywords.toString());
            }
        }
    }

    private void loadPriorStatusParameters(Parameters.PriorStatusParameters priorStatusParameters) {
        Parameters.PriorStatusParameters priorStatusParameters2 = this.getPriorStatusParameters();
        if (!(priorStatusParameters2 instanceof Parameters.MutablePriorStatusParameters)) {
            return;
        }
        Parameters.MutablePriorStatusParameters mutablePriorStatusParameters = (Parameters.MutablePriorStatusParameters)priorStatusParameters2;
        if (priorStatusParameters instanceof Parameters.MutablePriorStatusParameters) {
            Parameters.MutablePriorStatusParameters mutablePriorStatusParameters2 = (Parameters.MutablePriorStatusParameters)priorStatusParameters;
            mutablePriorStatusParameters.setPriorStatusMode(mutablePriorStatusParameters2.getPriorStatusMode());
            mutablePriorStatusParameters.setMatchPriorStatusValues(mutablePriorStatusParameters2.getMatchPriorStatusValues());
        } else {
            boolean[] blArray = priorStatusParameters.getPriorStatusValues();
            if (blArray == null) {
                mutablePriorStatusParameters.setPriorStatusMode(1);
                mutablePriorStatusParameters.setMatchPriorStatusValues(new boolean[4]);
            } else {
                mutablePriorStatusParameters.setPriorStatusMode(2);
                mutablePriorStatusParameters.setMatchPriorStatusValues(blArray);
            }
        }
    }

    private void loadEnvParameters(Parameters.EnvParameters envParameters) {
        Parameters.EnvParameters envParameters2 = this.getEnvParameters();
        if (!(envParameters2 instanceof Parameters.LegacyEnvParameters)) {
            return;
        }
        Parameters.LegacyEnvParameters legacyEnvParameters = (Parameters.LegacyEnvParameters)envParameters2;
        if (envParameters instanceof Parameters.LegacyEnvParameters) {
            Parameters.LegacyEnvParameters legacyEnvParameters2 = (Parameters.LegacyEnvParameters)envParameters;
            legacyEnvParameters.setEnvFiles(legacyEnvParameters2.getEnvFiles());
            legacyEnvParameters.setEnvName(legacyEnvParameters2.getEnvName());
        }
    }

    private void loadConcurrencyParameters(Parameters.ConcurrencyParameters concurrencyParameters) {
        Parameters.ConcurrencyParameters concurrencyParameters2 = this.getConcurrencyParameters();
        if (!(concurrencyParameters2 instanceof Parameters.MutableConcurrencyParameters)) {
            return;
        }
        Parameters.MutableConcurrencyParameters mutableConcurrencyParameters = (Parameters.MutableConcurrencyParameters)concurrencyParameters2;
        mutableConcurrencyParameters.setConcurrency(concurrencyParameters.getConcurrency());
    }

    private void loadTimeoutFactorParameters(Parameters.TimeoutFactorParameters timeoutFactorParameters) {
        Parameters.TimeoutFactorParameters timeoutFactorParameters2 = this.getTimeoutFactorParameters();
        if (!(timeoutFactorParameters2 instanceof Parameters.MutableTimeoutFactorParameters)) {
            return;
        }
        Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters = (Parameters.MutableTimeoutFactorParameters)timeoutFactorParameters2;
        mutableTimeoutFactorParameters.setTimeoutFactor(timeoutFactorParameters.getTimeoutFactor());
    }

    public void save() throws IOException, Interview.Fault {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException();
        }
        this.save(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException, Interview.Fault {
        WorkDirectory workDirectory;
        Properties properties = new Properties();
        TestSuite testSuite = this.getTestSuite();
        if (testSuite != null) {
            properties.put("TESTSUITE", testSuite.getPath());
        }
        if ((workDirectory = this.getWorkDirectory()) != null) {
            properties.put("WORKDIR", workDirectory.getPath());
        }
        this.save(properties);
        this.setEdited(false);
        OutputStream outputStream = this.backupPolicy == null ? new BufferedOutputStream(new FileOutputStream(file)) : this.backupPolicy.backupAndOpenStream(file);
        try {
            properties.store(outputStream, "JavaTest Configuration Interview");
            this.currFile = file;
            this.currFileLastModified = file.lastModified();
            this.currFileLoaded = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public boolean isFileLoaded() {
        return this.currFileLoaded;
    }

    public boolean isFileNewer() {
        File file = this.getFile();
        return file != null && file.exists() && (this.currFileLastModified == 0L || file.lastModified() > this.currFileLastModified);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

