/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;

public class InitialUrlFilter
extends TestFilter {
    private String[] initUrls;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$ExcludeListFilter == null ? (class$com$sun$javatest$ExcludeListFilter = InitialUrlFilter.class$("com.sun.javatest.ExcludeListFilter")) : class$com$sun$javatest$ExcludeListFilter);
    static /* synthetic */ Class class$com$sun$javatest$ExcludeListFilter;

    public InitialUrlFilter(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            this.initUrls = null;
        } else {
            this.initUrls = new String[fileArray.length];
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isAbsolute()) {
                    throw new IllegalArgumentException(fileArray[n].getPath());
                }
                this.initUrls[n] = fileArray[n].getPath().toLowerCase();
                if (File.separatorChar != '/') {
                    this.initUrls[n] = this.initUrls[n].replace(File.separatorChar, '/');
                }
                ++n;
            }
        }
    }

    public InitialUrlFilter(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.initUrls = null;
        } else {
            this.initUrls = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.initUrls[n] = stringArray[n].toLowerCase();
                ++n;
            }
        }
    }

    public boolean accepts(TestDescription testDescription) {
        if (this.initUrls == null) {
            return true;
        }
        String string = testDescription.getRootRelativeURL().toLowerCase();
        int n = 0;
        while (n < this.initUrls.length) {
            String string2 = this.initUrls[n];
            if (InitialUrlFilter.isInitialUrlMatch(string, this.initUrls[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isInitialUrlMatch(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.startsWith(string2) && (InitialUrlFilter.isDelimiter(string2.charAt(string2.length() - 1)) || InitialUrlFilter.isDelimiter(string.charAt(string2.length())));
    }

    public String getName() {
        return i18n.getString("iurlFilter.name");
    }

    public String getDescription() {
        return i18n.getString("iurlFilter.description");
    }

    public String getReason() {
        return i18n.getString("iurlFilter.reason");
    }

    private static boolean isDelimiter(char c) {
        return c == '/' || c == '#';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

