/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.WizPrint;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinderQueue;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyArray;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

class HarnessHttpHandler
extends JThttpProvider
implements Harness.Observer {
    private Harness harness;
    private boolean debug = false;
    private String magicToken;
    private int[] stats = new int[4];
    private TestFinderQueue tfq;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$HarnessHttpHandler == null ? (class$com$sun$javatest$HarnessHttpHandler = HarnessHttpHandler.class$("com.sun.javatest.HarnessHttpHandler")) : class$com$sun$javatest$HarnessHttpHandler);
    static /* synthetic */ Class class$com$sun$javatest$HarnessHttpHandler;

    HarnessHttpHandler(Harness harness) {
        this.harness = harness;
        harness.addObserver(this);
    }

    public void serviceRequest(httpURL httpURL2, PrintWriter printWriter) {
        String string = httpURL2.getNextFile();
        if (string == null) {
            this.beginGood(printWriter);
            this.printHtml(printWriter);
        } else if (string.equals("env")) {
            this.beginGood(printWriter);
            this.printEnv(printWriter);
        } else if (string.equals("interview")) {
            this.beginGood(printWriter);
            this.printInterview(printWriter);
        } else if (string.equals("text")) {
            this.printText(httpURL2, printWriter);
        } else if (string.equals("stop")) {
            if (!this.harness.isRunning()) {
                JThttpProvider.println(printWriter, i18n.getString("harnessHttp.noStop"));
            } else {
                this.beginGood(printWriter);
                if (this.magicToken == null) {
                    long l = Math.round(Math.floor(Math.random() * 30000.0));
                    this.magicToken = Integer.toString((int)l);
                }
                PageGenerator.writeHeader(printWriter, i18n.getString("harnessHttp.stop.hdr"));
                PageGenerator.startBody(printWriter);
                String string2 = httpURL2.getValue("token");
                if (string2 == null) {
                    this.printStopConfirm(printWriter);
                } else if (string2.equals(this.magicToken)) {
                    this.harness.stop();
                    JThttpProvider.println(printWriter, i18n.getString("harnessHttp.stopped"));
                } else {
                    this.printStopErr(printWriter);
                }
                printWriter.println("<hr>");
                PageGenerator.writeFooter(printWriter);
                PageGenerator.endBody(printWriter);
                PageGenerator.writeEndDoc(printWriter);
            }
        } else {
            if (this.debug) {
                System.out.println("TRT.HH-remainder of URL unknown (" + string + ")");
            }
            this.beginBad(printWriter);
            this.printHtml(printWriter);
        }
        printWriter.close();
    }

    private void beginGood(PrintWriter printWriter) {
        PageGenerator.generateOkHttp(printWriter);
        PageGenerator.generateDocType(printWriter, 0);
    }

    private void beginBad(PrintWriter printWriter) {
        PageGenerator.generateBadHttp(printWriter);
        PageGenerator.generateDocType(printWriter, 0);
    }

    private void printHtml(PrintWriter printWriter) {
        PageGenerator.writeBeginDoc(printWriter);
        this.printIndex(printWriter);
        printWriter.println("<hr>");
        PageGenerator.writeFooter(printWriter);
        PageGenerator.endBody(printWriter);
        PageGenerator.writeEndDoc(printWriter);
    }

    private void printEnv(PrintWriter printWriter) {
        PageGenerator.writeBeginDoc(printWriter);
        PageGenerator.writeHeader(printWriter, i18n.getString("harnessHttp.env.title"));
        printWriter.print("<h3>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.env.hdr"));
        printWriter.println("</h3>");
        Parameters parameters = this.harness.getParameters();
        if (parameters != null) {
            this.printEnv(printWriter, parameters.getEnv());
        } else {
            printWriter.println(i18n.getString("harnessHttp.env.none"));
        }
        printWriter.println("<hr>");
        PageGenerator.writeFooter(printWriter);
        PageGenerator.endBody(printWriter);
        PageGenerator.writeEndDoc(printWriter);
    }

    private void printInterview(PrintWriter printWriter) {
        PageGenerator.writeBeginDoc(printWriter);
        PageGenerator.writeHeader(printWriter, i18n.getString("harnessHttp.interview.title"));
        printWriter.print("<h3>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.interview.hdr"));
        printWriter.println("</h3>");
        try {
            Parameters parameters = this.harness.getParameters();
            if (parameters == null || !(this.harness.getParameters() instanceof InterviewParameters)) {
                JThttpProvider.println(printWriter, i18n.getString("harnessHttp.interview.none"));
            } else {
                InterviewParameters interviewParameters = (InterviewParameters)this.harness.getParameters();
                WizPrint wizPrint = new WizPrint(interviewParameters);
                wizPrint.setShowResponses(true);
                wizPrint.setShowResponseTypes(true);
                wizPrint.setShowTags(true);
                wizPrint.write(printWriter);
            }
            printWriter.println("<hr>");
            PageGenerator.writeFooter(printWriter);
            PageGenerator.endBody(printWriter);
            PageGenerator.writeEndDoc(printWriter);
        }
        catch (IOException iOException) {
            JThttpProvider.println(printWriter, i18n.getString("harnessHttp.ioProblem"));
        }
    }

    private void printText(httpURL httpURL2, PrintWriter printWriter) {
        Parameters parameters = this.harness.getParameters();
        String string = httpURL2.getNextFile();
        if (string == null) {
            this.beginGood(printWriter);
            this.printIndex(printWriter);
        } else if (string.equals("env")) {
            TestEnvironment testEnvironment = parameters.getEnv();
            if (testEnvironment == null) {
                JThttpProvider.print(printWriter, i18n.getString("harnessHttp.env.none"));
                return;
            }
            String[] stringArray = new String[]{};
            Iterator iterator = testEnvironment.elements().iterator();
            while (iterator.hasNext()) {
                TestEnvironment.Element element = (TestEnvironment.Element)iterator.next();
                stringArray = PropertyArray.put(stringArray, element.getKey(), element.getValue());
            }
            try {
                PropertyArray.save(stringArray, printWriter);
            }
            catch (IOException iOException) {
                printWriter.println(i18n.getString("harnessHttp.ioProblem"));
            }
        } else if (string.equals("config")) {
            if (parameters == null) {
                printWriter.print(i18n.getString("harnessHttp.text.unavail"));
                return;
            }
            TestSuite testSuite = parameters.getTestSuite();
            printWriter.print(i18n.getString("harnessHttp.text.ts.path"));
            printWriter.print("=");
            if (testSuite != null) {
                printWriter.println(testSuite.getPath());
            } else {
                printWriter.println(i18n.getString("harnessHttp.text.empty"));
            }
            printWriter.print(i18n.getString("harnessHttp.text.ts.name"));
            printWriter.print("=");
            if (testSuite != null) {
                printWriter.println(testSuite.getName());
            } else {
                printWriter.println(i18n.getString("harnessHttp.text.empty"));
            }
            printWriter.print(i18n.getString("harnessHttp.text.wd.val"));
            printWriter.print("=");
            WorkDirectory workDirectory = parameters.getWorkDirectory();
            if (workDirectory != null) {
                printWriter.println(workDirectory.getPath());
            } else {
                printWriter.println(i18n.getString("harnessHttp.text.empty"));
            }
        } else if (string.equals("tests")) {
            if (parameters == null) {
                printWriter.print(i18n.getString("harnessHttp.text.unavail"));
                return;
            }
            String[] stringArray = parameters.getTests();
            if (stringArray != null && stringArray.length != 0) {
                int n = 0;
                while (n < stringArray.length) {
                    printWriter.print("url");
                    printWriter.print(Integer.toString(n));
                    printWriter.print("=");
                    printWriter.println(stringArray[n]);
                    ++n;
                }
            }
        } else if (string.equals("stats")) {
            if (!this.harness.isRunning()) {
                printWriter.println("");
                return;
            }
            this.stats[3] = this.harness.getTestsFoundCount() - this.stats[0] - this.stats[1] - this.stats[2];
            int n = 0;
            while (n < 4) {
                printWriter.print(Status.typeToString(n).replace(' ', '_'));
                printWriter.print("=");
                printWriter.println(this.stats[n]);
                ++n;
            }
        } else if (string.equals("state")) {
            JThttpProvider.print(printWriter, i18n.getString("harnessHttp.state.run.val"));
            printWriter.println(this.harness.isRunning());
        } else if (string.equals("results")) {
            TestResultTable testResultTable = this.harness.getResultTable();
            TestFilter[] testFilterArray = parameters.getFilters();
            String[] stringArray = parameters.getTests();
            TestResultTable.TreeIterator treeIterator = null;
            treeIterator = stringArray == null || stringArray.length == 0 ? testResultTable.getIterator(testFilterArray) : testResultTable.getIterator(parameters.getTests(), testFilterArray);
            while (treeIterator.hasNext()) {
                TestResult testResult = (TestResult)treeIterator.next();
                printWriter.println(testResult.getTestName());
                printWriter.println(testResult.getStatus().toString());
            }
        } else {
            if (this.debug) {
                System.out.println("TRT.HH-remainder of URL unknown (" + string + ")");
            }
            JThttpProvider.println(printWriter, i18n.getString("harnessHttp.badRequest", httpURL2.getFullPath()));
        }
    }

    private void printStopConfirm(PrintWriter printWriter) {
        printWriter.print("<h2>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.stopConfirm.hdr"));
        printWriter.println("</h2>");
        printWriter.print("<h4>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.stopConfirm.txt"));
        printWriter.println("</h4>");
        printWriter.print("<Form method=get enctype=application/x-www-form-urlencoded>");
        printWriter.print("<p><Input align=center type=submit value=");
        printWriter.print(i18n.getString("harnessHttp.stopConfirm.btn"));
        printWriter.println(">");
        printWriter.print("<Input type=hidden name=token value=");
        printWriter.print(this.magicToken);
        printWriter.println("></Form>");
    }

    private void printStopErr(PrintWriter printWriter) {
        printWriter.println("<h2>");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.stopErr.hdr"));
        printWriter.println("</h2>");
        printWriter.println("<b>");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.stopErr.text1"));
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.stopErr.text2"));
        printWriter.println("</b>");
        printWriter.println("<p>");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.stopErr.text3"));
        printWriter.println("<a href=\"/harness/stop\">");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.stopErr.text4"));
        printWriter.println("</a>");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.stopErr.text5"));
    }

    private void printIndex(PrintWriter printWriter) {
        PageGenerator.writeHeader(printWriter, i18n.getString("harnessHttp.index.title"));
        PageGenerator.startBody(printWriter);
        printWriter.println("<h2>");
        printWriter.print("JavaTest &#8482; ");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.index.hdr"));
        printWriter.println("</h2>");
        Parameters parameters = this.harness.getParameters();
        if (parameters == null) {
            printWriter.println(i18n.getString("harnessHttp.parameters.noParams"));
            return;
        }
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.tsName"));
        String string = parameters.getTestSuite().getName();
        JThttpProvider.println(printWriter, string == null ? i18n.getString("harnessHttp.parameters.noTs") : string);
        printWriter.println("<br>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.tsPath"));
        File file = parameters.getTestSuite().getRoot();
        JThttpProvider.println(printWriter, file == null ? i18n.getString("harnessHttp.parameters.noTs") : file.getPath());
        printWriter.println("<br>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.wd"));
        WorkDirectory workDirectory = parameters.getWorkDirectory();
        if (workDirectory != null) {
            JThttpProvider.println(printWriter, workDirectory.getPath());
        } else {
            JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.noWd"));
        }
        printWriter.println("<p>");
        this.printParameters(printWriter, parameters);
        TestResultTable testResultTable = this.harness.getResultTable();
        printWriter.println("<h3>");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.results.hdr"));
        printWriter.println("</h3>");
        if (testResultTable != null) {
            JThttpProvider jThttpProvider = RootRegistry.getObjectHandler(testResultTable);
            if (jThttpProvider != null && jThttpProvider.getRootURL() != null) {
                printWriter.print("<a href=\"");
                printWriter.print(jThttpProvider.getRootURL());
                printWriter.print("\">");
                JThttpProvider.print(printWriter, i18n.getString("harnessHttp.trt.link"));
                printWriter.println("</a>");
            }
        } else {
            printWriter.print(i18n.getString("harnessHttp.trt.none"));
        }
    }

    private void printParameters(PrintWriter printWriter, Parameters parameters) {
        Object object;
        Object object2;
        printWriter.println("<h3>");
        JThttpProvider.println(printWriter, i18n.getString("harnessHttp.parameters.hdr"));
        printWriter.println("</h3>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.env"));
        TestEnvironment testEnvironment = parameters.getEnv();
        if (testEnvironment != null) {
            printWriter.print("<a href=\"");
            printWriter.print(this.getRootURL());
            printWriter.print("/env\">");
            JThttpProvider.print(printWriter, testEnvironment.getName());
            printWriter.println("</a>");
        } else {
            JThttpProvider.println(printWriter, i18n.getString("harnessHttp.parameters.noEnv"));
        }
        printWriter.println("<br>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.interview"));
        if (parameters instanceof InterviewParameters) {
            object2 = (InterviewParameters)parameters;
            object = ((InterviewParameters)object2).getFile();
            printWriter.print("<a href=\"");
            printWriter.print(this.getRootURL());
            printWriter.print("/interview\">");
            JThttpProvider.print(printWriter, object == null ? i18n.getString("harnessHttp.parameters.noInterviewFile") : ((File)object).getPath());
            printWriter.println("</a>");
        } else {
            JThttpProvider.println(printWriter, i18n.getString("harnessHttp.parameters.noInterview"));
        }
        printWriter.println("<p>");
        printWriter.println("<ul>");
        printWriter.print("<li>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.urls"));
        this.printTests(printWriter);
        printWriter.print("<li>");
        JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.jtx"));
        object2 = parameters.getExcludeListParameters();
        if (object2 instanceof Parameters.MutableExcludeListParameters) {
            object = (Parameters.MutableExcludeListParameters)object2;
            File[] fileArray = object.getExcludeFiles();
            if (fileArray == null || fileArray.length == 0) {
                JThttpProvider.println(printWriter, i18n.getString("harnessHttp.parameters.emptyJtx"));
            } else {
                printWriter.println("<ul>");
                int n = 0;
                while (n < fileArray.length) {
                    printWriter.println("<li>" + fileArray[n].getPath());
                    ++n;
                }
                printWriter.println("</ul>");
            }
        } else {
            JThttpProvider.println(printWriter, i18n.getString("harnessHttp.parameters.noJtx"));
        }
        printWriter.println("</ul>");
    }

    private void printTests(PrintWriter printWriter) {
        String[] stringArray = this.harness.getParameters().getTests();
        if (stringArray == null || stringArray.length == 0) {
            JThttpProvider.print(printWriter, i18n.getString("harnessHttp.parameters.noTests"));
        } else {
            printWriter.println("<ul>");
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println("<li>");
                JThttpProvider.println(printWriter, stringArray[n]);
                ++n;
            }
            printWriter.println("</ul>");
        }
    }

    private void printEnv(PrintWriter printWriter, TestEnvironment testEnvironment) {
        printWriter.print(i18n.getString("harnessHttp.env.name"));
        JThttpProvider.println(printWriter, testEnvironment.getName());
        String string = "Key";
        String string2 = "Value";
        printWriter.println("<Table Border>");
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("<tr><th>");
        stringBuffer.append(JThttpProvider.filterTags(string));
        stringBuffer.append("<th>");
        stringBuffer.append(JThttpProvider.filterTags(string2));
        stringBuffer.append("</tr>");
        printWriter.println(stringBuffer.toString());
        Iterator iterator = testEnvironment.keys().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            printWriter.println("<tr>");
            stringBuffer.setLength(0);
            stringBuffer.append("<td>");
            stringBuffer.append(string3.toString());
            stringBuffer.append("<td>");
            try {
                stringBuffer.append(JThttpProvider.filterTags(StringArray.join(testEnvironment.lookup(string3))));
            }
            catch (TestEnvironment.Fault fault) {
                stringBuffer.append(i18n.getString("harnessHttp.env.error"));
            }
            printWriter.println(stringBuffer.toString());
            printWriter.println("</tr>");
        }
        printWriter.println("</Table>");
    }

    public void startingTestRun(Parameters parameters) {
    }

    public void startingTest(TestResult testResult) {
    }

    public void finishedTest(TestResult testResult) {
        int n = testResult.getStatus().getType();
        this.stats[n] = this.stats[n] + 1;
    }

    public void stoppingTestRun() {
    }

    public void finishedTesting() {
    }

    public void finishedTestRun(boolean bl) {
    }

    public void error(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

