/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Deprecated;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.HarnessHttpHandler;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.Trace;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.ReadAheadIterator;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class Harness {
    private BackupPolicy backupPolicy;
    private int autostopThreshold;
    private Observer[] observers;
    private HarnessHttpHandler httpHandler;
    private Trace trace;
    private Thread worker;
    private Parameters params;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private ExcludeList excludeList;
    private TestResultTable.TreeIterator testIter;
    private int readAheadMode;
    private ReadAheadIterator raTestIter;
    private int numTestsDone;
    private TestEnvironment env;
    private TestResultTable resultTable;
    private long startTime;
    private long finishTime;
    private boolean stopping;
    private static File classDir;
    private static final boolean ZERO_TESTS_OK = true;
    private static final boolean ZERO_TESTS_ERROR = false;
    private static final int DEFAULT_READ_AHEAD = 100;
    private static I18NResourceBundle i18n;
    private static final Integer EXCEPTION;
    private static final Integer ERROR;
    private static final Integer THROWABLE;
    static /* synthetic */ Class class$com$sun$javatest$Harness;

    public Harness(File file) {
        this();
        Harness.setClassDir(file);
    }

    public Harness() {
        Integer n = Integer.getInteger("javatest.autostop.threshold");
        this.autostopThreshold = n == null ? 0 : n;
        this.observers = new Observer[0];
        this.readAheadMode = 2;
        this.startTime = -1L;
        this.finishTime = -1L;
        this.backupPolicy = BackupPolicy.noBackups();
        this.params = null;
        if (!Boolean.getBoolean("javatest.noTraceRequired")) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        }
        if (HttpdServer.isActive()) {
            this.httpHandler = new HarnessHttpHandler(this);
            RootRegistry.getInstance().addHandler("/harness", "JavaTest Harness", this.httpHandler);
        }
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public boolean isTracingRequired() {
        return this.trace != null;
    }

    public void setTracingRequired(boolean bl) {
        if (bl && this.trace == null) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        } else if (!bl && this.trace != null) {
            this.removeObserver(this.trace);
            this.trace = null;
        }
    }

    public static File getClassDir() {
        return classDir;
    }

    public static void setClassDir(File file) {
        if (classDir != null && classDir != file) {
            throw new IllegalStateException(i18n.getString("harness.classDirAlreadySet"));
        }
        classDir = file;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public TestEnvironment getEnv() {
        return this.env;
    }

    public TestResultTable getResultTable() {
        WorkDirectory workDirectory = this.params == null ? null : this.params.getWorkDirectory();
        return workDirectory == null ? null : workDirectory.getTestResultTable();
    }

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers = (Observer[])DynamicArray.append(this.observers, observer);
    }

    public synchronized void removeObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
    }

    public void start(Parameters parameters) throws Fault {
        this.startWorker(parameters);
    }

    public synchronized void waitUntilDone() throws InterruptedException {
        while (this.worker != null) {
            this.wait();
        }
    }

    public synchronized void stop() {
        if (this.worker != null) {
            if (!this.stopping) {
                Observer[] observerArray = this.observers;
                int n = observerArray.length - 1;
                while (n >= 0) {
                    observerArray[n].stoppingTestRun();
                    --n;
                }
                this.stopping = true;
            }
            this.worker.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean batch(Parameters parameters) throws Fault, InterruptedException {
        this.readAheadMode = 0;
        Harness harness = this;
        // MONITORENTER : harness
        if (this.worker != null) {
            throw new Fault(i18n, "harness.alreadyRunning");
        }
        this.worker = Thread.currentThread();
        // MONITOREXIT : harness
        boolean bl = false;
        try {
            bl = this.runTests(parameters, true);
            return bl;
        }
        catch (TestSuite.Fault fault) {
            throw new Fault(i18n, "harness.testsuiteError", fault.getMessage());
        }
        finally {
            Harness harness2 = this;
        }
    }

    public boolean isRunning() {
        return this.worker != null;
    }

    public boolean isAllTestsFound() {
        if (this.isRunning() && this.raTestIter != null) {
            return this.raTestIter.isSourceExhausted();
        }
        return false;
    }

    public long getElapsedTime() {
        long l = 0L;
        if (this.startTime == -1L) {
            l = 0L;
        } else if (this.finishTime == -1L) {
            long l2 = System.currentTimeMillis();
            l = l2 - this.startTime;
        } else {
            l = this.finishTime - this.startTime;
        }
        return l;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getEstimatedTime() {
        if (!this.isRunning() || this.numTestsDone == 0) {
            return 0L;
        }
        long l = this.getElapsedTime() * (long)(this.getTestsFoundCount() - this.numTestsDone) / (long)this.numTestsDone;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTestsFoundCount() {
        if (this.raTestIter == null) {
            return 0;
        }
        ReadAheadIterator readAheadIterator = this.raTestIter;
        synchronized (readAheadIterator) {
            return this.raTestIter.getUsedElementCount() + this.raTestIter.getOutputQueueSize();
        }
    }

    private synchronized void startWorker(final Parameters parameters) throws Fault {
        if (this.worker != null) {
            throw new Fault(i18n, "harness.alreadyRunning");
        }
        this.worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                boolean bl = false;
                try {
                    bl = Harness.this.runTests(parameters, false);
                }
                catch (Fault fault) {
                    Harness.this.notifyLocalizedError(fault.getMessage());
                }
                catch (TestSuite.Fault fault) {
                    Harness.this.notifyLocalizedError(fault.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    Harness.this.notifyError(i18n, "harness.interrupted");
                }
                finally {
                    Harness harness = Harness.this;
                }
            }
        };
        this.worker.setName("Harness:Worker");
        this.worker.setPriority(3);
        this.worker.start();
    }

    private boolean runTests(Parameters parameters, boolean bl) throws Fault, TestSuite.Fault, InterruptedException {
        int n;
        Object[] objectArray;
        boolean bl2 = false;
        this.stopping = false;
        this.startTime = System.currentTimeMillis();
        this.finishTime = -1L;
        this.numTestsDone = 0;
        if (!parameters.isValid()) {
            throw new Fault(i18n, "harness.incompleteParameters", parameters.getErrorMessage());
        }
        this.params = parameters;
        this.testSuite = this.params.getTestSuite();
        this.workDir = this.params.getWorkDirectory();
        this.resultTable = this.workDir.getTestResultTable();
        this.excludeList = this.params.getExcludeList();
        this.workDir.log(i18n, "harness.starting");
        float f = this.params.getTimeoutFactor();
        if (f == Float.NaN) {
            f = 1.0f;
        }
        String[] stringArray = new String[]{String.valueOf((int)Math.ceil(f)), String.valueOf(f)};
        this.env = this.params.getEnv();
        this.env.put("javatestTimeoutFactor", stringArray);
        this.env.putUrlAndFile("javatestClassDir", classDir, true);
        this.env.putUrlAndFile("harnessClassDir", classDir, true);
        this.env.putUrlAndFile("javatestWorkDir", this.workDir.getRoot(), true);
        this.env.putUrlAndFile("testSuiteRoot", this.testSuite.getRoot(), this.testSuite.getRoot().isDirectory());
        this.env.putUrlAndFile("testSuiteRootDir", this.testSuite.getRootDir(), true);
        String[] stringArray2 = this.params.getTests();
        TestFilter[] testFilterArray = this.params.getFilters();
        this.resultTable.waitUntilReady();
        if (stringArray2 == null || stringArray2.length == 0) {
            this.testIter = this.resultTable.getIterator(testFilterArray);
        } else {
            try {
                objectArray = new File[stringArray2.length];
                n = 0;
                while (n < stringArray2.length) {
                    objectArray[n] = new File(stringArray2[n]);
                    ++n;
                }
                this.testIter = this.resultTable.getIterator((File[])objectArray, testFilterArray);
            }
            catch (TestResultTable.Fault fault) {
                throw new Fault(i18n, "harness.badInitFiles", fault.getMessage());
            }
        }
        this.raTestIter = new ReadAheadIterator(this.testIter, this.readAheadMode, 100);
        if (this.autostopThreshold > 0) {
            this.addObserver(new Autostop(this.autostopThreshold));
        }
        this.testSuite.starting(this);
        this.resultTable.starting();
        objectArray = this.observers;
        n = objectArray.length - 1;
        while (n >= 0) {
            objectArray[n].startingTestRun(this.params);
            --n;
        }
        try {
            int n2 = this.params.getConcurrency();
            n2 = Math.max(1, Math.min(n2, 50));
            bl2 = new TestRunner().run(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finishTime = System.currentTimeMillis();
        objectArray = this.observers;
        int n3 = objectArray.length - 1;
        while (n3 >= 0) {
            objectArray[n3].finishedTesting();
            --n3;
        }
        this.resultTable.finished();
        int[] nArray = this.testIter.getResultStats();
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            n4 += nArray[n5];
            ++n5;
        }
        if (n4 == 0) {
            this.notifyError(i18n, "harness.noTests");
            bl2 = false;
        } else if (bl2 && this.resultTable.getTestFinder().getErrorCount() > 0) {
            this.notifyError(i18n, "harness.finderError");
            bl2 = false;
        }
        this.resultTable.waitUntilReady();
        this.workDir.log(i18n, "harness.done", new Integer(bl2 ? 0 : 1));
        return bl2;
    }

    /*
     * Exception decompiling
     */
    private boolean runTest(TestDescription var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TestResult createErrorResult(TestDescription testDescription, String string, Throwable throwable) {
        TestResult testResult;
        Status status = Status.error(string);
        if (throwable == null) {
            testResult = new TestResult(testDescription, status);
        } else {
            testResult = new TestResult(testDescription);
            TestResult.Section section = testResult.createSection(i18n.getString("harness.details"));
            PrintWriter printWriter = section.createOutput(i18n.getString("harness.stackTrace"));
            throwable.printStackTrace(printWriter);
            printWriter.close();
            testResult.setStatus(status);
        }
        try {
            testResult.writeResults(this.workDir, this.backupPolicy);
        }
        catch (Exception exception) {
            this.workDir.log(i18n, "harness.unexpectedThrowable", new Object[]{exception, EXCEPTION});
        }
        return testResult;
    }

    private void notifyError(I18NResourceBundle i18NResourceBundle, String string) {
        this.notifyLocalizedError(i18NResourceBundle.getString(string));
    }

    private void notifyError(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.notifyLocalizedError(i18NResourceBundle.getString(string, object));
    }

    private void notifyError(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.notifyLocalizedError(i18NResourceBundle.getString(string, objectArray));
    }

    private void notifyLocalizedError(String string) {
        Observer[] observerArray = this.observers;
        int n = observerArray.length - 1;
        while (n >= 0) {
            observerArray[n].error(string);
            --n;
        }
    }

    private Integer classifyThrowable(Throwable throwable) {
        if (throwable instanceof Exception) {
            return EXCEPTION;
        }
        if (throwable instanceof Error) {
            return ERROR;
        }
        return THROWABLE;
    }

    static /* synthetic */ Thread access$402(Harness harness, Thread thread) {
        harness.worker = thread;
        return harness.worker;
    }

    static /* synthetic */ Observer[] access$500(Harness harness) {
        return harness.observers;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$900(Harness harness, TestDescription testDescription) {
        return harness.runTest(testDescription);
    }

    static /* synthetic */ int access$1108(Harness harness) {
        return harness.numTestsDone++;
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$Harness == null ? (class$com$sun$javatest$Harness = Harness.class$("com.sun.javatest.Harness")) : class$com$sun$javatest$Harness);
        EXCEPTION = new Integer(0);
        ERROR = new Integer(1);
        THROWABLE = new Integer(2);
    }

    class Autostop
    implements Observer {
        private int level;
        private int threshold;

        Autostop(int n) {
            this.threshold = n;
        }

        public void startingTestRun(Parameters parameters) {
        }

        public void startingTest(TestResult testResult) {
        }

        public void finishedTest(TestResult testResult) {
            switch (testResult.getStatus().getType()) {
                case 1: {
                    ++this.level;
                    break;
                }
                case 2: {
                    this.level += 5;
                    break;
                }
                default: {
                    this.level = Math.max(this.level - 2, 0);
                }
            }
            if (this.level >= this.threshold) {
                Harness.this.notifyError(i18n, "harness.tooManyErrors");
                Harness.this.stop();
            }
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
        }

        public void error(String string) {
        }
    }

    private class TestRunner {
        private Set activeThreads;
        private boolean allPassed;
        private boolean stopping;

        private TestRunner() {
        }

        /*
         * Unable to fully structure code
         */
        synchronized boolean run(int var1_1) throws InterruptedException {
            var2_2 = new Thread[var1_1];
            this.activeThreads = new HashSet<E>();
            this.allPassed = true;
            try {
                var3_3 = 0;
                while (!this.stopping) {
                    var4_5 = 0;
                    while (var4_5 < var2_2.length) {
                        var5_7 = var2_2[var4_5];
                        if (var5_7 == null || !this.activeThreads.contains(var5_7)) {
                            var6_10 = Math.max(1, Thread.currentThread().getPriority() - 1);
                            var5_7 = new Thread(this){
                                private final /* synthetic */ TestRunner this$1;
                                {
                                    this.this$1 = testRunner;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        TestDescription testDescription;
                                        while ((testDescription = TestRunner.access$700(this.this$1)) != null) {
                                            if (!Harness.access$900(TestRunner.access$800(this.this$1), testDescription)) {
                                                TestRunner.access$1002(this.this$1, false);
                                            }
                                            Harness.access$1108(TestRunner.access$800(this.this$1));
                                        }
                                        Object var3_2 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        TestRunner.access$1200(this.this$1, this);
                                        throw throwable;
                                    }
                                    TestRunner.access$1200(this.this$1, this);
                                }
                            };
                            var5_7.setName("Harness:Worker-" + var4_5 + ":" + var3_3++);
                            var5_7.start();
                            var5_7.setPriority(var6_10);
                            this.activeThreads.add(var5_7);
                            var2_2[var4_5] = var5_7;
                        }
                        ++var4_5;
                    }
                    this.wait();
                }
                var4_5 = 0;
                while (var4_5 < var1_1) {
                    if (var2_2[var4_5] != null) {
                        while (this.activeThreads.contains(var2_2[var4_5])) {
                            this.wait();
                        }
                        var2_2[var4_5] = null;
                    }
                    ++var4_5;
                }
            }
            catch (InterruptedException var3_4) {
                this.stopping = true;
                var4_6 = this.activeThreads.iterator();
                while (var4_6.hasNext()) {
                    var5_8 = (Thread)var4_6.next();
                    var5_8.interrupt();
                }
                var5_9 = System.currentTimeMillis();
                try {
                    while (this.activeThreads.size() > 0 && System.currentTimeMillis() - var5_9 < 2000L) {
                        this.wait(100L);
                    }
                }
                catch (InterruptedException var7_11) {
                    // empty catch block
                }
                throw var3_4;
            }
            finally {
                var9_13 = 0;
                ** while (var9_13 < var2_2.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var2_2[var9_13] != null) {
                    Deprecated.invokeThreadStop(var2_2[var9_13]);
                }
                ++var9_13;
                continue;
            }
lbl56:
            // 1 sources

            throw var8_12;
        }

        private synchronized TestDescription nextTest() {
            if (this.stopping) {
                return null;
            }
            if (Harness.this.raTestIter.hasNext()) {
                TestResult testResult = (TestResult)Harness.this.raTestIter.next();
                try {
                    return testResult.getDescription();
                }
                catch (TestResult.Fault fault) {
                    this.stopping = true;
                    throw new JavaTestError(i18n, "runner.trProb", testResult.getWorkRelativePath(), (Throwable)fault);
                }
            }
            this.stopping = true;
            return null;
        }

        private synchronized void threadExiting(Thread thread) {
            this.activeThreads.remove(thread);
            this.notifyAll();
        }

        static /* synthetic */ TestDescription access$700(TestRunner testRunner) {
            return testRunner.nextTest();
        }

        static /* synthetic */ Harness access$800(TestRunner testRunner) {
            return testRunner.Harness.this;
        }

        static /* synthetic */ boolean access$1002(TestRunner testRunner, boolean bl) {
            testRunner.allPassed = bl;
            return testRunner.allPassed;
        }

        static /* synthetic */ void access$1200(TestRunner testRunner, Thread thread) {
            testRunner.threadExiting(thread);
        }
    }

    public static interface Observer {
        public void startingTestRun(Parameters var1);

        public void startingTest(TestResult var1);

        public void finishedTest(TestResult var1);

        public void stoppingTestRun();

        public void finishedTesting();

        public void finishedTestRun(boolean var1);

        public void error(String var1);
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

