/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.BasicParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.Properties;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class FileParameters
extends BasicParameters
implements Parameters.LegacyEnvParameters {
    private File[] envFiles;
    private File[] cachedAbsEnvFiles;
    private File cachedAbsEnvFiles_base;
    private File[] cachedAbsEnvFiles_envFiles;
    private String envName;
    private TestEnvContext cachedEnvTable;
    private File[] cachedEnvTable_absEnvFiles;
    private String envTableError;
    private TestEnvironment cachedEnv;
    private TestEnvContext cachedEnv_envTable;
    private String cachedEnv_envName;
    private String envError;
    private File reportDir;
    private static final String PARAMFILE_EXTN = ".jtp";
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$FileParameters == null ? (class$com$sun$javatest$FileParameters = FileParameters.class$("com.sun.javatest.FileParameters")) : class$com$sun$javatest$FileParameters);
    static /* synthetic */ Class class$com$sun$javatest$FileParameters;

    public static boolean isParameterFile(File file) {
        return file.getPath().endsWith(PARAMFILE_EXTN);
    }

    public FileParameters() {
    }

    public FileParameters(File file) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        properties.load(bufferedReader);
        ((Reader)bufferedReader).close();
        this.setTestSuite(properties.getProperty("javasoft.sqe.javatest.selection.testSuite"));
        this.setWorkDirectory(properties.getProperty("javasoft.sqe.javatest.results.workDir"));
        this.setTests(properties.getProperty("javasoft.sqe.javatest.selection.tests"));
        this.setExcludeFiles(properties.getProperty("javasoft.sqe.javatest.selection.excludeList"));
        String string = properties.getProperty("javasoft.sqe.javatest.selection.keywordOp");
        String string2 = properties.getProperty("javasoft.sqe.javatest.selection.keywords");
        this.setKeywords(string, string2);
        String string3 = properties.getProperty("javasoft.sqe.javatest.selection.status");
        String[] stringArray = new String[]{properties.getProperty("javasoft.sqe.javatest.selection.prev.passed"), properties.getProperty("javasoft.sqe.javatest.selection.prev.failed"), properties.getProperty("javasoft.sqe.javatest.selection.prev.error"), properties.getProperty("javasoft.sqe.javatest.selection.prev.notRun")};
        this.setPriorStatusValues(string3, stringArray);
        this.setEnvFiles(properties.getProperty("javasoft.sqe.javatest.execution.envFiles"));
        this.setEnvName(properties.getProperty("javasoft.sqe.javatest.execution.environment"));
        this.setConcurrency(properties.getProperty("javasoft.sqe.javatest.execution.concurrency"));
        this.setTimeoutFactor(properties.getProperty("javasoft.sqe.javatest.execution.timeFactor"));
        this.setReportDir(properties.getProperty("javasoft.sqe.javatest.results.reportDir"));
    }

    public FileParameters(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        int n = 0;
        while (n < stringArray.length) {
            if ("-testSuite".equalsIgnoreCase(stringArray[n]) || "-t".equalsIgnoreCase(stringArray[n])) {
                string = stringArray[++n];
            } else if ("-keywords".equalsIgnoreCase(stringArray[n])) {
                string5 = stringArray[++n];
            } else if ("-status".equalsIgnoreCase(stringArray[n])) {
                string6 = stringArray[++n].toLowerCase();
            } else if ("-exclude".equalsIgnoreCase(stringArray[n])) {
                string4 = string4 == null ? stringArray[++n] : string4 + " " + stringArray[++n];
            } else if ("-envFile".equalsIgnoreCase(stringArray[n])) {
                string7 = string7 == null ? stringArray[++n] : string7 + " " + stringArray[++n];
            } else if ("-env".equalsIgnoreCase(stringArray[n])) {
                string8 = stringArray[++n];
            } else if ("-concurrency".equalsIgnoreCase(stringArray[n])) {
                string9 = stringArray[++n];
            } else if ("-timeoutFactor".equalsIgnoreCase(stringArray[n])) {
                string10 = stringArray[++n];
            } else if ("-report".equalsIgnoreCase(stringArray[n]) || "-r".equalsIgnoreCase(stringArray[n])) {
                string11 = stringArray[++n];
            } else if ("-workDir".equalsIgnoreCase(stringArray[n]) || "-w".equalsIgnoreCase(stringArray[n])) {
                string2 = stringArray[++n];
            } else {
                if (stringArray[n].startsWith("-")) {
                    throw new IllegalArgumentException(stringArray[n]);
                }
                String[] stringArray2 = new String[stringArray.length - n];
                System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
                string3 = StringArray.join(stringArray2);
                n = stringArray.length;
            }
            ++n;
        }
        this.setTestSuite(string);
        this.setWorkDirectory(string2);
        this.setTests(string3);
        this.setExcludeFiles(string4);
        this.setKeywords("expr", string5);
        this.setPriorStatusValues(string6);
        this.setEnvFiles(string7);
        this.setEnvName(string8);
        this.setConcurrency(string9);
        this.setTimeoutFactor(string10);
        this.setReportDir(string11);
    }

    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    public File[] getEnvFiles() {
        return this.envFiles;
    }

    public File[] getAbsoluteEnvFiles() {
        this.updateAbsoluteEnvFiles();
        return this.cachedAbsEnvFiles;
    }

    public void setEnvFiles(File[] fileArray) {
        this.envFiles = fileArray;
    }

    private void setEnvFiles(String string) {
        String[] stringArray = StringArray.split(string);
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        this.setEnvFiles(fileArray);
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String string) {
        this.envName = string;
    }

    public TestEnvContext getEnvTable() {
        this.updateEnvTable();
        return this.cachedEnvTable;
    }

    public TestEnvironment getEnv() {
        this.updateEnv();
        return this.cachedEnv;
    }

    private void updateAbsoluteEnvFiles() {
        File file;
        TestSuite testSuite = this.getTestSuite();
        File file2 = file = testSuite == null ? null : testSuite.getRootDir();
        if (this.cachedAbsEnvFiles == null || this.cachedAbsEnvFiles_base != file || this.cachedAbsEnvFiles_envFiles != this.envFiles) {
            this.cachedAbsEnvFiles = BasicParameters.getAbsoluteFiles(file, this.envFiles);
        }
    }

    private void updateEnvTable() {
        block2: {
            this.updateAbsoluteEnvFiles();
            File[] fileArray = this.cachedAbsEnvFiles;
            if (this.cachedEnvTable != null && BasicParameters.equal(fileArray, this.cachedEnvTable_absEnvFiles)) break block2;
            try {
                this.cachedEnvTable = new TestEnvContext(fileArray);
                this.cachedEnvTable_absEnvFiles = fileArray;
                this.envTableError = null;
            }
            catch (TestEnvContext.Fault fault) {
                this.cachedEnvTable = null;
                this.envTableError = fault.getMessage();
            }
        }
    }

    private void updateEnv() {
        TestEnvironment testEnvironment;
        TestEnvContext testEnvContext = this.getEnvTable();
        if (testEnvContext == null) {
            this.cachedEnv = null;
            this.envError = i18n.getString("fp.noEnvs", this.envName);
            return;
        }
        try {
            if (this.envName == null) {
                this.envName = "";
            }
            if ((testEnvironment = testEnvContext.getEnv(this.envName)) == null) {
                this.cachedEnv = null;
                this.envError = i18n.getString("fp.envNotFound", this.envName);
                return;
            }
            Iterator iterator = testEnvironment.elements().iterator();
            while (iterator.hasNext()) {
                TestEnvironment.Element element = (TestEnvironment.Element)iterator.next();
                if (element.value.indexOf("VALUE_NOT_DEFINED") < 0) continue;
                String string = (element.definedInEnv == null ? "" : "env." + element.definedInEnv + ".") + element.key + "=" + element.value;
                this.cachedEnv = null;
                this.envError = i18n.getString("fp.undefinedEntry", new Object[]{string, element.definedInFile});
                return;
            }
        }
        catch (TestEnvironment.Fault fault) {
            this.cachedEnv = null;
            this.envError = i18n.getString("fp.badEnv", new Object[]{this.envName, fault.getMessage()});
            return;
        }
        this.cachedEnv = testEnvironment;
        this.envError = null;
    }

    private boolean isEnvOK() {
        this.updateEnv();
        return this.envTableError == null && this.envError == null;
    }

    public boolean isValid() {
        return super.isValid() && this.isEnvOK();
    }

    public String getErrorMessage() {
        String string = super.getErrorMessage();
        return string != null ? string : (this.envTableError != null ? this.envTableError : null);
    }

    private void setTestSuite(String string) {
        this.setTestSuite(string == null ? null : new File(string));
    }

    private void setWorkDirectory(String string) {
        this.setWorkDirectory(string == null ? null : new File(string));
    }

    private void setTests(String string) {
        this.setTests(StringArray.split(string));
    }

    private void setExcludeFiles(String string) {
        String[] stringArray = StringArray.split(string);
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        this.setExcludeFiles(fileArray);
    }

    private void setKeywords(String string, String string2) {
        if (string == null || string.equals("ignore")) {
            this.setKeywordsMode(1);
        } else if (string.equals("expr")) {
            this.setKeywords(3, string2);
        } else if (string.equals("allOf")) {
            this.setKeywords(2, string2);
        } else if (string.equals("anyOf")) {
            this.setKeywords(1, string2);
        } else {
            this.setKeywordsMode(1);
        }
    }

    private void setPriorStatusValues(String string, String[] stringArray) {
        if (string == null || !string.equals("allOf")) {
            this.setPriorStatusValues((boolean[])null);
        } else {
            boolean[] blArray = new boolean[4];
            int n = 0;
            while (n < stringArray.length) {
                blArray[n] = "true".equals(stringArray[n]);
                ++n;
            }
            this.setPriorStatusValues(blArray);
        }
    }

    private void setPriorStatusValues(String string) {
        if (string == null || string.length() == 0) {
            this.setPriorStatusValues((boolean[])null);
        } else {
            boolean[] blArray = new boolean[]{string.indexOf("pass") != -1, string.indexOf("fail") != -1, string.indexOf("erro") != -1, string.indexOf("notr") != -1};
            this.setPriorStatusValues(blArray);
        }
    }

    private void setConcurrency(String string) {
        if (string == null) {
            this.setConcurrency(1);
        } else {
            try {
                this.setConcurrency(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.concurrencyError = i18n.getString("fp.badConcurrency", string);
            }
        }
    }

    private void setTimeoutFactor(String string) {
        if (string == null) {
            this.setTimeoutFactor(1.0f);
        } else {
            try {
                this.setTimeoutFactor(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.timeoutFactorError = i18n.getString("fp.badTimeoutFactor", string);
            }
        }
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File file) {
        this.reportDir = file;
    }

    private void setReportDir(String string) {
        if (string == null) {
            this.setReportDir((File)null);
        } else {
            this.setReportDir(new File(string));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

