/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.AndExprKeywords;
import com.sun.javatest.ExprKeywords;
import com.sun.javatest.Keywords;
import com.sun.javatest.NotExprKeywords;
import com.sun.javatest.OrExprKeywords;
import com.sun.javatest.ParenExprKeywords;
import com.sun.javatest.TermExprKeywords;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.Set;

class ExprParser {
    protected static boolean allowNumericKeywords = Boolean.getBoolean("javatest.allowNumericKeywords");
    private String text;
    private Set validKeywords;
    private int index;
    private int token;
    private String idValue;
    private static final int ID = 0;
    private static final int AND = 1;
    private static final int OR = 2;
    private static final int NOT = 3;
    private static final int LPAREN = 4;
    private static final int RPAREN = 5;
    private static final int END = 6;
    private static final int ERROR = 7;
    private static I18NResourceBundle i18n = Keywords.i18n;

    ExprParser(String string, Set set) {
        this.text = string == null ? "" : string;
        this.validKeywords = set;
        this.nextToken();
    }

    ExprKeywords parse() throws Keywords.Fault {
        ExprKeywords exprKeywords = this.parseExpr();
        this.expect(6);
        return exprKeywords;
    }

    ExprKeywords parseExpr() throws Keywords.Fault {
        ExprKeywords exprKeywords = this.parseTerm();
        while (exprKeywords != null) {
            switch (this.token) {
                case 1: {
                    this.nextToken();
                    exprKeywords = new AndExprKeywords(exprKeywords, this.parseTerm());
                    break;
                }
                case 2: {
                    this.nextToken();
                    exprKeywords = new OrExprKeywords(exprKeywords, this.parseTerm());
                    break;
                }
                default: {
                    return exprKeywords;
                }
            }
            exprKeywords = exprKeywords.order();
        }
        return null;
    }

    ExprKeywords parseTerm() throws Keywords.Fault {
        switch (this.token) {
            case 0: {
                String string = this.idValue;
                if (this.validKeywords != null && !this.validKeywords.contains(string)) {
                    throw new Keywords.Fault(i18n, "kw.invalidKeyword", string);
                }
                this.nextToken();
                return new TermExprKeywords(string);
            }
            case 3: {
                this.nextToken();
                return new NotExprKeywords(this.parseTerm());
            }
            case 4: {
                this.nextToken();
                ExprKeywords exprKeywords = this.parseExpr();
                this.expect(5);
                return new ParenExprKeywords(exprKeywords);
            }
        }
        throw new Keywords.Fault(i18n, "kw.badKeywordExpr");
    }

    private void expect(int n) throws Keywords.Fault {
        if (n != this.token) {
            throw new Keywords.Fault(i18n, "kw.badKeywordExpr");
        }
        this.nextToken();
    }

    private void nextToken() {
        block8: while (this.index < this.text.length()) {
            char c = this.text.charAt(this.index++);
            switch (c) {
                case '\t': 
                case ' ': {
                    break;
                }
                case '&': {
                    this.token = 1;
                    return;
                }
                case '|': {
                    this.token = 2;
                    return;
                }
                case '!': {
                    this.token = 3;
                    return;
                }
                case '(': {
                    this.token = 4;
                    return;
                }
                case ')': {
                    this.token = 5;
                    return;
                }
                default: {
                    if (!Character.isUnicodeIdentifierStart(c) && (!allowNumericKeywords || !Character.isDigit(c))) continue block8;
                    this.idValue = String.valueOf(Character.toLowerCase(c));
                    while (this.index < this.text.length() && Character.isUnicodeIdentifierPart(this.text.charAt(this.index))) {
                        char c2;
                        if (Character.isIdentifierIgnorable(c2 = this.text.charAt(this.index++))) continue;
                        this.idValue = this.idValue + Character.toLowerCase(c2);
                    }
                    this.token = 0;
                    return;
                }
            }
        }
        this.token = 6;
    }
}

