/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class ExcludeListUpdateHandler {
    private File localFile;
    private long localFileLastModified;
    private URL remoteURL;
    private long remoteURLLastModified;

    public ExcludeListUpdateHandler(URL uRL, File file) {
        if (uRL == null || file == null) {
            throw new NullPointerException();
        }
        this.remoteURL = uRL;
        this.localFile = file;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public long getLocalFileLastModified() {
        if (this.localFileLastModified == 0L) {
            this.localFileLastModified = this.localFile.lastModified();
        }
        return this.localFileLastModified;
    }

    public URL getRemoteURL() {
        return this.remoteURL;
    }

    public long getRemoteURLLastModified() throws IOException {
        if (this.remoteURLLastModified == 0L) {
            URLConnection uRLConnection = this.remoteURL.openConnection();
            uRLConnection.connect();
            this.remoteURLLastModified = uRLConnection.getLastModified();
            uRLConnection.getInputStream().close();
        }
        return this.remoteURLLastModified;
    }

    public boolean isUpdateAvailable() throws IOException {
        this.getLocalFileLastModified();
        this.getRemoteURLLastModified();
        return this.remoteURLLastModified > this.localFileLastModified;
    }

    public void update() throws IOException {
        this.update(this.remoteURL.openConnection());
    }

    public void updateIfNewer() throws IOException {
        URLConnection uRLConnection = this.remoteURL.openConnection();
        uRLConnection.getContentLength();
        uRLConnection.connect();
        this.remoteURLLastModified = uRLConnection.getLastModified();
        if (this.remoteURLLastModified > this.getLocalFileLastModified()) {
            this.update(uRLConnection);
        } else {
            uRLConnection.getInputStream().close();
        }
    }

    private void update(URLConnection uRLConnection) throws IOException {
        int n;
        uRLConnection.connect();
        int n2 = uRLConnection.getContentLength();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.localFile));
        int n3 = 0;
        byte[] byArray = new byte[4096];
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            int n4 = Math.max((n3 += n) * 100 / n2, 100);
        }
        ((InputStream)bufferedInputStream).close();
        ((OutputStream)bufferedOutputStream).close();
    }
}

