/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class ExcludeList {
    public static final int NO_CHECKSUM = 0;
    public static final int BAD_CHECKSUM = 1;
    public static final int GOOD_CHECKSUM = 2;
    private Map table = new HashMap();
    private int checksumState;
    private String title;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$ExcludeList == null ? (class$com$sun$javatest$ExcludeList = ExcludeList.class$("com.sun.javatest.ExcludeList")) : class$com$sun$javatest$ExcludeList);
    public static final String EXCLUDEFILE_EXTN = ".jtx";
    static /* synthetic */ Class class$com$sun$javatest$ExcludeList;

    public static boolean isExcludeFile(File file) {
        return file.getPath().endsWith(EXCLUDEFILE_EXTN);
    }

    public ExcludeList() {
        this.checksumState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcludeList(File file) throws FileNotFoundException, IOException, Fault {
        if (file != null) {
            long l;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Parser parser = new Parser(bufferedReader);
            try {
                Entry entry;
                while ((entry = parser.readEntry()) != null) {
                    this.addEntry(entry);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            long l2 = parser.getChecksum();
            this.checksumState = l2 == 0L ? 0 : (l2 == (l = this.computeChecksum()) ? 2 : 1);
            this.title = parser.getTitle();
        }
    }

    public ExcludeList(File[] fileArray) throws FileNotFoundException, IOException, Fault {
        this.checksumState = 2;
        int n = 0;
        while (n < fileArray.length) {
            ExcludeList excludeList = new ExcludeList(fileArray[n]);
            this.merge(excludeList);
            ++n;
        }
    }

    public boolean excludesAllOf(TestDescription testDescription) {
        return this.excludesAllOf(testDescription.getRootRelativeURL());
    }

    public boolean excludesAllOf(String string) {
        Object v = this.table.get(new Key(string));
        return v != null && v instanceof Entry && ((Entry)v).testCase == null;
    }

    public boolean excludesAnyOf(TestDescription testDescription) {
        return this.excludesAnyOf(testDescription.getRootRelativeURL());
    }

    public boolean excludesAnyOf(String string) {
        Object v = this.table.get(new Key(string));
        return v != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTestCases(TestDescription testDescription) {
        Key key = new Key(testDescription.getRootRelativeURL());
        Map map = this.table;
        synchronized (map) {
            Object v = this.table.get(key);
            if (v == null) {
                return null;
            }
            if (v instanceof Entry) {
                Entry entry = (Entry)v;
                if (entry.testCase == null) {
                    return null;
                }
                return new String[]{entry.testCase};
            }
            Entry[] entryArray = (Entry[])v;
            String[] stringArray = new String[entryArray.length];
            int n = 0;
            while (n < entryArray.length) {
                stringArray[n] = entryArray[n].testCase;
                ++n;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEntry(Entry entry) throws Fault {
        Map map = this.table;
        synchronized (map) {
            Key key = new Key(entry.relativeURL);
            Object v = this.table.get(key);
            if (v == null) {
                this.table.put(key, entry);
            } else if (v instanceof Entry) {
                Entry entry2 = (Entry)v;
                if (entry2.testCase == null) {
                    if (entry.testCase != null) throw new Fault(i18n, "excl.cantExcludeCase", entry.relativeURL);
                    this.table.put(key, entry);
                } else {
                    if (entry.testCase == null) {
                        throw new Fault(i18n, "excl.cantExcludeTest", entry.relativeURL);
                    }
                    if (entry2.testCase.equals(entry.testCase)) {
                        this.table.put(key, entry);
                    } else {
                        this.table.put(key, new Entry[]{entry2, entry});
                    }
                }
            } else {
                if (entry.testCase == null) {
                    throw new Fault(i18n, "excl.cantExcludeTest", entry.relativeURL);
                }
                Object[] objectArray = (Entry[])v;
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n].testCase.equals(entry.testCase)) {
                        objectArray[n] = entry;
                        return;
                    }
                    ++n;
                }
                this.table.put(key, DynamicArray.append(objectArray, entry));
            }
            this.checksumState = 0;
            return;
        }
    }

    public Entry getEntry(String string) {
        int n;
        String string2 = null;
        if (string.endsWith("]") && (n = string.lastIndexOf("[")) != -1) {
            string2 = string.substring(n + 1, string.length() - 1);
            string = string.substring(0, n);
        }
        return this.getEntry(string, string2);
    }

    public Entry getEntry(String string, String string2) {
        Key key = new Key(string);
        Object v = this.table.get(key);
        if (v == null) {
            return null;
        }
        if (v instanceof Entry) {
            Entry entry = (Entry)v;
            if (string2 == null) {
                return entry;
            }
            return ExcludeList.isInList(entry.testCase, string2) ? entry : null;
        }
        Entry[] entryArray = (Entry[])v;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            if (ExcludeList.isInList(entry.testCase, string2)) {
                return entry;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ExcludeList excludeList) {
        Map map = this.table;
        synchronized (map) {
            Iterator iterator = excludeList.getIterator(false);
            while (iterator.hasNext()) {
                Object object;
                Entry entry = (Entry)iterator.next();
                Key key = new Key(entry.relativeURL);
                Object v = this.table.get(key);
                if (v == null) {
                    this.table.put(key, entry);
                    continue;
                }
                if (v instanceof Entry) {
                    object = (Entry)v;
                    if (((Entry)object).testCase == null || entry.testCase == null) {
                        this.table.put(key, new Entry(((Entry)object).relativeURL, null, ExcludeList.mergeBugIds(((Entry)object).bugIds, entry.bugIds), ExcludeList.mergePlatforms(((Entry)object).platforms, entry.platforms), ExcludeList.mergeSynopsis(((Entry)object).synopsis, entry.synopsis)));
                        continue;
                    }
                    this.table.put(key, new Entry[]{object, entry});
                    continue;
                }
                if (entry.testCase == null) {
                    object = entry.bugIds;
                    String[] stringArray = entry.platforms;
                    String string = entry.synopsis;
                    Entry[] entryArray = (Entry[])v;
                    int n = 0;
                    while (n < entryArray.length) {
                        object = ExcludeList.mergeBugIds((int[])object, entryArray[n].bugIds);
                        stringArray = ExcludeList.mergePlatforms(stringArray, entryArray[n].platforms);
                        string = ExcludeList.mergeSynopsis(string, entryArray[n].synopsis);
                        ++n;
                    }
                    this.table.put(key, new Entry(entry.relativeURL, null, (int[])object, stringArray, string));
                    continue;
                }
                this.table.put(key, (Entry[])DynamicArray.append((Entry[])v, entry));
            }
        }
        this.checksumState = Math.min(this.checksumState, excludeList.getChecksumState());
    }

    private static int[] mergeBugIds(int[] nArray, int[] nArray2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        while (n < nArray.length) {
            treeSet.add(new Integer(nArray[n]));
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            treeSet.add(new Integer(nArray2[n2]));
            ++n2;
        }
        int[] nArray3 = new int[treeSet.size()];
        int n3 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            nArray3[n3++] = (Integer)iterator.next();
        }
        return nArray3;
    }

    private static String[] mergePlatforms(String[] stringArray, String[] stringArray2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            treeSet.add(stringArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            treeSet.add(stringArray2[n2]);
            ++n2;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    private static String mergeSynopsis(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        if (string.indexOf(string2) != -1) {
            return string;
        }
        if (string2.indexOf(string) != -1) {
            return string2;
        }
        return string + "; " + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Entry entry) {
        Map map = this.table;
        synchronized (map) {
            Key key = new Key(entry.relativeURL);
            Object v = this.table.get(key);
            if (v == null) {
                return;
            }
            if (v instanceof Entry) {
                if (v == entry) {
                    this.table.remove(key);
                }
            } else {
                Entry[] entryArray = (Entry[])DynamicArray.remove((Object[])((Entry[])v), entry);
                if (entryArray == v) {
                    return;
                }
                if (entryArray.length == 1) {
                    this.table.put(key, entryArray[0]);
                } else {
                    this.table.put(key, entryArray);
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof Entry[]) {
                n += ((Entry[])v).length;
                continue;
            }
            ++n;
        }
        return n;
    }

    public Iterator getIterator(boolean bl) {
        if (bl) {
            return this.table.values().iterator();
        }
        Vector<Object> vector = new Vector<Object>(this.table.size());
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof Entry) {
                vector.addElement(v);
                continue;
            }
            Entry[] entryArray = (Entry[])v;
            int n = 0;
            while (n < entryArray.length) {
                vector.addElement(entryArray[n]);
                ++n;
            }
        }
        return vector.iterator();
    }

    public int getChecksumState() {
        return this.checksumState;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void write(File file) throws IOException {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TreeSet<Entry> treeSet = new TreeSet<Entry>();
        Iterator iterator = this.getIterator(false);
        while (iterator.hasNext()) {
            object = (Entry)iterator.next();
            treeSet.add((Entry)object);
            n = ((Entry)object).testCase == null ? Math.max(((Entry)object).relativeURL.length(), n) : Math.max(((Entry)object).relativeURL.length() + ((Entry)object).testCase.length() + 2, n);
            n2 = Math.max(this.bugIdsToString((Entry)object).length(), n2);
            n3 = Math.max(this.platformsToString((Entry)object).length(), n3);
        }
        object = new BufferedWriter(new FileWriter(file));
        ((Writer)object).write("# Exclude List");
        ((BufferedWriter)object).newLine();
        ((Writer)object).write("# SCCS %W% %E%");
        ((BufferedWriter)object).newLine();
        if (this.title != null) {
            ((Writer)object).write("### title " + this.title);
            ((BufferedWriter)object).newLine();
        }
        ((Writer)object).write("### checksum ");
        long l = this.computeChecksum();
        if (l < 0L) {
            ((Writer)object).write("-");
        }
        ((Writer)object).write(Long.toHexString(Math.abs(l)));
        ((BufferedWriter)object).newLine();
        Iterator iterator2 = treeSet.iterator();
        while (iterator2.hasNext()) {
            Entry entry = (Entry)iterator2.next();
            if (entry.testCase == null) {
                this.write((Writer)object, entry.relativeURL, n + 2);
            } else {
                this.write((Writer)object, entry.relativeURL + "[" + entry.testCase + "]", n + 2);
            }
            this.write((Writer)object, this.bugIdsToString(entry), n2 + 2);
            this.write((Writer)object, this.platformsToString(entry), n3 + 2);
            ((Writer)object).write(entry.synopsis);
            ((BufferedWriter)object).newLine();
        }
        ((BufferedWriter)object).close();
    }

    private long computeChecksum() {
        long l = 0L;
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof Entry) {
                l += ((Entry)v).computeChecksum();
                continue;
            }
            Entry[] entryArray = (Entry[])v;
            int n = 0;
            while (n < entryArray.length) {
                l += entryArray[n].computeChecksum();
                ++n;
            }
        }
        if (l == 0L) {
            l = 1L;
        }
        return Math.abs(l);
    }

    private void write(Writer writer, String string, int n) throws IOException {
        writer.write(string);
        int n2 = string.length();
        while (n2 < n) {
            writer.write(32);
            ++n2;
        }
    }

    private String bugIdsToString(Entry entry) {
        StringBuffer stringBuffer = new StringBuffer(entry.bugIds.length * 10);
        stringBuffer.append(entry.bugIds[0]);
        int n = 1;
        while (n < entry.bugIds.length) {
            stringBuffer.append(',');
            stringBuffer.append(entry.bugIds[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String platformsToString(Entry entry) {
        StringBuffer stringBuffer = new StringBuffer(entry.bugIds.length * 10);
        stringBuffer.append(entry.platforms[0]);
        int n = 1;
        while (n < entry.platforms.length) {
            stringBuffer.append(',');
            stringBuffer.append(entry.platforms[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean equals(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    private static boolean isInList(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string.indexOf(string2);
        while (n != -1) {
            if (!(n != 0 && string.charAt(n - 1) != ',' || n + string2.length() != string.length() && string.charAt(n + string2.length()) != ',')) {
                return true;
            }
            n = string.indexOf(string2, n + 1);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Entry
    implements Comparable {
        private String relativeURL;
        private String testCase;
        private int[] bugIds;
        private String[] platforms;
        private String synopsis;

        public Entry(String string, String string2, int[] nArray, String[] stringArray, String string3) {
            if (nArray == null || stringArray == null) {
                throw new NullPointerException();
            }
            if (nArray.length == 0 && stringArray.length > 0) {
                throw new IllegalArgumentException();
            }
            this.relativeURL = string;
            this.testCase = string2;
            this.bugIds = nArray;
            this.platforms = stringArray;
            this.synopsis = string3;
        }

        public int compareTo(Object object) {
            Entry entry = (Entry)object;
            int n = this.relativeURL.compareTo(entry.relativeURL);
            if (n == 0) {
                if (this.testCase == null && entry.testCase == null) {
                    return 0;
                }
                if (this.testCase == null) {
                    return -1;
                }
                if (entry.testCase == null) {
                    return 1;
                }
                return this.testCase.compareTo(entry.testCase);
            }
            return n;
        }

        public String getRelativeURL() {
            return this.relativeURL;
        }

        public String getTestCases() {
            return this.testCase;
        }

        public String[] getTestCaseList() {
            if (this.testCase == null) {
                return null;
            }
            Vector<String> vector = new Vector<String>();
            int n = -1;
            int n2 = 0;
            while (n2 < this.testCase.length()) {
                if (this.testCase.charAt(n2) == ',') {
                    if (n != -1) {
                        vector.addElement(this.testCase.substring(n, n2));
                    }
                    n = -1;
                } else if (n == -1) {
                    n = n2;
                }
                ++n2;
            }
            if (n != -1) {
                vector.addElement(this.testCase.substring(n));
            }
            if (vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public int[] getBugIds() {
            return this.bugIds;
        }

        public String[] getPlatforms() {
            return this.platforms;
        }

        public String getSynopsis() {
            return this.synopsis;
        }

        public static Entry read(String string) throws Fault {
            try {
                return new Parser(new StringReader(string)).readEntry();
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "excl.badEntry", iOException);
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return Entry.equals(this.relativeURL, entry.relativeURL) && Entry.equals(this.testCase, entry.testCase) && Entry.equals(this.bugIds, entry.bugIds) && Entry.equals(this.platforms, entry.platforms) && Entry.equals(this.synopsis, entry.synopsis);
            }
            return false;
        }

        public int hashCode() {
            return this.relativeURL.hashCode();
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.relativeURL);
            if (this.testCase != null) {
                stringBuffer.append('[');
                stringBuffer.append(this.testCase);
                stringBuffer.append(']');
            }
            if (this.bugIds != null) {
                n = 0;
                while (n < this.bugIds.length) {
                    stringBuffer.append(n == 0 ? (char)' ' : ',');
                    stringBuffer.append(this.bugIds[n]);
                    ++n;
                }
            }
            if (this.platforms != null) {
                n = 0;
                while (n < this.platforms.length) {
                    stringBuffer.append(n == 0 ? (char)' ' : ',');
                    stringBuffer.append(this.platforms[n]);
                    ++n;
                }
            }
            if (this.synopsis != null) {
                stringBuffer.append(' ');
                stringBuffer.append(this.synopsis);
            }
            return new String(stringBuffer);
        }

        long computeChecksum() {
            long l = this.computeChecksum(this.relativeURL);
            if (this.testCase != null) {
                l = l * 37L + this.computeChecksum(this.testCase);
            }
            int n = 0;
            while (n < this.bugIds.length) {
                l = l * 37L + (long)this.bugIds[n];
                ++n;
            }
            int n2 = 0;
            while (n2 < this.platforms.length) {
                l = l * 37L + this.computeChecksum(this.platforms[n2]);
                ++n2;
            }
            l = l * 37L + this.computeChecksum(this.synopsis);
            return l;
        }

        private long computeChecksum(String string) {
            long l = 0L;
            int n = 0;
            while (n < string.length()) {
                l = l * 37L + (long)string.charAt(n);
                ++n;
            }
            return l;
        }

        private static boolean equals(int[] nArray, int[] nArray2) {
            if (nArray == null || nArray2 == null) {
                return nArray == null && nArray2 == null;
            }
            if (nArray.length != nArray2.length) {
                return false;
            }
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != nArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private static boolean equals(String[] stringArray, String[] stringArray2) {
            if (stringArray == null || stringArray2 == null) {
                return stringArray == null && stringArray2 == null;
            }
            if (stringArray.length != stringArray2.length) {
                return false;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (!Entry.equals(stringArray[n], stringArray2[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private static boolean equals(String string, String string2) {
            return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
        }
    }

    private static class Key {
        private static final char sep = File.separatorChar;
        private String relativeURL;
        private int hash;

        Key(String string) {
            this.relativeURL = string;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                int n2 = this.relativeURL.length();
                int n3 = 0;
                while (n3 < n2) {
                    char c = Character.toLowerCase(this.relativeURL.charAt(n3));
                    if (c == sep) {
                        c = '/';
                    }
                    n = 31 * n + c;
                    ++n3;
                }
                this.hash = n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Key)) {
                return false;
            }
            String string = this.relativeURL;
            String string2 = ((Key)object).relativeURL;
            int n = string.length();
            if (n != string2.length()) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                char c;
                char c2 = Character.toLowerCase(string.charAt(n2));
                if (c2 == sep) {
                    c2 = '/';
                }
                if ((c = Character.toLowerCase(string2.charAt(n2))) == sep) {
                    c = '/';
                }
                if (c2 != c) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    private static final class Parser {
        private Reader in;
        private int ch;
        private Map platformCache = new HashMap();
        private long checksum;
        private String title;

        Parser(Reader reader) throws IOException {
            this.in = reader;
            this.ch = reader.read();
        }

        long getChecksum() {
            return this.checksum;
        }

        String getTitle() {
            return this.title;
        }

        Entry readEntry() throws IOException, Fault {
            int n;
            String string = this.readURL();
            if (string == null) {
                return null;
            }
            String string2 = null;
            if (string.endsWith("]") && (n = string.lastIndexOf("[")) != -1) {
                string2 = string.substring(n + 1, string.length() - 1);
                string = string.substring(0, n);
            }
            int[] nArray = this.readBugIds();
            String[] stringArray = this.readPlatforms();
            String string3 = this.readRest();
            return new Entry(string, string2, nArray, stringArray, string3);
        }

        private boolean isEndOfLine(int n) {
            return n == -1 || n == 10 || n == 13;
        }

        private boolean isWhitespace(int n) {
            return n == 32 || n == 9;
        }

        private String readURL() throws IOException, Fault {
            block5: while (true) {
                this.skipWhite();
                switch (this.ch) {
                    case -1: {
                        return null;
                    }
                    case 35: {
                        this.skipComment();
                        continue block5;
                    }
                    case 10: 
                    case 13: {
                        this.ch = this.in.read();
                        continue block5;
                    }
                }
                break;
            }
            return this.readWord();
        }

        private int[] readBugIds() throws IOException {
            this.skipWhite();
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            int n = 0;
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                if (Character.isDigit((char)this.ch)) {
                    n = n * 10 + Character.digit((char)this.ch, 10);
                } else if (this.ch == 44) {
                    treeSet.add(new Integer(n));
                    n = 0;
                }
                this.ch = this.in.read();
            }
            treeSet.add(new Integer(n));
            if (treeSet.size() == 0) {
                treeSet.add(new Integer(0));
            }
            int[] nArray = new int[treeSet.size()];
            int n2 = 0;
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                nArray[n2++] = (Integer)iterator.next();
            }
            return nArray;
        }

        private String[] readPlatforms() throws IOException {
            this.skipWhite();
            String string = this.readWord();
            String[] stringArray = (String[])this.platformCache.get(string);
            if (stringArray == null) {
                int n = 0;
                int n2 = 0;
                while (n2 < string.length()) {
                    if (string.charAt(n2) == ',') {
                        ++n;
                    }
                    ++n2;
                }
                TreeSet<String> treeSet = new TreeSet<String>();
                int n3 = 0;
                int n4 = string.indexOf(44);
                while (n4 != -1) {
                    treeSet.add(string.substring(n3, n4));
                    n3 = n4 + 1;
                    n4 = string.indexOf(44, n3);
                }
                treeSet.add(string.substring(n3));
                stringArray = treeSet.toArray(new String[treeSet.size()]);
                this.platformCache.put(string, stringArray);
            }
            return stringArray;
        }

        private String readRest() throws IOException {
            this.skipWhite();
            StringBuffer stringBuffer = new StringBuffer(80);
            while (!this.isEndOfLine(this.ch)) {
                stringBuffer.append((char)this.ch);
                this.ch = this.in.read();
            }
            this.ch = this.in.read();
            return stringBuffer.toString();
        }

        private void readCheckSum() throws IOException {
            this.skipWhite();
            String string = this.readWord();
            try {
                this.checksum = Long.parseLong(string, 16);
                this.skipWhite();
                if (!this.isEndOfLine(this.ch)) {
                    throw new IOException("extra text after checksum in exclude list");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("badly-formed checksum in exclude list: " + string);
            }
        }

        private String readWord() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(32);
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                stringBuffer.append((char)this.ch);
                this.ch = this.in.read();
            }
            return stringBuffer.toString();
        }

        /*
         * Unable to fully structure code
         */
        private void skipComment() throws IOException, Fault {
            this.ch = this.in.read();
            if (this.ch != 35) ** GOTO lbl16
            this.ch = this.in.read();
            if (this.ch != 35) ** GOTO lbl16
            this.ch = this.in.read();
            this.skipWhite();
            var1_1 = this.readWord();
            if (var1_1.equalsIgnoreCase("checksum")) {
                this.readCheckSum();
                return;
            }
            if (!var1_1.equals("title")) ** GOTO lbl16
            this.skipWhite();
            this.title = this.readRest();
            return;
lbl-1000:
            // 1 sources

            {
                this.ch = this.in.read();
lbl16:
                // 4 sources

                ** while (!this.isEndOfLine((int)this.ch))
            }
lbl17:
            // 1 sources

        }

        private void skipWhite() throws IOException {
            while (this.ch != -1 && this.isWhitespace(this.ch)) {
                this.ch = this.in.read();
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }
    }
}

