/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;

public class EditJTI {
    private InterviewParameters interview;
    private boolean verbose;
    private PrintWriter out;
    private static int MAX_INDENT = Integer.getInteger("EditJTI.maxIndent", 32);
    private static int NUM_BACKUPS = Integer.getInteger("EditJTI.numBackups", 2);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$EditJTI == null ? (class$com$sun$javatest$EditJTI = EditJTI.class$("com.sun.javatest.EditJTI")) : class$com$sun$javatest$EditJTI);
    static /* synthetic */ Class class$com$sun$javatest$EditJTI;

    public static void main(String[] stringArray) {
        try {
            EditJTI editJTI = new EditJTI();
            boolean bl = editJTI.run(stringArray);
            System.exit(bl ? 0 : 1);
        }
        catch (BadArgs badArgs) {
            System.err.println(badArgs.getMessage());
            EditJTI.usage(System.err);
            System.exit(2);
        }
        catch (Fault fault) {
            System.err.println(fault.getMessage());
            System.exit(3);
        }
    }

    public static void usage(PrintStream printStream) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$EditJTI == null ? (class$com$sun$javatest$EditJTI = EditJTI.class$("com.sun.javatest.EditJTI")) : class$com$sun$javatest$EditJTI).getName());
        printStream.println(i18n.getString("editJTI.usage.title"));
        printStream.print("  ");
        printStream.print(string);
        printStream.println(i18n.getString("editJTI.usage.summary"));
        printStream.println(i18n.getString("editJTI.usage.options"));
        printStream.println(i18n.getString("editJTI.usage.help1"));
        printStream.println(i18n.getString("editJTI.usage.help2"));
        printStream.println(i18n.getString("editJTI.usage.help3"));
        printStream.println(i18n.getString("editJTI.usage.classpath1"));
        printStream.println(i18n.getString("editJTI.usage.classpath2"));
        printStream.println(i18n.getString("editJTI.usage.log1"));
        printStream.println(i18n.getString("editJTI.usage.log2"));
        printStream.println(i18n.getString("editJTI.usage.outfile1"));
        printStream.println(i18n.getString("editJTI.usage.outfile2"));
        printStream.println(i18n.getString("editJTI.usage.path1"));
        printStream.println(i18n.getString("editJTI.usage.path2"));
        printStream.println(i18n.getString("editJTI.usage.preview1"));
        printStream.println(i18n.getString("editJTI.usage.preview2"));
        printStream.println(i18n.getString("editJTI.usage.ts1"));
        printStream.println(i18n.getString("editJTI.usage.ts2"));
        printStream.println(i18n.getString("editJTI.usage.verbose1"));
        printStream.println(i18n.getString("editJTI.usage.verbose2"));
        printStream.println("");
        printStream.println(i18n.getString("editJTI.usage.edit"));
        printStream.println(i18n.getString("editJTI.usage.set"));
        printStream.println(i18n.getString("editJTI.usage.search"));
        printStream.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] stringArray) throws BadArgs, Fault {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            boolean bl = this.run(stringArray, printWriter);
            Object var5_4 = null;
            printWriter.flush();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            printWriter.flush();
            throw throwable;
        }
    }

    public boolean run(String[] stringArray, PrintWriter printWriter) throws BadArgs, Fault {
        Object object;
        boolean bl;
        boolean bl2;
        String[] stringArray2;
        File file;
        File file2;
        File file3;
        block51: {
            file3 = null;
            file2 = null;
            file = null;
            File file4 = null;
            File file5 = null;
            stringArray2 = null;
            boolean bl3 = false;
            bl2 = false;
            bl = false;
            boolean bl4 = false;
            int n = 0;
            while (n < stringArray.length) {
                if ((stringArray[n].equals("-o") || stringArray[n].equals("-out")) && n + 1 < stringArray.length) {
                    file2 = new File(stringArray[++n]);
                } else if ((stringArray[n].equals("-l") || stringArray[n].equals("log")) && n + 1 < stringArray.length) {
                    file = new File(stringArray[++n]);
                } else if (stringArray[n].equals("-n") || stringArray[n].equals("-preview")) {
                    bl2 = true;
                } else if (stringArray[n].equals("-p") || stringArray[n].equals("-path")) {
                    bl = true;
                } else if (stringArray[n].equals("-v") || stringArray[n].equals("-verbose")) {
                    bl4 = true;
                } else if ((stringArray[n].equals("-cp") || stringArray[n].equals("-classpath")) && n + 1 < stringArray.length) {
                    file4 = new File(stringArray[++n]);
                } else if ((stringArray[n].equals("-ts") || stringArray[n].equals("-testsuite")) && n + 1 < stringArray.length) {
                    file5 = new File(stringArray[++n]);
                } else if (stringArray[n].equals("-help") || stringArray[n].equals("-usage") || stringArray[n].equals("/?")) {
                    bl3 = true;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        throw new BadArgs((ResourceBundle)i18n, "editJTI.badOption", stringArray[n]);
                    }
                    if (n <= stringArray.length - 1) {
                        stringArray2 = new String[stringArray.length - 1 - n];
                        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
                        file3 = new File(stringArray[stringArray.length - 1]);
                        n = stringArray.length - 1;
                    } else {
                        throw new BadArgs((ResourceBundle)i18n, "editJTI.badOption", stringArray[n]);
                    }
                }
                ++n;
            }
            if (stringArray.length == 0 || bl3) {
                EditJTI.usage(System.out);
                if (file3 == null) {
                    return true;
                }
            }
            if (file4 != null && file5 != null) {
                throw new BadArgs(i18n, "editJTI.cantHaveClassPathAndTestSuite");
            }
            if (file3 == null) {
                throw new BadArgs(i18n, "editJTI.noInterview");
            }
            this.verbose = bl4;
            this.out = printWriter;
            try {
                if (file5 != null) {
                    try {
                        object = TestSuite.open(file5);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new Fault(i18n, "editJTI.cantFindTestSuite", file5);
                    }
                    catch (TestSuite.NotTestSuiteFault notTestSuiteFault) {
                        throw new Fault(i18n, "editJTI.notATestSuite", file5);
                    }
                    catch (TestSuite.Fault fault) {
                        throw new Fault(i18n, "editJTI.cantOpenTestSuite", new Object[]{file5, fault});
                    }
                    this.load(file3, (TestSuite)object);
                    break block51;
                }
                if (file4 != null) {
                    object = new URLClassLoader(new URL[]{file4.toURL()});
                    this.load(file3, (URLClassLoader)object);
                } else {
                    this.load(file3);
                }
            }
            catch (Interview.Fault fault) {
                throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{file3.getPath(), fault.getMessage()});
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Fault(i18n, "editJTI.cantFindFile", file3.getPath());
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{file3.getPath(), iOException});
            }
        }
        if (NUM_BACKUPS > 0) {
            this.interview.setBackupPolicy(BackupPolicy.simpleBackups(NUM_BACKUPS));
        }
        if (stringArray2 != null) {
            this.edit(stringArray2);
        }
        if (bl) {
            this.showPath();
        }
        try {
            if (file != null) {
                if (bl2) {
                    object = i18n.getString("editJTI.wouldWriteLog", file);
                    printWriter.println((String)object);
                } else {
                    this.writeLog(file);
                }
            }
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "editJTI.cantWriteLog", new Object[]{file.getPath(), iOException});
        }
        try {
            if (bl2) {
                object = this.interview.isEdited() ? i18n.getString("editJTI.wouldSaveEdited", file2 != null ? file2 : file3) : (file2 != null ? i18n.getString("editJTI.wouldSaveNotEdited", file2) : i18n.getString("editJTI.wouldNotSave"));
                printWriter.println((String)object);
            } else if (file2 != null) {
                this.save(file2);
            } else if (this.interview.isEdited()) {
                this.save(file3);
            }
        }
        catch (Interview.Fault fault) {
            throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{file2.getPath(), fault});
        }
        catch (IOException iOException) {
            File file6 = file2 == null ? this.interview.getFile() : file2;
            throw new Fault(i18n, "editJTI.cantSaveFile", new Object[]{file6.getPath(), iOException});
        }
        return this.interview.isFinishable();
    }

    public void load(File file) throws IOException, Interview.Fault {
        this.interview = InterviewParameters.open(file);
        this.interview.setEdited(false);
    }

    public void load(File file, TestSuite testSuite) throws IOException, Interview.Fault, Fault {
        try {
            this.interview = testSuite.createInterview();
        }
        catch (TestSuite.Fault fault) {
            throw new Fault(i18n, "editJTI.cantCreateInterviewForTestSuite", new Object[]{testSuite.getPath(), fault.getMessage()});
        }
        this.interview.load(file);
        this.interview.setEdited(false);
    }

    public void load(File file, URLClassLoader uRLClassLoader) throws IOException, Interview.Fault, Fault {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Properties properties = new Properties();
        properties.load(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        String string = (String)properties.get("INTERVIEW");
        try {
            Class<?> clazz = uRLClassLoader.loadClass(string);
            this.interview = (InterviewParameters)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new Fault(i18n, "editJTI.invalidInterview", file);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault(i18n, "editJTI.cantFindClass", new Object[]{string, file});
        }
        catch (InstantiationException instantiationException) {
            throw new Fault(i18n, "editJTI.cantInstantiateClass", new Object[]{string, file});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault(i18n, "editJTI.cantAccessClass", new Object[]{string, file});
        }
        this.interview.load(file);
        this.interview.setEdited(false);
    }

    public void save(File file) throws IOException, Interview.Fault {
        this.interview.save(file);
    }

    public void showPath() {
        Question[] questionArray = this.interview.getPath();
        int n = 0;
        int n2 = 0;
        while (n2 < questionArray.length) {
            n = Math.max(n, questionArray[n2].getTag().length());
            ++n2;
        }
        n = Math.min(n, MAX_INDENT);
        int n3 = 0;
        while (n3 < questionArray.length) {
            Question question = questionArray[n3];
            String string = question.getTag();
            String string2 = question.getStringValue();
            this.out.print(string);
            int n4 = string.length();
            if (n4 > MAX_INDENT && string2 != null && string2.length() > 0) {
                this.out.println();
                n4 = 0;
            }
            int n5 = n4;
            while (n5 < n) {
                this.out.print(' ');
                ++n5;
            }
            this.out.print(' ');
            this.out.println(string2 == null ? "" : string2);
            ++n3;
        }
    }

    public void writeLog(File file) throws IOException {
        WizPrint wizPrint = new WizPrint(this.interview);
        wizPrint.setShowResponses(true);
        wizPrint.setShowResponseTypes(false);
        wizPrint.setShowTags(true);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        wizPrint.write(bufferedWriter);
    }

    public void edit(String[] stringArray) throws Fault {
        int n = 0;
        while (n < stringArray.length) {
            this.edit(stringArray[n]);
            ++n;
        }
    }

    public void edit(String string) throws Fault {
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.indexOf(61);
        if (Character.isJavaIdentifierStart(string.charAt(0)) && n > 0) {
            this.setValue(string.substring(0, n), string.substring(n + 1));
        } else {
            int n2 = 0;
            char c = string.charAt(n2);
            int n3 = string.indexOf(c, n2 + 1);
            if (n3 == -1) {
                throw new Fault(i18n, "editJTI.badCmd", string);
            }
            int n4 = string.length() - 1;
            if (string.charAt(n4) != c) {
                throw new Fault(i18n, "editJTI.badCmd", string);
            }
            String string2 = string.substring(n2 + 1, n3);
            String string3 = string.substring(n3 + 1, n4);
            if (string2.length() == 0) {
                throw new Fault(i18n, "editJTI.badCmd", string);
            }
            this.setMatchingValues(string2, string3);
        }
    }

    private void setMatchingValues(String string, String string2) throws Fault {
        boolean bl = false;
        Question[] questionArray = this.interview.getPath();
        int n = 0;
        while (n < questionArray.length) {
            int n2;
            Question question = questionArray[n];
            String string3 = question.getStringValue();
            if (string3 != null && (n2 = EditJTI.match(string, string3, false, false)) >= 0) {
                String string4 = string3.substring(0, n2) + string2 + string3.substring(n2 + string.length());
                this.setValue(question, string4);
                bl = true;
                questionArray = this.interview.getPath();
            }
            ++n;
        }
        if (!bl) {
            throw new Fault(i18n, "editJTI.cantFindMatch", string);
        }
    }

    private void setValue(String string, String string2) throws Fault {
        Question[] questionArray = this.interview.getPath();
        int n = 0;
        while (n < questionArray.length) {
            Question question = questionArray[n];
            if (question.getTag().equals(string)) {
                this.setValue(question, string2);
                return;
            }
            ++n;
        }
        throw new Fault(i18n, "editJTI.cantFindQuestion", string);
    }

    private void setValue(Question question, String string) throws Fault {
        try {
            String string2 = question.getStringValue();
            question.setValue(string);
            if (this.verbose) {
                this.out.println(i18n.getString("editJTI.update", new Object[]{question.getTag(), string2, question.getStringValue()}));
            }
        }
        catch (Interview.Fault fault) {
            throw new Fault(i18n, "editJTI.cantSetValue", new Object[]{question.getTag(), fault.getMessage()});
        }
    }

    private static int match(String string, String string2, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        while (n3 <= n2 - n) {
            if (string.regionMatches(!bl, 0, string2, n3, n) && (!bl2 || bl2 && (n3 == 0 || EditJTI.isBoundaryCh(string2.charAt(n3 - 1))) && (n3 + n == string2.length() || EditJTI.isBoundaryCh(string2.charAt(n3 + n))))) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }
}

