/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.wizard.DetailsBrowser;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.InfoPanel;
import com.sun.interview.wizard.PathPanel;
import com.sun.interview.wizard.QuestionPanel;
import com.sun.interview.wizard.SearchDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WizPane
extends JPanel {
    private Listener listener = new Listener();
    private Interview interview;
    private boolean infoEnabled;
    private HelpBroker helpHelpBroker;
    private String helpHelpPrefix = "wizard.";
    private JComponent main;
    private JPanel body;
    private PathPanel pathPanel;
    private QuestionPanel questionPanel;
    private JPanel buttonPanel;
    private InfoPanel infoPanel;
    private SearchDialog searchDialog;
    private DetailsBrowser detailsBrowser;
    private static final KeyStroke detailsKey = KeyStroke.getKeyStroke("shift alt D");
    private static String DETAILS = "details";
    private static String FIND_NEXT = "findNext";
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    static /* synthetic */ Class class$java$awt$Window;

    public WizPane(Interview interview) {
        this(interview, true);
    }

    public WizPane(Interview interview, boolean bl) {
        this.interview = interview;
        this.infoEnabled = bl;
        this.initGUI();
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpHelpBroker = helpBroker;
    }

    public void setHelpPrefix(String string) {
        this.helpHelpPrefix = string;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setButtonPanel(JPanel jPanel) {
        this.buttonPanel = jPanel;
        this.body.add((Component)jPanel, "South");
    }

    public boolean isEdited() {
        this.questionPanel.saveCurrentResponse();
        return this.interview.isEdited();
    }

    public boolean hasInfo() {
        return this.infoPanel != null;
    }

    public boolean isInfoVisible() {
        return this.main instanceof JSplitPane;
    }

    public void setInfoVisible(boolean bl) {
        Container container;
        if (this.infoPanel == null) {
            throw new IllegalStateException();
        }
        if (bl == this.isInfoVisible()) {
            return;
        }
        Dimension dimension = this.body.getSize();
        if (dimension.width == 0) {
            dimension = this.body.getPreferredSize();
        }
        Dimension dimension2 = this.infoPanel.getSize();
        if (dimension2.width == 0) {
            dimension2 = this.infoPanel.getPreferredSize();
        }
        this.remove(this.main);
        if (bl) {
            this.body.setBorder(null);
            container = new JSplitPane(1, this.body, this.infoPanel);
            ((JSplitPane)container).setDividerLocation(dimension.width - 1);
            this.main = container;
            this.infoPanel.setCurrentID(this.interview.getCurrentQuestion());
        } else {
            this.body.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.main = this.body;
        }
        this.add(this.main);
        container = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = WizPane.class$("java.awt.Window")) : class$java$awt$Window, this);
        if (container != null) {
            Dimension dimension3 = container.getSize();
            int n = new JSplitPane().getDividerSize();
            int n2 = dimension3.width;
            ((Window)container).setSize(n2 += (bl ? 1 : -1) * (dimension2.width + n), dimension3.height);
        }
    }

    public void save() {
        this.questionPanel.saveCurrentResponse();
    }

    public void prev() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.interview.prev();
        }
        catch (Interview.Fault fault) {}
    }

    public void next() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.interview.next();
        }
        catch (Interview.Fault fault) {
            this.questionPanel.showValueInvalidMessage();
        }
    }

    public void last() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.interview.last();
        }
        catch (Interview.Fault fault) {
            this.questionPanel.showValueInvalidMessage();
        }
    }

    public void find() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.setVisible(true);
    }

    public void findNext() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.find();
    }

    private void initGUI() {
        this.setInfo(this, "wizPane");
        this.setLayout(new BorderLayout());
        this.questionPanel = new QuestionPanel(this.interview);
        this.questionPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pathPanel = new PathPanel(this.questionPanel, this.interview);
        this.body = new JPanel(new BorderLayout());
        this.body.setName("wizPane.body");
        this.body.setFocusable(false);
        this.body.add((Component)this.pathPanel, "West");
        this.body.add((Component)this.questionPanel, "Center");
        this.body.registerKeyboardAction(this.listener, DETAILS, detailsKey, 1);
        this.body.registerKeyboardAction(this.listener, FIND_NEXT, KeyStroke.getKeyStroke("F3"), 1);
        if (this.infoEnabled && this.interview.getHelpSet() != null) {
            this.infoPanel = new InfoPanel(this.interview);
        }
        if (this.infoPanel == null) {
            this.body.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.main = this.body;
        } else {
            this.body.setBorder(null);
            this.main = new JSplitPane(1, this.body, this.infoPanel);
            this.setInfo(this.main, "wizPane.split");
        }
        this.add(this.main);
    }

    private void setInfo(JComponent jComponent, String string) {
        jComponent.setName(string);
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString(string + ".name"));
        accessibleContext.setAccessibleDescription(i18n.getString(string + ".desc"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(DETAILS)) {
                if (WizPane.this.detailsBrowser == null) {
                    Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = WizPane.class$("java.awt.Window")) : class$java$awt$Window, WizPane.this);
                    HelpSet helpSet = WizPane.this.infoPanel == null ? null : WizPane.this.infoPanel.getHelpSet();
                    WizPane.this.detailsBrowser = new DetailsBrowser(window, WizPane.this.interview, helpSet);
                }
                WizPane.this.detailsBrowser.setVisible(true);
            } else if (string.equals(FIND_NEXT)) {
                WizPane.this.findNext();
            }
        }
    }
}

