/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class StringQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    StringQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        StringQuestion stringQuestion = (StringQuestion)question;
        String[] stringArray = stringQuestion.getSuggestions();
        int n = stringQuestion.getNominalMaxLength();
        if (stringArray == null) {
            if (n > 80) {
                return this.createTextArea(stringQuestion, actionListener);
            }
            return this.createTextField(stringQuestion, actionListener);
        }
        return this.createEditableChoiceList(stringQuestion, actionListener);
    }

    private JPanel createTextArea(final StringQuestion stringQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("str");
        jPanel.setFocusable(false);
        JLabel jLabel = new JLabel(i18n.getString("str.area.lbl"));
        jLabel.setName("str.area.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("str.area.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("str.area.tip"));
        jPanel.add((Component)jLabel, "North");
        final JTextArea jTextArea = new JTextArea(stringQuestion.getValue());
        jTextArea.setName("str");
        jTextArea.setLineWrap(true);
        jTextArea.getDocument().addDocumentListener(new ActionDocListener(jTextArea, actionListener, "edited"));
        jTextArea.setToolTipText(jLabel.getToolTipText());
        jLabel.setLabelFor(jTextArea);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setName("str.sp");
        jScrollPane.setFocusable(false);
        jPanel.add((Component)jScrollPane, "Center");
        Runnable runnable = new Runnable(){

            public void run() {
                stringQuestion.setValue(jTextArea.getText());
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }

    private JPanel createTextField(final StringQuestion stringQuestion, ActionListener actionListener) {
        int n = stringQuestion.getNominalMaxLength();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("str");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (n <= 0) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
        }
        JLabel jLabel = new JLabel(i18n.getString("str.field.lbl"));
        jLabel.setName("str.field.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("str.field.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("str.field.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JTextField jTextField = new JTextField(stringQuestion.getValue());
        jTextField.setName("str");
        jTextField.addActionListener(actionListener);
        jTextField.getDocument().addDocumentListener(new ActionDocListener(jTextField, actionListener, "edited"));
        jTextField.setToolTipText(jLabel.getToolTipText());
        jLabel.setLabelFor(jTextField);
        if (n <= 0) {
            gridBagConstraints.fill = 2;
        } else {
            jTextField.setColumns(n);
        }
        jPanel.add((Component)jTextField, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                stringQuestion.setValue(jTextField.getText());
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }

    private JPanel createEditableChoiceList(final StringQuestion stringQuestion, ActionListener actionListener) {
        Object object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("str");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(i18n.getString("str.chc.lbl"));
        jLabel.setName("str.chc.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("str.chc.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("str.chc.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setName("str.chc");
        jComboBox.setEditable(true);
        jComboBox.setSelectedItem(stringQuestion.getValue());
        jLabel.setLabelFor(jComboBox);
        Component component = jComboBox.getEditor().getEditorComponent();
        if (component instanceof Accessible) {
            if (component.getName() == null) {
                component.setName("str.chc.ed");
            }
            object = component.getAccessibleContext();
            ((AccessibleContext)object).setAccessibleName(i18n.getString("str.chc.ed.name"));
            ((AccessibleContext)object).setAccessibleDescription(i18n.getString("str.chc.ed.desc"));
        }
        object = stringQuestion.getSuggestions();
        int n = 0;
        while (n < ((String[])object).length) {
            jComboBox.addItem(object[n]);
            ++n;
        }
        int n2 = stringQuestion.getNominalMaxLength();
        if (n2 <= 0) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
        } else {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
        }
        jPanel.add(jComboBox, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                stringQuestion.setValue((String)jComboBox.getSelectedItem());
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }
}

