/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PathPanel
extends JScrollPane {
    private QuestionPanel questionPanel;
    private Interview interview;
    private PathList pathList;
    private JList list;
    private String moreText;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public PathPanel(QuestionPanel questionPanel, Interview interview) {
        super(20, 31);
        this.questionPanel = questionPanel;
        this.interview = interview;
        this.moreText = i18n.getString("path.more");
        this.initGUI();
    }

    private void initGUI() {
        this.setName("path.sp");
        this.setFocusable(false);
        PathList pathList = new PathList();
        this.list = new JList(pathList);
        this.setInfo(this.list, "path.list", true);
        this.list.setCellRenderer(pathList);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.list.registerKeyboardAction(pathList, keyStroke, 0);
        this.list.addListSelectionListener(pathList);
        this.list.setPrototypeCellValue("What is a good default to use?");
        this.list.setSelectionMode(0);
        this.getViewport().setView(this.list);
        pathList.currentQuestionChanged(this.interview.getCurrentQuestion());
        this.addAncestorListener(pathList);
    }

    private void setInfo(JComponent jComponent, String string, boolean bl) {
        jComponent.setName(string);
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString(string + ".name"));
        if (bl) {
            String string2 = i18n.getString(string + ".tip");
            jComponent.setToolTipText(string2);
            accessibleContext.setAccessibleDescription(string2);
        } else {
            accessibleContext.setAccessibleDescription(i18n.getString(string + ".desc"));
        }
    }

    private class PathList
    extends AbstractListModel
    implements ActionListener,
    AncestorListener,
    ListCellRenderer,
    ListSelectionListener,
    Interview.Observer {
        private JLabel sample = new JLabel(){

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
        private Question[] currPath = new Question[0];
        private Question currQuestion;
        private int currIndex;

        private PathList() {
        }

        public int getSize() {
            if (this.currPath == null || this.currPath.length == 0) {
                return 0;
            }
            Question question = this.currPath[this.currPath.length - 1];
            boolean bl = !(question instanceof ErrorQuestion) && !(question instanceof FinalQuestion);
            return this.currPath.length + (bl ? 1 : 0);
        }

        public Object getElementAt(int n) {
            return n < this.currPath.length ? this.currPath[n] : PathPanel.this.moreText;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof String) {
                this.sample.setText(" " + (String)object);
                Font font = jList.getFont();
                this.sample.setFont(jList.getFont().deriveFont(2));
            } else {
                Question question = (Question)object;
                this.sample.setText(" " + question.getSummary());
                this.sample.setFont(jList.getFont());
            }
            if (bl) {
                this.sample.setBackground(jList.getSelectionBackground());
                this.sample.setForeground(jList.getSelectionForeground());
            } else {
                this.sample.setBackground(jList.getBackground());
                this.sample.setForeground(jList.getForeground());
            }
            this.sample.setOpaque(true);
            this.sample.setEnabled(jList.isEnabled());
            this.sample.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : null);
            return this.sample;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JList jList = (JList)actionEvent.getSource();
                Object e = jList.getSelectedValue();
                if (e == null || !(e instanceof Question)) break block3;
                Question question = (Question)e;
                if (question == PathPanel.this.interview.getCurrentQuestion()) {
                    return;
                }
                PathPanel.this.questionPanel.saveCurrentResponse();
                try {
                    PathPanel.this.interview.setCurrentQuestion(question);
                }
                catch (Interview.Fault fault) {}
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            Object e = jList.getSelectedValue();
            if (e != null && e instanceof Question) {
                Question question = (Question)e;
                if (question == PathPanel.this.interview.getCurrentQuestion()) {
                    return;
                }
                PathPanel.this.questionPanel.saveCurrentResponse();
                try {
                    PathPanel.this.interview.setCurrentQuestion(question);
                }
                catch (Interview.Fault fault) {}
            } else {
                jList.setSelectedIndex(this.currIndex);
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            PathPanel.this.interview.addObserver(this);
            this.pathUpdated();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            PathPanel.this.interview.removeObserver(this);
        }

        public void pathUpdated() {
            this.update(PathPanel.this.interview.getPath(), PathPanel.this.interview.getCurrentQuestion());
        }

        public void currentQuestionChanged(Question question) {
            int n = this.currIndex;
            this.currQuestion = question;
            if (this.currIndex + 1 < this.currPath.length && this.currPath[this.currIndex + 1] == question) {
                ++this.currIndex;
            } else if (this.currIndex > 0 && this.currPath[this.currIndex - 1] == question) {
                --this.currIndex;
            } else {
                int n2 = 0;
                while (n2 < this.currPath.length) {
                    if (this.currPath[n2] == question) {
                        this.currIndex = n2;
                        break;
                    }
                    ++n2;
                }
            }
            this.fireContentsChanged(this, n, this.currIndex);
            PathPanel.this.list.setSelectedIndex(this.currIndex);
            PathPanel.this.list.ensureIndexIsVisible(this.currIndex);
        }

        public void finished() {
        }

        private void update(Question[] questionArray, Question question) {
            int n;
            Question[] questionArray2 = this.currPath;
            this.currPath = questionArray;
            int n2 = 0;
            while (n2 < Math.min(questionArray2.length, questionArray.length)) {
                if (questionArray2[n2] != questionArray[n2]) break;
                ++n2;
            }
            if (n2 != questionArray2.length || n2 != questionArray.length) {
                n = Math.min(questionArray2.length, questionArray.length);
                if (n2 != n) {
                    this.fireContentsChanged(this, n2, n - 1);
                }
                if (n != questionArray2.length) {
                    this.fireIntervalRemoved(this, n, questionArray2.length - 1);
                }
                if (n != questionArray.length) {
                    this.fireIntervalAdded(this, n, questionArray.length - 1);
                }
            }
            this.currQuestion = question;
            n = 0;
            while (n < this.currPath.length) {
                if (this.currPath[n] == this.currQuestion) {
                    this.currIndex = n;
                    break;
                }
                ++n;
            }
            PathPanel.this.list.setSelectedIndex(this.currIndex);
            PathPanel.this.list.ensureIndexIsVisible(this.currIndex);
        }
    }
}

