/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class IntQuestionRenderer
implements QuestionRenderer {
    private int lwb;
    private int upb;
    private long range;
    private static final KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    IntQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        IntQuestion intQuestion = (IntQuestion)question;
        this.lwb = intQuestion.getLowerBound();
        this.upb = intQuestion.getUpperBound();
        this.range = (long)this.upb - (long)this.lwb;
        if (this.range > 10L) {
            return this.createTextField(intQuestion, actionListener);
        }
        return this.createSlider(intQuestion, actionListener);
    }

    private JPanel createTextField(final IntQuestion intQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("int");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(i18n.getString("int.field.lbl"));
        jLabel.setName("int.field.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("int.field.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("int.field.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        int n = 1;
        while (this.range >= 10L) {
            this.range /= 10L;
            ++n;
        }
        if (this.lwb < 0) {
            ++n;
        }
        String string = intQuestion.getStringValue();
        final JTextField jTextField = new JTextField(string, n);
        jTextField.setName("int.field");
        jTextField.addActionListener(actionListener);
        jTextField.getDocument().addDocumentListener(new ActionDocListener(jTextField, actionListener, "edited"));
        jTextField.setToolTipText(jLabel.getToolTipText());
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    intQuestion.setValue(jTextField.getText());
                }
                catch (Interview.Fault fault) {
                    throw new Error(fault);
                }
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }

    private JPanel createSlider(final IntQuestion intQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("int");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(i18n.getString("int.sldr.lbl"));
        jLabel.setName("int.sldr.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("int.sldr.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("int.sldr.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        int n = intQuestion.isValid() ? intQuestion.getValue() : this.lwb;
        final JSlider jSlider = new JSlider(this.lwb, this.upb, n);
        jSlider.setName("int.sldr");
        jSlider.setMajorTickSpacing((this.upb - this.lwb) / 2);
        jSlider.setMinorTickSpacing(1);
        jSlider.setSnapToTicks(true);
        jSlider.setPaintTicks(true);
        int n2 = intQuestion.getLabelStartHint();
        int n3 = intQuestion.getLabelIncrementHint();
        if (n3 != 0) {
            jSlider.setLabelTable(jSlider.createStandardLabels(n3, n2));
        }
        jSlider.setPaintLabels(true);
        jLabel.setLabelFor(jSlider);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jSlider, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                intQuestion.setValue(jSlider.getValue());
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }
}

