/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.InetAddressQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Keymap;

class InetAddressQuestionRenderer
implements QuestionRenderer {
    private static final KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    InetAddressQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        Object object;
        final InetAddressQuestion inetAddressQuestion = (InetAddressQuestion)question;
        InetAddress inetAddress = inetAddressQuestion.getValue();
        byte[] byArray = inetAddress == null ? new byte[4] : inetAddress.getAddress();
        final JTextField[] jTextFieldArray = new JTextField[4];
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                JTextField jTextField2 = (JTextField)jTextField.getClientProperty("next");
                String string = actionEvent.getActionCommand();
                if (string.equals(".")) {
                    if (jTextField2 != null) {
                        jTextField2.requestFocus();
                        jTextField2.getCaret().setDot(0);
                        jTextField2.getCaret().moveDot(jTextField2.getText().length());
                        return;
                    }
                } else if (Character.isDigit(string.charAt(0))) {
                    int n = jTextField.getCaret().getDot();
                    int n2 = jTextField.getCaret().getMark();
                    String string2 = jTextField.getText();
                    DefaultEditorKit.InsertContentAction insertContentAction = new DefaultEditorKit.InsertContentAction();
                    insertContentAction.actionPerformed(actionEvent);
                    String string3 = jTextField.getText();
                    int n3 = Integer.parseInt(string3);
                    if (string3.length() <= 3 && n3 <= 255) {
                        if (jTextField.getCaretPosition() == 3 && jTextField2 != null) {
                            jTextField2.requestFocus();
                            jTextField2.getCaret().setDot(0);
                            jTextField2.getCaret().moveDot(jTextField2.getText().length());
                        }
                        return;
                    }
                    jTextField.setText(string2);
                    jTextField.getCaret().setDot(n2);
                    jTextField.getCaret().moveDot(n);
                } else if (string.charAt(0) == '\n') {
                    return;
                }
                jTextFieldArray[0].getToolkit().beep();
            }
        };
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("inet");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        while (n < 4) {
            object = n == 0 ? "inet.ip" : "inet.dot";
            JLabel jLabel = new JLabel(i18n.getString((String)object + ".lbl"));
            jLabel.setDisplayedMnemonic(n == 0 ? (int)i18n.getString((String)object + ".mne").charAt(0) : 48 + n);
            jLabel.setToolTipText(i18n.getString((String)object + ".tip"));
            jPanel.add((Component)jLabel, gridBagConstraints);
            int n2 = byArray[n];
            JTextField jTextField = new JTextField(String.valueOf(n2 < 0 ? n2 + 256 : n2), 3);
            jTextField.setName("inet." + n);
            jTextField.setToolTipText(i18n.getString("inet.field.tip", new Integer(n)));
            jTextField.getDocument().addDocumentListener(new ActionDocListener(jTextField, actionListener, "edited"));
            Keymap keymap = JTextField.addKeymap("IP field", jTextField.getKeymap());
            keymap.setDefaultAction(abstractAction);
            jTextField.setKeymap(keymap);
            jLabel.setLabelFor(jTextField);
            if (n == 3) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
            }
            jPanel.add((Component)jTextField, gridBagConstraints);
            if (n > 0) {
                jTextFieldArray[n - 1].putClientProperty("next", jTextField);
            }
            jTextFieldArray[n] = jTextField;
            ++n;
        }
        object = new Runnable(){

            public void run() {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < 4) {
                    object = jTextFieldArray[n].getText();
                    if (object == null || ((String)object).length() == 0) {
                        stringBuffer.append("0");
                    } else {
                        stringBuffer.append((String)object);
                    }
                    if (n < 3) {
                        stringBuffer.append(".");
                    }
                    ++n;
                }
                try {
                    object = InetAddress.getByName(stringBuffer.toString());
                    inetAddressQuestion.setValue((InetAddress)object);
                }
                catch (UnknownHostException unknownHostException) {}
            }
        };
        jPanel.putClientProperty("valueSaver", object);
        return jPanel;
    }
}

