/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FloatQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;

class FloatQuestionRenderer
implements QuestionRenderer {
    private float lwb;
    private float upb;
    private float resolution;
    private float value;
    private float range;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    FloatQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        FloatQuestion floatQuestion = (FloatQuestion)question;
        this.lwb = floatQuestion.getLowerBound();
        this.upb = floatQuestion.getUpperBound();
        this.resolution = floatQuestion.getResolution();
        this.value = floatQuestion.getValue();
        this.range = this.upb - this.lwb;
        return this.createTextField(floatQuestion, actionListener);
    }

    private JPanel createTextField(final FloatQuestion floatQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("flt");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(i18n.getString("flt.field.lbl"));
        jLabel.setName("flt.field.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("flt.field.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("flt.field.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        int n = 1;
        while (this.range >= 10.0f) {
            this.range /= 10.0f;
            ++n;
        }
        if (this.lwb < 0.0f) {
            ++n;
        }
        n += 5;
        n = Math.min(n, 20);
        String string = floatQuestion.getStringValue();
        final JTextField jTextField = new JTextField(string, n);
        jTextField.setName("flt.field");
        jTextField.addActionListener(actionListener);
        jTextField.getDocument().addDocumentListener(new ActionDocListener(jTextField, actionListener, "edited"));
        jTextField.setToolTipText(jLabel.getToolTipText());
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    floatQuestion.setValue(jTextField.getText());
                }
                catch (Interview.Fault fault) {
                    throw new Error(fault);
                }
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }

    private JPanel createSlider(final FloatQuestion floatQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("flt");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(i18n.getString("flt.sldr.lbl"));
        jLabel.setName("flt.sldr.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("flt.sldr.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("flt.sldr.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        int n = (int)((this.upb - this.lwb) / this.resolution);
        int n2 = (int)((this.value - this.lwb) / this.resolution);
        final JSlider jSlider = new JSlider(0, n, n2);
        jSlider.setName("flt");
        jSlider.getAccessibleContext().setAccessibleName(jSlider.getName());
        jSlider.getAccessibleContext().setAccessibleDescription(jSlider.getToolTipText());
        jSlider.setMajorTickSpacing(n / 2);
        jSlider.setMinorTickSpacing(Math.max((int)(1.0f / this.resolution), 1));
        jSlider.setSnapToTicks(true);
        jSlider.setPaintTicks(true);
        float f = floatQuestion.getLabelStartHint();
        float f2 = floatQuestion.getLabelIncrementHint();
        int n3 = (int)((f - this.lwb) / this.resolution);
        int n4 = (int)(f2 / this.resolution);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int n5 = n3;
        while (n5 < n) {
            float f3 = this.lwb + (float)n5 * this.resolution;
            String string = f3 == (float)((int)f3) ? String.valueOf((int)f3) : String.valueOf(f3);
            hashtable.put(new Integer(n5), new JLabel(string));
            n5 += n4;
        }
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintLabels(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jSlider, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                int n = jSlider.getValue();
                floatQuestion.setValue(FloatQuestionRenderer.this.lwb + (float)n * FloatQuestionRenderer.this.resolution);
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }
}

