/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.SwingFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FileQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    FileQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        Serializable serializable;
        Object object;
        final FileQuestion fileQuestion = (FileQuestion)question;
        File file = fileQuestion.getValue();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("file");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(i18n.getString("file.file.lbl"));
        jLabel.setName("file.file.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("file.file.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("file.file.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JTextField jTextField = new JTextField(file == null ? "" : file.getPath());
        jTextField.setName("file.field");
        jTextField.addActionListener(actionListener);
        jTextField.getDocument().addDocumentListener(new ActionDocListener(jTextField, actionListener, "edited"));
        jTextField.setToolTipText(jLabel.getToolTipText());
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jTextField, gridBagConstraints);
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(fileQuestion.getSummary());
        FileFilter[] fileFilterArray = fileQuestion.getFilters();
        if (fileFilterArray == null || fileFilterArray.length == 0) {
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.setFileSelectionMode(0);
        } else {
            int n = -1;
            int n2 = 0;
            while (n2 < fileFilterArray.length) {
                object = fileFilterArray[n2];
                jFileChooser.addChoosableFileFilter(SwingFileFilter.wrap((FileFilter)object));
                if (object.acceptsDirectories()) {
                    if (n == -1) {
                        n = 2;
                    } else if (n == 0) {
                        n = 2;
                    }
                } else if (n == -1) {
                    n = 0;
                } else if (n == 1) {
                    n = 2;
                }
                ++n2;
            }
            jFileChooser.setFileSelectionMode(n);
        }
        String string = jTextField.getText();
        if (string.equals("")) {
            serializable = fileQuestion.getBaseDirectory();
            if (serializable == null) {
                serializable = new File(System.getProperty("user.dir"));
            }
            jFileChooser.setCurrentDirectory((File)serializable);
        } else {
            serializable = new File(string);
            jFileChooser.setSelectedFile((File)serializable);
        }
        serializable = new JButton(i18n.getString("file.browse.btn"));
        ((Component)serializable).setName("file.browse.btn");
        ((AbstractButton)serializable).setMnemonic(i18n.getString("file.browse.mne").charAt(0));
        ((JComponent)serializable).setToolTipText(i18n.getString("file.browse.tip"));
        ((AbstractButton)serializable).addActionListener(new ActionListener((JButton)serializable){
            private final /* synthetic */ JButton val$browseBtn;
            {
                this.val$browseBtn = jButton;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Object object;
                String string = jTextField.getText();
                if (string != null && string.length() > 0) {
                    File file = new File(string);
                    object = fileQuestion.getBaseDirectory();
                    if (!file.isAbsolute() && object != null) {
                        file = new File((File)object, string);
                    }
                    jFileChooser.setSelectedFile(file);
                }
                if ((n = jFileChooser.showDialog(this.val$browseBtn, "Select")) == 0) {
                    String string2;
                    Object object2;
                    object = jFileChooser.getSelectedFile().getPath();
                    FileFilter fileFilter = SwingFileFilter.unwrap(jFileChooser.getFileFilter());
                    if (fileFilter != null && fileFilter instanceof ExtensionFileFilter) {
                        object2 = (ExtensionFileFilter)fileFilter;
                        object = ((ExtensionFileFilter)object2).ensureExtension((String)object);
                    }
                    if ((object2 = fileQuestion.getBaseDirectory()) != null && ((String)object).startsWith((string2 = ((File)object2).getPath()) + File.separatorChar)) {
                        object = ((String)object).substring(string2.length() + 1);
                    }
                    jTextField.setText((String)object);
                }
            }
        });
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)serializable, gridBagConstraints);
        object = new Runnable(){

            public void run() {
                fileQuestion.setValue(new File(jTextField.getText()));
            }
        };
        jPanel.putClientProperty("valueSaver", object);
        return jPanel;
    }
}

