/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class EditableList
extends JPanel {
    private Listener listener = new Listener();
    private DefaultListModel listModel;
    private JList list;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton upBtn;
    private JButton downBtn;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public EditableList(String string, Object[] objectArray) {
        this.setLayout(new BorderLayout());
        this.setName(string);
        this.setFocusable(false);
        this.listModel = new DefaultListModel();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.listModel.addElement(objectArray[n]);
                ++n;
            }
        }
        this.list = new JList(this.listModel);
        this.list.setName(string);
        this.list.setToolTipText(i18n.getString(string + ".tip"));
        this.list.getAccessibleContext().setAccessibleName(this.list.getName());
        this.list.getAccessibleContext().setAccessibleDescription(this.list.getToolTipText());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this.listener);
        this.list.addMouseListener(this.listener);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setName(string + ".sp");
        jScrollPane.setFocusable(false);
        this.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setName(string + "bar");
        jToolBar.setFocusable(false);
        jToolBar.setFloatable(false);
        this.addBtn = this.createButton("list.add");
        jToolBar.add(this.addBtn);
        this.removeBtn = this.createButton("list.remove");
        jToolBar.add(this.removeBtn);
        this.upBtn = this.createButton("list.up");
        jToolBar.add(this.upBtn);
        this.downBtn = this.createButton("list.down");
        jToolBar.add(this.downBtn);
        this.add((Component)jToolBar, "East");
        this.updateButtons();
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public Object[] getItems() {
        return this.listModel.toArray();
    }

    public Object[] getItems(Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.listModel.size());
        this.listModel.copyInto(objectArray);
        return objectArray;
    }

    protected Object getNewItem() {
        return JOptionPane.showInputDialog(this, (Object)i18n.getString("list.add.title"));
    }

    protected Object getNewItem(Object object) {
        return JOptionPane.showInputDialog(this, i18n.getString("list.change.title"), object);
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(i18n.getString(string + ".btn"));
        jButton.setName(string);
        jButton.setToolTipText(i18n.getString(string + ".tip"));
        jButton.setMnemonic(i18n.getString(string + ".mne").charAt(0));
        jButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        jButton.addActionListener(this.listener);
        return jButton;
    }

    private void updateButtons() {
        if (this.list.isSelectionEmpty()) {
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else {
            this.removeBtn.setEnabled(true);
            int n = this.list.getSelectedIndex();
            this.upBtn.setEnabled(n > 0);
            this.downBtn.setEnabled(n + 1 < this.listModel.size());
        }
    }

    private void swap(int n, int n2) {
        Object e = this.listModel.elementAt(n);
        Object e2 = this.listModel.elementAt(n2);
        this.listModel.set(n, e2);
        this.listModel.set(n2, e);
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            if (object == EditableList.this.addBtn) {
                Object object2 = EditableList.this.getNewItem();
                if (object2 != null) {
                    if (EditableList.this.list.isSelectionEmpty()) {
                        EditableList.this.listModel.addElement(object2);
                    } else {
                        EditableList.this.listModel.add(1 + EditableList.this.list.getSelectedIndex(), object2);
                    }
                }
            } else if (object == EditableList.this.removeBtn) {
                if (!EditableList.this.list.isSelectionEmpty()) {
                    EditableList.this.listModel.remove(EditableList.this.list.getSelectedIndex());
                }
            } else if (object == EditableList.this.upBtn) {
                int n2;
                if (!EditableList.this.list.isSelectionEmpty() && (n2 = EditableList.this.list.getSelectedIndex()) > 0) {
                    EditableList.this.swap(n2, n2 - 1);
                    EditableList.this.list.setSelectedIndex(n2 - 1);
                }
            } else if (object == EditableList.this.downBtn && !EditableList.this.list.isSelectionEmpty() && (n = EditableList.this.list.getSelectedIndex()) + 1 < EditableList.this.listModel.size()) {
                EditableList.this.swap(n, n + 1);
                EditableList.this.list.setSelectedIndex(n + 1);
            }
            EditableList.this.updateButtons();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            EditableList.this.updateButtons();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = EditableList.this.list.locationToIndex(mouseEvent.getPoint());
                Object object = EditableList.this.getNewItem(EditableList.this.listModel.getElementAt(n));
                if (object != null) {
                    EditableList.this.listModel.set(n, object);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

