/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.Map;

public class WizCheck {
    private boolean verbose;
    private PrintStream log;
    private HashMap i18nMarkerSets = new HashMap();
    private HashMap moreInfoMarkerSets = new HashMap();
    private static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");
    static /* synthetic */ Class class$com$sun$interview$WizCheck;

    public static void usage() {
        String string = System.getProperty("program", "java " + (class$com$sun$interview$WizCheck == null ? (class$com$sun$interview$WizCheck = WizCheck.class$("com.sun.interview.WizCheck")) : class$com$sun$interview$WizCheck).getName());
        System.err.println(WizCheck.getI18NString("check.usage", string));
    }

    public static void main(String[] stringArray) {
        try {
            Object[] objectArray;
            String[] stringArray2 = null;
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase("-cp")) {
                    string = stringArray[++n];
                } else if (stringArray[n].equalsIgnoreCase("-help")) {
                    bl = true;
                } else if (stringArray[n].equalsIgnoreCase("-usage")) {
                    bl = true;
                } else if (stringArray[n].equalsIgnoreCase("-?")) {
                    bl = true;
                } else if (stringArray[n].equalsIgnoreCase("/?")) {
                    bl = true;
                } else if (stringArray[n].equalsIgnoreCase("-verbose")) {
                    bl2 = true;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        throw new BadArgs(i18n, "check.badOpt", stringArray[n]);
                    }
                    stringArray2 = new String[stringArray.length - n];
                    System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
                    n = stringArray.length - 1;
                }
                ++n;
            }
            if (bl) {
                WizCheck.usage();
                if (stringArray2 == null) {
                    System.exit(0);
                }
            }
            URLClassLoader uRLClassLoader = null;
            if (string != null && (objectArray = WizCheck.splitPath(string)) != null && objectArray.length > 0) {
                uRLClassLoader = new URLClassLoader((URL[])objectArray);
            }
            if (stringArray2 == null || stringArray2.length == 0) {
                throw new BadArgs(i18n, "check.noInterviews");
            }
            objectArray = new Interview[stringArray2.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                objectArray[n2] = WizCheck.loadInterview((String)stringArray2[n2], uRLClassLoader);
                ++n2;
            }
            WizCheck wizCheck = new WizCheck();
            wizCheck.verbose = bl2;
            boolean bl3 = wizCheck.check((Interview[])objectArray);
            System.exit(bl3 ? 0 : 1);
        }
        catch (BadArgs badArgs) {
            System.err.println(WizCheck.getI18NString("check.badArgs", badArgs.getMessage()));
            WizCheck.usage();
            System.exit(2);
        }
        catch (Fault fault) {
            System.err.println(WizCheck.getI18NString("check.fault", fault.getMessage()));
            System.exit(3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(4);
        }
    }

    public WizCheck() {
        this.log = System.err;
    }

    public boolean check(Interview[] interviewArray) throws Fault {
        Object object;
        Object object2;
        boolean bl = true;
        int n = 0;
        while (n < interviewArray.length) {
            bl &= this.checkInterview(interviewArray[n]);
            ++n;
        }
        boolean bl2 = true;
        Iterator iterator = this.i18nMarkerSets.values().iterator();
        while (iterator.hasNext()) {
            object2 = (MarkerSet)iterator.next();
            if (((MarkerSet)object2).isEmpty()) continue;
            if (bl2) {
                this.log.println(WizCheck.getI18NString("check.i18nUnRefEntries"));
                bl2 = false;
            }
            this.log.println(WizCheck.getI18NString("check.i18nTitle", ((MarkerSet)object2).getName()));
            object = ((MarkerSet)object2).iterator();
            while (object.hasNext()) {
                this.log.println(WizCheck.getI18NString("check.i18nEntry", object.next()));
            }
        }
        bl2 = true;
        object2 = this.moreInfoMarkerSets.values().iterator();
        while (object2.hasNext()) {
            object = (MarkerSet)object2.next();
            if (((MarkerSet)object).isEmpty()) continue;
            if (bl2) {
                this.log.println(WizCheck.getI18NString("check.moreInfoUnRefEntries"));
                bl2 = false;
            }
            this.log.println(WizCheck.getI18NString("check.moreInfoTitle", ((MarkerSet)object).getName()));
            Iterator iterator2 = ((MarkerSet)object).iterator();
            while (iterator2.hasNext()) {
                this.log.println(WizCheck.getI18NString("check.moreInfoEntry", iterator2.next()));
            }
        }
        return bl;
    }

    public boolean checkInterview(Interview interview) throws Fault {
        boolean bl = true;
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                Question question = (Question)object;
                Question question2 = (Question)object2;
                return question.getKey().compareTo(question2.getKey());
            }
        });
        treeSet.addAll(interview.getQuestions());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Question question = (Question)iterator.next();
            bl &= this.checkQuestion(question);
        }
        return bl;
    }

    private boolean checkQuestion(Question question) {
        String[] stringArray;
        ChoiceQuestion choiceQuestion;
        String[] stringArray2;
        boolean bl = true;
        bl &= this.checkHelpForQuestion(question);
        bl &= this.checkResourceForQuestion(question, question.getKey() + ".smry");
        bl &= this.checkResourceForQuestion(question, question.getKey() + ".text");
        if (question instanceof ChoiceQuestion && (stringArray2 = (choiceQuestion = (ChoiceQuestion)question).getChoices()) != (stringArray = choiceQuestion.getDisplayChoices())) {
            int n = 0;
            while (n < stringArray2.length) {
                String string = stringArray2[n];
                if (string != null) {
                    bl &= this.checkResourceForQuestion(question, question.getKey() + "." + string);
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean checkHelpForQuestion(Question question) {
        if (question instanceof ErrorQuestion) {
            return true;
        }
        Map.ID iD = question.getHelpID();
        if (iD != null) {
            try {
                Object object;
                Map map = question.getInterview().getHelpSet().getCombinedMap();
                URL uRL = map.getURLFromID(iD);
                if (uRL.getProtocol().equalsIgnoreCase("file") && !((File)(object = new File(uRL.getFile()))).exists()) {
                    this.log.println(WizCheck.getI18NString("check.moreInfoFileMissing", new Object[]{question.getKey(), object}));
                    return false;
                }
                if (this.verbose) {
                    this.log.println(WizCheck.getI18NString("check.moreInfoOK", new Object[]{question.getKey()}));
                }
                object = this.getMoreInfoMarkerSet(question.getInterview());
                ((MarkerSet)object).mark(iD);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                this.log.println(WizCheck.getI18NString("check.moreInfoBadURL", new Object[]{question.getKey(), malformedURLException}));
            }
        }
        this.log.println(WizCheck.getI18NString("check.moreInfoMissing", question.getKey()));
        return false;
    }

    private boolean checkResourceForQuestion(Question question, String string) {
        if (this.checkResourceForInterview(question.getInterview(), string)) {
            if (this.verbose) {
                this.log.println(WizCheck.getI18NString("check.i18nOK", new Object[]{question.getKey(), string}));
            }
            return true;
        }
        this.log.println(WizCheck.getI18NString("check.i18nMissing", new Object[]{question.getKey(), string}));
        return false;
    }

    private boolean checkResourceForInterview(Interview interview, String string) {
        Interview interview2 = interview.getParent();
        if (interview2 != null && this.checkResourceForInterview(interview2, string)) {
            return true;
        }
        ResourceBundle resourceBundle = interview.getResourceBundle();
        if (resourceBundle != null) {
            try {
                resourceBundle.getString(string);
                MarkerSet markerSet = this.getI18NMarkerSet(interview);
                markerSet.mark(string);
                return true;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return false;
    }

    private MarkerSet getI18NMarkerSet(Interview interview) {
        ResourceBundle resourceBundle = interview.getResourceBundle();
        MarkerSet markerSet = (MarkerSet)this.i18nMarkerSets.get(resourceBundle);
        if (markerSet == null) {
            markerSet = new MarkerSet(interview.getTag(), resourceBundle.getKeys());
            markerSet.mark("title");
            this.i18nMarkerSets.put(resourceBundle, markerSet);
        }
        return markerSet;
    }

    private MarkerSet getMoreInfoMarkerSet(Interview interview) {
        HelpSet helpSet = interview.getHelpSet();
        MarkerSet markerSet = (MarkerSet)this.moreInfoMarkerSets.get(helpSet.getHelpSetURL());
        if (markerSet == null) {
            Map map = helpSet.getLocalMap();
            markerSet = new MarkerSet(helpSet.getHelpSetURL().toString(), map.getAllIDs());
            this.moreInfoMarkerSets.put(helpSet.getHelpSetURL(), markerSet);
        }
        return markerSet;
    }

    private static Interview loadInterview(String string, ClassLoader classLoader) throws Fault {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            return (Interview)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault(i18n, "check.classNotFound", new Object[]{string});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault(i18n, "check.cantAccess", new Object[]{string, illegalAccessException});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault(i18n, "check.badClassName", new Object[]{string});
        }
        catch (InstantiationException instantiationException) {
            throw new Fault(i18n, "check.cantInstantiate", new Object[]{string, instantiationException});
        }
    }

    private static URL[] splitPath(String string) throws Fault {
        char c = File.pathSeparatorChar;
        Vector vector = new Vector();
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            WizCheck.add(string.substring(n, n2), vector);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        if (n != string.length()) {
            WizCheck.add(string.substring(n), vector);
        }
        Object[] objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void add(String string, Vector vector) throws Fault {
        try {
            if (string.length() != 0) {
                vector.addElement(new File(string).toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new Fault(i18n, "check.badPath", string);
        }
    }

    private static String getI18NString(String string) {
        return MessageFormat.format(i18n.getString(string), null);
    }

    private static String getI18NString(String string, Object object) {
        return MessageFormat.format(i18n.getString(string), object);
    }

    private static String getI18NString(String string, Object[] objectArray) {
        return MessageFormat.format(i18n.getString(string), objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MarkerSet {
        private String name;
        private TreeSet entries = new TreeSet();

        MarkerSet(String string, Enumeration enumeration) {
            this.name = string;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.entries.add(e.toString());
            }
        }

        String getName() {
            return this.name;
        }

        void mark(Object object) {
            this.entries.remove(object.toString());
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        Iterator iterator() {
            return this.entries.iterator();
        }
    }

    public static class Fault
    extends Exception {
        Fault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        Fault(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        Fault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }

    private static class BadArgs
    extends Exception {
        BadArgs(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }
}

