/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public abstract class TreeQuestion
extends Question {
    private static String[] empty = new String[0];
    private Model model;
    protected String[] value;

    protected TreeQuestion(Interview interview, String string, Model model) {
        super(interview, string);
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.setValue(TreeQuestion.split(string));
    }

    public void setValue(String[] stringArray) {
        Object[] objectArray;
        if (stringArray == null) {
            objectArray = this.value;
            this.value = null;
        } else {
            objectArray = this.value;
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
            this.value = treeSet.toArray(new String[treeSet.size()]);
        }
        if (!Arrays.equals(this.value, objectArray)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void setValue(Object[] objectArray) {
        if (objectArray == null) {
            this.setValue((String[])null);
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = this.model.getPath(objectArray[n]);
            ++n;
        }
    }

    public String getStringValue() {
        return TreeQuestion.join(this.value);
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void clear() {
        this.setValue((String[])null);
    }

    protected void load(Map map) {
        String string = (String)map.get(this.tag);
        this.setValue(string);
    }

    protected void save(Map map) {
        map.put(this.tag, TreeQuestion.join(this.value));
    }

    private static String[] split(String string) {
        if (string == null) {
            return empty;
        }
        Vector<String> vector = new Vector<String>();
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (TreeQuestion.white(string.charAt(n2))) {
                if (n != -1) {
                    vector.addElement(string.substring(n, n2));
                }
                n = -1;
            } else if (n == -1) {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            vector.addElement(string.substring(n));
        }
        if (vector.size() == 0) {
            return empty;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static String join(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2].length();
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(stringArray[0]);
        int n3 = 1;
        while (n3 < stringArray.length) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static interface Model {
        public Object getRoot();

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public String getName(Object var1);

        public String getPath(Object var1);

        public boolean isLeaf(Object var1);
    }
}

