/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.Vector;

public abstract class StringListQuestion
extends Question {
    private static final String[] empty = new String[0];
    protected String[] value;

    protected StringListQuestion(Interview interview, String string) {
        super(interview, string);
        this.clear();
    }

    public String[] getValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.value.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            if (this.value[n] != null) {
                stringBuffer.append(this.value[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void setValue(String string) {
        this.setValue(string == null ? (String[])null : StringListQuestion.split(string));
    }

    public void setValue(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == null || stringArray[n].indexOf("\n") != -1) {
                    throw new IllegalArgumentException();
                }
                ++n;
            }
        }
        if (!StringListQuestion.equal(stringArray, this.value)) {
            if (stringArray == null) {
                this.value = null;
            } else {
                this.value = new String[stringArray.length];
                System.arraycopy(stringArray, 0, this.value, 0, stringArray.length);
            }
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void clear() {
        this.setValue((String[])null);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof String[]) {
            this.setValue((String[])v);
        } else if (v instanceof String) {
            this.setValue((String)v);
        }
    }

    protected void save(Map map) {
        if (this.value != null) {
            map.put(this.tag, this.getStringValue());
        }
    }

    protected static boolean equal(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return stringArray == stringArray2;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!StringListQuestion.equal(stringArray[n], stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected static boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    protected static String[] split(String string) {
        if (string == null) {
            return empty;
        }
        Vector<String> vector = new Vector<String>();
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                if (n != -1) {
                    vector.addElement(string.substring(n, n2));
                }
                n = -1;
            } else if (n == -1) {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            vector.addElement(string.substring(n));
        }
        if (vector.size() == 0) {
            return empty;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

