/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.CheckList;
import com.sun.interview.Checklist;
import com.sun.interview.Interview;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.HelpSet;
import javax.help.Map;

public abstract class Question {
    protected final String tag;
    protected final String key;
    private String text;
    private String summary;
    private Map.ID id;
    private URL image;
    protected Interview interview;

    protected Question(Interview interview, String string) {
        this.interview = interview;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No tag specified");
        }
        this.tag = interview.tag == null ? string : interview.tag + "." + string;
        Question question = interview.allQuestions.put(this.tag, this);
        if (question != null) {
            throw new IllegalArgumentException("Duplicate tag for question: " + this.tag);
        }
        String string2 = interview.getClass().getName();
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        this.key = string2 + "." + string;
    }

    protected Question(Interview interview) {
        this.interview = interview;
        this.tag = null;
        this.key = null;
    }

    public Interview getInterview() {
        return this.interview;
    }

    public String getKey() {
        return this.key;
    }

    public String getTag() {
        return this.tag;
    }

    protected void setText(String string) {
        this.text = string.trim();
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.getI18NString(this.interview, this.key + ".text", true);
            if (this.text == null) {
                this.text = this.key + ".text";
            }
        }
        return MessageFormat.format(this.text, this.getTextArgs());
    }

    protected Object[] getTextArgs() {
        return null;
    }

    protected void setSummary(String string) {
        this.summary = string.trim();
    }

    public String getSummary() {
        if (this.summary == null) {
            this.summary = this.getI18NString(this.interview, this.key + ".smry", true);
            if (this.summary == null) {
                this.summary = this.key + ".smry";
            }
        }
        return this.summary;
    }

    public void setImage(String string) {
        this.image = this.getClass().getResource(string);
    }

    protected void setImage(URL uRL) {
        this.image = uRL;
    }

    public URL getImage() {
        if (this.image == null) {
            this.image = this.getClass().getResource(this.tag + ".gif");
        }
        if (this.image == null) {
            this.image = this.interview.getDefaultImage();
        }
        return this.image;
    }

    public Map.ID getHelpID() {
        if (this.id == null) {
            this.id = this.getID(this.interview, this.key);
        }
        return this.id;
    }

    private Map.ID getID(Interview interview, String string) {
        javax.help.Map map;
        Map.ID iD = null;
        if (interview.getParent() != null) {
            iD = this.getID(interview.getParent(), string);
        }
        if (iD != null) {
            return iD;
        }
        HelpSet helpSet = interview.getHelpSet();
        if (helpSet != null && (map = helpSet.getLocalMap()) != null && map.isValidID(string, helpSet)) {
            iD = Map.ID.create(string, helpSet);
            return iD;
        }
        return null;
    }

    public Checklist.Item[] getChecklistItems() {
        return this.getCheckListItems();
    }

    public CheckList.Item[] getCheckListItems() {
        return null;
    }

    public boolean isHidden() {
        return false;
    }

    protected abstract Question getNext();

    public abstract void clear();

    public abstract String getStringValue();

    public abstract void setValue(String var1) throws Interview.Fault;

    public abstract boolean isValueValid();

    public abstract boolean isValueAlwaysValid();

    protected abstract void load(Map var1);

    protected abstract void save(Map var1);

    protected void export(Map map) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof Question)) {
            return false;
        }
        Question question = (Question)object;
        return Question.equal(this.tag, question.tag) && Question.equal(this.getStringValue(), question.getStringValue());
    }

    private static boolean equal(String string, String string2) {
        return string == null || string2 == null ? string == string2 : string.equals(string2);
    }

    private String getI18NString(Interview interview, String string, boolean bl) {
        try {
            String string2 = null;
            Interview interview2 = interview.getParent();
            if (bl) {
                ResourceBundle resourceBundle;
                if (interview2 != null) {
                    string2 = this.getI18NString(interview2, string, bl);
                }
                if (string2 == null && (resourceBundle = interview.getResourceBundle()) != null) {
                    string2 = resourceBundle.getString(string);
                }
            } else {
                ResourceBundle resourceBundle = interview.getResourceBundle();
                if (resourceBundle != null) {
                    string2 = resourceBundle.getString(string);
                }
                if (string2 == null && interview2 != null) {
                    string2 = this.getI18NString(interview2, string, bl);
                }
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

