/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Checklist;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NestedInterviewQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpSetException;

public class Interview {
    public static final int EXPORT_IGNORE_ALL_EXCEPTIONS = 0;
    public static final int EXPORT_IGNORE_RUNTIME_EXCEPTIONS = 1;
    public static final int EXPORT_IGNORE_NO_EXCEPTIONS = 2;
    private static final int EXPORT_NUM_IGNORE_POLICIES = 3;
    private int exportIgnoreExceptionPolicy = 1;
    private Observer[] observers = new Observer[0];
    private static final Object[] empty = new Object[0];
    String tag;
    private String title;
    private Question firstQuestion;
    private Interview parent;
    private Vector children = new Vector();
    Map allQuestions = new HashMap();
    private URL defaultImage;
    private String helpSetName;
    private HelpSet helpSet;
    private String bundleName;
    private ResourceBundle bundle;
    private Vector path;
    private int currIndex;
    private Interview caller;
    private Question successor;
    private boolean updateEnabled;
    private boolean edited;
    static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");

    protected Interview(String string) {
        this(null, string);
    }

    protected Interview(Interview interview, String string) {
        this.parent = interview;
        this.tag = interview == null || interview.tag == null ? string : (string == null ? interview.tag : interview.tag + "." + string);
        if (interview != null) {
            interview.children.addElement(this);
        }
    }

    public Interview getParent() {
        return this.parent;
    }

    public String getTag() {
        return this.tag;
    }

    protected void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        if (this.title == null) {
            String string = "title";
            this.title = this.getI18NString(string).trim();
        }
        return this.title;
    }

    protected void setDefaultImage(URL uRL) {
        this.defaultImage = uRL;
    }

    public URL getDefaultImage() {
        if (this.defaultImage == null && this.parent != null) {
            return this.parent.getDefaultImage();
        }
        return this.defaultImage;
    }

    protected void setResourceBundle(String string) throws MissingResourceException {
        if (string != this.bundleName) {
            if (string != null) {
                String string2;
                Class<?> clazz = this.getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                if (string.startsWith("/")) {
                    string2 = string.substring(1);
                } else {
                    String string3 = clazz.getName();
                    String string4 = string3.substring(0, string3.lastIndexOf(46));
                    string2 = string4 + "." + string;
                }
                this.bundle = ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader);
            }
            this.bundleName = string;
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.bundle == null && this.parent != null) {
            return this.parent.getResourceBundle();
        }
        return this.bundle;
    }

    protected void setHelpSet(String string) throws HelpNotFoundFault, BadHelpFault {
        try {
            Object object;
            Object object2;
            String string2;
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            if (string.startsWith("/")) {
                string2 = string.substring(1);
            } else {
                object2 = clazz.getName();
                object = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
                string2 = ((String)object).replace('.', '/') + "/" + string;
            }
            object2 = HelpSet.findHelpSet(classLoader, string2);
            if (object2 == null) {
                throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", string2);
            }
            object = new HelpSet(classLoader, (URL)object2);
            this.setHelpSet((HelpSet)object);
        }
        catch (HelpSetException helpSetException) {
            throw new BadHelpFault(i18n, "interview.badHelp", helpSetException);
        }
    }

    protected void setHelpSet(HelpSet helpSet) {
        if (this.parent == null) {
            if (this.helpSet == null) {
                Iterator iterator = this.getInterviews().iterator();
                while (iterator.hasNext()) {
                    Interview interview = (Interview)iterator.next();
                    HelpSet helpSet2 = interview.getHelpSet();
                    if (helpSet2 == null) continue;
                    helpSet.add(helpSet2);
                }
            } else {
                Enumeration enumeration = this.helpSet.getHelpSets();
                while (enumeration.hasMoreElements()) {
                    HelpSet helpSet3 = (HelpSet)enumeration.nextElement();
                    this.helpSet.remove(helpSet3);
                    helpSet.add(helpSet3);
                }
            }
        } else {
            Interview interview = this;
            while (interview.parent != null) {
                interview = interview.parent;
            }
            HelpSet helpSet4 = interview.helpSet;
            if (helpSet4 != null) {
                if (this.helpSet != null) {
                    helpSet4.remove(this.helpSet);
                }
                helpSet4.add(helpSet);
            }
        }
        this.helpSet = helpSet;
    }

    public HelpSet getHelpSet() {
        if (this.helpSet == null && this.parent != null) {
            return this.parent.getHelpSet();
        }
        return this.helpSet;
    }

    public void setEdited(boolean bl) {
        Interview interview = this;
        while (interview.parent != null) {
            interview = interview.parent;
        }
        interview.edited = bl;
    }

    public boolean isEdited() {
        Interview interview = this;
        while (interview.parent != null) {
            interview = interview.parent;
        }
        return interview.edited;
    }

    public Question getFirstQuestion() {
        return this.firstQuestion;
    }

    protected void setFirstQuestion(Question question) {
        if (this.path != null) {
            throw new IllegalStateException();
        }
        this.firstQuestion = question;
    }

    public Interview getInterview(String string) throws Fault {
        if (string == null) {
            throw new NullPointerException();
        }
        Interview interview = this.getInterview0(string);
        if (interview != null) {
            return interview;
        }
        throw new Fault(i18n, "interview.cantFindInterview", string);
    }

    private Interview getInterview0(String string) {
        if (string.equals(this.tag)) {
            return this;
        }
        int n = 0;
        while (n < this.children.size()) {
            Interview interview = (Interview)this.children.elementAt(n);
            Interview interview2 = interview.getInterview0(string);
            if (interview2 != null) {
                return interview2;
            }
            ++n;
        }
        return null;
    }

    private Set getInterviews() {
        HashSet hashSet = new HashSet();
        this.getInterviews0(hashSet);
        return hashSet;
    }

    private void getInterviews0(Set set) {
        set.add(this);
        int n = 0;
        while (n < this.children.size()) {
            Interview interview = (Interview)this.children.elementAt(n);
            interview.getInterviews0(set);
            ++n;
        }
    }

    public boolean isFirst(Question question) {
        return question == this.firstQuestion;
    }

    public boolean isLast(Question question) {
        return question instanceof FinalQuestion && question.interview.caller == null;
    }

    public void reset() {
        this.ensurePathInitialized();
        this.updateEnabled = true;
        this.caller = null;
        this.currIndex = 0;
        this.path.setSize(1);
        this.path.setElementAt(this.firstQuestion, 0);
        this.updatePath(this.firstQuestion);
        this.notifyCurrentQuestionChanged(this.firstQuestion);
    }

    private void reset(Question question) {
        this.ensurePathInitialized();
        this.updateEnabled = true;
        this.caller = null;
        this.currIndex = 0;
        this.path.setSize(1);
        this.path.setElementAt(this.firstQuestion, 0);
        this.updatePath(this.firstQuestion);
        if (question == this.firstQuestion) {
            this.notifyCurrentQuestionChanged(question);
        } else {
            try {
                this.setCurrentQuestion(question);
            }
            catch (Fault fault) {
                this.notifyCurrentQuestionChanged(this.firstQuestion);
            }
        }
    }

    public void next() throws Fault {
        this.ensurePathInitialized();
        Interview interview = this;
        while (interview.path.elementAt(interview.currIndex) instanceof Interview) {
            interview = (Interview)interview.path.elementAt(interview.currIndex);
        }
        ++interview.currIndex;
        while (true) {
            if (interview.currIndex == interview.path.size()) {
                --interview.currIndex;
                throw new Fault(i18n, "interview.noMoreQuestions");
            }
            if (interview.path.elementAt(interview.currIndex) instanceof Interview) {
                interview = (Interview)interview.path.elementAt(interview.currIndex);
                interview.currIndex = 0;
                continue;
            }
            if (!(interview.path.elementAt(interview.currIndex) instanceof FinalQuestion) || interview.caller == null) break;
            interview = interview.caller;
            ++interview.currIndex;
        }
        Question question = (Question)interview.path.elementAt(interview.currIndex);
        this.notifyCurrentQuestionChanged(question);
    }

    public void prev() throws Fault {
        this.ensurePathInitialized();
        Interview interview = this;
        while (interview.path.elementAt(interview.currIndex) instanceof Interview) {
            interview = (Interview)interview.path.elementAt(interview.currIndex);
        }
        --interview.currIndex;
        while (true) {
            if (interview.currIndex < 0) {
                if (interview.caller == null) {
                    interview.currIndex = 0;
                    throw new Fault(i18n, "interview.noMoreQuestions");
                }
                interview = interview.caller;
                --interview.currIndex;
                continue;
            }
            if (interview.path.elementAt(interview.currIndex) instanceof Interview) {
                interview = (Interview)interview.path.elementAt(interview.currIndex);
                interview.currIndex = interview.path.size() - 1;
                continue;
            }
            if (!(interview.path.elementAt(interview.currIndex) instanceof FinalQuestion)) break;
            --interview.currIndex;
        }
        Question question = (Question)interview.path.elementAt(interview.currIndex);
        this.notifyCurrentQuestionChanged(question);
    }

    public void last() throws Fault {
        this.ensurePathInitialized();
        Interview interview = this;
        while (interview.path.elementAt(interview.currIndex) instanceof Interview) {
            interview = (Interview)interview.path.elementAt(interview.currIndex);
        }
        int n = interview.currIndex;
        Question question = (Question)interview.path.elementAt(n);
        ++n;
        while (n < interview.path.size()) {
            Object e = interview.path.elementAt(n);
            if (e instanceof Interview) {
                interview = (Interview)interview.path.elementAt(n);
                n = 0;
                continue;
            }
            if (e instanceof FinalQuestion && interview.caller != null) {
                int n2 = interview.caller.path.indexOf(interview);
                if (n2 == -1) {
                    throw new IllegalStateException();
                }
                interview = interview.caller;
                n = n2 + 1;
                continue;
            }
            question = (Question)e;
            ++n;
        }
        this.setCurrentQuestion(question);
    }

    public boolean isStarted() {
        Question[] questionArray = this.getCallRoot().getPath();
        int n = 0;
        while (n < questionArray.length - 1) {
            Question question = questionArray[n];
            if (!(question instanceof NullQuestion)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isFinishable() {
        this.ensurePathInitialized();
        Interview interview = this.getCallRoot();
        return interview.path.lastElement() instanceof FinalQuestion;
    }

    public void setCurrentQuestion(Question question) throws Fault {
        if (question == this.getCurrentQuestion()) {
            return;
        }
        boolean bl = this.getCallRoot().setCurrentQuestion0(question);
        if (!bl) {
            throw new Fault(i18n, "interview.questionNotOnPath");
        }
        this.notifyCurrentQuestionChanged(question);
    }

    private boolean setCurrentQuestion0(Question question) {
        this.ensurePathInitialized();
        int n = 0;
        while (n < this.path.size()) {
            Object e = this.path.elementAt(n);
            if (e.equals(question)) {
                this.currIndex = n;
                return true;
            }
            if (e instanceof Interview && ((Interview)e).setCurrentQuestion0(question)) {
                this.currIndex = n;
                return true;
            }
            ++n;
        }
        return false;
    }

    public Question getCurrentQuestion() {
        this.ensurePathInitialized();
        Interview interview = this.getCallRoot();
        while (interview instanceof Interview) {
            Interview interview2 = interview;
            interview = interview2.path.elementAt(interview2.currIndex);
        }
        return (Question)((Object)interview);
    }

    private void setCurrentQuestionFromPath(Question[] questionArray) {
        this.getCallRoot().setCurrentQuestionFromPath0(questionArray);
    }

    private void setCurrentQuestionFromPath0(Question[] questionArray) {
        int n = questionArray.length - 1;
        while (n >= 0) {
            if (this.setCurrentQuestion0(questionArray[n])) {
                this.notifyCurrentQuestionChanged(questionArray[n]);
                return;
            }
            --n;
        }
    }

    public Question[] getPath() {
        Vector vector = new Vector();
        this.iteratePath0(true, vector, true, true);
        Object[] objectArray = new Question[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Question[] getPathToCurrent() {
        Vector vector = new Vector();
        this.iteratePath0(true, vector, false, true);
        Object[] objectArray = new Question[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Iterator iteratePath(boolean bl) {
        Vector vector = new Vector();
        this.iteratePath0(bl, vector, true, true);
        return vector.iterator();
    }

    public Iterator iteratePathToCurrent(boolean bl) {
        Vector vector = new Vector();
        this.iteratePath0(bl, vector, false, true);
        return vector.iterator();
    }

    private void iteratePath0(boolean bl, List list, boolean bl2, boolean bl3) {
        this.ensurePathInitialized();
        int n = bl2 ? this.path.size() : this.currIndex + 1;
        int n2 = 0;
        while (n2 < n) {
            Object e = this.path.elementAt(n2);
            if (e instanceof Interview) {
                if (bl) {
                    ((Interview)e).iteratePath0(true, list, bl2, false);
                } else {
                    list.add(e);
                }
            } else {
                if (!bl3 && e instanceof FinalQuestion) {
                    return;
                }
                if (!((Question)e).isHidden()) {
                    list.add(e);
                }
            }
            ++n2;
        }
    }

    public boolean pathContains(Question question) {
        return this.getCallRoot().pathContains0(question);
    }

    public boolean pathContains(Interview interview) {
        return this.getCallRoot().pathContains0(interview);
    }

    private boolean pathContains0(Object object) {
        this.ensurePathInitialized();
        int n = 0;
        while (n < this.path.size()) {
            Object e = this.path.elementAt(n);
            if (e == object || e instanceof Interview && ((Interview)e).pathContains0(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Set getQuestions() {
        HashSet hashSet = new HashSet();
        this.getQuestions0(hashSet);
        return hashSet;
    }

    private void getQuestions0(Set set) {
        set.addAll(this.allQuestions.values());
        int n = 0;
        while (n < this.children.size()) {
            Interview interview = (Interview)this.children.elementAt(n);
            interview.getQuestions0(set);
            ++n;
        }
    }

    public Map getAllQuestions() {
        HashMap hashMap = new HashMap();
        this.getAllQuestions0(hashMap);
        return hashMap;
    }

    private void getAllQuestions0(Map map) {
        map.putAll(this.allQuestions);
        int n = 0;
        while (n < this.children.size()) {
            Interview interview = (Interview)this.children.elementAt(n);
            interview.getAllQuestions0(map);
            ++n;
        }
    }

    public boolean isChecklistEmpty() {
        Iterator iterator = this.iteratePath(true);
        while (iterator.hasNext()) {
            Question question = (Question)iterator.next();
            Checklist.Item[] itemArray = question.getChecklistItems();
            if (itemArray == null || itemArray.length <= 0) continue;
            return false;
        }
        return true;
    }

    public Checklist createChecklist() {
        Checklist checklist = new Checklist();
        Iterator iterator = this.iteratePath(true);
        while (iterator.hasNext()) {
            Question question = (Question)iterator.next();
            Checklist.Item[] itemArray = question.getChecklistItems();
            if (itemArray == null) continue;
            int n = 0;
            while (n < itemArray.length) {
                checklist.add(itemArray[n]);
                ++n;
            }
        }
        return checklist;
    }

    public Checklist.Item createChecklistItem(String string, String string2) {
        String string3 = this.getI18NString(string);
        String string4 = this.getI18NString(string2);
        return new Checklist.Item(string3, string4);
    }

    public Checklist.Item createChecklistItem(String string, String string2, Object object) {
        String string3 = this.getI18NString(string);
        String string4 = this.getI18NString(string2, object);
        return new Checklist.Item(string3, string4);
    }

    public Checklist.Item createChecklistItem(String string, String string2, Object[] objectArray) {
        String string3 = this.getI18NString(string);
        String string4 = this.getI18NString(string2, objectArray);
        return new Checklist.Item(string3, string4);
    }

    protected Question callInterview(Interview interview, Question question) {
        return new NestedInterviewQuestion(this, interview, question);
    }

    public void clear() {
        this.updateEnabled = false;
        Iterator iterator = this.allQuestions.values().iterator();
        while (iterator.hasNext()) {
            Question question = (Question)iterator.next();
            question.clear();
        }
        int n = 0;
        while (n < this.children.size()) {
            Interview interview = (Interview)this.children.elementAt(n);
            interview.clear();
            ++n;
        }
        if (this.parent == null) {
            this.reset();
        }
    }

    public void load(Map map) throws Fault {
        this.load(map, true);
    }

    public void load(Map map, boolean bl) throws Fault {
        Object object;
        Object object2;
        Object object3;
        if (bl && !Interview.isChecksumValid(map)) {
            throw new Fault(i18n, "interview.checksumError");
        }
        if (this.parent == null && (object3 = (String)map.get("INTERVIEW")) != null && !((String)object3).equals(this.getClass().getName())) {
            throw new Fault(i18n, "interview.classMismatch");
        }
        this.updateEnabled = false;
        object3 = this.allQuestions.values().iterator();
        while (object3.hasNext()) {
            object2 = (Question)object3.next();
            ((Question)object2).clear();
        }
        object2 = this.allQuestions.values().iterator();
        while (object2.hasNext()) {
            Question question = (Question)object2.next();
            question.load(map);
        }
        int n = 0;
        while (n < this.children.size()) {
            object = (Interview)this.children.elementAt(n);
            ((Interview)object).load(map, false);
            ++n;
        }
        if (this.parent == null) {
            object = (String)map.get("QUESTION");
            Question question = object == null ? null : this.lookup((String)object);
            this.reset(question);
        }
    }

    private static boolean isChecksumValid(Map map) {
        try {
            String string = (String)map.get("CHECKSUM");
            if (string == null) {
                return false;
            }
            return Long.parseLong(string, 16) == Interview.computeChecksum(map);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void save(Map map) {
        if (this.parent == null) {
            map.put("INTERVIEW", this.getClass().getName());
            map.put("QUESTION", this.getCurrentQuestion().getTag());
        }
        Iterator iterator = this.allQuestions.values().iterator();
        while (iterator.hasNext()) {
            Question question = (Question)iterator.next();
            try {
                question.save(map);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("warning: " + runtimeException.toString());
                System.err.println("while saving value for question " + question.getTag() + " in interview " + this.tag);
            }
        }
        int n = 0;
        while (n < this.children.size()) {
            Interview interview = (Interview)this.children.elementAt(n);
            interview.save(map);
            ++n;
        }
        map.put("CHECKSUM", Long.toString(Interview.computeChecksum(map), 16));
    }

    private static long computeChecksum(Map map) {
        long l = 0L;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string.equals("CHECKSUM")) continue;
            l += Interview.computeChecksum(string) * Interview.computeChecksum(string2);
        }
        return l == Long.MIN_VALUE ? 0L : (l < 0L ? -l : l);
    }

    private static long computeChecksum(String string) {
        if (string == null) {
            return 1L;
        }
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            l = l * 37L + (long)string.charAt(n);
            ++n;
        }
        return l;
    }

    public void export(Map map) {
        Question[] questionArray = this.getPath();
        int n = 0;
        while (n < questionArray.length) {
            try {
                questionArray[n].export(map);
            }
            catch (RuntimeException runtimeException) {
                switch (this.exportIgnoreExceptionPolicy) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        throw runtimeException;
                    }
                }
            }
            catch (Error error) {
                switch (this.exportIgnoreExceptionPolicy) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        throw error;
                    }
                }
            }
            ++n;
        }
    }

    public int getExportIgnoreExceptionPolicy() {
        return this.exportIgnoreExceptionPolicy;
    }

    public void setExportIgnoreExceptionPolicy(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException();
        }
        this.exportIgnoreExceptionPolicy = n;
    }

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        Observer[] observerArray = new Observer[this.observers.length + 1];
        System.arraycopy(this.observers, 0, observerArray, 0, this.observers.length);
        observerArray[this.observers.length] = observer;
        this.observers = observerArray;
    }

    public synchronized void removeObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        int n = 0;
        while (n < this.observers.length) {
            if (this.observers[n] == observer) {
                Observer[] observerArray = new Observer[this.observers.length - 1];
                System.arraycopy(this.observers, 0, observerArray, 0, n);
                System.arraycopy(this.observers, n + 1, observerArray, n, this.observers.length - n - 1);
                this.observers = observerArray;
                return;
            }
            ++n;
        }
    }

    private void notifyCurrentQuestionChanged(Question question) {
        int n = 0;
        while (n < this.observers.length && question == this.getCurrentQuestion()) {
            this.observers[n].currentQuestionChanged(question);
            ++n;
        }
    }

    private void notifyPathUpdated() {
        int n = 0;
        while (n < this.observers.length) {
            this.observers[n].pathUpdated();
            ++n;
        }
    }

    private void ensurePathInitialized() {
        if (this.path == null) {
            this.path = new Vector();
            this.reset();
        }
    }

    private Question lookup(String string) {
        Question question = (Question)this.allQuestions.get(string);
        int n = 0;
        while (n < this.children.size() && question == null) {
            Interview interview = (Interview)this.children.elementAt(n);
            question = interview.lookup(string);
            ++n;
        }
        return question;
    }

    private Interview getCallRoot() {
        Interview interview = this;
        while (interview.caller != null) {
            interview = interview.caller;
        }
        return interview;
    }

    public void updatePath() {
        Interview interview = this.getCallRoot();
        interview.updatePath0(interview.firstQuestion);
    }

    public void updatePath(Question question) {
        this.getCallRoot().updatePath0(question);
    }

    private void updatePath0(Question question) {
        Object object;
        if (!this.updateEnabled) {
            return;
        }
        Question[] questionArray = this.getPathToCurrent();
        Object object2 = question;
        Interview interview = question.getInterview();
        while (interview != null) {
            object = interview.path;
            int n = -1;
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                if (((Vector)object).elementAt(n2) == object2) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            ((Vector)object).setSize(n + 1);
            object2 = interview;
            interview = interview.caller;
        }
        interview = question.getInterview();
        Question question2 = question = question.isValueValid() ? question.getNext() : null;
        while (question != null && !this.pathContains(question)) {
            if (question instanceof FinalQuestion) {
                interview.path.addElement(question);
                if (interview.caller == null) break;
                question = interview.successor;
                interview = interview.caller;
                continue;
            }
            if (question instanceof NestedInterviewQuestion) {
                object = (NestedInterviewQuestion)question;
                Interview interview2 = ((NestedInterviewQuestion)object).getNestedInterview();
                if (this.pathContains(interview2)) break;
                interview2.caller = interview;
                interview2.successor = ((NestedInterviewQuestion)object).getNext();
                if (interview2.path == null) {
                    interview2.path = new Vector();
                } else {
                    interview2.path.setSize(0);
                }
                interview.path.addElement(interview2);
                interview = interview2;
                question = interview2.firstQuestion;
                continue;
            }
            if (!question.isHidden()) {
                interview.path.addElement(question);
            }
            question = question.isValueValid() ? question.getNext() : null;
        }
        if (!this.pathContains(questionArray[questionArray.length - 1])) {
            this.setCurrentQuestionFromPath(questionArray);
        }
        this.notifyPathUpdated();
    }

    private String getI18NString(String string) {
        return this.getI18NString(string, empty);
    }

    private String getI18NString(String string, Object object) {
        return this.getI18NString(string, new Object[]{object});
    }

    private String getI18NString(String string, Object[] objectArray) {
        Object object;
        try {
            object = this.getResourceBundle();
            if (object != null) {
                return MessageFormat.format(((ResourceBundle)object).getString(string), objectArray);
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("WARNING: missing resource: " + string);
        }
        object = new StringBuffer(string);
        int n = 0;
        while (n < objectArray.length) {
            ((StringBuffer)object).append('\n');
            ((StringBuffer)object).append(objectArray.toString());
            ++n;
        }
        return ((StringBuffer)object).toString();
    }

    public static interface Observer {
        public void currentQuestionChanged(Question var1);

        public void pathUpdated();
    }

    public static class HelpNotFoundFault
    extends Fault {
        public final String name;

        HelpNotFoundFault(ResourceBundle resourceBundle, String string, String string2) {
            super(resourceBundle, string, string2);
            this.name = string2;
        }
    }

    public static class BadHelpFault
    extends Fault {
        public final HelpSetException exc;

        BadHelpFault(ResourceBundle resourceBundle, String string, HelpSetException helpSetException) {
            super(resourceBundle, string, helpSetException.getMessage());
            this.exc = helpSetException;
        }
    }

    public static class Fault
    extends Exception {
        public Fault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        public Fault(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        public Fault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }
}

