/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class InetAddressQuestion
extends Question {
    protected InetAddress value;
    private String stringValue;
    private transient String newStringValue;
    private static final ResourceBundle i18n = Interview.i18n;

    protected InetAddressQuestion(Interview interview, String string) {
        super(interview, string);
    }

    public InetAddress getValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.stringValue == null && this.value != null) {
            this.stringValue = this.value.getHostAddress();
        }
        return this.stringValue;
    }

    public void setValue(InetAddress inetAddress) {
        InetAddress inetAddress2 = this.value;
        this.value = inetAddress;
        this.stringValue = this.newStringValue;
        this.newStringValue = null;
        if (!InetAddressQuestion.equal(this.value, inetAddress2)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return this.value != null;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void setValue(String string) throws Interview.Fault {
        InetAddress inetAddress;
        try {
            inetAddress = string == null ? null : InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        this.newStringValue = string;
        this.setValue(inetAddress);
    }

    public void clear() {
        this.setValue((InetAddress)null);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof InetAddress) {
            this.setValue((InetAddress)v);
        } else if (v instanceof String) {
            try {
                this.setValue((String)v);
            }
            catch (Interview.Fault fault) {
                throw new Error(fault);
            }
        }
    }

    protected void save(Map map) {
        String string = this.getStringValue();
        if (string != null) {
            map.put(this.tag, string);
        }
    }

    protected static boolean equal(InetAddress inetAddress, InetAddress inetAddress2) {
        return inetAddress == null ? inetAddress2 == null : inetAddress.equals(inetAddress2);
    }
}

