/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class FloatQuestion
extends Question {
    protected float value = Float.NaN;
    private String stringValue;
    private transient String newStringValue;
    private float min = Float.MIN_VALUE;
    private float max = Float.MAX_VALUE;
    private float resolution;
    private float labelStart;
    private float labelIncrement;
    private static final ResourceBundle i18n = Interview.i18n;

    protected FloatQuestion(Interview interview, String string) {
        super(interview, string);
        this.clear();
    }

    protected FloatQuestion(Interview interview, String string, float f, float f2, float f3) {
        super(interview, string);
        this.setBounds(f, f2);
        this.setResolution(f3);
        this.clear();
    }

    protected void setBounds(float f, float f2) {
        if (f >= f2) {
            throw new IllegalArgumentException("invalid bounds");
        }
        this.min = f;
        this.max = f2;
    }

    public float getLowerBound() {
        return this.min;
    }

    public float getUpperBound() {
        return this.max;
    }

    public boolean isValid() {
        return !Float.isNaN(this.value) && (this.min == Float.MIN_VALUE || this.min <= this.value) && this.value <= this.max;
    }

    public void setResolution(float f) {
        this.resolution = f;
    }

    public float getResolution() {
        return this.resolution;
    }

    public float getValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.stringValue == null) {
            if (Float.isNaN(this.value)) {
                this.stringValue = "";
            } else {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                this.stringValue = numberFormat.format(new Double(this.value));
            }
        }
        return this.stringValue;
    }

    public void setValue(String string) throws Interview.Fault {
        ParsePosition parsePosition;
        if (string == null || string.equals("NaN")) {
            this.clear();
            return;
        }
        if ((string = string.trim()).length() == 0) {
            this.clear();
            return;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = numberFormat.parse(string, parsePosition = new ParsePosition(0));
        float f = number != null && parsePosition.getIndex() == string.length() ? number.floatValue() : Float.NaN;
        this.newStringValue = string;
        this.setValue(f);
    }

    public void setValue(float f) {
        float f2 = this.value;
        this.value = f;
        this.stringValue = this.newStringValue;
        this.newStringValue = null;
        if (this.value != f2) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return this.isValid();
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    protected void setLabelHints(float f, float f2) {
        this.labelStart = f;
        this.labelIncrement = f2;
    }

    public float getLabelStartHint() {
        return this.labelStart;
    }

    public float getLabelIncrementHint() {
        return this.labelIncrement;
    }

    public void clear() {
        this.setValue(Float.NaN);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v == null) {
            this.clear();
        } else if (v instanceof Float) {
            this.setValue(((Float)v).floatValue());
        } else if (v instanceof String) {
            try {
                this.setValue((String)v);
            }
            catch (Interview.Fault fault) {
                throw new Error(fault);
            }
        }
    }

    protected void save(Map map) {
        map.put(this.tag, this.getStringValue());
    }
}

