/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.File;
import java.util.Map;

public abstract class FileQuestion
extends Question {
    protected File value;
    private File baseDir;
    private boolean baseRelativeOnly;
    private FileFilter[] filters;

    protected FileQuestion(Interview interview, String string) {
        super(interview, string);
    }

    public File getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value == null ? null : this.value.getPath();
    }

    public void setValue(String string) {
        this.setValue(string == null ? (File)null : new File(string));
    }

    public void setValue(File file) {
        File file2 = this.value;
        this.value = file;
        if (!FileQuestion.equal(this.value, file2)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public FileFilter[] getFilters() {
        return this.filters;
    }

    public void setFilter(FileFilter fileFilter) {
        this.filters = new FileFilter[]{fileFilter};
    }

    public void setFilters(FileFilter[] fileFilterArray) {
        this.filters = fileFilterArray;
    }

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public void setBaseDirectory(File file) {
        this.baseDir = file;
    }

    public boolean isBaseRelativeOnly() {
        return this.baseRelativeOnly;
    }

    public void setBaseRelativeOnly(boolean bl) {
        this.baseRelativeOnly = bl;
    }

    public void clear() {
        this.setValue((File)null);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof File) {
            this.setValue((File)v);
        } else if (v instanceof String) {
            this.setValue(new File((String)v));
        }
    }

    protected void save(Map map) {
        if (this.value != null) {
            map.put(this.tag, this.value.toString());
        }
    }

    protected static boolean equal(File file, File file2) {
        return file == null ? file2 == null : file.equals(file2);
    }
}

