/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.File;
import java.util.Map;
import java.util.Vector;

public abstract class FileListQuestion
extends Question {
    private static final File[] empty = new File[0];
    protected File[] value;
    private File baseDir;
    private boolean baseRelativeOnly;
    private FileFilter[] filters;

    protected FileListQuestion(Interview interview, String string) {
        super(interview, string);
    }

    public File[] getValue() {
        return this.value;
    }

    public String getStringValue() {
        return FileListQuestion.join(this.value);
    }

    public void setValue(String string) {
        this.setValue(string == null ? (File[])null : FileListQuestion.split(string));
    }

    public void setValue(File[] fileArray) {
        File[] fileArray2 = this.value;
        this.value = fileArray;
        if (!FileListQuestion.equal(this.value, fileArray2)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public FileFilter[] getFilters() {
        return this.filters;
    }

    public void setFilter(FileFilter fileFilter) {
        this.filters = new FileFilter[]{fileFilter};
    }

    public void setFilters(FileFilter[] fileFilterArray) {
        this.filters = fileFilterArray;
    }

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public void setBaseDirectory(File file) {
        this.baseDir = file;
    }

    public boolean isBaseRelativeOnly() {
        return this.baseRelativeOnly;
    }

    public void setBaseRelativeOnly(boolean bl) {
        this.baseRelativeOnly = bl;
    }

    public void clear() {
        this.setValue((File[])null);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof File[]) {
            this.setValue((File[])v);
        } else if (v instanceof String) {
            this.setValue(FileListQuestion.split((String)v));
        }
    }

    public static File[] split(String string) {
        if (string == null) {
            return empty;
        }
        char c = string.indexOf(10) == -1 ? (char)' ' : '\n';
        Vector<File> vector = new Vector<File>();
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == c) {
                if (n != -1) {
                    vector.addElement(new File(string.substring(n, n2)));
                }
                n = -1;
            } else if (n == -1) {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            vector.addElement(new File(string.substring(n)));
        }
        if (vector.size() == 0) {
            return empty;
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void save(Map map) {
        if (this.value != null) {
            map.put(this.tag, FileListQuestion.join(this.value));
        }
    }

    public static String join(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return "";
        }
        int n = fileArray.length - 1;
        int n2 = 0;
        while (n2 < fileArray.length) {
            n += fileArray[n2].getPath().length();
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        String string = fileArray[0].getPath();
        stringBuffer.append(string);
        if (fileArray.length == 1 && string.indexOf(32) != -1) {
            stringBuffer.append('\n');
        } else {
            int n3 = 1;
            while (n3 < fileArray.length) {
                stringBuffer.append('\n');
                stringBuffer.append(fileArray[n3].getPath());
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    protected static boolean equal(File[] fileArray, File[] fileArray2) {
        if (fileArray == null || fileArray2 == null) {
            return fileArray == fileArray2;
        }
        if (fileArray.length != fileArray2.length) {
            return false;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n] != fileArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

