/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import java.io.File;

public class ExtensionFileFilter
implements FileFilter {
    private String[] extns;
    private String description;
    private boolean caseSensitive;

    public ExtensionFileFilter(String string, String string2) {
        this.extns = new String[]{string};
        this.description = string2;
    }

    public ExtensionFileFilter(String[] stringArray, String string) {
        this.extns = stringArray;
        this.description = string;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean accept(File file) {
        int n = 0;
        while (n < this.extns.length) {
            if (this.endsWith(file.getName(), this.extns[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean acceptsDirectories() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String ensureExtension(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = 0;
        while (n < this.extns.length) {
            if (this.endsWith(string, this.extns[n])) {
                return string;
            }
            ++n;
        }
        return string + this.extns[0];
    }

    public File ensureExtension(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getPath();
        String string2 = this.ensureExtension(string);
        return string2.equals(string) ? file : new File(string2);
    }

    private boolean endsWith(String string, String string2) {
        int n;
        if (this.caseSensitive) {
            return string.endsWith(string2);
        }
        int n2 = string.length();
        if (n2 < (n = string2.length())) {
            return false;
        }
        int n3 = n2 - n;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n3 + n4);
            char c2 = string2.charAt(n4);
            if (Character.toLowerCase(c) != Character.toLowerCase(c2)) {
                return false;
            }
            ++n4;
        }
        return true;
    }
}

