/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ChoiceQuestion
extends Question {
    private String[] choices;
    private String[] displayChoices;
    protected String value;

    protected ChoiceQuestion(Interview interview, String string) {
        super(interview, string);
    }

    protected ChoiceQuestion(Interview interview, String string, String[] stringArray) {
        super(interview, string);
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray) {
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray, boolean bl) {
        this.setChoices(stringArray, bl ? null : stringArray);
    }

    protected void setChoices(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (stringArray2 != null && stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        this.choices = stringArray;
        this.displayChoices = stringArray2;
        if (this.value == null) {
            this.value = stringArray[0];
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (this.value.equals(stringArray[n])) {
                    this.value = stringArray[n];
                    return;
                }
                ++n;
            }
            this.value = stringArray[0];
        }
    }

    protected void setI18NChoices(String[] stringArray) {
        this.setChoices(stringArray, true);
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String[] getDisplayChoices() {
        if (this.displayChoices == null) {
            ResourceBundle resourceBundle = this.interview.getResourceBundle();
            if (resourceBundle == null) {
                return this.choices;
            }
            this.displayChoices = new String[this.choices.length];
            int n = 0;
            while (n < this.choices.length) {
                String string = this.choices[n];
                try {
                    this.displayChoices[n] = string == null ? null : resourceBundle.getString(this.key + "." + string);
                }
                catch (MissingResourceException missingResourceException) {
                    this.displayChoices[n] = string;
                }
                ++n;
            }
        }
        return this.displayChoices;
    }

    public String getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (this.choices == null) {
            return;
        }
        if (string == null) {
            String string2 = this.value;
            this.value = null;
            if (string2 != null) {
                this.interview.updatePath(this);
                this.interview.setEdited(true);
            }
        } else if (!string.equals(this.value)) {
            int n = 0;
            while (n < this.choices.length) {
                if (string.equals(this.choices[n])) {
                    this.value = this.choices[n];
                    this.interview.updatePath(this);
                    this.interview.setEdited(true);
                    return;
                }
                ++n;
            }
        }
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void clear() {
        this.setValue(this.choices == null || this.choices.length == 0 ? null : this.choices[0]);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof String) {
            this.setValue((String)v);
        }
    }

    protected void save(Map map) {
        if (this.value != null) {
            map.put(this.tag, this.value);
        }
    }
}

