/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ChoiceArrayQuestion
extends Question {
    private String[] choices;
    private String[] displayChoices;
    protected boolean[] value;

    protected ChoiceArrayQuestion(Interview interview, String string) {
        super(interview, string);
    }

    protected ChoiceArrayQuestion(Interview interview, String string, String[] stringArray) {
        super(interview, string);
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray) {
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray, boolean bl) {
        this.setChoices(stringArray, bl ? null : stringArray);
    }

    protected void setChoices(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new NullPointerException();
            }
            ++n;
        }
        if (stringArray2 != null) {
            if (stringArray.length != stringArray2.length) {
                throw new IllegalArgumentException();
            }
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2] == null) {
                    throw new NullPointerException();
                }
                ++n2;
            }
        }
        this.choices = stringArray;
        this.displayChoices = stringArray2;
        this.value = new boolean[stringArray.length];
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String[] getDisplayChoices() {
        if (this.displayChoices == null) {
            ResourceBundle resourceBundle = this.interview.getResourceBundle();
            if (resourceBundle == null) {
                return this.choices;
            }
            this.displayChoices = new String[this.choices.length];
            int n = 0;
            while (n < this.choices.length) {
                String string = this.choices[n];
                String string2 = this.key + "." + string;
                try {
                    this.displayChoices[n] = string == null ? null : resourceBundle.getString(string2);
                }
                catch (MissingResourceException missingResourceException) {
                    System.err.println("WARNING: missing resource " + string2);
                    this.displayChoices[n] = string;
                }
                ++n;
            }
        }
        return this.displayChoices;
    }

    public boolean[] getValue() {
        if (this.value == null) {
            throw new IllegalStateException();
        }
        boolean[] blArray = null;
        if (this.value != null) {
            blArray = new boolean[this.value.length];
            int n = 0;
            while (n < this.value.length) {
                blArray[n] = this.value[n];
                ++n;
            }
        }
        return blArray;
    }

    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        if (this.value.length != this.choices.length) {
            throw new IllegalStateException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value != null) {
            int n = 0;
            while (n < this.value.length) {
                if (this.value[n]) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(this.choices[n].replace(' ', '_'));
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void setValue(String string) {
        if (this.choices == null) {
            return;
        }
        boolean[] blArray = new boolean[this.choices.length];
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (ChoiceArrayQuestion.white(string.charAt(n2))) {
                if (n != -1) {
                    this.set(blArray, string.substring(n, n2));
                }
                n = -1;
            } else if (n == -1) {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            this.set(blArray, string.substring(n));
        }
        this.setValue(blArray);
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    private void set(boolean[] blArray, String string) {
        int n = 0;
        while (n < this.choices.length) {
            if (string.equals(this.choices[n].replace(' ', '_'))) {
                blArray[n] = true;
                return;
            }
            ++n;
        }
    }

    private static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public void setValue(boolean[] blArray) {
        if (this.choices == null) {
            return;
        }
        boolean bl = false;
        if (blArray == null) {
            int n = 0;
            while (n < this.value.length) {
                if (!bl) {
                    bl = this.value[n];
                }
                this.value[n] = false;
                ++n;
            }
        } else {
            int n = 0;
            while (n < Math.min(blArray.length, this.value.length)) {
                if (!bl) {
                    bl = this.value[n] != blArray[n];
                }
                this.value[n] = blArray[n];
                ++n;
            }
        }
        if (bl) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void clear() {
        this.setValue((boolean[])null);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v != null && v instanceof String) {
            this.setValue((String)v);
        }
    }

    protected void save(Map map) {
        map.put(this.tag, this.getStringValue());
    }
}

