/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.coi.tools.os.win.NativeLibException;
import com.coi.tools.os.win.RegDataContainer;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OSClassHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegistryHandler
extends OSClassHelper {
    public static final String UNINSTALL_ROOT = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    public static final Map ROOT_KEY_MAP = new HashMap();
    protected String uninstallName = null;
    private static final String UNINSTALLER_ICON = "UninstallerIcon";
    private static RegistryHandler defaultHandler = null;

    public RegistryHandler() {
    }

    public RegistryHandler(String className) {
        super(className);
        this.setDefault();
    }

    private synchronized void setDefault() {
        if (defaultHandler == null) {
            defaultHandler = this;
        }
    }

    public void setValue(String key, String value, String contents) throws NativeLibException {
    }

    public void setValue(String key, String value, String[] contents) throws NativeLibException {
    }

    public void setValue(String key, String value, byte[] contents) throws NativeLibException {
    }

    public void setValue(String key, String value, long contents) throws NativeLibException {
    }

    public RegDataContainer getValue(String key, String value, RegDataContainer defaultVal) throws NativeLibException {
        return null;
    }

    public boolean keyExist(String key) throws NativeLibException {
        return false;
    }

    public boolean valueExist(String key, String value) throws NativeLibException {
        return false;
    }

    public String[] getSubkeys(String key) throws NativeLibException {
        return null;
    }

    public String[] getValueNames(String key) throws NativeLibException {
        return null;
    }

    public RegDataContainer getValue(String key, String value) throws NativeLibException {
        return null;
    }

    public void createKey(String key) throws NativeLibException {
    }

    public void deleteKey(String key) throws NativeLibException {
    }

    public void deleteKeyIfEmpty(String key) throws NativeLibException {
    }

    public void deleteValue(String key, String value) throws NativeLibException {
    }

    public void setRoot(int i) throws NativeLibException {
    }

    public int getRoot() throws NativeLibException {
        return 0;
    }

    public void activateLogging() throws NativeLibException {
    }

    public void suspendLogging() throws NativeLibException {
    }

    public void resetLogging() throws NativeLibException {
    }

    public List getLoggingInfo() throws NativeLibException {
        return null;
    }

    public void setLoggingInfo(List info) throws NativeLibException {
    }

    public void addLoggingInfo(List info) throws NativeLibException {
    }

    public void rewind() throws NativeLibException {
    }

    public String getUninstallName() {
        if (this.uninstallName != null) {
            return this.uninstallName;
        }
        if (this.installdata == null) {
            return null;
        }
        return this.installdata.getVariable("APP_NAME") + " " + this.installdata.getVariable("APP_VER");
    }

    public boolean isProductRegistered() throws NativeLibException {
        String uninstallName = this.getUninstallName();
        if (uninstallName == null) {
            return false;
        }
        String keyName = UNINSTALL_ROOT + uninstallName;
        int oldVal = this.getRoot();
        this.setRoot(-2147483646);
        boolean retval = this.keyExist(keyName);
        this.setRoot(oldVal);
        return retval;
    }

    public void setUninstallName(String name) {
        this.uninstallName = name;
    }

    public void registerUninstallKey() throws NativeLibException {
        String uninstallName = this.getUninstallName();
        if (uninstallName == null) {
            return;
        }
        String keyName = UNINSTALL_ROOT + uninstallName;
        String cmd = "\"" + this.installdata.getVariable("JAVA_HOME") + "\\bin\\javaw.exe\" -jar \"" + this.installdata.getVariable("INSTALL_PATH") + "\\uninstaller\\uninstaller.jar\"";
        int oldVal = this.getRoot();
        this.setRoot(-2147483646);
        this.setValue(keyName, "DisplayName", uninstallName);
        this.setValue(keyName, "UninstallString", cmd);
        try {
            int bytesInBuffer;
            InputStream input = ResourceManager.getInstance().getInputStream(UNINSTALLER_ICON);
            String iconPath = this.installdata.getVariable("INSTALL_PATH") + File.separator + "Uninstaller" + File.separator + "UninstallerIcon.ico";
            FileOutputStream out = new FileOutputStream(iconPath);
            byte[] buffer = new byte[5120];
            long bytesCopied = 0L;
            while ((bytesInBuffer = input.read(buffer)) != -1) {
                out.write(buffer, 0, bytesInBuffer);
                bytesCopied += (long)bytesInBuffer;
            }
            input.close();
            out.close();
            this.setValue(keyName, "DisplayIcon", iconPath);
        }
        catch (Exception exception) {
            Debug.trace(exception);
        }
        this.setRoot(oldVal);
    }

    public boolean verify(AutomatedInstallData idata) throws Exception {
        super.verify(idata);
        return true;
    }

    public boolean doPerform() {
        return true;
    }

    public RegistryHandler getDefaultHandler() {
        return defaultHandler;
    }

    static {
        ROOT_KEY_MAP.put("HKCR", new Integer(Integer.MIN_VALUE));
        ROOT_KEY_MAP.put("HKEY_CLASSES_ROOT", new Integer(Integer.MIN_VALUE));
        ROOT_KEY_MAP.put("HKCU", new Integer(-2147483647));
        ROOT_KEY_MAP.put("HKEY_CURRENT_USER", new Integer(-2147483647));
        ROOT_KEY_MAP.put("HKLM", new Integer(-2147483646));
        ROOT_KEY_MAP.put("HKEY_LOCAL_MACHINE", new Integer(-2147483646));
        ROOT_KEY_MAP.put("HKU", new Integer(-2147483645));
        ROOT_KEY_MAP.put("HKEY_USERS", new Integer(-2147483645));
        ROOT_KEY_MAP.put("HKPD", new Integer(-2147483644));
        ROOT_KEY_MAP.put("HKEY_PERFORMANCE_DATA", new Integer(-2147483644));
        ROOT_KEY_MAP.put("HKCC", new Integer(-2147483643));
        ROOT_KEY_MAP.put("HKEY_CURRENT_CONFIG", new Integer(-2147483643));
        ROOT_KEY_MAP.put("HKDDS", new Integer(-2147483642));
        ROOT_KEY_MAP.put("HKEY_DYN_DATA", new Integer(-2147483642));
    }
}

